/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.ItemInfo;
import com.l2jserver.gameserver.model.itemauction.ItemAuction;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionBid;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionState;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class ExItemAuctionInfoPacket
extends L2GameServerPacket {
    private final boolean _refresh;
    private final int _timeRemaining;
    private final ItemAuction _currentAuction;
    private final ItemAuction _nextAuction;

    public ExItemAuctionInfoPacket(boolean refresh, ItemAuction currentAuction, ItemAuction nextAuction) {
        if (currentAuction == null) {
            throw new NullPointerException();
        }
        this._timeRemaining = currentAuction.getAuctionState() != ItemAuctionState.STARTED ? 0 : (int)(currentAuction.getFinishingTimeRemaining() / 1000L);
        this._refresh = refresh;
        this._currentAuction = currentAuction;
        this._nextAuction = nextAuction;
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(104);
        this.writeC(this._refresh ? 0 : 1);
        this.writeD(this._currentAuction.getInstanceId());
        ItemAuctionBid highestBid = this._currentAuction.getHighestBid();
        this.writeQ(highestBid != null ? highestBid.getLastBid() : this._currentAuction.getAuctionInitBid());
        this.writeD(this._timeRemaining);
        this.writeItemInfo(this._currentAuction.getItemInfo());
        if (this._nextAuction != null) {
            this.writeQ(this._nextAuction.getAuctionInitBid());
            this.writeD((int)(this._nextAuction.getStartingTime() / 1000L));
            this.writeItemInfo(this._nextAuction.getItemInfo());
        }
    }

    private final void writeItemInfo(ItemInfo item) {
        this.writeD(item.getItem().getItemId());
        this.writeD(item.getItem().getItemId());
        this.writeD(item.getLocation());
        this.writeQ(item.getCount());
        this.writeH(item.getItem().getType2());
        this.writeH(item.getCustomType1());
        this.writeH(0);
        this.writeD(item.getItem().getBodyPart());
        this.writeH(item.getEnchant());
        this.writeH(item.getCustomType2());
        this.writeD(item.getAugmentationBonus());
        this.writeD(item.getMana());
        this.writeD(item.getTime());
        this.writeH(item.getAttackElementType());
        this.writeH(item.getAttackElementPower());
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            super.writeH(item.getElementDefAttr(i));
        }
        this.writeH(0);
        this.writeH(0);
        this.writeH(0);
    }

    @Override
    public final String getType() {
        return "[S] fe:68:00 ExItemAuctionInfoPacket";
    }
}

