/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.RecipeController;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2ManufactureList;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopMsg;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Util;
import java.util.Arrays;
import java.util.List;

public final class RequestRecipeShopListSet
extends L2GameClientPacket {
    private static final String _C__B2_RequestRecipeShopListSet = "[C] b2 RequestRecipeShopListSet";
    private static final int BATCH_LENGTH = 12;
    private Recipe[] _items = null;

    @Override
    protected void readImpl() {
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new Recipe[count];
        for (int i = 0; i < count; ++i) {
            int id = this.readD();
            long cost = this.readQ();
            if (cost < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new Recipe(id, cost);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            player.setPrivateStoreType(0);
            player.broadcastUserInfo();
            return;
        }
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(player) || player.isInDuel()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInsideZone((byte)14)) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_PRIVATE_WORKSHOP_HERE));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2ManufactureList createList = new L2ManufactureList();
        List<L2RecipeList> dwarfRecipes = Arrays.asList(player.getDwarvenRecipeBook());
        List<L2RecipeList> commonRecipes = Arrays.asList(player.getCommonRecipeBook());
        for (Recipe i : this._items) {
            L2RecipeList list = RecipeController.getInstance().getRecipeList(i.getRecipeId());
            if (!dwarfRecipes.contains(list) && !commonRecipes.contains(list)) {
                Util.handleIllegalPlayerAction(player, "Warning!! Player " + player.getName() + " of account " + player.getAccountName() + " tried to set recipe which he dont have.", Config.DEFAULT_PUNISH);
                return;
            }
            if (i.addToList(createList)) continue;
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to set price more than " + 99900000000L + " adena in Private Manufacture.", Config.DEFAULT_PUNISH);
            return;
        }
        createList.setStoreName(player.getCreateList() != null ? player.getCreateList().getStoreName() : "");
        player.setCreateList(createList);
        player.setPrivateStoreType(5);
        player.sitDown();
        player.broadcastUserInfo();
        player.sendPacket(new RecipeShopMsg(player));
        player.broadcastPacket(new RecipeShopMsg(player));
    }

    @Override
    public String getType() {
        return _C__B2_RequestRecipeShopListSet;
    }

    private static class Recipe {
        private final int _recipeId;
        private final long _cost;

        public Recipe(int id, long c) {
            this._recipeId = id;
            this._cost = c;
        }

        public boolean addToList(L2ManufactureList list) {
            if (this._cost > 99900000000L) {
                return false;
            }
            list.add(new L2ManufactureItem(this._recipeId, this._cost));
            return true;
        }

        public int getRecipeId() {
            return this._recipeId;
        }
    }
}

