/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.util.GMAudit;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public final class RequestDropItem
extends L2GameClientPacket {
    private static final String _C__12_REQUESTDROPITEM = "[C] 12 RequestDropItem";
    private static Logger _log = Logger.getLogger(RequestDropItem.class.getName());
    private int _objectId;
    private long _count;
    private int _x;
    private int _y;
    private int _z;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._count = this.readQ();
        this._x = this.readD();
        this._y = this.readD();
        this._z = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || activeChar.isDead()) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getDropItem().tryPerformAction("drop item")) {
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (item == null || this._count == 0L || !activeChar.validateItemManipulation(this._objectId, "drop") || !Config.ALLOW_DISCARDITEM && !activeChar.isGM() || !item.isDropable() && (!activeChar.isGM() || !Config.GM_TRADE_RESTRICTED_ITEMS) || item.getItemType() == L2EtcItemType.PET_COLLAR && activeChar.havePetInvItems() || activeChar.isInsideZone((byte)21)) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (!(!item.isQuestItem() || activeChar.isGM() && Config.GM_TRADE_RESTRICTED_ITEMS)) {
            return;
        }
        if (this._count > item.getCount()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (Config.PLAYER_SPAWN_PROTECTION > 0 && activeChar.isInvul() && !activeChar.isGM()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (this._count < 0L) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestDropItem] Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to drop item with oid " + this._objectId + " but has count < 0!", Config.DEFAULT_PUNISH);
            return;
        }
        if (!item.isStackable() && this._count > 1L) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestDropItem] Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to drop non-stackable item with oid " + this._objectId + " but has count > 1!", Config.DEFAULT_PUNISH);
            return;
        }
        if (Config.JAIL_DISABLE_TRANSACTION && activeChar.isInJail()) {
            activeChar.sendMessage("You cannot drop items in Jail.");
            return;
        }
        if (!activeChar.getAccessLevel().allowTransaction()) {
            activeChar.sendMessage("Transactions are disable for your Access Level");
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOTHING_HAPPENED));
            return;
        }
        if (activeChar.isProcessingTransaction() || activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE));
            return;
        }
        if (activeChar.isFishing()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DO_WHILE_FISHING_2));
            return;
        }
        if (activeChar.isFlying()) {
            return;
        }
        if (activeChar.isCastingNow() && activeChar.getCurrentSkill() != null && activeChar.getCurrentSkill().getSkill().getItemConsumeId() == item.getItemId()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (activeChar.isCastingSimultaneouslyNow() && activeChar.getLastSimultaneousSkillCast() != null && activeChar.getLastSimultaneousSkillCast().getItemConsumeId() == item.getItemId()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (3 == item.getItem().getType2() && !activeChar.isGM()) {
            if (Config.DEBUG) {
                _log.finest(activeChar.getObjectId() + ":player tried to drop quest item");
            }
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_EXCHANGE_ITEM));
            return;
        }
        if (!activeChar.isInsideRadius(this._x, this._y, 150, false) || Math.abs(this._z - activeChar.getZ()) > 50) {
            if (Config.DEBUG) {
                _log.finest(activeChar.getObjectId() + ": trying to drop too far away");
            }
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISCARD_DISTANCE_TOO_FAR));
            return;
        }
        if (!activeChar.getInventory().canManipulateWithItemId(item.getItemId())) {
            activeChar.sendMessage("Cannot use this item.");
            return;
        }
        if (Config.DEBUG) {
            _log.fine("requested drop item " + this._objectId + "(" + item.getCount() + ") at " + this._x + "/" + this._y + "/" + this._z);
        }
        if (item.isEquipped()) {
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(item.getLocationSlot());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                activeChar.checkSShotsMatch(null, itm);
                iu.addModifiedItem(itm);
            }
            activeChar.sendPacket(iu);
            activeChar.broadcastUserInfo();
            ItemList il = new ItemList(activeChar, true);
            activeChar.sendPacket(il);
        }
        L2ItemInstance dropedItem = activeChar.dropItem("Drop", this._objectId, this._count, this._x, this._y, this._z, null, false, true);
        if (Config.DEBUG) {
            _log.fine("dropping " + this._objectId + " item(" + this._count + ") at: " + this._x + " " + this._y + " " + this._z);
        }
        if (activeChar.isGM()) {
            String target = activeChar.getTarget() != null ? activeChar.getTarget().getName() : "no-target";
            GMAudit.auditGMAction(activeChar.getName() + " [" + activeChar.getObjectId() + "]", "Drop", target, "(id: " + dropedItem.getItemId() + " name: " + dropedItem.getItemName() + " objId: " + dropedItem.getObjectId() + " x: " + activeChar.getX() + " y: " + activeChar.getY() + " z: " + activeChar.getZ() + ")");
        }
        if (dropedItem != null && dropedItem.getItemId() == 57 && dropedItem.getCount() >= 1000000L) {
            String msg = "Character (" + activeChar.getName() + ") has dropped (" + dropedItem.getCount() + ")adena at (" + this._x + "," + this._y + "," + this._z + ")";
            _log.warning(msg);
            GmListTable.broadcastMessageToGMs(msg);
        }
    }

    @Override
    public String getType() {
        return _C__12_REQUESTDROPITEM;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

