/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.communitybbs.CommunityBoard;
import com.l2jserver.gameserver.datatables.AdminCommandAccessRights;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.BypassHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.RequestShowCommunityBoard;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ConfirmDlg;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.GMAudit;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestBypassToServer
extends L2GameClientPacket {
    private static final String _C__23_REQUESTBYPASSTOSERVER = "[C] 23 RequestBypassToServer";
    private static Logger _log = Logger.getLogger(RequestBypassToServer.class.getName());
    private String _command;

    @Override
    protected void readImpl() {
        this._command = this.readS();
    }

    @Override
    protected void runImpl() {
        block62: {
            L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
            if (activeChar == null) {
                return;
            }
            if (!((L2GameClient)this.getClient()).getFloodProtectors().getServerBypass().tryPerformAction(this._command)) {
                return;
            }
            if (this._command.isEmpty()) {
                _log.info(activeChar.getName() + " send empty requestbypass");
                activeChar.logout();
                return;
            }
            try {
                if (this._command.startsWith("admin_")) {
                    String command = this._command.split(" ")[0];
                    IAdminCommandHandler ach = AdminCommandHandler.getInstance().getAdminCommandHandler(command);
                    if (ach == null) {
                        if (activeChar.isGM()) {
                            activeChar.sendMessage("The command " + command.substring(6) + " does not exist!");
                        }
                        _log.warning("No handler registered for admin command '" + command + "'");
                        return;
                    }
                    if (!AdminCommandAccessRights.getInstance().hasAccess(command, activeChar.getAccessLevel())) {
                        activeChar.sendMessage("You don't have the access rights to use this command!");
                        _log.warning("Character " + activeChar.getName() + " tried to use admin command " + command + ", without proper access level!");
                        return;
                    }
                    if (AdminCommandAccessRights.getInstance().requireConfirm(command)) {
                        activeChar.setAdminConfirmCmd(this._command);
                        ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.S1);
                        dlg.addString("Are you sure you want execute command " + this._command.substring(6) + " ?");
                        activeChar.sendPacket(dlg);
                    } else {
                        if (Config.GMAUDIT) {
                            GMAudit.auditGMAction(activeChar.getName() + " [" + activeChar.getObjectId() + "]", this._command, activeChar.getTarget() != null ? activeChar.getTarget().getName() : "no-target");
                        }
                        ach.useAdminCommand(this._command, activeChar);
                    }
                } else if (this._command.equals("come_here") && activeChar.isGM()) {
                    RequestBypassToServer.comeHere(activeChar);
                } else if (this._command.startsWith("npc_")) {
                    if (!activeChar.validateBypass(this._command)) {
                        return;
                    }
                    int endOfId = this._command.indexOf(95, 5);
                    String id = endOfId > 0 ? this._command.substring(4, endOfId) : this._command.substring(4);
                    try {
                        L2Object object = L2World.getInstance().findObject(Integer.parseInt(id));
                        if (this._command.substring(endOfId + 1).startsWith("event_participate")) {
                            L2Event.inscribePlayer(activeChar);
                        } else if (object instanceof L2Npc && endOfId > 0 && activeChar.isInsideRadius(object, 150, false, false)) {
                            ((L2Npc)object).onBypassFeedback(activeChar, this._command.substring(endOfId + 1));
                        }
                        activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                    }
                    catch (NumberFormatException nfe) {}
                } else if (this._command.startsWith("summon_")) {
                    if (!activeChar.validateBypass(this._command)) {
                        return;
                    }
                    int endOfId = this._command.indexOf(95, 8);
                    String id = endOfId > 0 ? this._command.substring(7, endOfId) : this._command.substring(7);
                    try {
                        L2Object object = L2World.getInstance().findObject(Integer.parseInt(id));
                        if (object instanceof L2MerchantSummonInstance && endOfId > 0 && activeChar.isInsideRadius(object, 150, false, false)) {
                            ((L2MerchantSummonInstance)object).onBypassFeedback(activeChar, this._command.substring(endOfId + 1));
                        }
                        activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                    }
                    catch (NumberFormatException nfe) {}
                } else if (this._command.startsWith("manor_menu_select")) {
                    IBypassHandler manor = BypassHandler.getInstance().getBypassHandler("manor_menu_select");
                    if (manor != null) {
                        manor.useBypass(this._command, activeChar, null);
                    }
                } else if (this._command.startsWith("_bbs")) {
                    if (Config.ENABLE_COMMUNITY_BOARD) {
                        if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), this._command))) {
                            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CB_OFFLINE));
                        }
                    } else {
                        CommunityBoard.getInstance().handleCommands((L2GameClient)this.getClient(), this._command);
                    }
                } else if (this._command.startsWith("_maillist") || this._command.startsWith("_friendlist")) {
                    CommunityBoard.getInstance().handleCommands((L2GameClient)this.getClient(), this._command);
                } else if (this._command.startsWith("_mail")) {
                    if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), "_bbsmail"))) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CB_OFFLINE));
                    }
                } else if (this._command.startsWith("_friend")) {
                    if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), "_bbsfriend"))) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CB_OFFLINE));
                    }
                } else if (this._command.startsWith("Quest ")) {
                    if (!activeChar.validateBypass(this._command)) {
                        return;
                    }
                    L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
                    if (player == null) {
                        return;
                    }
                    String p = this._command.substring(6).trim();
                    int idx = p.indexOf(32);
                    if (idx < 0) {
                        player.processQuestEvent(p, "");
                    } else {
                        player.processQuestEvent(p.substring(0, idx), p.substring(idx).trim());
                    }
                } else if (this._command.startsWith("_match")) {
                    L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
                    if (player == null) {
                        return;
                    }
                    String params = this._command.substring(this._command.indexOf("?") + 1);
                    StringTokenizer st = new StringTokenizer(params, "&");
                    int heroclass = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heropage = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heroid = Hero.getInstance().getHeroByClass(heroclass);
                    if (heroid > 0) {
                        Hero.getInstance().showHeroFights(player, heroclass, heroid, heropage);
                    }
                } else if (this._command.startsWith("_diary")) {
                    L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
                    if (player == null) {
                        return;
                    }
                    String params = this._command.substring(this._command.indexOf("?") + 1);
                    StringTokenizer st = new StringTokenizer(params, "&");
                    int heroclass = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heropage = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heroid = Hero.getInstance().getHeroByClass(heroclass);
                    if (heroid > 0) {
                        Hero.getInstance().showHeroDiary(player, heroclass, heroid, heropage);
                    }
                } else {
                    IBypassHandler handler = BypassHandler.getInstance().getBypassHandler(this._command);
                    if (handler != null) {
                        handler.useBypass(this._command, activeChar, null);
                    } else {
                        _log.log(Level.WARNING, this.getClient() + " sent not handled RequestBypassToServer: [" + this._command + "]");
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClient() + " sent bad RequestBypassToServer: \"" + this._command + "\"", e);
                if (!activeChar.isGM()) break block62;
                StringBuilder sb = new StringBuilder(200);
                sb.append("<html><body>Bypass error: ").append(e).append("<br1>Bypass command: ").append(this._command).append("<br1>StackTrace:<br1>");
                for (StackTraceElement ste : e.getStackTrace()) {
                    sb.append(ste.toString()).append("<br1>");
                }
                sb.append("</body></html>");
                NpcHtmlMessage msg = new NpcHtmlMessage(0, 12807);
                msg.setHtml(sb.toString());
                msg.disableValidation();
                activeChar.sendPacket(msg);
            }
        }
    }

    private static void comeHere(L2PcInstance activeChar) {
        L2Object obj = activeChar.getTarget();
        if (obj == null) {
            return;
        }
        if (obj instanceof L2Npc) {
            L2Npc temp = (L2Npc)obj;
            temp.setTarget(activeChar);
            temp.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(activeChar.getX(), activeChar.getY(), activeChar.getZ(), 0));
        }
    }

    @Override
    public String getType() {
        return _C__23_REQUESTBYPASSTOSERVER;
    }
}

