/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.debug;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.util.L2FastList;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javolution.util.FastMap;
import javolution.util.FastSet;

public class L2BossZone
extends L2ZoneType {
    private int _timeServerDown = 0;
    private int _timeClientDown = 0;
    private boolean _enabled = true;
    private FastMap<Integer, Long> _playerAllowedReEntryTimes;
    private FastSet<Integer> _playersAllowed;
    private int[] _oustLoc = new int[]{0, 0, 0};
    protected L2FastList<L2Character> _raidList = new L2FastList();

    public L2BossZone(int id) {
        super(id);
        this._playerAllowedReEntryTimes = new FastMap();
        this._playersAllowed = new FastSet();
        this._oustLoc = new int[3];
        GrandBossManager.getInstance().addZone(this);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("serverDownTime")) {
            this._timeServerDown = Integer.parseInt(value);
        } else if (name.equals("clientDownTime")) {
            this._timeClientDown = Integer.parseInt(value);
        } else if (name.equals("InvadeTime")) {
            if (this._timeServerDown == 0 && this._timeClientDown == 0) {
                this._timeServerDown = Integer.parseInt(value);
            }
        } else if (name.equals("EnabledByDefault")) {
            this._enabled = Boolean.parseBoolean(value);
        } else if (name.equals("oustX")) {
            this._oustLoc[0] = Integer.parseInt(value);
        } else if (name.equals("oustY")) {
            this._oustLoc[1] = Integer.parseInt(value);
        } else if (name.equals("oustZ")) {
            this._oustLoc[2] = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this._enabled) {
            if (character instanceof L2PcInstance) {
                L2PcInstance player = (L2PcInstance)character;
                player.setInsideZone((byte)12, true);
                if (player.isGM()) {
                    return;
                }
                if (this._playersAllowed.contains((Object)player.getObjectId())) {
                    Long expirationTime = (Long)this._playerAllowedReEntryTimes.get((Object)player.getObjectId());
                    if (expirationTime == null) {
                        long serverStartTime = GameServer.gameServer.serverLoadEnd;
                        if (serverStartTime > System.currentTimeMillis() - (long)this._timeServerDown) {
                            return;
                        }
                    } else {
                        this._playerAllowedReEntryTimes.remove((Object)player.getObjectId());
                        if (expirationTime > System.currentTimeMillis()) {
                            return;
                        }
                    }
                    this._playersAllowed.remove((Object)player.getObjectId());
                }
                if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
                    player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
                } else {
                    player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
                }
            } else if (character instanceof L2Summon) {
                L2PcInstance player = ((L2Summon)character).getOwner();
                if (player != null) {
                    if (this._playersAllowed.contains((Object)player.getObjectId()) || player.isGM()) {
                        return;
                    }
                    if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
                        player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
                    } else {
                        player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
                    }
                }
                ((L2Summon)character).unSummon(player);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this._enabled) {
            if (character instanceof L2PcInstance) {
                L2PcInstance player = (L2PcInstance)character;
                player.setInsideZone((byte)12, false);
                if (player.isGM()) {
                    return;
                }
                if (!player.isOnline() && this._playersAllowed.contains((Object)player.getObjectId())) {
                    this._playerAllowedReEntryTimes.put((Object)player.getObjectId(), (Object)(System.currentTimeMillis() + (long)this._timeClientDown));
                } else {
                    this._playersAllowed.remove((Object)player.getObjectId());
                    this._playerAllowedReEntryTimes.remove((Object)player.getObjectId());
                }
            }
            if (character instanceof L2Playable && this.getCharactersInside() != null && !this.getCharactersInside().isEmpty()) {
                this._raidList.clear();
                int count = 0;
                for (L2Character obj : this.getCharactersInside().values()) {
                    if (obj == null) continue;
                    if (obj instanceof L2Playable) {
                        ++count;
                        continue;
                    }
                    if (!(obj instanceof L2Attackable) || !obj.isRaid()) continue;
                    this._raidList.add(obj);
                }
                if (count == 0 && !this._raidList.isEmpty()) {
                    for (int i = 0; i < this._raidList.size(); ++i) {
                        L2Attackable raid = (L2Attackable)this._raidList.get(i);
                        if (raid == null || raid.getSpawn() == null || raid.isDead() || raid.isInsideRadius(raid.getSpawn().getLocx(), raid.getSpawn().getLocy(), 150, false)) continue;
                        raid.returnHome();
                    }
                }
            }
        }
        if (character instanceof L2Attackable && character.isRaid() && !character.isDead()) {
            ((L2Attackable)character).returnHome();
        }
    }

    @Deprecated
    public boolean isZoneEnabled() {
        return this._enabled;
    }

    public void setZoneDisable() {
        this._enabled = false;
    }

    public void setZoneEnable() {
        this._enabled = true;
    }

    public void setZoneEnabled(boolean flag) {
        if (this._enabled != flag) {
            this.oustAllPlayers();
        }
        this._enabled = flag;
    }

    public void setAllowedPlayers(FastSet<Integer> players) {
        if (players != null) {
            this._playersAllowed = players;
        }
    }

    public FastSet<Integer> getAllowedPlayers() {
        return this._playersAllowed;
    }

    public boolean isPlayerAllowed(L2PcInstance player) {
        if (player.isGM()) {
            return true;
        }
        if (this._playersAllowed.contains((Object)player.getObjectId())) {
            return true;
        }
        if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
            player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
        } else {
            player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
        return false;
    }

    public void movePlayersTo(int x, int y, int z) {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this._characterList.values()) {
            L2PcInstance player;
            if (!(character instanceof L2PcInstance) || !(player = (L2PcInstance)character).isOnline()) continue;
            player.teleToLocation(x, y, z);
        }
    }

    public void oustAllPlayers() {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this._characterList.values()) {
            L2PcInstance player;
            if (!(character instanceof L2PcInstance) || !(player = (L2PcInstance)character).isOnline()) continue;
            if (this._oustLoc[0] != 0 && this._oustLoc[1] != 0 && this._oustLoc[2] != 0) {
                player.teleToLocation(this._oustLoc[0], this._oustLoc[1], this._oustLoc[2]);
                continue;
            }
            player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
        this._playerAllowedReEntryTimes.clear();
        this._playersAllowed.clear();
    }

    public void allowPlayerEntry(L2PcInstance player, int durationInSec) {
        if (!player.isGM()) {
            if (!this._playersAllowed.contains((Object)player.getObjectId())) {
                this._playersAllowed.add((Object)player.getObjectId());
            }
            this._playerAllowedReEntryTimes.put((Object)player.getObjectId(), (Object)(System.currentTimeMillis() + (long)(durationInSec * 1000)));
        }
    }

    public void removePlayer(L2PcInstance player) {
        if (!player.isGM()) {
            this._playersAllowed.remove((Object)player.getObjectId());
            this._playerAllowedReEntryTimes.remove((Object)player.getObjectId());
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void updateKnownList(L2Npc npc) {
        if (this._characterList == null || this._characterList.isEmpty()) {
            return;
        }
        Map<Integer, L2PcInstance> npcKnownPlayers = npc.getKnownList().getKnownPlayers();
        for (L2Character character : this._characterList.values()) {
            L2PcInstance player;
            if (character == null || !(character instanceof L2PcInstance) || !(player = (L2PcInstance)character).isOnline()) continue;
            npcKnownPlayers.put(player.getObjectId(), player);
        }
    }

    public void checkAnnihilated(L2PcInstance pc) {
        if (!this._enabled) {
            return;
        }
        if (this.isPlayersAnnihilated()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    L2BossZone.this.oustAllPlayers();
                }
            }, 10000L);
        }
    }

    private synchronized boolean isPlayersAnnihilated() {
        if (this._characterList == null) {
            return false;
        }
        for (L2Character character : this._characterList.values()) {
            L2PcInstance player;
            if (!(character instanceof L2PcInstance) || (player = (L2PcInstance)character).isDead() || !player.isOnline()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    protected void TRACE(String message) {
        this.TRACE("", message);
    }

    @Deprecated
    protected void TRACE(String title, String message) {
        debug.TRACE(title, message);
    }

    @Deprecated
    protected String STR(L2Npc npc) {
        return debug.STR(npc);
    }

    @Deprecated
    protected String STR(L2Object obj) {
        return debug.STR(obj);
    }

    @Deprecated
    protected String STR(L2Skill skill) {
        return debug.STR(skill);
    }

    @Deprecated
    protected String STR(ScheduledFuture<?> task) {
        return debug.STR(task);
    }
}

