/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.zone.L2ZoneForm;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public abstract class L2ZoneType {
    protected static final Logger _log = Logger.getLogger(L2ZoneType.class.getName());
    private final int _id;
    protected L2ZoneForm _zone;
    protected FastMap<Integer, L2Character> _characterList;
    private boolean _checkAffected = false;
    private String _name = null;
    private int _minLvl;
    private int _maxLvl;
    private int[] _race;
    private int[] _class;
    private char _classType;
    private Map<Quest.QuestEventType, FastList<Quest>> _questEvents;
    private L2Object.InstanceType _target = L2Object.InstanceType.L2Character;

    protected L2ZoneType(int id) {
        this._id = id;
        this._characterList = new FastMap().shared();
        this._minLvl = 0;
        this._maxLvl = 255;
        this._classType = '\u0000';
        this._race = null;
        this._class = null;
    }

    public int getId() {
        return this._id;
    }

    public void setParameter(String name, String value) {
        this._checkAffected = true;
        if (name.equals("name")) {
            this._name = value;
        } else if (name.equals("affectedLvlMin")) {
            this._minLvl = Integer.parseInt(value);
        } else if (name.equals("affectedLvlMax")) {
            this._maxLvl = Integer.parseInt(value);
        } else if (name.equals("affectedRace")) {
            if (this._race == null) {
                this._race = new int[1];
                this._race[0] = Integer.parseInt(value);
            } else {
                int[] temp = new int[this._race.length + 1];
                for (int i = 0; i < this._race.length; ++i) {
                    temp[i] = this._race[i];
                }
                temp[i] = Integer.parseInt(value);
                this._race = temp;
            }
        } else if (name.equals("affectedClassId")) {
            if (this._class == null) {
                this._class = new int[1];
                this._class[0] = Integer.parseInt(value);
            } else {
                int[] temp = new int[this._class.length + 1];
                for (int i = 0; i < this._class.length; ++i) {
                    temp[i] = this._class[i];
                }
                temp[i] = Integer.parseInt(value);
                this._class = temp;
            }
        } else if (name.equals("affectedClassType")) {
            this._classType = value.equals("Fighter") ? (char)'\u0001' : (char)2;
        } else if (name.equals("targetClass")) {
            this._target = Enum.valueOf(L2Object.InstanceType.class, value);
        } else {
            _log.info(this.getClass().getSimpleName() + ": Unknown parameter - " + name + " in zone: " + this.getId());
        }
    }

    private boolean isAffected(L2Character character) {
        if (character.getLevel() < this._minLvl || character.getLevel() > this._maxLvl) {
            return false;
        }
        if (!character.isInstanceType(this._target)) {
            return false;
        }
        if (character instanceof L2PcInstance) {
            int i;
            boolean ok;
            if (this._classType != '\u0000' && (((L2PcInstance)character).isMageClass() ? this._classType == '\u0001' : this._classType == '\u0002')) {
                return false;
            }
            if (this._race != null) {
                ok = false;
                for (i = 0; i < this._race.length; ++i) {
                    if (((L2PcInstance)character).getRace().ordinal() != this._race[i]) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
            }
            if (this._class != null) {
                ok = false;
                for (i = 0; i < this._class.length; ++i) {
                    if (((L2PcInstance)character).getClassId().ordinal() != this._class[i]) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setZone(L2ZoneForm zone) {
        if (this._zone != null) {
            throw new IllegalStateException("Zone already set");
        }
        this._zone = zone;
    }

    public L2ZoneForm getZone() {
        return this._zone;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean isInsideZone(int x, int y) {
        return this._zone.isInsideZone(x, y, this._zone.getHighZ());
    }

    public boolean isInsideZone(int x, int y, int z) {
        return this._zone.isInsideZone(x, y, z);
    }

    public boolean isInsideZone(L2Object object) {
        return this.isInsideZone(object.getX(), object.getY(), object.getZ());
    }

    public double getDistanceToZone(int x, int y) {
        return this.getZone().getDistanceToZone(x, y);
    }

    public double getDistanceToZone(L2Object object) {
        return this.getZone().getDistanceToZone(object.getX(), object.getY());
    }

    public void revalidateInZone(L2Character character) {
        if (this._checkAffected && !this.isAffected(character)) {
            return;
        }
        if (this.isInsideZone(character.getX(), character.getY(), character.getZ())) {
            if (!this._characterList.containsKey((Object)character.getObjectId())) {
                FastList<Quest> quests = this.getQuestByEvent(Quest.QuestEventType.ON_ENTER_ZONE);
                if (quests != null) {
                    for (Quest quest : quests) {
                        quest.notifyEnterZone(character, this);
                    }
                }
                this._characterList.put((Object)character.getObjectId(), (Object)character);
                this.onEnter(character);
            }
        } else if (this._characterList.containsKey((Object)character.getObjectId())) {
            FastList<Quest> quests = this.getQuestByEvent(Quest.QuestEventType.ON_EXIT_ZONE);
            if (quests != null) {
                for (Quest quest : quests) {
                    quest.notifyExitZone(character, this);
                }
            }
            this._characterList.remove((Object)character.getObjectId());
            this.onExit(character);
        }
    }

    public void removeCharacter(L2Character character) {
        if (this._characterList.containsKey((Object)character.getObjectId())) {
            FastList<Quest> quests = this.getQuestByEvent(Quest.QuestEventType.ON_EXIT_ZONE);
            if (quests != null) {
                for (Quest quest : quests) {
                    quest.notifyExitZone(character, this);
                }
            }
            this._characterList.remove((Object)character.getObjectId());
            this.onExit(character);
        }
    }

    public boolean isCharacterInZone(L2Character character) {
        return this._characterList.containsKey((Object)character.getObjectId());
    }

    protected abstract void onEnter(L2Character var1);

    protected abstract void onExit(L2Character var1);

    public abstract void onDieInside(L2Character var1);

    public abstract void onReviveInside(L2Character var1);

    public FastMap<Integer, L2Character> getCharactersInside() {
        return this._characterList;
    }

    public void addQuestEvent(Quest.QuestEventType EventType2, Quest q) {
        FastList questByEvents;
        if (this._questEvents == null) {
            this._questEvents = new FastMap();
        }
        if ((questByEvents = this._questEvents.get((Object)EventType2)) == null) {
            questByEvents = new FastList();
        }
        if (!questByEvents.contains((Object)q)) {
            questByEvents.add((Object)q);
        }
        this._questEvents.put(EventType2, (FastList<Quest>)questByEvents);
    }

    public FastList<Quest> getQuestByEvent(Quest.QuestEventType EventType2) {
        if (this._questEvents == null) {
            return null;
        }
        return this._questEvents.get((Object)EventType2);
    }

    public void broadcastPacket(L2GameServerPacket packet) {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this._characterList.values()) {
            if (character == null || !(character instanceof L2PcInstance)) continue;
            character.sendPacket(packet);
        }
    }

    public L2Object.InstanceType getTargetType() {
        return this._target;
    }

    public void setTargetType(L2Object.InstanceType type) {
        this._target = type;
        this._checkAffected = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    public void visualizeZone(int z) {
        this.getZone().visualizeZone(z);
    }
}

