/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.templates.StatsSet;

public final class Participant {
    public final int objectId;
    public L2PcInstance player;
    public final String name;
    public final int side;
    public final int baseClass;
    public boolean disconnected = false;
    public boolean defaulted = false;
    public final StatsSet stats;

    public Participant(L2PcInstance plr, int olympiadSide) {
        this.objectId = plr.getObjectId();
        this.player = plr;
        this.name = plr.getName();
        this.side = olympiadSide;
        this.baseClass = plr.getBaseClass();
        this.stats = Olympiad.getNobleStats(this.objectId);
    }

    public Participant(int objId, int olympiadSide) {
        this.objectId = objId;
        this.player = null;
        this.name = "-";
        this.side = olympiadSide;
        this.baseClass = 0;
        this.stats = null;
    }

    public final void updatePlayer() {
        if (this.player == null || !this.player.isOnline()) {
            this.player = L2World.getInstance().getPlayer(this.objectId);
        }
    }

    public final void updateStat(String statName, int increment) {
        this.stats.set(statName, Math.max(this.stats.getInteger(statName) + increment, 0));
    }

    public final void updateNobleStats() {
        Olympiad.updateNobleStats(this.objectId, this.stats);
    }
}

