/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeGuardManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.CombatFlag;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class FortSiege
implements Siegable {
    protected static final Logger _log = Logger.getLogger(FortSiege.class.getName());
    private List<L2SiegeClan> _attackerClans = new FastList();
    protected FastList<L2Spawn> _commanders = new FastList();
    private final Fort _fort;
    private boolean _isInProgress = false;
    private FortSiegeGuardManager _siegeGuardManager;
    ScheduledFuture<?> _siegeEnd = null;
    ScheduledFuture<?> _siegeRestore = null;
    ScheduledFuture<?> _siegeStartTask = null;

    public FortSiege(Fort fort) {
        this._fort = fort;
        this.checkAutoTask();
        FortSiegeManager.getInstance().addSiege(this);
    }

    @Override
    public void endSiege() {
        if (this.getIsInProgress()) {
            this._isInProgress = false;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED);
            sm.addFortName(this.getFort());
            this.announceToPlayer(sm);
            this.removeFlags();
            this.unSpawnFlags();
            this.updatePlayerSiegeStateFlags(true);
            this.getFort().getZone().banishForeigners(this.getFort().getOwnerClan());
            this.getFort().getZone().setIsActive(false);
            this.getFort().getZone().updateZoneStatusForCharactersInside();
            this.getFort().getZone().setSiegeInstance(null);
            this.saveFortSiege();
            this.clearSiegeClan();
            this.removeCommanders();
            this.getFort().spawnNpcCommanders();
            this.getSiegeGuardManager().unspawnSiegeGuard();
            this.getFort().resetDoors();
            ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSuspiciousMerchantSpawn(), (long)(FortSiegeManager.getInstance().getSuspiciousMerchantRespawnDelay() * 60) * 1000L);
            this.setSiegeDateTime(true);
            if (this._siegeEnd != null) {
                this._siegeEnd.cancel(true);
                this._siegeEnd = null;
            }
            if (this._siegeRestore != null) {
                this._siegeRestore.cancel(true);
                this._siegeRestore = null;
            }
            if (this.getFort().getOwnerClan() != null && this.getFort().getFlagPole().getMeshIndex() == 0) {
                this.getFort().setVisibleFlag(true);
            }
            _log.info("Siege of " + this.getFort().getName() + " fort finished.");
        }
    }

    @Override
    public void startSiege() {
        if (!this.getIsInProgress()) {
            if (this._siegeStartTask != null) {
                this._siegeStartTask.cancel(true);
                this.getFort().despawnSuspiciousMerchant();
            }
            this._siegeStartTask = null;
            if (this.getAttackerClans().isEmpty()) {
                return;
            }
            this._isInProgress = true;
            this.loadSiegeClan();
            this.updatePlayerSiegeStateFlags(false);
            this.teleportPlayer(TeleportWhoType.Attacker, MapRegionTable.TeleportWhereType.Town);
            this.getFort().despawnNpcCommanders();
            this.spawnCommanders();
            this.getFort().resetDoors();
            this.spawnSiegeGuard();
            this.getFort().setVisibleFlag(false);
            this.getFort().getZone().setSiegeInstance(this);
            this.getFort().getZone().setIsActive(true);
            this.getFort().getZone().updateZoneStatusForCharactersInside();
            this._siegeEnd = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(), (long)(FortSiegeManager.getInstance().getSiegeLength() * 60) * 1000L);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_S1_HAS_BEGUN);
            sm.addFortName(this.getFort());
            this.announceToPlayer(sm);
            this.saveFortSiege();
            _log.info("Siege of " + this.getFort().getName() + " fort started.");
        }
    }

    public void announceToPlayer(SystemMessage sm) {
        L2Clan clan;
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                member.sendPacket(sm);
            }
        }
        if (this.getFort().getOwnerClan() != null) {
            clan = ClanTable.getInstance().getClan(this.getFort().getOwnerClan().getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                member.sendPacket(sm);
            }
        }
    }

    public void announceToPlayer(SystemMessage sm, String s) {
        sm.addString(s);
        this.announceToPlayer(sm);
    }

    public void updatePlayerSiegeStateFlags(boolean clear) {
        L2Clan clan;
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)1);
                    member.setSiegeSide(this.getFort().getFortId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY * 1000, Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.broadcastUserInfo();
            }
        }
        if (this.getFort().getOwnerClan() != null) {
            clan = ClanTable.getInstance().getClan(this.getFort().getOwnerClan().getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)2);
                    member.setSiegeSide(this.getFort().getFortId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY * 1000, Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.broadcastUserInfo();
            }
        }
    }

    public boolean checkIfInZone(L2Object object) {
        return this.checkIfInZone(object.getX(), object.getY(), object.getZ());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getIsInProgress() && this.getFort().checkIfInZone(x, y, z);
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        return this.getAttackerClan(clan) != null;
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        return clan != null && this.getFort().getOwnerClan() == clan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSiegeClan() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("DELETE FROM fortsiege_clans WHERE fort_id=?");
            statement.setInt(1, this.getFort().getFortId());
            statement.execute();
            statement.close();
            if (this.getFort().getOwnerClan() != null) {
                statement = con.prepareStatement("DELETE FROM fortsiege_clans WHERE clan_id=?");
                statement.setInt(1, this.getFort().getOwnerClan().getClanId());
                statement.execute();
            }
            this.getAttackerClans().clear();
            if (this.getIsInProgress()) {
                this.endSiege();
            }
            if (this._siegeStartTask != null) {
                this._siegeStartTask.cancel(true);
                this._siegeStartTask = null;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: clearSiegeClan(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void clearSiegeDate() {
        this.getFort().getSiegeDate().setTimeInMillis(0L);
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        FastList players = new FastList();
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getPlayersInZone() {
        return this.getFort().getZone().getAllPlayers();
    }

    public List<L2PcInstance> getOwnersInZone() {
        FastList players = new FastList();
        if (this.getFort().getOwnerClan() != null) {
            L2Clan clan = ClanTable.getInstance().getClan(this.getFort().getOwnerClan().getClanId());
            if (clan != this.getFort().getOwnerClan()) {
                return null;
            }
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public void killedCommander(L2FortCommanderInstance instance) {
        if (this._commanders != null && this.getFort() != null && this._commanders.size() != 0) {
            L2Spawn spawn = instance.getSpawn();
            if (spawn != null) {
                FastList<FortSiegeManager.SiegeSpawn> commanders = FortSiegeManager.getInstance().getCommanderSpawnList(this.getFort().getFortId());
                for (FortSiegeManager.SiegeSpawn spawn2 : commanders) {
                    if (spawn2.getNpcId() != spawn.getNpcid()) continue;
                    int message = 0;
                    switch (spawn2.getId()) {
                        case 1: {
                            message = 1300004;
                            break;
                        }
                        case 2: {
                            message = 1300006;
                            break;
                        }
                        case 3: {
                            message = 1300005;
                            break;
                        }
                        case 4: {
                            message = 1300020;
                        }
                    }
                    if (message == 0) continue;
                    instance.broadcastPacket(new NpcSay(instance.getObjectId(), 1, instance.getNpcId(), message));
                }
                this._commanders.remove((Object)spawn);
                if (this._commanders.isEmpty()) {
                    this.spawnFlag(this.getFort().getFortId());
                    if (this._siegeRestore != null) {
                        this._siegeRestore.cancel(true);
                    }
                    for (L2DoorInstance door : this.getFort().getDoors()) {
                        if (!door.getIsCommanderDoor()) continue;
                        door.openMe();
                    }
                    this.getFort().getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.ALL_BARRACKS_OCCUPIED));
                } else if (this._siegeRestore == null) {
                    this.getFort().getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.SEIZED_BARRACKS));
                    this._siegeRestore = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSiegeRestore(), (long)(FortSiegeManager.getInstance().getCountDownLength() * 60) * 1000L);
                } else {
                    this.getFort().getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.SEIZED_BARRACKS));
                }
            } else {
                _log.warning("FortSiege.killedCommander(): killed commander, but commander not registered for fortress. NpcId: " + instance.getNpcId() + " FortId: " + this.getFort().getFortId());
            }
        }
    }

    public void killedFlag(L2Npc flag) {
        if (flag == null) {
            return;
        }
        for (L2SiegeClan clan : this.getAttackerClans()) {
            if (!clan.removeFlag(flag)) continue;
            return;
        }
    }

    public boolean registerAttacker(L2PcInstance player, boolean force) {
        if (player.getClan() == null) {
            return false;
        }
        if (force || this.checkIfCanRegister(player)) {
            this.saveSiegeClan(player.getClan());
            if (this.getAttackerClans().size() == 1) {
                if (!force) {
                    player.reduceAdena("siege", 250000L, null, true);
                }
                this.startAutoTask(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSiegeClan(int clanId) {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = clanId != 0 ? con.prepareStatement("DELETE FROM fortsiege_clans WHERE fort_id=? AND clan_id=?") : con.prepareStatement("DELETE FROM fortsiege_clans WHERE fort_id=?");
            statement.setInt(1, this.getFort().getFortId());
            if (clanId != 0) {
                statement.setInt(2, clanId);
            }
            statement.execute();
            this.loadSiegeClan();
            if (this.getAttackerClans().isEmpty()) {
                if (this.getIsInProgress()) {
                    this.endSiege();
                } else {
                    this.saveFortSiege();
                }
                if (this._siegeStartTask != null) {
                    this._siegeStartTask.cancel(true);
                    this._siegeStartTask = null;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on removeSiegeClan: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void removeSiegeClan(L2Clan clan) {
        if (clan == null || clan.getHasFort() == this.getFort().getFortId() || !FortSiegeManager.getInstance().checkIsRegistered(clan, this.getFort().getFortId())) {
            return;
        }
        this.removeSiegeClan(clan.getClanId());
    }

    public void checkAutoTask() {
        if (this._siegeStartTask != null) {
            return;
        }
        long delay = this.getFort().getSiegeDate().getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        if (delay < 0L) {
            this.saveFortSiege();
            this.clearSiegeClan();
            ThreadPoolManager.getInstance().executeTask(new ScheduleSuspiciousMerchantSpawn());
            return;
        }
        this.loadSiegeClan();
        if (this.getAttackerClans().isEmpty()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSuspiciousMerchantSpawn(), delay);
        } else {
            if (delay > 3600000L) {
                ThreadPoolManager.getInstance().executeTask(new ScheduleSuspiciousMerchantSpawn());
                this._siegeStartTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(3600), delay - 3600000L);
            }
            if (delay > 600000L) {
                ThreadPoolManager.getInstance().executeTask(new ScheduleSuspiciousMerchantSpawn());
                this._siegeStartTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(600), delay - 600000L);
            } else {
                this._siegeStartTask = delay > 300000L ? ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(300), delay - 300000L) : (delay > 60000L ? ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(60), delay - 60000L) : ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(60), 0L));
            }
            _log.info("Siege of " + this.getFort().getName() + " fort: " + this.getFort().getSiegeDate().getTime());
        }
    }

    public void startAutoTask(boolean setTime) {
        if (this._siegeStartTask != null) {
            return;
        }
        if (setTime) {
            this.setSiegeDateTime(false);
        }
        if (this.getFort().getOwnerClan() != null) {
            this.getFort().getOwnerClan().broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.A_FORTRESS_IS_UNDER_ATTACK));
        }
        this._siegeStartTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(3600), 0L);
    }

    public void teleportPlayer(TeleportWhoType teleportWho, MapRegionTable.TeleportWhereType teleportWhere) {
        List<L2PcInstance> players;
        switch (teleportWho) {
            case Owner: {
                players = this.getOwnersInZone();
                break;
            }
            case Attacker: {
                players = this.getAttackersInZone();
                break;
            }
            default: {
                players = this.getPlayersInZone();
            }
        }
        for (L2PcInstance player : players) {
            if (player.isGM() || player.isInJail()) continue;
            player.teleToLocation(teleportWhere);
        }
    }

    private void addAttacker(int clanId) {
        this.getAttackerClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.ATTACKER));
    }

    public boolean checkIfCanRegister(L2PcInstance player) {
        boolean b = true;
        if (player.getClan() == null || player.getClan().getLevel() < FortSiegeManager.getInstance().getSiegeClanMinLevel()) {
            b = false;
            player.sendMessage("Only clans with Level " + FortSiegeManager.getInstance().getSiegeClanMinLevel() + " and higher may register for a fortress siege.");
        } else if ((player.getClanPrivileges() & 0x40000) != 262144) {
            b = false;
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
        } else if (player.getClan() == this.getFort().getOwnerClan()) {
            b = false;
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING));
        } else if (this.getFort().getOwnerClan() != null && player.getClan().getHasCastle() > 0 && player.getClan().getHasCastle() == this.getFort().getCastleId()) {
            b = false;
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_REGISTER_TO_SIEGE_DUE_TO_CONTRACT));
        } else if (this.getFort().getTimeTillRebelArmy() > 0 && this.getFort().getTimeTillRebelArmy() <= 7200) {
            b = false;
            player.sendMessage("You cannot register for the fortress siege 2 hours prior to rebel army attack.");
        } else if (this.getFort().getSiege().getAttackerClans().isEmpty() && player.getInventory().getAdena() < 250000L) {
            b = false;
            player.sendMessage("You need 250,000 adena to register");
        } else {
            for (Fort fort : FortManager.getInstance().getForts()) {
                if (fort.getSiege().getAttackerClan(player.getClanId()) != null) {
                    b = false;
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE));
                    break;
                }
                if (fort.getOwnerClan() != player.getClan() || !fort.getSiege().getIsInProgress() && fort.getSiege()._siegeStartTask == null) continue;
                b = false;
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE));
                break;
            }
        }
        return b;
    }

    public boolean checkIfAlreadyRegisteredForSameDay(L2Clan clan) {
        for (FortSiege siege : FortSiegeManager.getInstance().getSieges()) {
            if (siege == this || siege.getSiegeDate().get(7) != this.getSiegeDate().get(7)) continue;
            if (siege.checkIsAttacker(clan)) {
                return true;
            }
            if (!siege.checkIsDefender(clan)) continue;
            return true;
        }
        return false;
    }

    private void setSiegeDateTime(boolean merchant) {
        Calendar newDate = Calendar.getInstance();
        if (merchant) {
            newDate.add(12, FortSiegeManager.getInstance().getSuspiciousMerchantRespawnDelay());
        } else {
            newDate.add(12, 60);
        }
        this.getFort().setSiegeDate(newDate);
        this.saveSiegeDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSiegeClan() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            this.getAttackerClans().clear();
            ResultSet rs = null;
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT clan_id FROM fortsiege_clans WHERE fort_id=?");
            statement.setInt(1, this.getFort().getFortId());
            rs = statement.executeQuery();
            while (rs.next()) {
                this.addAttacker(rs.getInt("clan_id"));
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                _log.log(Level.WARNING, "Exception: loadSiegeClan(): " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                L2DatabaseFactory.close(con);
                throw throwable;
            }
            L2DatabaseFactory.close(con);
        }
        L2DatabaseFactory.close(con);
    }

    private void removeCommanders() {
        if (this._commanders != null && !this._commanders.isEmpty()) {
            for (L2Spawn spawn : this._commanders) {
                if (spawn == null) continue;
                spawn.stopRespawn();
                if (spawn.getLastSpawn() == null) continue;
                spawn.getLastSpawn().deleteMe();
            }
            this._commanders.clear();
        }
    }

    private void removeFlags() {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
    }

    private void saveFortSiege() {
        this.clearSiegeDate();
        this.saveSiegeDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSiegeDate() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("UPDATE fort SET siegeDate = ? WHERE id = ?");
            statement.setLong(1, this.getSiegeDate().getTimeInMillis());
            statement.setInt(2, this.getFort().getFortId());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeDate(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSiegeClan(L2Clan clan) {
        if (this.getAttackerClans().size() >= FortSiegeManager.getInstance().getAttackerMaxClans()) {
            return;
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("INSERT INTO fortsiege_clans (clan_id,fort_id) values (?,?)");
            statement.setInt(1, clan.getClanId());
            statement.setInt(2, this.getFort().getFortId());
            statement.execute();
            this.addAttacker(clan.getClanId());
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeClan(L2Clan clan): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void spawnCommanders() {
        try {
            this._commanders.clear();
            for (FortSiegeManager.SiegeSpawn _sp : FortSiegeManager.getInstance().getCommanderSpawnList(this.getFort().getFortId())) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(_sp.getNpcId());
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(1);
                    spawnDat.setLocx(_sp.getLocation().getX());
                    spawnDat.setLocy(_sp.getLocation().getY());
                    spawnDat.setLocz(_sp.getLocation().getZ());
                    spawnDat.setHeading(_sp.getLocation().getHeading());
                    spawnDat.setRespawnDelay(60);
                    spawnDat.doSpawn();
                    spawnDat.stopRespawn();
                    this._commanders.add((Object)spawnDat);
                    continue;
                }
                _log.warning("FortSiege.spawnCommander: Data missing in NPC table for ID: " + _sp.getNpcId() + ".");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FortSiege.spawnCommander: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private void spawnFlag(int Id) {
        for (CombatFlag cf : FortSiegeManager.getInstance().getFlagList(Id)) {
            cf.spawnMe();
        }
    }

    private void unSpawnFlags() {
        if (FortSiegeManager.getInstance().getFlagList(this.getFort().getFortId()) == null) {
            return;
        }
        for (CombatFlag cf : FortSiegeManager.getInstance().getFlagList(this.getFort().getFortId())) {
            cf.unSpawnMe();
        }
    }

    private void spawnSiegeGuard() {
        this.getSiegeGuardManager().spawnSiegeGuard();
    }

    @Override
    public final L2SiegeClan getAttackerClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getAttackerClan(clan.getClanId());
    }

    @Override
    public final L2SiegeClan getAttackerClan(int clanId) {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    @Override
    public final List<L2SiegeClan> getAttackerClans() {
        return this._attackerClans;
    }

    public final Fort getFort() {
        return this._fort;
    }

    public final boolean getIsInProgress() {
        return this._isInProgress;
    }

    @Override
    public final Calendar getSiegeDate() {
        return this.getFort().getSiegeDate();
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        L2SiegeClan sc;
        if (clan != null && (sc = this.getAttackerClan(clan)) != null) {
            return sc.getFlag();
        }
        return null;
    }

    public final FortSiegeGuardManager getSiegeGuardManager() {
        if (this._siegeGuardManager == null) {
            this._siegeGuardManager = new FortSiegeGuardManager(this.getFort());
        }
        return this._siegeGuardManager;
    }

    public void resetSiege() {
        this.removeCommanders();
        this.spawnCommanders();
        this.getFort().resetDoors();
    }

    public List<L2Spawn> getCommanders() {
        return this._commanders;
    }

    @Override
    public L2SiegeClan getDefenderClan(int clanId) {
        return null;
    }

    @Override
    public L2SiegeClan getDefenderClan(L2Clan clan) {
        return null;
    }

    @Override
    public List<L2SiegeClan> getDefenderClans() {
        return null;
    }

    @Override
    public boolean giveFame() {
        return true;
    }

    @Override
    public int getFameFrequency() {
        return Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY;
    }

    @Override
    public int getFameAmount() {
        return Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS;
    }

    public class ScheduleSiegeRestore
    implements Runnable {
        @Override
        public void run() {
            if (!FortSiege.this.getIsInProgress()) {
                return;
            }
            try {
                FortSiege.this._siegeRestore = null;
                FortSiege.this.resetSiege();
                FortSiege.this.announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.BARRACKS_FUNCTION_RESTORED));
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleSiegeRestore() for Fort: " + FortSiege.this._fort.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public class ScheduleSuspiciousMerchantSpawn
    implements Runnable {
        @Override
        public void run() {
            if (FortSiege.this.getIsInProgress()) {
                return;
            }
            try {
                FortSiege.this._fort.spawnSuspiciousMerchant();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleSuspicoiusMerchantSpawn() for Fort: " + FortSiege.this._fort.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public class ScheduleStartSiegeTask
    implements Runnable {
        private final Fort _fortInst;
        private final int _time;

        public ScheduleStartSiegeTask(int time) {
            this._fortInst = FortSiege.this._fort;
            this._time = time;
        }

        @Override
        public void run() {
            if (FortSiege.this.getIsInProgress()) {
                return;
            }
            try {
                if (this._time == 3600) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(600), 3000000L);
                } else if (this._time == 600) {
                    FortSiege.this.getFort().despawnSuspiciousMerchant();
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(10);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(300), 300000L);
                } else if (this._time == 300) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(5);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(60), 240000L);
                } else if (this._time == 60) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(1);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(30), 30000L);
                } else if (this._time == 30) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(30);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(10), 20000L);
                } else if (this._time == 10) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(10);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(5), 5000L);
                } else if (this._time == 5) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(5);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(1), 4000L);
                } else if (this._time == 1) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addNumber(1);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(0), 1000L);
                } else if (this._time == 0) {
                    this._fortInst.getSiege().startSiege();
                } else {
                    _log.warning("Exception: ScheduleStartSiegeTask(): unknown siege time: " + this._time);
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleStartSiegeTask() for Fort: " + this._fortInst.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public class ScheduleEndSiegeTask
    implements Runnable {
        @Override
        public void run() {
            if (!FortSiege.this.getIsInProgress()) {
                return;
            }
            try {
                FortSiege.this._siegeEnd = null;
                FortSiege.this.endSiege();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleEndSiegeTask() for Fort: " + FortSiege.this._fort.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public static enum TeleportWhoType {
        All,
        Attacker,
        Owner;

    }
}

