/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MultiSell;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import javolution.util.FastList;

public final class L2TransformManagerInstance
extends L2MerchantInstance {
    private static final String htmlFolder = "data/html/masterTransformation/";
    public static final String[] _questVarNames = new String[]{"EmergentAbility65-", "EmergentAbility70-", "ClassAbility75-", "ClassAbility80-"};
    private static final int[] _itemsIds = new int[]{10280, 10281, 10282, 10283, 10284, 10285, 10286, 10287, 10288, 10289, 10290, 10291, 10292, 10293, 10294, 10612};

    public L2TransformManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TransformManagerInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return "data/html/masterTransformation/master_transformation001.htm";
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("LearnTransformationSkill")) {
            if (L2TransformManagerInstance.canTransform(player)) {
                L2TransformManagerInstance.showTransformSkillList(player);
            } else {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation003.htm");
                player.sendPacket(html);
            }
            return;
        }
        if (command.startsWith("BuyTransformationItems")) {
            if (L2TransformManagerInstance.canTransform(player)) {
                MultiSell.getInstance().separateAndSend(32323001, player, this, false);
            } else {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation004.htm");
                player.sendPacket(html);
            }
            return;
        }
        if (command.startsWith("LearnSubClassSkill")) {
            if (player.isSubClassActive()) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation008.htm");
                player.sendPacket(html);
            } else {
                boolean hasItems = false;
                for (int i : _itemsIds) {
                    if (player.getInventory().getItemByItemId(i) == null) continue;
                    hasItems = true;
                    break;
                }
                if (hasItems) {
                    L2TransformManagerInstance.showSubClassSkillList(player);
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation008.htm");
                    player.sendPacket(html);
                }
            }
            return;
        }
        if (command.startsWith("CancelCertification")) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            if (player.getSubClasses().size() == 0) {
                html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation007.htm");
            } else if (player.isSubClassActive()) {
                html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation008.htm");
            } else if (player.getAdena() < (long)Config.FEE_DELETE_SUBCLASS_SKILLS) {
                html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation008no.htm");
            } else {
                int i;
                QuestState st = player.getQuestState("SubClassSkills");
                if (st == null) {
                    st = QuestManager.getInstance().getQuest("SubClassSkills").newQuestState(player);
                }
                int activeCertifications = 0;
                for (String varName : _questVarNames) {
                    for (i = 1; i <= Config.MAX_SUBCLASS; ++i) {
                        String qvar = st.getGlobalQuestVar(varName + i);
                        if (qvar.isEmpty() || !qvar.endsWith(";") && qvar.equals("0")) continue;
                        ++activeCertifications;
                    }
                }
                if (activeCertifications == 0) {
                    html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation010no.htm");
                } else {
                    for (String varName : _questVarNames) {
                        for (i = 1; i <= Config.MAX_SUBCLASS; ++i) {
                            String qvarName = varName + i;
                            String qvar = st.getGlobalQuestVar(qvarName);
                            if (qvar.endsWith(";")) {
                                String skillIdVar = qvar.replace(";", "");
                                if (Util.isDigit(skillIdVar)) {
                                    int skillId = Integer.parseInt(skillIdVar);
                                    L2Skill sk = SkillTable.getInstance().getInfo(skillId, 1);
                                    if (sk == null) continue;
                                    player.removeSkill(sk);
                                    st.saveGlobalQuestVar(qvarName, "0");
                                    continue;
                                }
                                _log.warning("Invalid Sub-Class Skill Id: " + skillIdVar + " for player " + player.getName() + "!");
                                continue;
                            }
                            if (qvar.isEmpty() || qvar.equals("0")) continue;
                            if (Util.isDigit(qvar)) {
                                int itemObjId = Integer.parseInt(qvar);
                                L2ItemInstance itemInstance = player.getInventory().getItemByObjectId(itemObjId);
                                if (itemInstance != null) {
                                    player.destroyItem("CancelCertification", itemObjId, 1L, (L2Object)player, false);
                                } else {
                                    itemInstance = player.getWarehouse().getItemByObjectId(itemObjId);
                                    if (itemInstance != null) {
                                        _log.warning("Somehow " + player.getName() + " put a certification book into warehouse!");
                                        player.getWarehouse().destroyItem("CancelCertification", itemInstance, 1L, player, (Object)false);
                                    } else {
                                        _log.warning("Somehow " + player.getName() + " deleted a certification book!");
                                    }
                                }
                                st.saveGlobalQuestVar(qvarName, "0");
                                continue;
                            }
                            _log.warning("Invalid item object Id: " + qvar + " for player " + player.getName() + "!");
                        }
                    }
                    player.reduceAdena("Cleanse", Config.FEE_DELETE_SUBCLASS_SKILLS, this, true);
                    html.setFile(player.getHtmlPrefix(), "data/html/masterTransformation/master_transformation009no.htm");
                    player.sendSkillList();
                }
                L2ItemInstance itemInstance = null;
                for (int itemId : _itemsIds) {
                    itemInstance = player.getInventory().getItemByItemId(itemId);
                    if (itemInstance == null) continue;
                    _log.warning(this.getClass().getName() + ": player " + player + " had 'extra' certification skill books while cancelling sub-class certifications!");
                    player.destroyItem("CancelCertificationExtraBooks", itemInstance, this, false);
                }
            }
            player.sendPacket(html);
            return;
        }
        super.onBypassFeedback(player, command);
    }

    public static boolean canTransform(L2PcInstance player) {
        if (Config.ALLOW_TRANSFORM_WITHOUT_QUEST) {
            return true;
        }
        QuestState st = player.getQuestState("136_MoreThanMeetsTheEye");
        return st != null && st.isCompleted();
    }

    public static void showTransformSkillList(L2PcInstance player) {
        FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableTransformSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.ClassTransform);
        int counts = 0;
        for (L2SkillLearn s : skills) {
            if (SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel()) == null) continue;
            ++counts;
            asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), s.getLevelUpSp(), 0);
        }
        if (counts == 0) {
            int minlevel = SkillTreesData.getInstance().getMinLevelForNewSkill(player, SkillTreesData.getInstance().getTransformSkillTree());
            if (minlevel > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1);
                sm.addNumber(minlevel);
                player.sendPacket(sm);
            } else {
                player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
            }
        } else {
            player.sendPacket(asl);
        }
    }

    public static void showSubClassSkillList(L2PcInstance player) {
        FastList<L2SkillLearn> subClassSkills = SkillTreesData.getInstance().getAvailableSubClassSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.SubClass);
        int count = 0;
        for (L2SkillLearn s : subClassSkills) {
            if (SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel()) == null) continue;
            ++count;
            asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), 0, 0);
        }
        if (count > 0) {
            player.sendPacket(asl);
        } else {
            player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
        }
    }
}

