/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.RecipeController;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2PlayerAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.cache.WarehouseCacheManager;
import com.l2jserver.gameserver.communitybbs.BB.Forum;
import com.l2jserver.gameserver.communitybbs.Manager.RegionBBSManager;
import com.l2jserver.gameserver.datatables.AccessLevels;
import com.l2jserver.gameserver.datatables.AdminCommandAccessRights;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.EnchantGroupsTable;
import com.l2jserver.gameserver.datatables.FishTable;
import com.l2jserver.gameserver.datatables.HennaTable;
import com.l2jserver.gameserver.datatables.HeroSkillTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.NobleSkillTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.FishData;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Fishing;
import com.l2jserver.gameserver.model.L2HennaInstance;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Macro;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2ManufactureList;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.L2PremiumItem;
import com.l2jserver.gameserver.model.L2Radar;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.L2Request;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2Transformation;
import com.l2jserver.gameserver.model.L2UIKeysSettings;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.MacroList;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.ShortCuts;
import com.l2jserver.gameserver.model.TerritoryWard;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.L2Trap;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.appearance.PcAppearance;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ControlTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TamedBeastInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PcKnownList;
import com.l2jserver.gameserver.model.actor.position.PcPosition;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.status.PcStatus;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.ClassLevel;
import com.l2jserver.gameserver.model.base.Experience;
import com.l2jserver.gameserver.model.base.PlayerClass;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.itemcontainer.PcRefund;
import com.l2jserver.gameserver.model.itemcontainer.PcWarehouse;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ChangeWaitType;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.ConfirmDlg;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExAutoSoulShot;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExDominionWarStart;
import com.l2jserver.gameserver.network.serverpackets.ExDuelUpdateUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExFishingEnd;
import com.l2jserver.gameserver.network.serverpackets.ExFishingStart;
import com.l2jserver.gameserver.network.serverpackets.ExGetBookMarkInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExGetOnAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMode;
import com.l2jserver.gameserver.network.serverpackets.ExPrivateStoreSetWholeMsg;
import com.l2jserver.gameserver.network.serverpackets.ExSetCompassZoneCode;
import com.l2jserver.gameserver.network.serverpackets.ExSpawnEmitter;
import com.l2jserver.gameserver.network.serverpackets.ExStartScenePlayer;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.ExVitalityPointInfo;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.FriendStatusPacket;
import com.l2jserver.gameserver.network.serverpackets.GameGuardQuery;
import com.l2jserver.gameserver.network.serverpackets.GetOnVehicle;
import com.l2jserver.gameserver.network.serverpackets.HennaInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.LeaveWorld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NicknameChanged;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ObservationMode;
import com.l2jserver.gameserver.network.serverpackets.ObservationReturn;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetInventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDelete;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgSell;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopMsg;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopSellList;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.Ride;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.ShortBuffStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SkillList;
import com.l2jserver.gameserver.network.serverpackets.Snoop;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TargetSelected;
import com.l2jserver.gameserver.network.serverpackets.TargetUnselected;
import com.l2jserver.gameserver.network.serverpackets.TradeDone;
import com.l2jserver.gameserver.network.serverpackets.TradeOtherDone;
import com.l2jserver.gameserver.network.serverpackets.TradeStart;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSiegeFlag;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.skills.l2skills.L2SkillTrap;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.chars.L2PcTemplate;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Henna;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.FloodProtectors;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Point3D;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;

public final class L2PcInstance
extends L2Playable {
    private static final String RESTORE_SKILLS_FOR_CHAR = "SELECT skill_id,skill_level FROM character_skills WHERE charId=? AND class_index=?";
    private static final String ADD_NEW_SKILL = "INSERT INTO character_skills (charId,skill_id,skill_level,class_index) VALUES (?,?,?,?)";
    private static final String UPDATE_CHARACTER_SKILL_LEVEL = "UPDATE character_skills SET skill_level=? WHERE skill_id=? AND charId=? AND class_index=?";
    private static final String DELETE_SKILL_FROM_CHAR = "DELETE FROM character_skills WHERE skill_id=? AND charId=? AND class_index=?";
    private static final String DELETE_CHAR_SKILLS = "DELETE FROM character_skills WHERE charId=? AND class_index=?";
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_skills_save (charId,skill_id,skill_level,effect_count,effect_cur_time,reuse_delay,systime,restore_type,class_index,buff_index) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT skill_id,skill_level,effect_count,effect_cur_time, reuse_delay, systime, restore_type FROM character_skills_save WHERE charId=? AND class_index=? ORDER BY buff_index ASC";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_skills_save WHERE charId=? AND class_index=?";
    private static final String INSERT_CHARACTER = "INSERT INTO characters (account_name,charId,char_name,level,maxHp,curHp,maxCp,curCp,maxMp,curMp,face,hairStyle,hairColor,sex,exp,sp,karma,fame,pvpkills,pkkills,clanid,race,classid,deletetime,cancraft,title,title_color,accesslevel,online,isin7sdungeon,clan_privs,wantspeace,base_class,newbie,nobless,power_grade,createTime) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_CHARACTER = "UPDATE characters SET level=?,maxHp=?,curHp=?,maxCp=?,curCp=?,maxMp=?,curMp=?,face=?,hairStyle=?,hairColor=?,sex=?,heading=?,x=?,y=?,z=?,exp=?,expBeforeDeath=?,sp=?,karma=?,fame=?,pvpkills=?,pkkills=?,clanid=?,race=?,classid=?,deletetime=?,title=?,title_color=?,accesslevel=?,online=?,isin7sdungeon=?,clan_privs=?,wantspeace=?,base_class=?,onlinetime=?,punish_level=?,punish_timer=?,newbie=?,nobless=?,power_grade=?,subpledge=?,lvl_joined_academy=?,apprentice=?,sponsor=?,varka_ketra_ally=?,clan_join_expiry_time=?,clan_create_expiry_time=?,char_name=?,death_penalty_level=?,bookmarkslot=?,vitality_points=?,language=?,hero=? WHERE charId=?";
    private static final String RESTORE_CHARACTER = "SELECT account_name, charId, char_name, level, maxHp, curHp, maxCp, curCp, maxMp, curMp, face, hairStyle, hairColor, sex, heading, x, y, z, exp, expBeforeDeath, sp, karma, fame, pvpkills, pkkills, clanid, race, classid, deletetime, cancraft, title, title_color, accesslevel, online, char_slot, lastAccess, clan_privs, wantspeace, base_class, onlinetime, isin7sdungeon, punish_level, punish_timer, newbie, nobless, power_grade, subpledge, lvl_joined_academy, apprentice, sponsor, varka_ketra_ally,clan_join_expiry_time,clan_create_expiry_time,death_penalty_level,bookmarkslot,vitality_points,createTime,language,hero FROM characters WHERE charId=?";
    private static final String INSERT_TP_BOOKMARK = "INSERT INTO character_tpbookmark (charId,Id,x,y,z,icon,tag,name) values (?,?,?,?,?,?,?,?)";
    private static final String UPDATE_TP_BOOKMARK = "UPDATE character_tpbookmark SET icon=?,tag=?,name=? where charId=? AND Id=?";
    private static final String RESTORE_TP_BOOKMARK = "SELECT Id,x,y,z,icon,tag,name FROM character_tpbookmark WHERE charId=?";
    private static final String DELETE_TP_BOOKMARK = "DELETE FROM character_tpbookmark WHERE charId=? AND Id=?";
    private static final String RESTORE_CHAR_SUBCLASSES = "SELECT class_id,exp,sp,level,class_index FROM character_subclasses WHERE charId=? ORDER BY class_index ASC";
    private static final String ADD_CHAR_SUBCLASS = "INSERT INTO character_subclasses (charId,class_id,exp,sp,level,class_index) VALUES (?,?,?,?,?,?)";
    private static final String UPDATE_CHAR_SUBCLASS = "UPDATE character_subclasses SET exp=?,sp=?,level=?,class_id=? WHERE charId=? AND class_index =?";
    private static final String DELETE_CHAR_SUBCLASS = "DELETE FROM character_subclasses WHERE charId=? AND class_index=?";
    private static final String RESTORE_CHAR_HENNAS = "SELECT slot,symbol_id FROM character_hennas WHERE charId=? AND class_index=?";
    private static final String ADD_CHAR_HENNA = "INSERT INTO character_hennas (charId,symbol_id,slot,class_index) VALUES (?,?,?,?)";
    private static final String DELETE_CHAR_HENNA = "DELETE FROM character_hennas WHERE charId=? AND slot=? AND class_index=?";
    private static final String DELETE_CHAR_HENNAS = "DELETE FROM character_hennas WHERE charId=? AND class_index=?";
    private static final String DELETE_CHAR_SHORTCUTS = "DELETE FROM character_shortcuts WHERE charId=? AND class_index=?";
    private static final String SELECT_CHAR_TRANSFORM = "SELECT transform_id FROM characters WHERE charId=?";
    private static final String UPDATE_CHAR_TRANSFORM = "UPDATE characters SET transform_id=? WHERE charId=?";
    public static final int REQUEST_TIMEOUT = 15;
    public static final int STORE_PRIVATE_NONE = 0;
    public static final int STORE_PRIVATE_SELL = 1;
    public static final int STORE_PRIVATE_BUY = 3;
    public static final int STORE_PRIVATE_MANUFACTURE = 5;
    public static final int STORE_PRIVATE_PACKAGE_SELL = 8;
    private L2GameClient _client;
    private String _accountName;
    private long _deleteTimer;
    private long _creationTime;
    private String _lang = null;
    private String _htmlPrefix = null;
    private volatile boolean _isOnline = false;
    private long _onlineTime;
    private long _onlineBeginTime;
    private long _lastAccess;
    private long _uptime;
    private final ReentrantLock _subclassLock = new ReentrantLock();
    protected int _baseClass;
    protected int _activeClass;
    protected int _classIndex = 0;
    private int _controlItemId;
    private L2PetData _data;
    private L2PetLevelData _leveldata;
    private int _curFeed;
    protected Future<?> _mountFeedTask;
    private ScheduledFuture<?> _dismountTask;
    private boolean _petItems = false;
    private Map<Integer, SubClass> _subClasses;
    private PcAppearance _appearance;
    private int _charId = 199546;
    private long _expBeforeDeath;
    private int _karma;
    private int _pvpKills;
    private int _pkKills;
    private byte _pvpFlag;
    private int _fame;
    private ScheduledFuture<?> _fameTask;
    private ScheduledFuture<?> _vitalityTask;
    private ScheduledFuture<?> _teleportWatchdog;
    private byte _siegeState = 0;
    private int _siegeSide = 0;
    private int _curWeightPenalty = 0;
    private int _lastCompassZone;
    private boolean _isIn7sDungeon = false;
    private int _bookmarkslot = 0;
    private List<TeleportBookmark> tpbookmark = new FastList();
    private PunishLevel _punishLevel = PunishLevel.NONE;
    private long _punishTimer = 0L;
    private ScheduledFuture<?> _punishTask;
    private boolean _inOlympiadMode = false;
    private boolean _OlympiadStart = false;
    private int _olympiadGameId = -1;
    private int _olympiadSide = -1;
    public int olyBuff = 0;
    private boolean _isInDuel = false;
    private int _duelState = 0;
    private int _duelId = 0;
    private SystemMessageId _noDuelReason = SystemMessageId.THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL;
    private L2Vehicle _vehicle = null;
    private Point3D _inVehiclePosition;
    public ScheduledFuture<?> _taskforfish;
    private int _mountType;
    private int _mountNpcId;
    private int _mountLevel;
    private int _mountObjectID = 0;
    public int _telemode = 0;
    private boolean _inCrystallize;
    private boolean _inCraftMode;
    private long _offlineShopStart = 0L;
    private L2Transformation _transformation;
    private int _transformationId = 0;
    private final Map<Integer, L2RecipeList> _dwarvenRecipeBook = new FastMap();
    private final Map<Integer, L2RecipeList> _commonRecipeBook = new FastMap();
    private final Map<Integer, L2PremiumItem> _premiumItems = new FastMap();
    private boolean _waitTypeSitting;
    private int _lastX;
    private int _lastY;
    private int _lastZ;
    private boolean _observerMode = false;
    private final Point3D _lastServerPosition = new Point3D(0, 0, 0);
    private int _recomHave;
    private int _recomLeft;
    private ScheduledFuture<?> _recoBonusTask;
    private ScheduledFuture<?> _recoGiveTask;
    private boolean _recoTwoHoursGiven = false;
    private final PcInventory _inventory = new PcInventory(this);
    private PcWarehouse _warehouse;
    private PcRefund _refund;
    private int _privatestore;
    private TradeList _activeTradeList;
    private ItemContainer _activeWarehouse;
    private L2ManufactureList _createList;
    private TradeList _sellList;
    private TradeList _buyList;
    private PreparedListContainer _currentMultiSell = null;
    private int _newbie;
    private boolean _noble = false;
    private boolean _hero = false;
    public boolean aura = false;
    public boolean voteServerRestart = false;
    private L2Npc _lastFolkNpc = null;
    private int _questNpcObject = 0;
    private final Map<String, QuestState> _quests = new FastMap();
    private final ShortCuts _shortCuts = new ShortCuts(this);
    private final MacroList _macroses = new MacroList(this);
    private final List<L2PcInstance> _snoopListener = new FastList();
    private final List<L2PcInstance> _snoopedPlayer = new FastList();
    private final L2HennaInstance[] _henna = new L2HennaInstance[3];
    private int _hennaSTR;
    private int _hennaINT;
    private int _hennaDEX;
    private int _hennaMEN;
    private int _hennaWIT;
    private int _hennaCON;
    private L2Summon _summon = null;
    private L2Decoy _decoy = null;
    private L2Trap _trap = null;
    private int _agathionId = 0;
    private List<L2TamedBeastInstance> _tamedBeast = null;
    private boolean _minimapAllowed = false;
    private int _partyroom = 0;
    private int _clanId;
    private L2Clan _clan;
    private int _apprentice = 0;
    private int _sponsor = 0;
    private long _clanJoinExpiryTime;
    private long _clanCreateExpiryTime;
    private int _powerGrade = 0;
    private int _clanPrivileges = 0;
    private int _pledgeClass = 0;
    private int _pledgeType = 0;
    private int _lvlJoinedAcademy = 0;
    private int _wantsPeace = 0;
    private int _deathPenaltyBuffLevel = 0;
    private final AtomicInteger _charges = new AtomicInteger();
    private ScheduledFuture<?> _chargeTask = null;
    private int _souls = 0;
    private ScheduledFuture<?> _soulTask = null;
    private Point3D _currentSkillWorldPosition;
    private L2AccessLevel _accessLevel;
    private boolean _messageRefusal = false;
    private boolean _silenceMode = false;
    private boolean _dietMode = false;
    private boolean _tradeRefusal = false;
    private boolean _exchangeRefusal = false;
    private L2Party _party;
    private L2PcInstance _activeRequester;
    private long _requestExpireTime = 0L;
    private final L2Request _request = new L2Request(this);
    private L2ItemInstance _arrowItem;
    private L2ItemInstance _boltItem;
    private long _protectEndTime = 0L;
    private long _teleportProtectEndTime = 0L;
    private long _recentFakeDeathEndTime = 0L;
    private boolean _isFakeDeath;
    private L2Weapon _fistsWeaponItem;
    private final Map<Integer, String> _chars = new FastMap();
    private int _expertiseArmorPenalty = 0;
    private int _expertiseWeaponPenalty = 0;
    private boolean _isEnchanting = false;
    private L2ItemInstance _activeEnchantItem = null;
    private L2ItemInstance _activeEnchantSupportItem = null;
    private L2ItemInstance _activeEnchantAttrItem = null;
    private long _activeEnchantTimestamp = 0L;
    protected boolean _inventoryDisable = false;
    protected Map<Integer, L2CubicInstance> _cubics = new FastMap().shared();
    protected FastSet<Integer> _activeSoulShots = new FastSet().shared();
    public final ReentrantLock soulShotLock = new ReentrantLock();
    public int eventX;
    public int eventY;
    public int eventZ;
    public int eventkarma;
    public int eventpvpkills;
    public int eventpkkills;
    public String eventTitle;
    public LinkedList<String> kills = new LinkedList();
    public boolean eventSitForced = false;
    public boolean atEvent = false;
    private byte _handysBlockCheckerEventArena = (byte)-1;
    private final int[] _loto = new int[5];
    private final int[] _race = new int[2];
    private final BlockList _blockList = new BlockList(this);
    private int _team = 0;
    private int _alliedVarkaKetra = 0;
    private L2Fishing _fishCombat;
    private boolean _fishing = false;
    private int _fishx = 0;
    private int _fishy = 0;
    private int _fishz = 0;
    private int[] _transformAllowedSkills = new int[0];
    private ScheduledFuture<?> _taskRentPet;
    private ScheduledFuture<?> _taskWater;
    private final List<String> _validBypass = new FastList();
    private final List<String> _validBypass2 = new FastList();
    private SkillDat _currentSkill;
    private SkillDat _currentPetSkill;
    private SkillDat _queuedSkill;
    private int _cursedWeaponEquippedId = 0;
    private boolean _combatFlagEquippedId = false;
    private int _reviveRequested = 0;
    private double _revivePower = 0.0;
    private boolean _revivePet = false;
    private double _cpUpdateIncCheck = 0.0;
    private double _cpUpdateDecCheck = 0.0;
    private double _cpUpdateInterval = 0.0;
    private double _mpUpdateIncCheck = 0.0;
    private double _mpUpdateDecCheck = 0.0;
    private double _mpUpdateInterval = 0.0;
    private boolean _isRidingStrider = false;
    private boolean _isFlyingMounted = false;
    private int _clientX;
    private int _clientY;
    private int _clientZ;
    private int _clientHeading;
    private static final int FALLING_VALIDATION_DELAY = 10000;
    private volatile long _fallingTimestamp = 0L;
    private int _multiSocialTarget = 0;
    private int _multiSociaAction = 0;
    private int _movieId = 0;
    private String _adminConfirmCmd = null;
    private volatile long _lastItemAuctionInfoRequest = 0L;
    private Future<?> _PvPRegTask;
    private long _pvpFlagLasts;
    private L2UIKeysSettings _uiKeySettings;
    private int _herbstask = 0;
    ScheduledFuture<?> _shortBuffTask = null;
    private boolean _married = false;
    private int _partnerId = 0;
    private int _coupleId = 0;
    private boolean _engagerequest = false;
    private int _engageid = 0;
    private boolean _marryrequest = false;
    private boolean _marryaccepted = false;
    private final SummonRequest _summonRequest = new SummonRequest();
    private final GatesRequest _gatesRequest = new GatesRequest();
    private List<QuestState> _notifyQuestOfDeathList;
    private boolean _gmEnable = true;
    private ScheduledFuture<?> _taskWarnUserTakeBreak;
    private FishData _fish;
    private L2ItemInstance _lure = null;
    public int _shortBuffTaskSkillId = 0;
    private final FastMap<Integer, TimeStamp> _reuseTimeStamps = new FastMap().shared();
    private boolean _canFeed;
    private int _eventEffectId = 0;
    private boolean _isInSiege;
    private boolean _expGainOn = true;
    private final List<Integer> _friendList = new FastList();

    public boolean isSpawnProtected() {
        return this._protectEndTime > (long)GameTimeController.getGameTicks();
    }

    public boolean isTeleportProtected() {
        return this._teleportProtectEndTime > (long)GameTimeController.getGameTicks();
    }

    public void setPvpFlagLasts(long time) {
        this._pvpFlagLasts = time;
    }

    public long getPvpFlagLasts() {
        return this._pvpFlagLasts;
    }

    public void startPvPFlag() {
        this.updatePvPFlag(1);
        this._PvPRegTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PvPFlag(), 1000L, 1000L);
    }

    public void stopPvpRegTask() {
        if (this._PvPRegTask != null) {
            this._PvPRegTask.cancel(true);
        }
    }

    public void stopPvPFlag() {
        this.stopPvpRegTask();
        this.updatePvPFlag(0);
        this._PvPRegTask = null;
    }

    public static L2PcInstance create(int objectId, L2PcTemplate template, String accountName, String name, byte hairStyle, byte hairColor, byte face, boolean sex) {
        PcAppearance app = new PcAppearance(face, hairColor, hairStyle, sex);
        L2PcInstance player = new L2PcInstance(objectId, template, accountName, app);
        player.setName(name);
        player.setCreateTime(System.currentTimeMillis());
        player.setBaseClass(player.getClassId());
        player.setNewbie(1);
        boolean ok = player.createDb();
        if (!ok) {
            return null;
        }
        return player;
    }

    public static L2PcInstance createDummyPlayer(int objectId, String name) {
        L2PcInstance player = new L2PcInstance(objectId);
        player.setName(name);
        return player;
    }

    public String getAccountName() {
        if (this.getClient() == null) {
            return this.getAccountNamePlayer();
        }
        return this.getClient().getAccountName();
    }

    public String getAccountNamePlayer() {
        return this._accountName;
    }

    public String getAccountName2() {
        return this._accountName;
    }

    public Map<Integer, String> getAccountChars() {
        return this._chars;
    }

    public int getRelation(L2PcInstance target) {
        int result = 0;
        if (this.getClan() != null) {
            result |= 0x40;
            if (this.getClan() == target.getClan()) {
                result |= 0x100;
            }
            if (this.getAllyId() != 0) {
                result |= 0x10000;
            }
        }
        if (this.isClanLeader()) {
            result |= 0x80;
        }
        if (this.getParty() != null && this.getParty() == target.getParty()) {
            result |= 0x20;
            block11: for (int i = 0; i < this.getParty().getPartyMembers().size(); ++i) {
                if (this.getParty().getPartyMembers().get(i) != this) continue;
                switch (i) {
                    case 0: {
                        result |= 0x10;
                        continue block11;
                    }
                    case 1: {
                        result |= 8;
                        continue block11;
                    }
                    case 2: {
                        result |= 7;
                        continue block11;
                    }
                    case 3: {
                        result |= 6;
                        continue block11;
                    }
                    case 4: {
                        result |= 5;
                        continue block11;
                    }
                    case 5: {
                        result |= 4;
                        continue block11;
                    }
                    case 6: {
                        result |= 3;
                        continue block11;
                    }
                    case 7: {
                        result |= 2;
                        continue block11;
                    }
                    case 8: {
                        result |= 1;
                    }
                }
            }
        }
        if (this.getSiegeState() != 0) {
            if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(this) != 0) {
                result |= 0x80000;
            } else {
                result |= 0x200;
                result = this.getSiegeState() != target.getSiegeState() ? (result |= 0x1000) : (result |= 0x800);
                if (this.getSiegeState() == 1) {
                    result |= 0x400;
                }
            }
        }
        if (this.getClan() != null && target.getClan() != null && target.getPledgeType() != -1 && this.getPledgeType() != -1 && target.getClan().isAtWarWith(this.getClan().getClanId())) {
            result |= 0x8000;
            if (this.getClan().isAtWarWith(target.getClan().getClanId())) {
                result |= 0x4000;
            }
        }
        if (this.getBlockCheckerArena() != -1) {
            result |= 0x200;
            HandysBlockCheckerManager.ArenaParticipantsHolder holder = HandysBlockCheckerManager.getInstance().getHolder(this.getBlockCheckerArena());
            result = holder.getPlayerTeam(this) == 0 ? (result |= 0x1000) : (result |= 0x800);
            result |= 0x400;
        }
        return result;
    }

    public static L2PcInstance load(int objectId) {
        return L2PcInstance.restore(objectId);
    }

    private void initPcStatusUpdateValues() {
        this._cpUpdateInterval = (double)this.getMaxCp() / 352.0;
        this._cpUpdateIncCheck = this.getMaxCp();
        this._cpUpdateDecCheck = (double)this.getMaxCp() - this._cpUpdateInterval;
        this._mpUpdateInterval = (double)this.getMaxMp() / 352.0;
        this._mpUpdateIncCheck = this.getMaxMp();
        this._mpUpdateDecCheck = (double)this.getMaxMp() - this._mpUpdateInterval;
    }

    private L2PcInstance(int objectId, L2PcTemplate template, String accountName, PcAppearance app) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2PcInstance);
        super.initCharStatusUpdateValues();
        this.initPcStatusUpdateValues();
        this._accountName = accountName;
        app.setOwner(this);
        this._appearance = app;
        this._ai = new L2PlayerAI(new AIAccessor());
        this.startVitalityTask();
    }

    private L2PcInstance(int objectId) {
        super(objectId, null);
        this.setInstanceType(L2Object.InstanceType.L2PcInstance);
        super.initCharStatusUpdateValues();
        this.initPcStatusUpdateValues();
    }

    @Override
    public final PcKnownList getKnownList() {
        return (PcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new PcKnownList(this));
    }

    @Override
    public final PcStat getStat() {
        return (PcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PcStat(this));
    }

    @Override
    public final PcStatus getStatus() {
        return (PcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new PcStatus(this));
    }

    @Override
    public PcPosition getPosition() {
        return (PcPosition)super.getPosition();
    }

    @Override
    public void initPosition() {
        this.setObjectPosition(new PcPosition(this));
    }

    public final PcAppearance getAppearance() {
        return this._appearance;
    }

    public final L2PcTemplate getBaseTemplate() {
        return CharTemplateTable.getInstance().getTemplate(this._baseClass, this.getAppearance().getSex());
    }

    @Override
    public final L2PcTemplate getTemplate() {
        return (L2PcTemplate)super.getTemplate();
    }

    public void setTemplate(ClassId newclass) {
        super.setTemplate(CharTemplateTable.getInstance().getTemplate(newclass, this.getAppearance().getSex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._ai == null) {
                    this._ai = new L2PlayerAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    @Override
    public final int getLevel() {
        return this.getStat().getLevel();
    }

    public int getNewbie() {
        return this._newbie;
    }

    public void setNewbie(int newbieRewards) {
        this._newbie = newbieRewards;
    }

    public void setBaseClass(int baseClass) {
        this._baseClass = baseClass;
    }

    public void setBaseClass(ClassId classId) {
        this._baseClass = classId.ordinal();
    }

    public boolean isInStoreMode() {
        return this.getPrivateStoreType() > 0;
    }

    public boolean isInCraftMode() {
        return this._inCraftMode;
    }

    public void isInCraftMode(boolean b) {
        this._inCraftMode = b;
    }

    public void logout() {
        this.logout(true);
    }

    public void logout(boolean closeClient) {
        try {
            this.closeNetConnection(closeClient);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on logout(): " + e.getMessage(), e);
        }
    }

    public L2RecipeList[] getCommonRecipeBook() {
        return this._commonRecipeBook.values().toArray(new L2RecipeList[this._commonRecipeBook.values().size()]);
    }

    public L2RecipeList[] getDwarvenRecipeBook() {
        return this._dwarvenRecipeBook.values().toArray(new L2RecipeList[this._dwarvenRecipeBook.values().size()]);
    }

    public void registerCommonRecipeList(L2RecipeList recipe, boolean saveToDb) {
        this._commonRecipeBook.put(recipe.getId(), recipe);
        if (saveToDb) {
            this.insertNewRecipeData(recipe.getId(), false);
        }
    }

    public void registerDwarvenRecipeList(L2RecipeList recipe, boolean saveToDb) {
        this._dwarvenRecipeBook.put(recipe.getId(), recipe);
        if (saveToDb) {
            this.insertNewRecipeData(recipe.getId(), true);
        }
    }

    public boolean hasRecipeList(int recipeId) {
        if (this._dwarvenRecipeBook.containsKey(recipeId)) {
            return true;
        }
        return this._commonRecipeBook.containsKey(recipeId);
    }

    public void unregisterRecipeList(int recipeId) {
        L2ShortCut[] allShortCuts;
        if (this._dwarvenRecipeBook.remove(recipeId) != null) {
            this.deleteRecipeData(recipeId, true);
        } else if (this._commonRecipeBook.remove(recipeId) != null) {
            this.deleteRecipeData(recipeId, false);
        } else {
            _log.warning("Attempted to remove unknown RecipeList: " + recipeId);
        }
        for (L2ShortCut sc : allShortCuts = this.getAllShortCuts()) {
            if (sc == null || sc.getId() != recipeId || sc.getType() != 5) continue;
            this.deleteShortCut(sc.getSlot(), sc.getPage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewRecipeData(int recipeId, boolean isDwarf) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO character_recipebook (charId, id, classIndex, type) values(?,?,?,?)");
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, recipeId);
            statement.setInt(3, isDwarf ? this._classIndex : 0);
            statement.setInt(4, isDwarf ? 1 : 0);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.log(Level.SEVERE, "SQL exception while inserting recipe: " + recipeId + " from character " + this.getObjectId(), e);
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecipeData(int recipeId, boolean isDwarf) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_recipebook WHERE charId=? AND id=? AND classIndex=?");
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, recipeId);
            statement.setInt(3, isDwarf ? this._classIndex : 0);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.log(Level.SEVERE, "SQL exception while deleting recipe: " + recipeId + " from character " + this.getObjectId(), e);
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public int getLastQuestNpcObject() {
        return this._questNpcObject;
    }

    public void setLastQuestNpcObject(int npcId) {
        this._questNpcObject = npcId;
    }

    public QuestState getQuestState(String quest) {
        return this._quests.get(quest);
    }

    public void setQuestState(QuestState qs) {
        this._quests.put(qs.getQuestName(), qs);
    }

    public void delQuestState(String quest) {
        this._quests.remove(quest);
    }

    private QuestState[] addToQuestStateArray(QuestState[] questStateArray, QuestState state) {
        int len = questStateArray.length;
        QuestState[] tmp = new QuestState[len + 1];
        for (int i = 0; i < len; ++i) {
            tmp[i] = questStateArray[i];
        }
        tmp[len] = state;
        return tmp;
    }

    public Quest[] getAllActiveQuests() {
        FastList quests = new FastList();
        for (QuestState qs : this._quests.values()) {
            int questId;
            if (qs == null || qs.getQuest() == null || (questId = qs.getQuest().getQuestIntId()) > 19999 || questId < 1 || !qs.isStarted() && !Config.DEVELOPER) continue;
            quests.add((Object)qs.getQuest());
        }
        return (Quest[])quests.toArray((Object[])new Quest[quests.size()]);
    }

    public QuestState[] getQuestsForAttacks(L2Npc npc) {
        QuestState[] states = null;
        for (Quest quest : npc.getTemplate().getEventQuests(Quest.QuestEventType.ON_ATTACK)) {
            if (this.getQuestState(quest.getName()) == null) continue;
            states = states == null ? new QuestState[]{this.getQuestState(quest.getName())} : this.addToQuestStateArray(states, this.getQuestState(quest.getName()));
        }
        return states;
    }

    public QuestState[] getQuestsForKills(L2Npc npc) {
        QuestState[] states = null;
        for (Quest quest : npc.getTemplate().getEventQuests(Quest.QuestEventType.ON_KILL)) {
            if (this.getQuestState(quest.getName()) == null) continue;
            states = states == null ? new QuestState[]{this.getQuestState(quest.getName())} : this.addToQuestStateArray(states, this.getQuestState(quest.getName()));
        }
        return states;
    }

    public QuestState[] getQuestsForTalk(int npcId) {
        QuestState[] states = null;
        Quest[] quests = NpcTable.getInstance().getTemplate(npcId).getEventQuests(Quest.QuestEventType.ON_TALK);
        if (quests != null) {
            for (Quest quest : quests) {
                if (quest == null || this.getQuestState(quest.getName()) == null) continue;
                states = states == null ? new QuestState[]{this.getQuestState(quest.getName())} : this.addToQuestStateArray(states, this.getQuestState(quest.getName()));
            }
        }
        return states;
    }

    public QuestState processQuestEvent(String quest, String event) {
        L2Npc npc;
        QuestState[] states;
        L2Object object;
        QuestState qs;
        QuestState retval = null;
        if (event == null) {
            event = "";
        }
        if ((qs = this.getQuestState(quest)) == null && event.length() == 0) {
            return retval;
        }
        if (qs == null) {
            Quest q = QuestManager.getInstance().getQuest(quest);
            if (q == null) {
                return retval;
            }
            qs = q.newQuestState(this);
        }
        if (qs != null && this.getLastQuestNpcObject() > 0 && (object = L2World.getInstance().findObject(this.getLastQuestNpcObject())) instanceof L2Npc && this.isInsideRadius(object, 150, false, false) && (states = this.getQuestsForTalk((npc = (L2Npc)object).getNpcId())) != null) {
            for (QuestState state : states) {
                if (!state.getQuest().getName().equals(qs.getQuest().getName())) continue;
                if (qs.getQuest().notifyEvent(event, npc, this)) {
                    this.showQuestWindow(quest, State.getStateName(qs.getState()));
                }
                retval = qs;
            }
        }
        return retval;
    }

    private void showQuestWindow(String questId, String stateId) {
        String path = "data/scripts/quests/" + questId + "/" + stateId + ".htm";
        String content = HtmCache.getInstance().getHtm(this.getHtmlPrefix(), path);
        if (content != null) {
            if (Config.DEBUG) {
                _log.fine("Showing quest window for quest " + questId + " state " + stateId + " html path: " + path);
            }
            NpcHtmlMessage npcReply = new NpcHtmlMessage(5);
            npcReply.setHtml(content);
            this.sendPacket(npcReply);
        }
        this.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void addNotifyQuestOfDeath(QuestState qs) {
        if (qs == null) {
            return;
        }
        if (!this.getNotifyQuestOfDeath().contains(qs)) {
            this.getNotifyQuestOfDeath().add(qs);
        }
    }

    public void removeNotifyQuestOfDeath(QuestState qs) {
        if (qs == null || this._notifyQuestOfDeathList == null) {
            return;
        }
        this._notifyQuestOfDeathList.remove(qs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<QuestState> getNotifyQuestOfDeath() {
        if (this._notifyQuestOfDeathList == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._notifyQuestOfDeathList == null) {
                    this._notifyQuestOfDeathList = new FastList();
                }
            }
        }
        return this._notifyQuestOfDeathList;
    }

    public final boolean isNotifyQuestOfDeathEmpty() {
        return this._notifyQuestOfDeathList == null || this._notifyQuestOfDeathList.isEmpty();
    }

    public L2ShortCut[] getAllShortCuts() {
        return this._shortCuts.getAllShortCuts();
    }

    public L2ShortCut getShortCut(int slot, int page) {
        return this._shortCuts.getShortCut(slot, page);
    }

    public void registerShortCut(L2ShortCut shortcut) {
        this._shortCuts.registerShortCut(shortcut);
    }

    public void deleteShortCut(int slot, int page) {
        this._shortCuts.deleteShortCut(slot, page);
    }

    public void registerMacro(L2Macro macro) {
        this._macroses.registerMacro(macro);
    }

    public void deleteMacro(int id) {
        this._macroses.deleteMacro(id);
    }

    public MacroList getMacroses() {
        return this._macroses;
    }

    public void setSiegeState(byte siegeState) {
        this._siegeState = siegeState;
    }

    public byte getSiegeState() {
        return this._siegeState;
    }

    public void setSiegeSide(int val) {
        this._siegeSide = val;
    }

    public boolean isRegisteredOnThisSiegeField(int val) {
        return this._siegeSide == val || this._siegeSide >= 81 && this._siegeSide <= 89;
    }

    public int getSiegeSide() {
        return this._siegeSide;
    }

    public void setPvpFlag(int pvpFlag) {
        this._pvpFlag = (byte)pvpFlag;
    }

    @Override
    public byte getPvpFlag() {
        return this._pvpFlag;
    }

    @Override
    public void updatePvPFlag(int value) {
        if (this.getPvpFlag() == value) {
            return;
        }
        this.setPvpFlag(value);
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        if (this.getPet() != null) {
            this.sendPacket(new RelationChanged(this.getPet(), this.getRelation(this), false));
        }
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance target : plrs) {
            target.sendPacket(new RelationChanged(this, this.getRelation(target), this.isAutoAttackable(target)));
            if (this.getPet() == null) continue;
            target.sendPacket(new RelationChanged(this.getPet(), this.getRelation(target), this.isAutoAttackable(target)));
        }
    }

    @Override
    public void revalidateZone(boolean force) {
        if (this.getWorldRegion() == null) {
            return;
        }
        if (force) {
            this._zoneValidateCounter = (byte)4;
        } else {
            this._zoneValidateCounter = (byte)(this._zoneValidateCounter - 1);
            if (this._zoneValidateCounter < 0) {
                this._zoneValidateCounter = (byte)4;
            } else {
                return;
            }
        }
        this.getWorldRegion().revalidateZones(this);
        if (Config.ALLOW_WATER) {
            this.checkWaterState();
        }
        if (this.isInsideZone((byte)19)) {
            if (this._lastCompassZone == 8) {
                return;
            }
            this._lastCompassZone = 8;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(8);
            this.sendPacket(cz);
        } else if (this.isInsideZone((byte)2)) {
            if (this._lastCompassZone == 11) {
                return;
            }
            this._lastCompassZone = 11;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(11);
            this.sendPacket(cz);
        } else if (this.isInsideZone((byte)0)) {
            if (this._lastCompassZone == 14) {
                return;
            }
            this._lastCompassZone = 14;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(14);
            this.sendPacket(cz);
        } else if (this.isIn7sDungeon()) {
            if (this._lastCompassZone == 13) {
                return;
            }
            this._lastCompassZone = 13;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(13);
            this.sendPacket(cz);
        } else if (this.isInsideZone((byte)1)) {
            if (this._lastCompassZone == 12) {
                return;
            }
            this._lastCompassZone = 12;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(12);
            this.sendPacket(cz);
        } else {
            if (this._lastCompassZone == 15) {
                return;
            }
            if (this._lastCompassZone == 11) {
                this.updatePvPStatus();
            }
            this._lastCompassZone = 15;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(15);
            this.sendPacket(cz);
        }
    }

    public boolean hasDwarvenCraft() {
        return this.getSkillLevel(172) >= 1;
    }

    public int getDwarvenCraft() {
        return this.getSkillLevel(172);
    }

    public boolean hasCommonCraft() {
        return this.getSkillLevel(1320) >= 1;
    }

    public int getCommonCraft() {
        return this.getSkillLevel(1320);
    }

    public int getPkKills() {
        return this._pkKills;
    }

    public void setPkKills(int pkKills) {
        this._pkKills = pkKills;
    }

    public long getDeleteTimer() {
        return this._deleteTimer;
    }

    public void setDeleteTimer(long deleteTimer) {
        this._deleteTimer = deleteTimer;
    }

    public int getCurrentLoad() {
        return this._inventory.getTotalWeight();
    }

    public int getRecomHave() {
        return this._recomHave;
    }

    protected void incRecomHave() {
        if (this._recomHave < 255) {
            ++this._recomHave;
        }
    }

    public void setRecomHave(int value) {
        this._recomHave = value > 255 ? 255 : (value < 0 ? 0 : value);
    }

    public void setRecomLeft(int value) {
        this._recomLeft = value > 255 ? 255 : (value < 0 ? 0 : value);
    }

    public int getRecomLeft() {
        return this._recomLeft;
    }

    protected void decRecomLeft() {
        if (this._recomLeft > 0) {
            --this._recomLeft;
        }
    }

    public void giveRecom(L2PcInstance target) {
        target.incRecomHave();
        this.decRecomLeft();
    }

    public void setExpBeforeDeath(long exp) {
        this._expBeforeDeath = exp;
    }

    public long getExpBeforeDeath() {
        return this._expBeforeDeath;
    }

    @Override
    public int getKarma() {
        return this._karma;
    }

    public void setKarma(int karma) {
        if (karma < 0) {
            karma = 0;
        }
        if (this._karma == 0 && karma > 0) {
            Collection<L2Object> objs = this.getKnownList().getKnownObjects().values();
            for (L2Object object : objs) {
                if (!(object instanceof L2GuardInstance) || ((L2GuardInstance)object).getAI().getIntention() != CtrlIntention.AI_INTENTION_IDLE) continue;
                ((L2GuardInstance)object).getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        } else if (this._karma > 0 && karma == 0) {
            this.setKarmaFlag(0);
        }
        this._karma = karma;
        this.broadcastKarma();
    }

    public int getMaxLoad() {
        int con = this.getCON();
        if (con < 1) {
            return 31000;
        }
        if (con > 59) {
            return 176000;
        }
        double baseLoad = Math.pow(1.029993928, con) * 30495.627366;
        return (int)this.calcStat(Stats.MAX_LOAD, baseLoad * Config.ALT_WEIGHT_LIMIT, this, null);
    }

    public int getExpertiseArmorPenalty() {
        return this._expertiseArmorPenalty;
    }

    public int getExpertiseWeaponPenalty() {
        return this._expertiseWeaponPenalty;
    }

    public int getWeightPenalty() {
        if (this._dietMode) {
            return 0;
        }
        return this._curWeightPenalty;
    }

    public void refreshOverloaded() {
        int maxLoad = this.getMaxLoad();
        if (maxLoad > 0) {
            long weightproc = (long)this.getCurrentLoad() * 1000L / (long)maxLoad;
            int newWeightPenalty = (weightproc = (long)((double)weightproc * this.calcStat(Stats.WEIGHT_LIMIT, 1.0, this, null))) < 500L || this._dietMode ? 0 : (weightproc < 666L ? 1 : (weightproc < 800L ? 2 : (weightproc < 1000L ? 3 : 4)));
            if (this._curWeightPenalty != newWeightPenalty) {
                this._curWeightPenalty = newWeightPenalty;
                if (newWeightPenalty > 0 && !this._dietMode) {
                    super.addSkill(SkillTable.getInstance().getInfo(4270, newWeightPenalty));
                    this.setIsOverloaded(this.getCurrentLoad() > maxLoad);
                } else {
                    super.removeSkill(this.getKnownSkill(4270));
                    this.setIsOverloaded(false);
                }
                this.sendPacket(new UserInfo(this));
                this.sendPacket(new EtcStatusUpdate(this));
                this.broadcastPacket(new CharInfo(this));
                this.broadcastPacket(new ExBrExtraUserInfo(this));
            }
        }
    }

    public void refreshExpertisePenalty() {
        if (!Config.EXPERTISE_PENALTY) {
            return;
        }
        int armorPenalty = 0;
        int weaponPenalty = 0;
        for (L2ItemInstance item : this.getInventory().getItems()) {
            int crystaltype;
            if (item == null || !item.isEquipped() || item.getItemType() == L2EtcItemType.ARROW || item.getItemType() == L2EtcItemType.BOLT || (crystaltype = item.getItem().getCrystalType()) <= this.getExpertiseLevel()) continue;
            if (item.isWeapon() && crystaltype > weaponPenalty) {
                weaponPenalty = crystaltype;
                continue;
            }
            if (crystaltype <= armorPenalty) continue;
            armorPenalty = crystaltype;
        }
        boolean changed = false;
        if ((armorPenalty -= this.getExpertiseLevel()) < 0) {
            armorPenalty = 0;
        } else if (armorPenalty > 4) {
            armorPenalty = 4;
        }
        if (this.getExpertiseArmorPenalty() != armorPenalty || this.getSkillLevel(6213) != armorPenalty) {
            this._expertiseArmorPenalty = armorPenalty;
            if (this._expertiseArmorPenalty > 0) {
                super.addSkill(SkillTable.getInstance().getInfo(6213, this._expertiseArmorPenalty));
            } else {
                super.removeSkill(this.getKnownSkill(6213));
            }
            changed = true;
        }
        if ((weaponPenalty -= this.getExpertiseLevel()) < 0) {
            weaponPenalty = 0;
        } else if (weaponPenalty > 4) {
            weaponPenalty = 4;
        }
        if (this.getExpertiseWeaponPenalty() != weaponPenalty || this.getSkillLevel(6209) != weaponPenalty) {
            this._expertiseWeaponPenalty = weaponPenalty;
            if (this._expertiseWeaponPenalty > 0) {
                super.addSkill(SkillTable.getInstance().getInfo(6209, this._expertiseWeaponPenalty));
            } else {
                super.removeSkill(this.getKnownSkill(6209));
            }
            changed = true;
        }
        if (changed) {
            this.sendPacket(new EtcStatusUpdate(this));
        }
    }

    public void checkIfWeaponIsAllowed() {
        if (this.isGM()) {
            return;
        }
        for (L2Effect currenteffect : this.getAllEffects()) {
            L2Skill effectSkill = currenteffect.getSkill();
            if (effectSkill.isOffensive() || effectSkill.getTargetType() == L2Skill.SkillTargetType.TARGET_PARTY && effectSkill.getSkillType() == L2SkillType.BUFF || effectSkill.getWeaponDependancy(this)) continue;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(effectSkill);
            this.sendPacket(sm);
            if (Config.DEBUG) {
                _log.info("   | Skill " + effectSkill.getName() + " has been disabled for (" + this.getName() + "); Reason: Incompatible Weapon Type.");
            }
            currenteffect.exit();
        }
    }

    public void checkSShotsMatch(L2ItemInstance equipped, L2ItemInstance unequipped) {
        if (unequipped == null) {
            return;
        }
        unequipped.setChargedSoulshot(0);
        unequipped.setChargedSpiritshot(0);
    }

    public void useEquippableItem(L2ItemInstance item, boolean abortAttack) {
        L2ItemInstance[] items = null;
        boolean isEquiped = item.isEquipped();
        int oldInvLimit = this.getInventoryLimit();
        SystemMessage sm = null;
        if ((item.getItem().getBodyPart() & 0x4080) != 0) {
            L2ItemInstance old = this.getInventory().getPaperdollItem(5);
            this.checkSShotsMatch(item, old);
        }
        if (isEquiped) {
            if (item.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addNumber(item.getEnchantLevel());
                sm.addItemName(item);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(item);
            }
            this.sendPacket(sm);
            int slot = this.getInventory().getSlotFromItem(item);
            items = slot == 0x400000 ? this.getInventory().unEquipItemInSlotAndRecord(item.getLocationSlot()) : this.getInventory().unEquipItemInBodySlotAndRecord(slot);
        } else {
            items = this.getInventory().equipItemAndRecord(item);
            if (item.isEquipped()) {
                if (item.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_S2_EQUIPPED);
                    sm.addNumber(item.getEnchantLevel());
                    sm.addItemName(item);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_EQUIPPED);
                    sm.addItemName(item);
                }
                this.sendPacket(sm);
                item.decreaseMana(false);
                if ((item.getItem().getBodyPart() & 0x4080) != 0) {
                    this.rechargeAutoSoulShot(true, true, false);
                }
            } else {
                this.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
            }
        }
        this.refreshExpertisePenalty();
        this.checkAuraItemEquipped();
        this.broadcastUserInfo();
        InventoryUpdate iu = new InventoryUpdate();
        iu.addItems(Arrays.asList(items));
        this.sendPacket(iu);
        if (abortAttack) {
            this.abortAttack();
        }
        if (this.getInventoryLimit() != oldInvLimit) {
            this.sendPacket(new ExStorageMaxCount(this));
        }
    }

    public int getPvpKills() {
        return this._pvpKills;
    }

    public void setPvpKills(int pvpKills) {
        this._pvpKills = pvpKills;
    }

    public int getFame() {
        return this._fame;
    }

    public void setFame(int fame) {
        this._fame = fame > Config.MAX_PERSONAL_FAME_POINTS ? Config.MAX_PERSONAL_FAME_POINTS : fame;
    }

    public ClassId getClassId() {
        return this.getTemplate().classId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassId(int Id) {
        if (!this._subclassLock.tryLock()) {
            return;
        }
        try {
            if (this.getLvlJoinedAcademy() != 0 && this._clan != null && PlayerClass.values()[Id].getLevel() == ClassLevel.Third) {
                if (this.getLvlJoinedAcademy() <= 16) {
                    this._clan.addReputationScore(Config.JOIN_ACADEMY_MAX_REP_SCORE, true);
                } else if (this.getLvlJoinedAcademy() >= 39) {
                    this._clan.addReputationScore(Config.JOIN_ACADEMY_MIN_REP_SCORE, true);
                } else {
                    this._clan.addReputationScore(Config.JOIN_ACADEMY_MAX_REP_SCORE - (this.getLvlJoinedAcademy() - 16) * 20, true);
                }
                this.setLvlJoinedAcademy(0);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_EXPELLED);
                msg.addPcName(this);
                this._clan.broadcastToOnlineMembers(msg);
                this._clan.broadcastToOnlineMembers(new PledgeShowMemberListDelete(this.getName()));
                this._clan.removeClanMember(this.getObjectId(), 0L);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ACADEMY_MEMBERSHIP_TERMINATED));
                this.getInventory().addItem("Gift", 8181, 1L, this, null);
            }
            if (this.isSubClassActive()) {
                this.getSubClasses().get(this._classIndex).setClassId(Id);
            }
            this.setTarget(this);
            this.broadcastPacket(new MagicSkillUse(this, 5103, 1, 1000, 0));
            this.setClassTemplate(Id);
            if (this.getClassId().level() == 3) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THIRD_CLASS_TRANSFER));
            } else {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLASS_TRANSFER));
            }
            if (this.isInParty()) {
                this.getParty().broadcastToPartyMembers(new PartySmallWindowUpdate(this));
            }
            if (this.getClan() != null) {
                this.getClan().broadcastToOnlineMembers(new PledgeShowMemberListUpdate(this));
            }
            this.rewardSkills();
            if (!this.isGM() && Config.DECREASE_SKILL_LEVEL) {
                this.checkPlayerSkills();
            }
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    public long getExp() {
        return this.getStat().getExp();
    }

    public void setActiveEnchantAttrItem(L2ItemInstance stone) {
        this._activeEnchantAttrItem = stone;
    }

    public L2ItemInstance getActiveEnchantAttrItem() {
        return this._activeEnchantAttrItem;
    }

    public void setActiveEnchantItem(L2ItemInstance scroll) {
        if (scroll == null) {
            this.setActiveEnchantSupportItem(null);
            this.setActiveEnchantTimestamp(0L);
            this.setIsEnchanting(false);
        }
        this._activeEnchantItem = scroll;
    }

    public L2ItemInstance getActiveEnchantItem() {
        return this._activeEnchantItem;
    }

    public void setActiveEnchantSupportItem(L2ItemInstance item) {
        this._activeEnchantSupportItem = item;
    }

    public L2ItemInstance getActiveEnchantSupportItem() {
        return this._activeEnchantSupportItem;
    }

    public long getActiveEnchantTimestamp() {
        return this._activeEnchantTimestamp;
    }

    public void setActiveEnchantTimestamp(long val) {
        this._activeEnchantTimestamp = val;
    }

    public void setIsEnchanting(boolean val) {
        this._isEnchanting = val;
    }

    public boolean isEnchanting() {
        return this._isEnchanting;
    }

    public void setFistsWeaponItem(L2Weapon weaponItem) {
        this._fistsWeaponItem = weaponItem;
    }

    public L2Weapon getFistsWeaponItem() {
        return this._fistsWeaponItem;
    }

    public L2Weapon findFistsWeaponItem(int classId) {
        L2Weapon weaponItem = null;
        if (classId >= 0 && classId <= 9) {
            L2Item temp = ItemTable.getInstance().getTemplate(246);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 10 && classId <= 17) {
            L2Item temp = ItemTable.getInstance().getTemplate(251);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 18 && classId <= 24) {
            L2Item temp = ItemTable.getInstance().getTemplate(244);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 25 && classId <= 30) {
            L2Item temp = ItemTable.getInstance().getTemplate(249);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 31 && classId <= 37) {
            L2Item temp = ItemTable.getInstance().getTemplate(245);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 38 && classId <= 43) {
            L2Item temp = ItemTable.getInstance().getTemplate(250);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 44 && classId <= 48) {
            L2Item temp = ItemTable.getInstance().getTemplate(248);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 49 && classId <= 52) {
            L2Item temp = ItemTable.getInstance().getTemplate(252);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 53 && classId <= 57) {
            L2Item temp = ItemTable.getInstance().getTemplate(247);
            weaponItem = (L2Weapon)temp;
        }
        return weaponItem;
    }

    public void rewardSkills() {
        if (Config.AUTO_LEARN_SKILLS) {
            this.giveAvailableSkills(Config.AUTO_LEARN_FS_SKILLS, true);
        } else {
            this.giveAvailableAutoGetSkills();
        }
        this.checkItemRestriction();
        this.sendSkillList();
    }

    public void regiveTemporarySkills() {
        if (this.isNoble()) {
            this.setNoble(true);
        }
        if (this.isHero()) {
            this.setHero(true);
        }
        if (this.getClan() != null) {
            L2Clan clan = this.getClan();
            clan.addSkillEffects(this);
            if (clan.getLevel() >= SiegeManager.getInstance().getSiegeClanMinLevel() && this.isClanLeader()) {
                SiegeManager.getInstance().addSiegeSkills(this);
            }
            if (this.getClan().getHasCastle() > 0) {
                CastleManager.getInstance().getCastleByOwner(this.getClan()).giveResidentialSkills(this);
            }
            if (this.getClan().getHasFort() > 0) {
                FortManager.getInstance().getFortByOwner(this.getClan()).giveResidentialSkills(this);
            }
        }
        this.getInventory().reloadEquippedItems();
        this.restoreDeathPenaltyBuffLevel();
    }

    public int giveAvailableSkills(boolean includedByFs, boolean includeAutoGet) {
        int unLearnable = 0;
        int skillCounter = 0;
        FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableSkills(this, this.getClassId(), includedByFs, includeAutoGet);
        while (skills.size() > unLearnable) {
            for (L2SkillLearn s : skills) {
                L2Effect toggleEffect;
                L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                if (sk == null || sk.getId() == 1405 && !Config.AUTO_LEARN_DIVINE_INSPIRATION && !this.isGM()) {
                    ++unLearnable;
                    continue;
                }
                if (this.getSkillLevel(sk.getId()) == -1) {
                    ++skillCounter;
                }
                if (sk.isToggle() && (toggleEffect = this.getFirstEffect(sk.getId())) != null) {
                    toggleEffect.exit();
                    sk.getEffects(this, this);
                }
                this.addSkill(sk, true);
            }
            skills = SkillTreesData.getInstance().getAvailableSkills(this, this.getClassId(), includedByFs, includeAutoGet);
        }
        this.sendMessage(skillCounter + "\u306e\u30b9\u30ad\u30eb\u3092\u7fd2\u5f97\u3057\u307e\u3057\u305f\u3002");
        return skillCounter;
    }

    public void giveAvailableAutoGetSkills() {
        FastList<L2SkillLearn> autoGetSkills = SkillTreesData.getInstance().getAvailableAutoGetSkills(this);
        if (autoGetSkills != null && !autoGetSkills.isEmpty()) {
            for (L2SkillLearn s : autoGetSkills) {
                L2Skill skill = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                if (skill != null) {
                    this.addSkill(skill, true);
                    continue;
                }
                _log.warning("Skipped null autoGet Skill for player:" + this.getName() + "[" + this.getObjectId() + "]");
            }
        }
    }

    public void setExp(long exp) {
        if (exp < 0L) {
            exp = 0L;
        }
        this.getStat().setExp(exp);
    }

    public Race getRace() {
        if (!this.isSubClassActive()) {
            return this.getTemplate().race;
        }
        L2PcTemplate charTemp = CharTemplateTable.getInstance().getTemplate(this._baseClass, this.getAppearance().getSex());
        return charTemp.race;
    }

    public L2Radar getRadar() {
        return new L2Radar(this);
    }

    public boolean isMinimapAllowed() {
        return this._minimapAllowed;
    }

    public void setMinimapAllowed(boolean b) {
        this._minimapAllowed = b;
    }

    public int getSp() {
        return this.getStat().getSp();
    }

    public void setSp(int sp) {
        if (sp < 0) {
            sp = 0;
        }
        super.getStat().setSp(sp);
    }

    public boolean isCastleLord(int castleId) {
        Castle castle;
        L2Clan clan = this.getClan();
        return clan != null && clan.getLeader().getPlayerInstance() == this && (castle = CastleManager.getInstance().getCastleByOwner(clan)) != null && castle == CastleManager.getInstance().getCastleById(castleId);
    }

    public int getClanId() {
        return this._clanId;
    }

    public int getClanCrestId() {
        if (this._clan != null) {
            return this._clan.getCrestId();
        }
        return 0;
    }

    public int getClanCrestLargeId() {
        if (this._clan != null) {
            return this._clan.getCrestLargeId();
        }
        return 0;
    }

    public long getClanJoinExpiryTime() {
        return this._clanJoinExpiryTime;
    }

    public void setClanJoinExpiryTime(long time) {
        this._clanJoinExpiryTime = time;
    }

    public long getClanCreateExpiryTime() {
        return this._clanCreateExpiryTime;
    }

    public void setClanCreateExpiryTime(long time) {
        this._clanCreateExpiryTime = time;
    }

    public void setOnlineTime(long time) {
        this._onlineTime = time;
        this._onlineBeginTime = System.currentTimeMillis();
    }

    @Override
    public PcInventory getInventory() {
        return this._inventory;
    }

    public void removeItemFromShortCut(int objectId) {
        this._shortCuts.deleteShortCutByObjectId(objectId);
    }

    public boolean isSitting() {
        return this._waitTypeSitting;
    }

    public void setIsSitting(boolean state) {
        this._waitTypeSitting = state;
    }

    public void sitDown() {
        this.sitDown(true);
    }

    public void sitDown(boolean checkCast) {
        if (checkCast && this.isCastingNow()) {
            return;
        }
        if (!(this._waitTypeSitting || this.isAttackingDisabled() || this.isOutOfControl() || this.isImmobilized())) {
            this.breakAttack();
            this.setIsSitting(true);
            this.broadcastPacket(new ChangeWaitType(this, 0));
            ThreadPoolManager.getInstance().scheduleGeneral(new SitDownTask(), 2500L);
            this.setIsParalyzed(true);
        }
    }

    public void standUp() {
        if (L2Event.active && this.eventSitForced) {
            this.sendMessage("A dark force beyond your mortal understanding makes your knees to shake when you try to stand up ...");
        } else if (this._waitTypeSitting && !this.isInStoreMode() && !this.isAlikeDead()) {
            if (this._effects.isAffected(64)) {
                this.stopEffects(L2EffectType.RELAXING);
            }
            this.broadcastPacket(new ChangeWaitType(this, 1));
            ThreadPoolManager.getInstance().scheduleGeneral(new StandUpTask(), 2500L);
        }
    }

    public PcWarehouse getWarehouse() {
        if (this._warehouse == null) {
            this._warehouse = new PcWarehouse(this);
            this._warehouse.restore();
        }
        if (Config.WAREHOUSE_CACHE) {
            WarehouseCacheManager.getInstance().addCacheTask(this);
        }
        return this._warehouse;
    }

    public void clearWarehouse() {
        if (this._warehouse != null) {
            this._warehouse.deleteMe();
        }
        this._warehouse = null;
    }

    public boolean hasRefund() {
        return this._refund != null && this._refund.getSize() > 0 && Config.ALLOW_REFUND;
    }

    public PcRefund getRefund() {
        if (this._refund == null) {
            this._refund = new PcRefund(this);
        }
        return this._refund;
    }

    public void clearRefund() {
        if (this._refund != null) {
            this._refund.deleteMe();
        }
        this._refund = null;
    }

    @Deprecated
    public int getCharId() {
        return this._charId;
    }

    public void setCharId(int charId) {
        this._charId = charId;
    }

    public long getAdena() {
        return this._inventory.getAdena();
    }

    public long getAncientAdena() {
        return this._inventory.getAncientAdena();
    }

    public void addAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_ADENA);
            sm.addItemNumber(count);
            this.sendPacket(sm);
        }
        if (count > 0L) {
            this._inventory.addAdena(process, count, this, reference);
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(this._inventory.getAdenaInstance());
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
        }
    }

    public boolean reduceAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (count > this.getAdena()) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            }
            return false;
        }
        if (count > 0L) {
            L2ItemInstance adenaItem = this._inventory.getAdenaInstance();
            if (!this._inventory.reduceAdena(process, count, this, reference)) {
                return false;
            }
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(adenaItem);
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            if (sendMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED_ADENA);
                sm.addItemNumber(count);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public void addAncientAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
            sm.addItemName(5575);
            sm.addItemNumber(count);
            this.sendPacket(sm);
        }
        if (count > 0L) {
            this._inventory.addAncientAdena(process, count, this, reference);
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(this._inventory.getAncientAdenaInstance());
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
        }
    }

    public boolean reduceAncientAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (count > this.getAncientAdena()) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            }
            return false;
        }
        if (count > 0L) {
            L2ItemInstance ancientAdenaItem = this._inventory.getAncientAdenaInstance();
            if (!this._inventory.reduceAncientAdena(process, count, this, reference)) {
                return false;
            }
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(ancientAdenaItem);
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            if (sendMessage) {
                SystemMessage sm;
                if (count > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(5575);
                    sm.addItemNumber(count);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(5575);
                    this.sendPacket(sm);
                }
            }
        }
        return true;
    }

    public void addItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        if (item.getCount() > 0L) {
            TerritoryWard ward;
            if (sendMessage) {
                SystemMessage sm;
                if (item.getCount() > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                    sm.addItemName(item);
                    sm.addItemNumber(item.getCount());
                    this.sendPacket(sm);
                } else if (item.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_A_S1_S2);
                    sm.addNumber(item.getEnchantLevel());
                    sm.addItemName(item);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1);
                    sm.addItemName(item);
                    this.sendPacket(sm);
                }
            }
            L2ItemInstance newitem = this._inventory.addItem(process, item, this, reference);
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate playerIU = new InventoryUpdate();
                playerIU.addItem(newitem);
                this.sendPacket(playerIU);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(14, this.getCurrentLoad());
            this.sendPacket(su);
            if (!(this.isGM() || this._inventory.validateCapacity(0, item.isQuestItem()) || !newitem.isDropable() || newitem.isStackable() && newitem.getLastChange() == 2)) {
                this.dropItem("InvDrop", newitem, null, true, true);
            } else if (CursedWeaponsManager.getInstance().isCursed(newitem.getItemId())) {
                CursedWeaponsManager.getInstance().activate(this, newitem);
            } else if (FortSiegeManager.getInstance().isCombat(item.getItemId())) {
                if (FortSiegeManager.getInstance().activateCombatFlag(this, item)) {
                    Fort fort = FortManager.getInstance().getFort(this);
                    fort.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.C1_ACQUIRED_THE_FLAG), this.getName());
                }
            } else if (item.getItemId() >= 13560 && item.getItemId() <= 13568 && (ward = TerritoryWarManager.getInstance().getTerritoryWard(item.getItemId() - 13479)) != null) {
                ward.activate(this, item);
            }
        }
    }

    public L2ItemInstance addItem(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (count > 0L) {
            L2ItemInstance item = null;
            if (ItemTable.getInstance().getTemplate(itemId) == null) {
                _log.log(Level.SEVERE, "Item doesn't exist so cannot be added. Item ID: " + itemId);
                return null;
            }
            item = ItemTable.getInstance().createDummyItem(itemId);
            if (sendMessage && (!this.isCastingNow() && item.getItemType() == L2EtcItemType.HERB || item.getItemType() != L2EtcItemType.HERB)) {
                SystemMessage sm;
                if (count > 1L) {
                    if (process.equalsIgnoreCase("sweep") || process.equalsIgnoreCase("Quest")) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        sm.addItemName(itemId);
                        sm.addItemNumber(count);
                        this.sendPacket(sm);
                    } else {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                        sm.addItemName(itemId);
                        sm.addItemNumber(count);
                        this.sendPacket(sm);
                    }
                } else if (process.equalsIgnoreCase("sweep") || process.equalsIgnoreCase("Quest")) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                    sm.addItemName(itemId);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1);
                    sm.addItemName(itemId);
                    this.sendPacket(sm);
                }
            }
            if (item.getItemType() == L2EtcItemType.HERB) {
                if (!this.isCastingNow()) {
                    L2ItemInstance herb = new L2ItemInstance(this._charId, itemId);
                    IItemHandler handler = ItemHandler.getInstance().getItemHandler(herb.getEtcItem());
                    if (handler == null) {
                        _log.warning("No item handler registered for Herb - item ID " + herb.getItemId() + ".");
                    } else {
                        handler.useItem(this, herb, false);
                        if (this._herbstask >= 100) {
                            this._herbstask -= 100;
                        }
                    }
                } else {
                    this._herbstask += 100;
                    ThreadPoolManager.getInstance().scheduleAi(new HerbTask(process, itemId, count, reference, sendMessage), this._herbstask);
                }
            } else {
                TerritoryWard ward;
                L2ItemInstance createdItem = this._inventory.addItem(process, itemId, count, this, reference);
                if (!(this.isGM() || this._inventory.validateCapacity(0, item.isQuestItem()) || !createdItem.isDropable() || createdItem.isStackable() && createdItem.getLastChange() == 2)) {
                    this.dropItem("InvDrop", createdItem, null, true);
                } else if (CursedWeaponsManager.getInstance().isCursed(createdItem.getItemId())) {
                    CursedWeaponsManager.getInstance().activate(this, createdItem);
                } else if (FortSiegeManager.getInstance().isCombat(createdItem.getItemId())) {
                    if (FortSiegeManager.getInstance().activateCombatFlag(this, item)) {
                        Fort fort = FortManager.getInstance().getFort(this);
                        fort.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.C1_ACQUIRED_THE_FLAG), this.getName());
                    }
                } else if (createdItem.getItemId() >= 13560 && createdItem.getItemId() <= 13568 && (ward = TerritoryWarManager.getInstance().getTerritoryWard(createdItem.getItemId() - 13479)) != null) {
                    ward.activate(this, createdItem);
                }
                return createdItem;
            }
        }
        return null;
    }

    public boolean destroyItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        return this.destroyItem(process, item, item.getCount(), reference, sendMessage);
    }

    public boolean destroyItem(String process, L2ItemInstance item, long count, L2Object reference, boolean sendMessage) {
        if ((item = this._inventory.destroyItem(process, item, count, this, (Object)reference)) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            }
            return false;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            if (item.getItemId() == 57) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED_ADENA).addItemNumber(count));
            } else if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item);
                sm.addItemNumber(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.getItemByObjectId(objectId);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            }
            return false;
        }
        return this.destroyItem(process, item, count, reference, sendMessage);
    }

    public boolean destroyItemWithoutTrace(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.getItemByObjectId(objectId);
        if (item == null || item.getCount() < count) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            }
            return false;
        }
        return this.destroyItem(null, item, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (itemId == 57) {
            return this.reduceAdena(process, count, reference, sendMessage);
        }
        L2ItemInstance item = this._inventory.getItemByItemId(itemId);
        if (item == null || item.getCount() < count || this._inventory.destroyItemByItemId(process, itemId, count, this, reference) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            }
            return false;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(itemId);
                sm.addItemNumber(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(itemId);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public L2ItemInstance transferItem(String process, int objectId, long count, Inventory target, L2Object reference) {
        L2ItemInstance oldItem = this.checkItemManipulation(objectId, count, "transfer");
        if (oldItem == null) {
            return null;
        }
        L2ItemInstance newItem = this.getInventory().transferItem(process, objectId, count, target, this, reference);
        if (newItem == null) {
            return null;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
            } else {
                playerIU.addRemovedItem(oldItem);
            }
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate playerSU = new StatusUpdate(this);
        playerSU.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(playerSU);
        if (target instanceof PcInventory) {
            L2PcInstance targetPlayer = ((PcInventory)target).getOwner();
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate playerIU = new InventoryUpdate();
                if (newItem.getCount() > count) {
                    playerIU.addModifiedItem(newItem);
                } else {
                    playerIU.addNewItem(newItem);
                }
                targetPlayer.sendPacket(playerIU);
            } else {
                targetPlayer.sendPacket(new ItemList(targetPlayer, false));
            }
            playerSU = new StatusUpdate(targetPlayer);
            playerSU.addAttribute(14, targetPlayer.getCurrentLoad());
            targetPlayer.sendPacket(playerSU);
        } else if (target instanceof PetInventory) {
            PetInventoryUpdate petIU = new PetInventoryUpdate();
            if (newItem.getCount() > count) {
                petIU.addModifiedItem(newItem);
            } else {
                petIU.addNewItem(newItem);
            }
            ((PetInventory)target).getOwner().getOwner().sendPacket(petIU);
        }
        return newItem;
    }

    public boolean dropItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage, boolean protectItem) {
        if ((item = this._inventory.dropItem(process, item, this, reference)) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_NOT_DISCARDED));
            }
            return false;
        }
        item.dropMe(this, this.getX() + Rnd.get(50) - 25, this.getY() + Rnd.get(50) - 25, this.getZ() + 20);
        if (Config.AUTODESTROY_ITEM_AFTER > 0 && Config.DESTROY_DROPPED_PLAYER_ITEM && !Config.LIST_PROTECTED_ITEMS.contains(item.getItemId()) && (item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM || !item.isEquipable())) {
            ItemsAutoDestroy.getInstance().addItem(item);
        }
        if (Config.DESTROY_DROPPED_PLAYER_ITEM) {
            if (item.isStackable() && item.getCount() < 2L) {
                item.setProtected(false);
            } else if (!item.isEquipable() || item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                item.setProtected(false);
            } else {
                item.setProtected(true);
            }
        } else {
            item.setProtected(true);
        }
        if (protectItem) {
            item.getDropProtection().protect(this);
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DROPPED_S1);
            sm.addItemName(item);
            this.sendPacket(sm);
        }
        return true;
    }

    public boolean dropItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        return this.dropItem(process, item, reference, sendMessage, false);
    }

    public L2ItemInstance dropItem(String process, int objectId, long count, int x, int y, int z, L2Object reference, boolean sendMessage, boolean protectItem) {
        L2ItemInstance invitem = this._inventory.getItemByObjectId(objectId);
        L2ItemInstance item = this._inventory.dropItem(process, objectId, count, this, reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_NOT_DISCARDED));
            }
            return null;
        }
        item.dropMe(this, x, y, z);
        if (Config.AUTODESTROY_ITEM_AFTER > 0 && Config.DESTROY_DROPPED_PLAYER_ITEM && !Config.LIST_PROTECTED_ITEMS.contains(item.getItemId()) && (item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM || !item.isEquipable())) {
            ItemsAutoDestroy.getInstance().addItem(item);
        }
        if (Config.DESTROY_DROPPED_PLAYER_ITEM) {
            if (item.isStackable() && item.getCount() < 2L) {
                item.setProtected(false);
            } else if (!item.isEquipable() || item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                item.setProtected(false);
            } else {
                item.setProtected(true);
            }
        } else {
            item.setProtected(true);
        }
        if (protectItem) {
            item.getDropProtection().protect(this);
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(invitem);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DROPPED_S1);
            sm.addItemName(item);
            this.sendPacket(sm);
        }
        return item;
    }

    public L2ItemInstance checkItemManipulation(int objectId, long count, String action) {
        if (L2World.getInstance().findObject(objectId) == null) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item not available in L2World");
            return null;
        }
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null || item.getOwnerId() != this.getObjectId()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item he is not owner of");
            return null;
        }
        if (count < 0L || count > 1L && !item.isStackable()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item with invalid count: " + count);
            return null;
        }
        if (count > item.getCount()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " more items than he owns");
            return null;
        }
        if (this.getPet() != null && this.getPet().getControlObjectId() == objectId || this.getMountObjectID() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ": player tried to " + action + " item controling pet");
            }
            return null;
        }
        if (this.getActiveEnchantItem() != null && this.getActiveEnchantItem().getObjectId() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ":player tried to " + action + " an enchant scroll he was using");
            }
            return null;
        }
        if (item.isAugmented() && (this.isCastingNow() || this.isCastingSimultaneouslyNow())) {
            return null;
        }
        return item;
    }

    public void setProtection(boolean protect) {
        if (Config.DEVELOPER && (protect || this._protectEndTime > 0L)) {
            _log.warning(this.getName() + ": Protection " + (protect ? "ON " + (GameTimeController.getGameTicks() + Config.PLAYER_SPAWN_PROTECTION * 10) : "OFF") + " (currently " + GameTimeController.getGameTicks() + ")");
        }
        this._protectEndTime = protect ? (long)(GameTimeController.getGameTicks() + Config.PLAYER_SPAWN_PROTECTION * 10) : 0L;
    }

    public void setTeleportProtection(boolean protect) {
        if (Config.DEVELOPER && (protect || this._teleportProtectEndTime > 0L)) {
            _log.warning(this.getName() + ": Tele Protection " + (protect ? "ON " + (GameTimeController.getGameTicks() + Config.PLAYER_TELEPORT_PROTECTION * 10) : "OFF") + " (currently " + GameTimeController.getGameTicks() + ")");
        }
        this._teleportProtectEndTime = protect ? (long)(GameTimeController.getGameTicks() + Config.PLAYER_TELEPORT_PROTECTION * 10) : 0L;
    }

    public void setRecentFakeDeath(boolean protect) {
        this._recentFakeDeathEndTime = protect ? (long)(GameTimeController.getGameTicks() + Config.PLAYER_FAKEDEATH_UP_PROTECTION * 10) : 0L;
    }

    public boolean isRecentFakeDeath() {
        return this._recentFakeDeathEndTime > (long)GameTimeController.getGameTicks();
    }

    public final boolean isFakeDeath() {
        return this._isFakeDeath;
    }

    public final void setIsFakeDeath(boolean value) {
        this._isFakeDeath = value;
    }

    @Override
    public final boolean isAlikeDead() {
        if (super.isAlikeDead()) {
            return true;
        }
        return this.isFakeDeath();
    }

    public L2GameClient getClient() {
        return this._client;
    }

    public void setClient(L2GameClient client) {
        this._client = client;
    }

    private void closeNetConnection(boolean closeClient) {
        L2GameClient client = this._client;
        if (client != null) {
            if (client.isDetached()) {
                client.cleanMe(true);
            } else if (!client.getConnection().isClosed()) {
                if (closeClient) {
                    client.close(LeaveWorld.STATIC_PACKET);
                } else {
                    client.close(ServerClose.STATIC_PACKET);
                }
            }
        }
    }

    public Point3D getCurrentSkillWorldPosition() {
        return this._currentSkillWorldPosition;
    }

    public void setCurrentSkillWorldPosition(Point3D worldPosition) {
        this._currentSkillWorldPosition = worldPosition;
    }

    @Override
    public void enableSkill(L2Skill skill) {
        super.enableSkill(skill);
        this._reuseTimeStamps.remove((Object)skill.getReuseHashCode());
    }

    @Override
    protected boolean checkDoCastConditions(L2Skill skill) {
        if (!super.checkDoCastConditions(skill)) {
            return false;
        }
        switch (skill.getSkillType()) {
            case SUMMON_TRAP: {
                if (this.isInsideZone((byte)1)) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE));
                    return false;
                }
                if (this.getTrap() == null || this.getTrap().getSkill().getId() != ((L2SkillTrap)skill).getTriggerSkillId()) break;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                sm.addSkillName(skill);
                this.sendPacket(sm);
                return false;
            }
            case SUMMON: {
                if (((L2SkillSummon)skill).isCubic() || this.getPet() == null && !this.isMounted()) break;
                if (Config.DEBUG) {
                    _log.fine("player has a pet already. ignore summon skill");
                }
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ALREADY_HAVE_A_PET));
                return false;
            }
        }
        if (this.isInOlympiadMode() && (skill.isHeroSkill() || skill.getSkillType() == L2SkillType.RESURRECT)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THIS_SKILL_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT);
            this.sendPacket(sm);
            return false;
        }
        int charges = this.getCharges();
        if (skill.getMaxCharges() == 0 && charges < skill.getNumCharges() || this.isInAirShip() && skill.getSkillType() != L2SkillType.REFUEL) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            this.sendPacket(sm);
            return false;
        }
        return true;
    }

    private boolean needCpUpdate(int barPixels) {
        double currentCp = this.getCurrentCp();
        if (currentCp <= 1.0 || this.getMaxCp() < barPixels) {
            return true;
        }
        if (currentCp <= this._cpUpdateDecCheck || currentCp >= this._cpUpdateIncCheck) {
            if (currentCp == (double)this.getMaxCp()) {
                this._cpUpdateIncCheck = currentCp + 1.0;
                this._cpUpdateDecCheck = currentCp - this._cpUpdateInterval;
            } else {
                double doubleMulti = currentCp / this._cpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._cpUpdateDecCheck = this._cpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._cpUpdateIncCheck = this._cpUpdateDecCheck + this._cpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    private boolean needMpUpdate(int barPixels) {
        double currentMp = this.getCurrentMp();
        if (currentMp <= 1.0 || this.getMaxMp() < barPixels) {
            return true;
        }
        if (currentMp <= this._mpUpdateDecCheck || currentMp >= this._mpUpdateIncCheck) {
            if (currentMp == (double)this.getMaxMp()) {
                this._mpUpdateIncCheck = currentMp + 1.0;
                this._mpUpdateDecCheck = currentMp - this._mpUpdateInterval;
            } else {
                double doubleMulti = currentMp / this._mpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._mpUpdateDecCheck = this._mpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._mpUpdateIncCheck = this._mpUpdateDecCheck + this._mpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    @Override
    public void broadcastStatusUpdate() {
        OlympiadGameTask game;
        L2GameServerPacket update;
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(9, (int)this.getCurrentHp());
        su.addAttribute(11, (int)this.getCurrentMp());
        su.addAttribute(33, (int)this.getCurrentCp());
        su.addAttribute(34, this.getMaxCp());
        this.sendPacket(su);
        boolean needCpUpdate = this.needCpUpdate(352);
        boolean needHpUpdate = this.needHpUpdate(352);
        L2Party party = this._party;
        if (party != null && (needCpUpdate || needHpUpdate || this.needMpUpdate(352))) {
            if (Config.DEBUG) {
                _log.fine("Send status for party window of " + this.getObjectId() + "(" + this.getName() + ") to his party. CP: " + this.getCurrentCp() + " HP: " + this.getCurrentHp() + " MP: " + this.getCurrentMp());
            }
            update = new PartySmallWindowUpdate(this);
            party.broadcastToPartyMembers(this, update);
        }
        if (this.isInOlympiadMode() && this.isOlympiadStart() && (needCpUpdate || needHpUpdate) && (game = OlympiadGameManager.getInstance().getOlympiadTask(this.getOlympiadGameId())) != null && game.isBattleStarted()) {
            game.getZone().broadcastStatusUpdate(this);
        }
        if (this.isInDuel() && (needCpUpdate || needHpUpdate)) {
            update = new ExDuelUpdateUserInfo(this);
            DuelManager.getInstance().broadcastToOppositTeam(this, update);
        }
    }

    public final void broadcastUserInfo() {
        this.sendPacket(new UserInfo(this));
        if (Config.DEBUG) {
            _log.fine("players to notify:" + this.getKnownList().getKnownPlayers().size() + " packet: [S] 03 CharInfo");
        }
        this.broadcastPacket(new CharInfo(this));
        this.broadcastPacket(new ExBrExtraUserInfo(this));
        if (TerritoryWarManager.getInstance().isTWInProgress() && (TerritoryWarManager.getInstance().checkIsRegistered(-1, this.getObjectId()) || TerritoryWarManager.getInstance().checkIsRegistered(-1, this.getClan()))) {
            this.broadcastPacket(new ExDominionWarStart(this));
        }
    }

    public final void broadcastTitleInfo() {
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        if (Config.DEBUG) {
            _log.fine("players to notify:" + this.getKnownList().getKnownPlayers().size() + " packet: [S] cc TitleUpdate");
        }
        this.broadcastPacket(new NicknameChanged(this));
    }

    @Override
    public final void broadcastPacket(L2GameServerPacket mov) {
        if (!(mov instanceof CharInfo)) {
            this.sendPacket(mov);
        }
        mov.setInvisible(this.getAppearance().getInvisible());
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            player.sendPacket(mov);
            if (!(mov instanceof CharInfo)) continue;
            int relation = this.getRelation(player);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(player.getObjectId());
            if (oldrelation == null || oldrelation == relation) continue;
            player.sendPacket(new RelationChanged(this, relation, this.isAutoAttackable(player)));
            if (this.getPet() == null) continue;
            player.sendPacket(new RelationChanged(this.getPet(), relation, this.isAutoAttackable(player)));
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        if (!(mov instanceof CharInfo)) {
            this.sendPacket(mov);
        }
        mov.setInvisible(this.getAppearance().getInvisible());
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false)) continue;
            player.sendPacket(mov);
            if (!(mov instanceof CharInfo)) continue;
            int relation = this.getRelation(player);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(player.getObjectId());
            if (oldrelation == null || oldrelation == relation) continue;
            player.sendPacket(new RelationChanged(this, relation, this.isAutoAttackable(player)));
            if (this.getPet() == null) continue;
            player.sendPacket(new RelationChanged(this.getPet(), relation, this.isAutoAttackable(player)));
        }
    }

    public int getAllyId() {
        if (this._clan == null) {
            return 0;
        }
        return this._clan.getAllyId();
    }

    public int getAllyCrestId() {
        if (this.getClanId() == 0) {
            return 0;
        }
        if (this.getClan().getAllyId() == 0) {
            return 0;
        }
        return this.getClan().getAllyCrestId();
    }

    @Override
    protected void onHitTimer(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, byte shld) {
        super.onHitTimer(target, damage, crit, miss, soulshot, shld);
    }

    public void queryGameGuard() {
        this.getClient().setGameGuardOk(false);
        this.sendPacket(new GameGuardQuery());
        if (Config.GAMEGUARD_ENFORCE) {
            ThreadPoolManager.getInstance().scheduleGeneral(new GameGuardCheck(), 30000L);
        }
    }

    @Override
    public void sendPacket(L2GameServerPacket packet) {
        if (this._client != null) {
            this._client.sendPacket(packet);
        }
    }

    public void sendPacket(SystemMessageId id) {
        this.sendPacket(SystemMessage.getSystemMessage(id));
    }

    public void doInteract(L2Character target) {
        if (target instanceof L2PcInstance) {
            L2PcInstance temp = (L2PcInstance)target;
            this.sendPacket(ActionFailed.STATIC_PACKET);
            if (temp.getPrivateStoreType() == 1 || temp.getPrivateStoreType() == 8) {
                this.sendPacket(new PrivateStoreListSell(this, temp));
            } else if (temp.getPrivateStoreType() == 3) {
                this.sendPacket(new PrivateStoreListBuy(this, temp));
            } else if (temp.getPrivateStoreType() == 5) {
                this.sendPacket(new RecipeShopSellList(this, temp));
            }
        } else if (target != null) {
            target.onAction(this);
        }
    }

    public void doAutoLoot(L2Attackable target, L2Attackable.RewardItem item) {
        if (this.isInParty() && ItemTable.getInstance().getTemplate(item.getItemId()).getItemType() != L2EtcItemType.HERB) {
            this.getParty().distributeItem(this, item, false, target);
        } else if (item.getItemId() == 57) {
            this.addAdena("Loot", item.getCount(), target, true);
        } else {
            this.addItem("Loot", item.getItemId(), item.getCount(), target, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPickupItem(L2Object object) {
        if (this.isAlikeDead() || this.isFakeDeath()) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (!(object instanceof L2ItemInstance)) {
            _log.warning(this + " trying to pickup wrong target." + this.getTarget());
            return;
        }
        L2ItemInstance target = (L2ItemInstance)object;
        this.sendPacket(ActionFailed.STATIC_PACKET);
        StopMove sm = new StopMove(this);
        if (Config.DEBUG) {
            _log.fine("pickup pos: " + target.getX() + " " + target.getY() + " " + target.getZ());
        }
        this.sendPacket(sm);
        L2ItemInstance l2ItemInstance = target;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!target.getDropProtection().tryPickUp(this)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
                return;
            }
            if ((this.isInParty() && this.getParty().getLootDistribution() == 0 || !this.isInParty()) && !this._inventory.validateCapacity(target)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SLOTS_FULL));
                return;
            }
            if (this.isInvul() && !this.isGM()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
                return;
            }
            if (target.getOwnerId() != 0 && target.getOwnerId() != this.getObjectId() && !this.isInLooterParty(target.getOwnerId())) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                if (target.getItemId() == 57) {
                    SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1_ADENA);
                    smsg.addItemNumber(target.getCount());
                    this.sendPacket(smsg);
                } else if (target.getCount() > 1L) {
                    SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S2_S1_S);
                    smsg.addItemName(target);
                    smsg.addItemNumber(target.getCount());
                    this.sendPacket(smsg);
                } else {
                    SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                    smsg.addItemName(target);
                    this.sendPacket(smsg);
                }
                return;
            }
            if (FortSiegeManager.getInstance().isCombat(target.getItemId()) && !FortSiegeManager.getInstance().checkIfCanPickup(this)) {
                return;
            }
            if (target.getItemLootShedule() != null && (target.getOwnerId() == this.getObjectId() || this.isInLooterParty(target.getOwnerId()))) {
                target.resetOwnerTimer();
            }
            target.pickupMe(this);
            if (Config.SAVE_DROPPED_ITEM) {
                ItemsOnGroundManager.getInstance().removeObject(target);
            }
        }
        if (target.getItemType() == L2EtcItemType.HERB) {
            IItemHandler handler = ItemHandler.getInstance().getItemHandler(target.getEtcItem());
            if (handler == null) {
                _log.fine("No item handler registered for item ID " + target.getItemId() + ".");
            } else {
                handler.useItem(this, target, false);
            }
            ItemTable.getInstance().destroyItem("Consume", target, this, null);
        } else if (CursedWeaponsManager.getInstance().isCursed(target.getItemId())) {
            this.addItem("Pickup", target, null, true);
        } else if (FortSiegeManager.getInstance().isCombat(target.getItemId())) {
            this.addItem("Pickup", target, null, true);
        } else {
            if (target.getItemType() instanceof L2ArmorType || target.getItemType() instanceof L2WeaponType) {
                SystemMessage msg;
                if (target.getEnchantLevel() > 0) {
                    msg = SystemMessage.getSystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2_S3);
                    msg.addPcName(this);
                    msg.addNumber(target.getEnchantLevel());
                    msg.addItemName(target.getItemId());
                    this.broadcastPacket(msg, 1400);
                } else {
                    msg = SystemMessage.getSystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2);
                    msg.addPcName(this);
                    msg.addItemName(target.getItemId());
                    this.broadcastPacket(msg, 1400);
                }
            }
            if (this.isInParty()) {
                this.getParty().distributeItem(this, target);
            } else if (target.getItemId() == 57 && this.getInventory().getAdenaInstance() != null) {
                this.addAdena("Pickup", target.getCount(), null, true);
                ItemTable.getInstance().destroyItem("Pickup", target, this, null);
            } else {
                this.addItem("Pickup", target, null, true);
            }
        }
    }

    public boolean canOpenPrivateStore() {
        return !this.isAlikeDead() && !this.isInOlympiadMode() && !this.isMounted() && !this.isInsideZone((byte)14) && !this.isCastingNow();
    }

    public void tryOpenPrivateBuyStore() {
        if (this.canOpenPrivateStore()) {
            if (this.getPrivateStoreType() == 3 || this.getPrivateStoreType() == 4) {
                this.setPrivateStoreType(0);
            }
            if (this.getPrivateStoreType() == 0) {
                if (this.isSitting()) {
                    this.standUp();
                }
                this.setPrivateStoreType(4);
                this.sendPacket(new PrivateStoreManageListBuy(this));
            }
        } else {
            if (this.isInsideZone((byte)14)) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_PRIVATE_STORE_HERE));
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public void tryOpenPrivateSellStore(boolean isPackageSale) {
        if (this.canOpenPrivateStore()) {
            if (this.getPrivateStoreType() == 1 || this.getPrivateStoreType() == 2 || this.getPrivateStoreType() == 8) {
                this.setPrivateStoreType(0);
            }
            if (this.getPrivateStoreType() == 0) {
                if (this.isSitting()) {
                    this.standUp();
                }
                this.setPrivateStoreType(2);
                this.sendPacket(new PrivateStoreManageListSell(this, isPackageSale));
            }
        } else {
            if (this.isInsideZone((byte)14)) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_PRIVATE_STORE_HERE));
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public final PreparedListContainer getMultiSell() {
        return this._currentMultiSell;
    }

    public final void setMultiSell(PreparedListContainer list) {
        this._currentMultiSell = list;
    }

    @Override
    public boolean isTransformed() {
        return this._transformation != null && !this._transformation.isStance();
    }

    public boolean isInStance() {
        return this._transformation != null && this._transformation.isStance();
    }

    public void transform(L2Transformation transformation) {
        if (this._transformation != null) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN);
            this.sendPacket(msg);
            return;
        }
        this.setQueuedSkill(null, false, false);
        if (this.isMounted()) {
            this.dismount();
        }
        this._transformation = transformation;
        this.stopAllToggles();
        transformation.onTransform();
        this.sendSkillList();
        this.sendPacket(new SkillCoolTime(this));
        this.sendPacket(ExBasicActionList.getStaticPacket(this));
        this.broadcastUserInfo();
    }

    @Override
    public void untransform() {
        if (this._transformation != null) {
            this.setTransformAllowedSkills(new int[0]);
            this._transformation.onUntransform();
            this._transformation = null;
            this.stopEffects(L2EffectType.TRANSFORMATION);
            this.sendSkillList();
            this.sendPacket(new SkillCoolTime(this));
            this.sendPacket(ExBasicActionList.getStaticPacket(this));
            this.broadcastUserInfo();
        }
    }

    public L2Transformation getTransformation() {
        return this._transformation;
    }

    public int getTransformationId() {
        return this._transformation == null ? 0 : this._transformation.getId();
    }

    public int transformId() {
        return this._transformationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformInsertInfo() {
        this._transformationId = this.getTransformationId();
        if (this._transformationId == 302 || this._transformationId == 301) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(UPDATE_CHAR_TRANSFORM);
            statement.setInt(1, this._transformationId);
            statement.setInt(2, this.getObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Transformation insert info: ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transformSelectInfo() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SELECT_CHAR_TRANSFORM);
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            rset.next();
            this._transformationId = rset.getInt("transform_id");
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Transformation select info: ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return this._transformationId;
    }

    @Override
    public void setTarget(L2Object newTarget) {
        L2Object oldTarget;
        if (newTarget != null) {
            boolean isParty;
            boolean bl = isParty = newTarget instanceof L2PcInstance && this.isInParty() && this.getParty().getPartyMembers().contains((Object)newTarget);
            if (!isParty && !newTarget.isVisible()) {
                newTarget = null;
            }
            if (newTarget != null && !isParty && Math.abs(newTarget.getZ() - this.getZ()) > 1000) {
                newTarget = null;
            }
        }
        if (!this.isGM()) {
            if (newTarget instanceof L2FestivalMonsterInstance && !this.isFestivalParticipant()) {
                newTarget = null;
            } else if (newTarget instanceof L2Vehicle) {
                newTarget = null;
            } else if (this.isInParty() && this.getParty().isInDimensionalRift()) {
                byte riftType = this.getParty().getDimensionalRift().getType();
                byte riftRoom = this.getParty().getDimensionalRift().getCurrentRoom();
                if (newTarget != null && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(newTarget.getX(), newTarget.getY(), newTarget.getZ())) {
                    newTarget = null;
                }
            }
        }
        if ((oldTarget = this.getTarget()) != null) {
            if (oldTarget.equals(newTarget)) {
                return;
            }
            if (oldTarget instanceof L2Character) {
                ((L2Character)oldTarget).removeStatusListener(this);
            }
        }
        if (newTarget instanceof L2Character) {
            ((L2Character)newTarget).addStatusListener(this);
            TargetSelected my = new TargetSelected(this.getObjectId(), newTarget.getObjectId(), this.getX(), this.getY(), this.getZ());
            this.broadcastPacket(my);
        }
        if (newTarget == null && this.getTarget() != null) {
            this.broadcastPacket(new TargetUnselected(this));
        }
        super.setTarget(newTarget);
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return this.getInventory().getPaperdollItem(5);
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return this.getFistsWeaponItem();
        }
        return (L2Weapon)weapon.getItem();
    }

    public L2ItemInstance getChestArmorInstance() {
        return this.getInventory().getPaperdollItem(6);
    }

    public L2ItemInstance getLegsArmorInstance() {
        return this.getInventory().getPaperdollItem(11);
    }

    public L2Armor getActiveChestArmorItem() {
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor == null) {
            return null;
        }
        return (L2Armor)armor.getItem();
    }

    public L2Armor getActiveLegsArmorItem() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        if (legs == null) {
            return null;
        }
        return (L2Armor)legs.getItem();
    }

    public boolean isWearingHeavyArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && (L2ArmorType)legs.getItemType() == L2ArmorType.HEAVY && (L2ArmorType)armor.getItemType() == L2ArmorType.HEAVY) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && (L2ArmorType)armor.getItemType() == L2ArmorType.HEAVY;
    }

    public boolean isWearingLightArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && (L2ArmorType)legs.getItemType() == L2ArmorType.LIGHT && (L2ArmorType)armor.getItemType() == L2ArmorType.LIGHT) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && (L2ArmorType)armor.getItemType() == L2ArmorType.LIGHT;
    }

    public boolean isWearingMagicArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && (L2ArmorType)legs.getItemType() == L2ArmorType.MAGIC && (L2ArmorType)armor.getItemType() == L2ArmorType.MAGIC) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && (L2ArmorType)armor.getItemType() == L2ArmorType.MAGIC;
    }

    public boolean isMarried() {
        return this._married;
    }

    public void setMarried(boolean state) {
        this._married = state;
    }

    public boolean isEngageRequest() {
        return this._engagerequest;
    }

    public void setEngageRequest(boolean state, int playerid) {
        this._engagerequest = state;
        this._engageid = playerid;
    }

    public void setMarryRequest(boolean state) {
        this._marryrequest = state;
    }

    public boolean isMarryRequest() {
        return this._marryrequest;
    }

    public void setMarryAccepted(boolean state) {
        this._marryaccepted = state;
    }

    public boolean isMarryAccepted() {
        return this._marryaccepted;
    }

    public int getEngageId() {
        return this._engageid;
    }

    public int getPartnerId() {
        return this._partnerId;
    }

    public void setPartnerId(int partnerid) {
        this._partnerId = partnerid;
    }

    public int getCoupleId() {
        return this._coupleId;
    }

    public void setCoupleId(int coupleId) {
        this._coupleId = coupleId;
    }

    public void engageAnswer(int answer) {
        if (!this._engagerequest) {
            return;
        }
        if (this._engageid == 0) {
            return;
        }
        L2PcInstance ptarget = L2World.getInstance().getPlayer(this._engageid);
        this.setEngageRequest(false, 0);
        if (ptarget != null) {
            if (answer == 1) {
                CoupleManager.getInstance().createCouple(ptarget, this);
                ptarget.sendMessage("Request to Engage has been >ACCEPTED<");
            } else {
                ptarget.sendMessage("Request to Engage has been >DENIED<!");
            }
        }
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return this.getInventory().getPaperdollItem(7);
    }

    @Override
    public L2Item getSecondaryWeaponItem() {
        L2ItemInstance item = this.getInventory().getPaperdollItem(7);
        if (item != null) {
            return item.getItem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this.isMounted()) {
            this.stopFeed();
        }
        L2PcInstance l2PcInstance = this;
        synchronized (l2PcInstance) {
            if (this.isFakeDeath()) {
                this.stopFakeDeath(true);
            }
        }
        if (killer != null) {
            L2PcInstance pk = killer.getActingPlayer();
            TvTEvent.onKill(killer, this);
            if (this.atEvent && pk != null) {
                pk.kills.add(this.getName());
            }
            if (Config.ANNOUNCE_PK_PVP && pk != null && !pk.isGM()) {
                SystemMessage sm;
                String msg = "";
                if (this.getPvpFlag() == 0) {
                    msg = Config.ANNOUNCE_PK_MSG.replace("$killer", pk.getName()).replace("$target", this.getName());
                    if (Config.ANNOUNCE_PK_PVP_NORMAL_MESSAGE) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
                        sm.addString(msg);
                        Announcements.getInstance().announceToAll(sm);
                    } else {
                        Announcements.getInstance().announceToAll(msg);
                    }
                } else if (this.getPvpFlag() != 0) {
                    msg = Config.ANNOUNCE_PVP_MSG.replace("$killer", pk.getName()).replace("$target", this.getName());
                    if (Config.ANNOUNCE_PK_PVP_NORMAL_MESSAGE) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
                        sm.addString(msg);
                        Announcements.getInstance().announceToAll(sm);
                    } else {
                        Announcements.getInstance().announceToAll(msg);
                    }
                }
            }
            this.broadcastStatusUpdate();
            this.setExpBeforeDeath(0L);
            if (this.isCursedWeaponEquipped()) {
                CursedWeaponsManager.getInstance().drop(this._cursedWeaponEquippedId, killer);
            } else if (this.isCombatFlagEquipped()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    TerritoryWarManager.getInstance().dropCombatFlag(this, true, false);
                } else {
                    Fort fort = FortManager.getInstance().getFort(this);
                    if (fort != null) {
                        FortSiegeManager.getInstance().dropCombatFlag(this, fort.getFortId());
                    } else {
                        int slot = this.getInventory().getSlotFromItem(this.getInventory().getItemByItemId(9819));
                        this.getInventory().unEquipItemInBodySlot(slot);
                        this.destroyItem("CombatFlag", this.getInventory().getItemByItemId(9819), null, true);
                    }
                }
            } else if (pk == null || !pk.isCursedWeaponEquipped()) {
                this.onDieDropItem(killer);
                if ((!this.isInsideZone((byte)0) || this.isInsideZone((byte)2)) && pk != null && pk.getClan() != null && this.getClan() != null && !this.isAcademyMember() && !pk.isAcademyMember() && (this._clan.isAtWarWith(pk.getClanId()) && pk.getClan().isAtWarWith(this._clan.getClanId()) || this.isInSiege() && pk.isInSiege()) && AntiFeedManager.getInstance().check(killer, this)) {
                    if (this.getClan().getReputationScore() > 0) {
                        pk.getClan().addReputationScore(Config.REPUTATION_SCORE_PER_KILL, false);
                    }
                    if (pk.getClan().getReputationScore() > 0) {
                        this._clan.takeReputationScore(Config.REPUTATION_SCORE_PER_KILL, false);
                    }
                }
                if (Config.ALT_GAME_DELEVEL && !this.isLucky()) {
                    boolean siegeNpc = killer instanceof L2DefenderInstance || killer instanceof L2FortCommanderInstance;
                    boolean atWar = pk != null && this.getClan() != null && this.getClan().isAtWarWith(pk.getClanId());
                    this.deathPenalty(atWar, pk != null, siegeNpc);
                } else if (!this.isInsideZone((byte)0) || this.isInSiege() || pk == null) {
                    this.onDieUpdateKarma();
                }
            }
        }
        this.setPvpFlag(0);
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
        }
        if (this._fusionSkill != null) {
            this.abortCast();
        }
        for (L2Character character : this.getKnownList().getKnownCharacters()) {
            if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != this) continue;
            character.abortCast();
        }
        if (this.isInParty() && this.getParty().isInDimensionalRift()) {
            this.getParty().getDimensionalRift().getDeadMemberList().add((Object)this);
        }
        if (this.getAgathionId() != 0) {
            this.setAgathionId(0);
        }
        this.calculateDeathPenaltyBuffLevel(killer);
        this.stopRentPet();
        this.stopWaterTask();
        AntiFeedManager.getInstance().setLastDeathTime(this.getObjectId());
        if (this.isPhoenixBlessed()) {
            this.reviveRequest(this, null, false);
        } else if (this.isAffected(1) && this.isInSiege()) {
            this.reviveRequest(this, null, false);
        }
        L2BossZone zone = GrandBossManager.getInstance().getZone(this);
        if (zone != null) {
            zone.checkAnnihilated(this);
        }
        return true;
    }

    private void onDieDropItem(L2Character killer) {
        if (this.atEvent || killer == null) {
            return;
        }
        L2PcInstance pk = killer.getActingPlayer();
        if (this.getKarma() <= 0 && pk != null && pk.getClan() != null && this.getClan() != null && pk.getClan().isAtWarWith(this.getClanId())) {
            return;
        }
        if (!(this.isInsideZone((byte)0) && pk != null || this.isGM() && !Config.KARMA_DROP_GM)) {
            boolean isKarmaDrop = false;
            boolean isKillerNpc = killer instanceof L2Npc;
            int pkLimit = Config.KARMA_PK_LIMIT;
            int dropEquip = 0;
            int dropEquipWeapon = 0;
            int dropItem = 0;
            int dropLimit = 0;
            int dropPercent = 0;
            if (this.getKarma() > 0 && this.getPkKills() >= pkLimit) {
                isKarmaDrop = true;
                dropPercent = Config.KARMA_RATE_DROP;
                dropEquip = Config.KARMA_RATE_DROP_EQUIP;
                dropEquipWeapon = Config.KARMA_RATE_DROP_EQUIP_WEAPON;
                dropItem = Config.KARMA_RATE_DROP_ITEM;
                dropLimit = Config.KARMA_DROP_LIMIT;
            } else if (isKillerNpc && this.getLevel() > 4 && !this.isFestivalParticipant()) {
                dropPercent = Config.PLAYER_RATE_DROP;
                dropEquip = Config.PLAYER_RATE_DROP_EQUIP;
                dropEquipWeapon = Config.PLAYER_RATE_DROP_EQUIP_WEAPON;
                dropItem = Config.PLAYER_RATE_DROP_ITEM;
                dropLimit = Config.PLAYER_DROP_LIMIT;
            }
            if (dropPercent > 0 && Rnd.get(100) < dropPercent) {
                int dropCount = 0;
                int itemDropPercent = 0;
                for (L2ItemInstance itemDrop : this.getInventory().getItems()) {
                    if (itemDrop.isShadowItem() || itemDrop.isTimeLimitedItem() || !itemDrop.isDropable() || itemDrop.getItemId() == 57 || itemDrop.getItem().getType2() == 3 || this.getPet() != null && this.getPet().getControlObjectId() == itemDrop.getItemId() || Arrays.binarySearch(Config.KARMA_LIST_NONDROPPABLE_ITEMS, itemDrop.getItemId()) >= 0 || Arrays.binarySearch(Config.KARMA_LIST_NONDROPPABLE_PET_ITEMS, itemDrop.getItemId()) >= 0) continue;
                    if (itemDrop.isEquipped()) {
                        itemDropPercent = itemDrop.getItem().getType2() == 0 ? dropEquipWeapon : dropEquip;
                        this.getInventory().unEquipItemInSlot(itemDrop.getLocationSlot());
                    } else {
                        itemDropPercent = dropItem;
                    }
                    if (Rnd.get(100) >= itemDropPercent) continue;
                    this.dropItem("DieDrop", itemDrop, killer, true);
                    if (isKarmaDrop) {
                        _log.warning(this.getName() + " has karma and dropped id = " + itemDrop.getItemId() + ", count = " + itemDrop.getCount());
                    } else {
                        _log.warning(this.getName() + " dropped id = " + itemDrop.getItemId() + ", count = " + itemDrop.getCount());
                    }
                    if (++dropCount >= dropLimit) break;
                }
            }
        }
    }

    private void onDieUpdateKarma() {
        if (this.getKarma() > 0) {
            double karmaLost = Config.KARMA_LOST_BASE;
            karmaLost *= (double)this.getLevel();
            karmaLost *= (double)this.getLevel() / 100.0;
            if ((karmaLost = (double)Math.round(karmaLost)) < 0.0) {
                karmaLost = 1.0;
            }
            this.setKarma(this.getKarma() - (int)karmaLost);
        }
    }

    public void onKillUpdatePvPKarma(L2Character target) {
        if (target == null) {
            return;
        }
        if (!(target instanceof L2Playable)) {
            return;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return;
        }
        if (targetPlayer == this) {
            return;
        }
        if (this.isCursedWeaponEquipped()) {
            CursedWeaponsManager.getInstance().increaseKills(this._cursedWeaponEquippedId);
            return;
        }
        if (this.isInDuel() && targetPlayer.isInDuel()) {
            return;
        }
        if (this.isInsideZone((byte)0) || targetPlayer.isInsideZone((byte)0)) {
            return;
        }
        if (this.checkIfPvP(target) && targetPlayer.getPvpFlag() != 0 || this.isInsideZone((byte)0) && targetPlayer.isInsideZone((byte)0)) {
            this.increasePvpKills(target);
        } else {
            if (targetPlayer.getClan() != null && this.getClan() != null && this.getClan().isAtWarWith(targetPlayer.getClanId()) && targetPlayer.getClan().isAtWarWith(this.getClanId()) && targetPlayer.getPledgeType() != -1 && this.getPledgeType() != -1) {
                this.increasePvpKills(target);
                return;
            }
            if (targetPlayer.getKarma() > 0) {
                if (Config.KARMA_AWARD_PK_KILL) {
                    this.increasePvpKills(target);
                }
            } else if (targetPlayer.getPvpFlag() == 0) {
                this.increasePkKillsAndKarma(target);
                this.checkItemRestriction();
            }
        }
    }

    public void increasePvpKills(L2Character target) {
        if (target instanceof L2PcInstance && AntiFeedManager.getInstance().check(this, target)) {
            this.setPvpKills(this.getPvpKills() + 1);
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
        }
    }

    public void increasePkKillsAndKarma(L2Character target) {
        int baseKarma;
        int newKarma = baseKarma = Config.KARMA_MIN_KARMA;
        int karmaLimit = Config.KARMA_MAX_KARMA;
        int pkLVL = this.getLevel();
        int pkPKCount = this.getPkKills();
        int targLVL = target.getLevel();
        int lvlDiffMulti = 0;
        int pkCountMulti = 0;
        pkCountMulti = pkPKCount > 0 ? pkPKCount / 2 : 1;
        if (pkCountMulti < 1) {
            pkCountMulti = 1;
        }
        if ((lvlDiffMulti = pkLVL > targLVL ? pkLVL / targLVL : 1) < 1) {
            lvlDiffMulti = 1;
        }
        newKarma *= pkCountMulti;
        if ((newKarma *= lvlDiffMulti) < baseKarma) {
            newKarma = baseKarma;
        }
        if (newKarma > karmaLimit) {
            newKarma = karmaLimit;
        }
        if (this.getKarma() > Integer.MAX_VALUE - newKarma) {
            newKarma = Integer.MAX_VALUE - this.getKarma();
        }
        this.setKarma(this.getKarma() + newKarma);
        if (target instanceof L2PcInstance && AntiFeedManager.getInstance().check(this, target)) {
            this.setPkKills(this.getPkKills() + 1);
        }
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    public int calculateKarmaLost(long exp) {
        long expGained = Math.abs(exp);
        int karmaLost = 0;
        if ((karmaLost = (expGained /= (long)Config.KARMA_XP_DIVIDER) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)expGained) < Config.KARMA_LOST_BASE) {
            karmaLost = Config.KARMA_LOST_BASE;
        }
        if (karmaLost > this.getKarma()) {
            karmaLost = this.getKarma();
        }
        return karmaLost;
    }

    public void updatePvPStatus() {
        if (this.isInsideZone((byte)0)) {
            return;
        }
        this.setPvpFlagLasts(System.currentTimeMillis() + (long)Config.PVP_NORMAL_TIME);
        if (this.getPvpFlag() == 0) {
            this.startPvPFlag();
        }
    }

    public void updatePvPStatus(L2Character target) {
        L2PcInstance player_target = target.getActingPlayer();
        if (player_target == null) {
            return;
        }
        if (this.isInDuel() && player_target.getDuelId() == this.getDuelId()) {
            return;
        }
        if (!(this.isInsideZone((byte)0) && player_target.isInsideZone((byte)0) || player_target.getKarma() != 0)) {
            if (this.checkIfPvP(player_target)) {
                this.setPvpFlagLasts(System.currentTimeMillis() + (long)Config.PVP_PVP_TIME);
            } else {
                this.setPvpFlagLasts(System.currentTimeMillis() + (long)Config.PVP_NORMAL_TIME);
            }
            if (this.getPvpFlag() == 0) {
                this.startPvPFlag();
            }
        }
    }

    public boolean isLucky() {
        return this.getLevel() <= 9 && this.getKnownSkill(194) != null;
    }

    public void restoreExp(double restorePercent) {
        if (this.getExpBeforeDeath() > 0L) {
            this.getStat().addExp(Math.round((double)(this.getExpBeforeDeath() - this.getExp()) * restorePercent / 100.0));
            this.setExpBeforeDeath(0L);
        }
    }

    public void deathPenalty(boolean atwar, boolean killed_by_pc, boolean killed_by_siege_npc) {
        int lvl = this.getLevel();
        int clan_luck = this.getSkillLevel(390);
        double clan_luck_modificator = 1.0;
        if (!killed_by_pc) {
            switch (clan_luck) {
                case 3: {
                    clan_luck_modificator = 0.8;
                    break;
                }
                case 2: {
                    clan_luck_modificator = 0.8;
                    break;
                }
                case 1: {
                    clan_luck_modificator = 0.88;
                    break;
                }
                default: {
                    clan_luck_modificator = 1.0;
                    break;
                }
            }
        } else {
            switch (clan_luck) {
                case 3: {
                    clan_luck_modificator = 0.5;
                    break;
                }
                case 2: {
                    clan_luck_modificator = 0.5;
                    break;
                }
                case 1: {
                    clan_luck_modificator = 0.5;
                    break;
                }
                default: {
                    clan_luck_modificator = 1.0;
                }
            }
        }
        double percentLost = Config.PLAYER_XP_PERCENT_LOST[this.getLevel()] * clan_luck_modificator;
        if (this.getKarma() > 0) {
            percentLost *= (double)Config.RATE_KARMA_EXP_LOST;
        }
        if (this.isFestivalParticipant() || atwar) {
            percentLost /= 4.0;
        }
        long lostExp = 0L;
        if (!this.atEvent) {
            lostExp = lvl < 86 ? Math.round((double)(this.getStat().getExpForLevel(lvl + 1) - this.getStat().getExpForLevel(lvl)) * percentLost / 100.0) : Math.round((double)(this.getStat().getExpForLevel(86) - this.getStat().getExpForLevel(85)) * percentLost / 100.0);
        }
        this.setExpBeforeDeath(this.getExp());
        if (this.isInsideZone((byte)0)) {
            if (this.isInsideZone((byte)2)) {
                if (this.isInSiege() && (killed_by_pc || killed_by_siege_npc)) {
                    lostExp = 0L;
                }
            } else if (killed_by_pc) {
                lostExp = 0L;
            }
        }
        if (Config.DEBUG) {
            _log.fine(this.getName() + " died and lost " + lostExp + " experience.");
        }
        this.getStat().addExp(-lostExp);
    }

    public boolean isPartyWaiting() {
        return PartyMatchWaitingList.getInstance().getPlayers().contains(this);
    }

    public void setPartyRoom(int id) {
        this._partyroom = id;
    }

    public int getPartyRoom() {
        return this._partyroom;
    }

    public boolean isInPartyMatchRoom() {
        return this._partyroom > 0;
    }

    public void stopAllTimers() {
        this.stopHpMpRegeneration();
        this.stopWarnUserTakeBreak();
        this.stopWaterTask();
        this.stopFeed();
        this.clearPetData();
        this.storePetFood(this._mountNpcId);
        this.stopRentPet();
        this.stopPvpRegTask();
        this.stopPunishTask(true);
        this.stopSoulTask();
        this.stopChargeTask();
        this.stopFameTask();
        this.stopVitalityTask();
        this.stopRecoBonusTask();
        this.stopRecoGiveTask();
    }

    @Override
    public L2Summon getPet() {
        return this._summon;
    }

    public L2Decoy getDecoy() {
        return this._decoy;
    }

    public L2Trap getTrap() {
        return this._trap;
    }

    public void setPet(L2Summon summon) {
        this._summon = summon;
        if ((this._summon == null || this._summon instanceof L2SummonInstance) && this.getClassId().isSummoner() && this.getAttackElement() != -1) {
            this.sendPacket(new UserInfo(this));
        }
    }

    public void setDecoy(L2Decoy decoy) {
        this._decoy = decoy;
    }

    public void setTrap(L2Trap trap) {
        this._trap = trap;
    }

    public List<L2TamedBeastInstance> getTrainedBeasts() {
        return this._tamedBeast;
    }

    public void addTrainedBeast(L2TamedBeastInstance tamedBeast) {
        if (this._tamedBeast == null) {
            this._tamedBeast = new FastList();
        }
        this._tamedBeast.add(tamedBeast);
    }

    public L2Request getRequest() {
        return this._request;
    }

    public void setActiveRequester(L2PcInstance requester) {
        this._activeRequester = requester;
    }

    public L2PcInstance getActiveRequester() {
        L2PcInstance requester = this._activeRequester;
        if (requester != null && requester.isRequestExpired() && this._activeTradeList == null) {
            this._activeRequester = null;
        }
        return this._activeRequester;
    }

    public boolean isProcessingRequest() {
        return this.getActiveRequester() != null || this._requestExpireTime > (long)GameTimeController.getGameTicks();
    }

    public boolean isProcessingTransaction() {
        return this.getActiveRequester() != null || this._activeTradeList != null || this._requestExpireTime > (long)GameTimeController.getGameTicks();
    }

    public void onTransactionRequest(L2PcInstance partner) {
        this._requestExpireTime = GameTimeController.getGameTicks() + 150;
        partner.setActiveRequester(this);
    }

    public boolean isRequestExpired() {
        return this._requestExpireTime <= (long)GameTimeController.getGameTicks();
    }

    public void onTransactionResponse() {
        this._requestExpireTime = 0L;
    }

    public void setActiveWarehouse(ItemContainer warehouse) {
        this._activeWarehouse = warehouse;
    }

    public ItemContainer getActiveWarehouse() {
        return this._activeWarehouse;
    }

    public void setActiveTradeList(TradeList tradeList) {
        this._activeTradeList = tradeList;
    }

    public TradeList getActiveTradeList() {
        return this._activeTradeList;
    }

    public void onTradeStart(L2PcInstance partner) {
        this._activeTradeList = new TradeList(this);
        this._activeTradeList.setPartner(partner);
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.BEGIN_TRADE_WITH_C1);
        msg.addPcName(partner);
        this.sendPacket(msg);
        this.sendPacket(new TradeStart(this));
    }

    public void onTradeConfirm(L2PcInstance partner) {
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CONFIRMED_TRADE);
        msg.addPcName(partner);
        this.sendPacket(msg);
        this.sendPacket(new TradeOtherDone());
    }

    public void onTradeCancel(L2PcInstance partner) {
        if (this._activeTradeList == null) {
            return;
        }
        this._activeTradeList.lock();
        this._activeTradeList = null;
        this.sendPacket(new TradeDone(0));
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CANCELED_TRADE);
        msg.addPcName(partner);
        this.sendPacket(msg);
    }

    public void onTradeFinish(boolean successfull) {
        this._activeTradeList = null;
        this.sendPacket(new TradeDone(1));
        if (successfull) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TRADE_SUCCESSFUL));
        }
    }

    public void startTrade(L2PcInstance partner) {
        this.onTradeStart(partner);
        partner.onTradeStart(this);
    }

    public void cancelActiveTrade() {
        if (this._activeTradeList == null) {
            return;
        }
        L2PcInstance partner = this._activeTradeList.getPartner();
        if (partner != null) {
            partner.onTradeCancel(this);
        }
        this.onTradeCancel(this);
    }

    public L2ManufactureList getCreateList() {
        return this._createList;
    }

    public void setCreateList(L2ManufactureList x) {
        this._createList = x;
    }

    public TradeList getSellList() {
        if (this._sellList == null) {
            this._sellList = new TradeList(this);
        }
        return this._sellList;
    }

    public TradeList getBuyList() {
        if (this._buyList == null) {
            this._buyList = new TradeList(this);
        }
        return this._buyList;
    }

    public void setPrivateStoreType(int type) {
        this._privatestore = type;
        if (Config.OFFLINE_DISCONNECT_FINISHED && this._privatestore == 0 && (this.getClient() == null || this.getClient().isDetached())) {
            this.deleteMe();
        }
    }

    public int getPrivateStoreType() {
        return this._privatestore;
    }

    public void setClan(L2Clan clan) {
        this._clan = clan;
        this.setTitle("");
        if (clan == null) {
            this._clanId = 0;
            this._clanPrivileges = 0;
            this._pledgeType = 0;
            this._powerGrade = 0;
            this._lvlJoinedAcademy = 0;
            this._apprentice = 0;
            this._sponsor = 0;
            this._activeWarehouse = null;
            if (this._isOnline) {
                CommunityServerThread.getInstance().sendPacket(new WorldInfo(this, null, 1));
            }
            return;
        }
        if (!clan.isMember(this.getObjectId())) {
            this.setClan(null);
            return;
        }
        this._clanId = clan.getClanId();
        if (this._isOnline) {
            CommunityServerThread.getInstance().sendPacket(new WorldInfo(this, null, 1));
        }
    }

    public L2Clan getClan() {
        return this._clan;
    }

    public boolean isClanLeader() {
        if (this.getClan() == null) {
            return false;
        }
        return this.getObjectId() == this.getClan().getLeaderId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reduceArrowCount(boolean bolts) {
        L2ItemInstance arrows = this.getInventory().getPaperdollItem(7);
        if (arrows == null) {
            this.getInventory().unEquipItemInSlot(7);
            if (bolts) {
                this._boltItem = null;
            } else {
                this._arrowItem = null;
            }
            this.sendPacket(new ItemList(this, false));
            return;
        }
        if (arrows.getCount() > 1L) {
            L2ItemInstance l2ItemInstance = arrows;
            synchronized (l2ItemInstance) {
                arrows.changeCountWithoutTrace(-1, this, null);
                arrows.setLastChange(2);
                if (GameTimeController.getGameTicks() % 10 == 0) {
                    arrows.updateDatabase();
                }
                this._inventory.refreshWeight();
            }
        } else {
            this._inventory.destroyItem("Consume", arrows, this, null);
            this.getInventory().unEquipItemInSlot(7);
            if (bolts) {
                this._boltItem = null;
            } else {
                this._arrowItem = null;
            }
            if (Config.DEBUG) {
                _log.fine("removed arrows count");
            }
            this.sendPacket(new ItemList(this, false));
            return;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(arrows);
            this.sendPacket(iu);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
    }

    @Override
    protected boolean checkAndEquipArrows() {
        if (this.getInventory().getPaperdollItem(7) == null) {
            this._arrowItem = this.getInventory().findArrowForBow(this.getActiveWeaponItem());
            if (this._arrowItem != null) {
                this.getInventory().setPaperdollItem(7, this._arrowItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._arrowItem = this.getInventory().getPaperdollItem(7);
        }
        return this._arrowItem != null;
    }

    @Override
    protected boolean checkAndEquipBolts() {
        if (this.getInventory().getPaperdollItem(7) == null) {
            this._boltItem = this.getInventory().findBoltForCrossBow(this.getActiveWeaponItem());
            if (this._boltItem != null) {
                this.getInventory().setPaperdollItem(7, this._boltItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._boltItem = this.getInventory().getPaperdollItem(7);
        }
        return this._boltItem != null;
    }

    public boolean disarmWeapons() {
        if (this.isCursedWeaponEquipped()) {
            return false;
        }
        if (this.isCombatFlagEquipped()) {
            return false;
        }
        L2ItemInstance wpn = this.getInventory().getPaperdollItem(5);
        if (wpn != null) {
            L2ItemInstance[] unequiped = this.getInventory().unEquipItemInBodySlotAndRecord(wpn.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            this.sendPacket(iu);
            this.abortAttack();
            this.broadcastUserInfo();
            if (unequiped.length > 0) {
                SystemMessage sm = null;
                if (unequiped[0].getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                    sm.addNumber(unequiped[0].getEnchantLevel());
                    sm.addItemName(unequiped[0]);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                    sm.addItemName(unequiped[0]);
                }
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public boolean disarmShield() {
        L2ItemInstance sld = this.getInventory().getPaperdollItem(7);
        if (sld != null) {
            L2ItemInstance[] unequiped = this.getInventory().unEquipItemInBodySlotAndRecord(sld.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            this.sendPacket(iu);
            this.abortAttack();
            this.broadcastUserInfo();
            if (unequiped.length > 0) {
                SystemMessage sm = null;
                if (unequiped[0].getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                    sm.addNumber(unequiped[0].getEnchantLevel());
                    sm.addItemName(unequiped[0]);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                    sm.addItemName(unequiped[0]);
                }
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public boolean mount(L2Summon pet) {
        if (!this.disarmWeapons()) {
            return false;
        }
        if (!this.disarmShield()) {
            return false;
        }
        if (this.isTransformed()) {
            return false;
        }
        this.stopAllToggles();
        Ride mount = new Ride(this, true, pet.getTemplate().npcId);
        this.setMount(pet.getNpcId(), pet.getLevel(), mount.getMountType());
        this.setMountObjectID(pet.getControlObjectId());
        this.clearPetData();
        this.startFeed(pet.getNpcId());
        this.broadcastPacket(mount);
        this.broadcastUserInfo();
        pet.unSummon(this);
        return true;
    }

    public boolean mount(int npcId, int controlItemObjId, boolean useFood) {
        if (!this.disarmWeapons()) {
            return false;
        }
        if (!this.disarmShield()) {
            return false;
        }
        if (this.isTransformed()) {
            return false;
        }
        this.stopAllToggles();
        Ride mount = new Ride(this, true, npcId);
        int level = this.getLevel();
        if (npcId == 16041 && level < 70) {
            level = 70;
        }
        if (this.setMount(npcId, level, mount.getMountType())) {
            this.clearPetData();
            this.setMountObjectID(controlItemObjId);
            this.broadcastPacket(mount);
            this.broadcastUserInfo();
            if (useFood) {
                this.startFeed(npcId);
            }
            return true;
        }
        return false;
    }

    public boolean mountPlayer(L2Summon pet) {
        if (pet != null && pet.isMountable() && !this.isMounted() && !this.isBetrayed()) {
            if (this.isDead()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.STRIDER_CANT_BE_RIDDEN_WHILE_DEAD));
                return false;
            }
            if (pet.isDead()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.DEAD_STRIDER_CANT_BE_RIDDEN));
                return false;
            }
            if (pet.isInCombat() || pet.isRooted()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.STRIDER_IN_BATLLE_CANT_BE_RIDDEN));
                return false;
            }
            if (this.isInCombat()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.STRIDER_CANT_BE_RIDDEN_WHILE_IN_BATTLE));
                return false;
            }
            if (this.isSitting()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.STRIDER_CAN_BE_RIDDEN_ONLY_WHILE_STANDING));
                return false;
            }
            if (this.isFishing()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DO_WHILE_FISHING_2));
                return false;
            }
            if (this.isTransformed() || this.isCursedWeaponEquipped()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.getInventory().getItemByItemId(9819) != null) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendMessage("You cannot mount a steed while holding a flag.");
                return false;
            }
            if (pet.isHungry()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.HUNGRY_STRIDER_NOT_MOUNT));
                return false;
            }
            if (!Util.checkIfInRange(200, this, pet, true)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TOO_FAR_AWAY_FROM_FENRIR_TO_MOUNT));
                return false;
            }
            if (!pet.isDead() && !this.isMounted()) {
                this.mount(pet);
            }
        } else if (this.isRentedPet()) {
            this.stopRentPet();
        } else if (this.isMounted()) {
            if (this.getMountType() == 2 && this.isInsideZone((byte)6)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_DISMOUNT_HERE));
                return false;
            }
            if (this.isHungry()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.HUNGRY_STRIDER_NOT_MOUNT));
                return false;
            }
            this.dismount();
        }
        return true;
    }

    public boolean dismount() {
        if (this.checkLandingState() && this.getMountType() == 2 && !Config.ALT_WYVERN_MAKEALANDING) {
            if (!this.isGM() && Config.ALT_DISMOUNT_WYVERN_IN_NOLANDING) {
                this.teleToLocation(MapRegionTable.getInstance().getTeleToLocation(this, MapRegionTable.TeleportWhereType.Town), true);
            } else {
                return false;
            }
        }
        boolean wasFlying = this.isFlying();
        this.sendPacket(new SetupGauge(3, 0, 0));
        int petId = this._mountNpcId;
        if (this.setMount(0, 0, 0)) {
            this.stopFeed();
            this.clearPetData();
            if (wasFlying) {
                this.removeSkill(SkillTable.FrequentSkill.WYVERN_BREATH.getSkill());
            }
            Ride dismount = new Ride(this, false, 0);
            this.broadcastPacket(dismount);
            this.setMountObjectID(0);
            this.storePetFood(petId);
            this.broadcastUserInfo();
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsingDualWeapon() {
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (weaponItem == null) {
            return false;
        }
        if (weaponItem.getItemType() == L2WeaponType.DUAL) {
            return true;
        }
        if (weaponItem.getItemType() == L2WeaponType.DUALFIST) {
            return true;
        }
        return weaponItem.getItemType() == L2WeaponType.DUALDAGGER;
    }

    public void setUptime(long time) {
        this._uptime = time;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this._uptime;
    }

    @Override
    public boolean isInvul() {
        return super.isInvul() || this._teleportProtectEndTime > (long)GameTimeController.getGameTicks();
    }

    @Override
    public boolean isInParty() {
        return this._party != null;
    }

    public void setParty(L2Party party) {
        this._party = party;
    }

    public void joinParty(L2Party party) {
        if (party != null) {
            this._party = party;
            party.addPartyMember(this);
        }
    }

    public void leaveParty() {
        if (this.isInParty()) {
            this._party.removePartyMember(this);
            this._party = null;
        }
    }

    @Override
    public L2Party getParty() {
        return this._party;
    }

    @Override
    public boolean isGM() {
        return this.getAccessLevel().isGm();
    }

    public void setAccessLevel(int level) {
        if (level == AccessLevels._masterAccessLevelNum) {
            _log.warning("Master access level set for character " + this.getName() + "! Just a warning to be careful ;)");
            this._accessLevel = AccessLevels._masterAccessLevel;
        } else if (level == 0) {
            this._accessLevel = AccessLevels._userAccessLevel;
        } else {
            L2AccessLevel accessLevel = AccessLevels.getInstance().getAccessLevel(level);
            if (accessLevel == null) {
                if (level < 0) {
                    AccessLevels.getInstance().addBanAccessLevel(level);
                    this._accessLevel = AccessLevels.getInstance().getAccessLevel(level);
                } else {
                    _log.warning("Tryed to set unregistered access level " + level + " to character " + this.getName() + ". Setting access level without privileges!");
                    this._accessLevel = AccessLevels._userAccessLevel;
                }
            } else {
                this._accessLevel = accessLevel;
            }
        }
        this.getAppearance().setNameColor(this._accessLevel.getNameColor());
        this.getAppearance().setTitleColor(this._accessLevel.getTitleColor());
        this.broadcastUserInfo();
        CharNameTable.getInstance().addName(this);
    }

    public void setAccountAccesslevel(int level) {
        LoginServerThread.getInstance().sendAccessLevel(this.getAccountName(), level);
    }

    public void setGmEnable(boolean value) {
        this._gmEnable = value;
    }

    public boolean getGmEnable() {
        return this._gmEnable;
    }

    public L2AccessLevel getAccessLevel() {
        if (this._gmEnable) {
            return this.getL2AccessLevel();
        }
        return AccessLevels._userAccessLevel;
    }

    public L2AccessLevel getL2AccessLevel() {
        if (Config.EVERYBODY_HAS_ADMIN_RIGHTS) {
            return AccessLevels._masterAccessLevel;
        }
        if (this._accessLevel == null) {
            this.setAccessLevel(0);
        }
        return this._accessLevel;
    }

    @Override
    public double getLevelMod() {
        return (89.0 + (double)this.getLevel()) / 100.0;
    }

    public void updateAndBroadcastStatus(int broadcastType) {
        this.refreshOverloaded();
        this.refreshExpertisePenalty();
        if (broadcastType == 1) {
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
        }
        if (broadcastType == 2) {
            this.broadcastUserInfo();
        }
    }

    public void setKarmaFlag(int flag) {
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            player.sendPacket(new RelationChanged(this, this.getRelation(player), this.isAutoAttackable(player)));
            if (this.getPet() == null) continue;
            player.sendPacket(new RelationChanged(this.getPet(), this.getRelation(player), this.isAutoAttackable(player)));
        }
    }

    public void broadcastKarma() {
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(27, this.getKarma());
        this.sendPacket(su);
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            player.sendPacket(new RelationChanged(this, this.getRelation(player), this.isAutoAttackable(player)));
            if (this.getPet() == null) continue;
            player.sendPacket(new RelationChanged(this.getPet(), this.getRelation(player), this.isAutoAttackable(player)));
        }
    }

    public void setOnlineStatus(boolean isOnline, boolean updateInDb) {
        if (this._isOnline != isOnline) {
            this._isOnline = isOnline;
        }
        if (updateInDb) {
            this.updateOnlineStatus();
        }
    }

    public void setIsIn7sDungeon(boolean isIn7sDungeon) {
        this._isIn7sDungeon = isIn7sDungeon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnlineStatus() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET online=?, lastAccess=? WHERE charId=?");
            statement.setInt(1, this.isOnlineInt());
            statement.setLong(2, System.currentTimeMillis());
            statement.setInt(3, this.getObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed updating character online status.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDb() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(INSERT_CHARACTER);
            statement.setString(1, this._accountName);
            statement.setInt(2, this.getObjectId());
            statement.setString(3, this.getName());
            statement.setInt(4, this.getLevel());
            statement.setInt(5, this.getMaxHp());
            statement.setDouble(6, this.getCurrentHp());
            statement.setInt(7, this.getMaxCp());
            statement.setDouble(8, this.getCurrentCp());
            statement.setInt(9, this.getMaxMp());
            statement.setDouble(10, this.getCurrentMp());
            statement.setInt(11, this.getAppearance().getFace());
            statement.setInt(12, this.getAppearance().getHairStyle());
            statement.setInt(13, this.getAppearance().getHairColor());
            statement.setInt(14, this.getAppearance().getSex() ? 1 : 0);
            statement.setLong(15, this.getExp());
            statement.setInt(16, this.getSp());
            statement.setInt(17, this.getKarma());
            statement.setInt(18, this.getFame());
            statement.setInt(19, this.getPvpKills());
            statement.setInt(20, this.getPkKills());
            statement.setInt(21, this.getClanId());
            statement.setInt(22, this.getRace().ordinal());
            statement.setInt(23, this.getClassId().getId());
            statement.setLong(24, this.getDeleteTimer());
            statement.setInt(25, this.hasDwarvenCraft() ? 1 : 0);
            statement.setString(26, this.getTitle());
            statement.setInt(27, this.getAppearance().getTitleColor());
            statement.setInt(28, this.getL2AccessLevel().getLevel());
            statement.setInt(29, this.isOnlineInt());
            statement.setInt(30, this.isIn7sDungeon() ? 1 : 0);
            statement.setInt(31, this.getClanPrivileges());
            statement.setInt(32, this.getWantsPeace());
            statement.setInt(33, this.getBaseClass());
            statement.setInt(34, this.getNewbie());
            statement.setInt(35, this.isNoble() ? 1 : 0);
            statement.setLong(36, 0L);
            statement.setLong(37, this.getCreateTime());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not insert char data: " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static L2PcInstance restore(int objectId) {
        L2PcInstance player = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_CHARACTER);
            statement.setInt(1, objectId);
            ResultSet rset = statement.executeQuery();
            double currentCp = 0.0;
            double currentHp = 0.0;
            double currentMp = 0.0;
            if (rset.next()) {
                int activeClassId = rset.getInt("classid");
                boolean female = rset.getInt("sex") != 0;
                L2PcTemplate template = CharTemplateTable.getInstance().getTemplate(activeClassId, female);
                PcAppearance app = new PcAppearance(rset.getByte("face"), rset.getByte("hairColor"), rset.getByte("hairStyle"), female);
                player = new L2PcInstance(objectId, template, rset.getString("account_name"), app);
                player.setName(rset.getString("char_name"));
                player._lastAccess = rset.getLong("lastAccess");
                player.getStat().setExp(rset.getLong("exp"));
                player.setExpBeforeDeath(rset.getLong("expBeforeDeath"));
                player.getStat().setLevel(rset.getByte("level"));
                player.getStat().setSp(rset.getInt("sp"));
                player.setWantsPeace(rset.getInt("wantspeace"));
                player.setHeading(rset.getInt("heading"));
                player.setKarma(rset.getInt("karma"));
                player.setFame(rset.getInt("fame"));
                player.setPvpKills(rset.getInt("pvpkills"));
                player.setPkKills(rset.getInt("pkkills"));
                player.setOnlineTime(rset.getLong("onlinetime"));
                player.setNewbie(rset.getInt("newbie"));
                player.setNoble(rset.getInt("nobless") == 1);
                player.setClanJoinExpiryTime(rset.getLong("clan_join_expiry_time"));
                if (player.getClanJoinExpiryTime() < System.currentTimeMillis()) {
                    player.setClanJoinExpiryTime(0L);
                }
                player.setClanCreateExpiryTime(rset.getLong("clan_create_expiry_time"));
                if (player.getClanCreateExpiryTime() < System.currentTimeMillis()) {
                    player.setClanCreateExpiryTime(0L);
                }
                int clanId = rset.getInt("clanid");
                player.setPowerGrade((int)rset.getLong("power_grade"));
                player.setPledgeType(rset.getInt("subpledge"));
                if (clanId > 0) {
                    player.setClan(ClanTable.getInstance().getClan(clanId));
                }
                if (player.getClan() != null) {
                    if (player.getClan().getLeaderId() != player.getObjectId()) {
                        if (player.getPowerGrade() == 0) {
                            player.setPowerGrade(5);
                        }
                        player.setClanPrivileges(player.getClan().getRankPrivs(player.getPowerGrade()));
                    } else {
                        player.setClanPrivileges(0xFFFFFE);
                        player.setPowerGrade(1);
                    }
                    int pledgeClass = 0;
                    pledgeClass = player.getClan().getClanMember(objectId).calculatePledgeClass(player);
                    if (player.isNoble() && pledgeClass < 5) {
                        pledgeClass = 5;
                    }
                    if (player.isHero() && pledgeClass < 8) {
                        pledgeClass = 8;
                    }
                    player.setPledgeClass(pledgeClass);
                } else {
                    player.setClanPrivileges(0);
                }
                player.setDeleteTimer(rset.getLong("deletetime"));
                player.setTitle(rset.getString("title"));
                player.getAppearance().setTitleColor(rset.getInt("title_color"));
                player.setAccessLevel(rset.getInt("accesslevel"));
                player.setFistsWeaponItem(player.findFistsWeaponItem(activeClassId));
                player.setUptime(System.currentTimeMillis());
                currentHp = rset.getDouble("curHp");
                currentCp = rset.getDouble("curCp");
                currentMp = rset.getDouble("curMp");
                player.setHero(rset.getInt("hero") == 1);
                player._classIndex = 0;
                try {
                    player.setBaseClass(rset.getInt("base_class"));
                }
                catch (Exception e) {
                    player.setBaseClass(activeClassId);
                }
                if (L2PcInstance.restoreSubClassData(player) && activeClassId != player.getBaseClass()) {
                    for (SubClass subClass : player.getSubClasses().values()) {
                        if (subClass.getClassId() != activeClassId) continue;
                        player._classIndex = subClass.getClassIndex();
                    }
                }
                if (player.getClassIndex() == 0 && activeClassId != player.getBaseClass()) {
                    player.setClassId(player.getBaseClass());
                    _log.warning("Player " + player.getName() + " reverted to base class. Possibly has tried a relogin exploit while subclassing.");
                } else {
                    player._activeClass = activeClassId;
                }
                player.setApprentice(rset.getInt("apprentice"));
                player.setSponsor(rset.getInt("sponsor"));
                player.setLvlJoinedAcademy(rset.getInt("lvl_joined_academy"));
                player.setIsIn7sDungeon(rset.getInt("isin7sdungeon") == 1);
                player.setPunishLevel(rset.getInt("punish_level"));
                if (player.getPunishLevel() != PunishLevel.NONE) {
                    player.setPunishTimer(rset.getLong("punish_timer"));
                } else {
                    player.setPunishTimer(0L);
                }
                CursedWeaponsManager.getInstance().checkPlayer(player);
                player.setAllianceWithVarkaKetra(rset.getInt("varka_ketra_ally"));
                player.setDeathPenaltyBuffLevel(rset.getInt("death_penalty_level"));
                player.setVitalityPoints(rset.getInt("vitality_points"), true);
                player.setXYZInvisible(rset.getInt("x"), rset.getInt("y"), rset.getInt("z"));
                player.setBookMarkSlot(rset.getInt("BookmarkSlot"));
                player.setCreateTime(rset.getLong("createTime"));
                player.setLang(rset.getString("language"));
                PreparedStatement stmt = con.prepareStatement("SELECT charId, char_name FROM characters WHERE account_name=? AND charId<>?");
                stmt.setString(1, player._accountName);
                stmt.setInt(2, objectId);
                ResultSet chars = stmt.executeQuery();
                while (chars.next()) {
                    Integer charId = chars.getInt("charId");
                    String charName = chars.getString("char_name");
                    player._chars.put(charId, charName);
                }
                chars.close();
                stmt.close();
            }
            rset.close();
            statement.close();
            if (Hero.getInstance().getHeroes() != null && Hero.getInstance().getHeroes().containsKey(objectId)) {
                player.setHero(true);
            }
            player.getInventory().restore();
            if (!Config.WAREHOUSE_CACHE) {
                player.getWarehouse();
            }
            player.restoreCharData();
            player.rewardSkills();
            if (Config.STORE_SKILL_COOLTIME) {
                player.restoreEffects();
            }
            player.setCurrentCp(currentCp);
            player.setCurrentHp(currentHp);
            player.setCurrentMp(currentMp);
            if (currentHp < 0.5) {
                player.setIsDead(true);
                player.stopHpMpRegeneration();
            }
            player.setPet(L2World.getInstance().getPet(player.getObjectId()));
            if (player.getPet() != null) {
                player.getPet().setOwner(player);
            }
            player.refreshOverloaded();
            player.refreshExpertisePenalty();
            player.restoreFriendList();
            if (Config.STORE_UI_SETTINGS) {
                player.restoreUISettings();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed loading character.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return player;
    }

    public Forum getMail() {
        throw new RuntimeException();
    }

    public void setMail(Forum forum) {
        throw new RuntimeException();
    }

    public Forum getMemo() {
        throw new RuntimeException();
    }

    public void setMemo(Forum forum) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean restoreSubClassData(L2PcInstance player) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_CHAR_SUBCLASSES);
            statement.setInt(1, player.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                SubClass subClass = new SubClass();
                subClass.setClassId(rset.getInt("class_id"));
                subClass.setLevel(rset.getByte("level"));
                subClass.setExp(rset.getLong("exp"));
                subClass.setSp(rset.getInt("sp"));
                subClass.setClassIndex(rset.getInt("class_index"));
                player.getSubClasses().put(subClass.getClassIndex(), subClass);
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore classes for " + player.getName() + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return true;
    }

    private void restoreCharData() {
        this.restoreSkills();
        this._macroses.restore();
        this._shortCuts.restore();
        this.restoreHenna();
        this.restoreTeleportBookmark();
        this.restoreRecipeBook(true);
        if (Config.STORE_RECIPE_SHOPLIST) {
            this.restoreRecipeShopList();
        }
        this.loadPremiumItemList();
        this.checkPetInvItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRecipeBook(boolean loadCommon) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            String sql = loadCommon ? "SELECT id, type, classIndex FROM character_recipebook WHERE charId=?" : "SELECT id FROM character_recipebook WHERE charId=? AND classIndex=? AND type = 1";
            PreparedStatement statement = con.prepareStatement(sql);
            statement.setInt(1, this.getObjectId());
            if (!loadCommon) {
                statement.setInt(2, this._classIndex);
            }
            ResultSet rset = statement.executeQuery();
            this._dwarvenRecipeBook.clear();
            while (rset.next()) {
                L2RecipeList recipe = RecipeController.getInstance().getRecipeList(rset.getInt("id"));
                if (loadCommon) {
                    if (rset.getInt(2) == 1) {
                        if (rset.getInt(3) != this._classIndex) continue;
                        this.registerDwarvenRecipeList(recipe, false);
                        continue;
                    }
                    this.registerCommonRecipeList(recipe, false);
                    continue;
                }
                this.registerDwarvenRecipeList(recipe, false);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore recipe book data:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public Map<Integer, L2PremiumItem> getPremiumItemList() {
        return this._premiumItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPremiumItemList() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            String sql = "SELECT itemNum, itemId, itemCount, itemSender FROM character_premium_items WHERE charId=?";
            PreparedStatement statement = con.prepareStatement(sql);
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int itemNum = rset.getInt("itemNum");
                int itemId = rset.getInt("itemId");
                long itemCount = rset.getLong("itemCount");
                String itemSender = rset.getString("itemSender");
                this._premiumItems.put(itemNum, new L2PremiumItem(itemId, itemCount, itemSender));
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore premium items: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePremiumItem(int itemNum, long newcount) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE character_premium_items SET itemCount=? WHERE charId=? AND itemNum=? ");
            statement.setLong(1, newcount);
            statement.setInt(2, this.getObjectId());
            statement.setInt(3, itemNum);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not update premium items: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePremiumItem(int itemNum) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_premium_items WHERE charId=? AND itemNum=? ");
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, itemNum);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not delete premium item: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public synchronized void store(boolean storeActiveEffects) {
        this.storeCharBase();
        this.storeCharSub();
        this.storeEffect(storeActiveEffects);
        this.transformInsertInfo();
        if (Config.STORE_RECIPE_SHOPLIST) {
            this.storeRecipeShopList();
        }
        if (Config.STORE_UI_SETTINGS) {
            this.storeUISettings();
        }
        SevenSigns.getInstance().saveSevenSignsData(this.getObjectId());
    }

    public void store() {
        this.store(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCharBase() {
        Connection con = null;
        try {
            int currentClassIndex = this.getClassIndex();
            this._classIndex = 0;
            long exp = this.getStat().getExp();
            byte level = this.getStat().getLevel();
            int sp = this.getStat().getSp();
            this._classIndex = currentClassIndex;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(UPDATE_CHARACTER);
            statement.setInt(1, level);
            statement.setInt(2, this.getMaxHp());
            statement.setDouble(3, this.getCurrentHp());
            statement.setInt(4, this.getMaxCp());
            statement.setDouble(5, this.getCurrentCp());
            statement.setInt(6, this.getMaxMp());
            statement.setDouble(7, this.getCurrentMp());
            statement.setInt(8, this.getAppearance().getFace());
            statement.setInt(9, this.getAppearance().getHairStyle());
            statement.setInt(10, this.getAppearance().getHairColor());
            statement.setInt(11, this.getAppearance().getSex() ? 1 : 0);
            statement.setInt(12, this.getHeading());
            statement.setInt(13, this._observerMode ? this._lastX : this.getX());
            statement.setInt(14, this._observerMode ? this._lastY : this.getY());
            statement.setInt(15, this._observerMode ? this._lastZ : this.getZ());
            statement.setLong(16, exp);
            statement.setLong(17, this.getExpBeforeDeath());
            statement.setInt(18, sp);
            statement.setInt(19, this.getKarma());
            statement.setInt(20, this.getFame());
            statement.setInt(21, this.getPvpKills());
            statement.setInt(22, this.getPkKills());
            statement.setInt(23, this.getClanId());
            statement.setInt(24, this.getRace().ordinal());
            statement.setInt(25, this.getClassId().getId());
            statement.setLong(26, this.getDeleteTimer());
            statement.setString(27, this.getTitle());
            statement.setInt(28, this.getAppearance().getTitleColor());
            statement.setInt(29, this.getL2AccessLevel().getLevel());
            statement.setInt(30, this.isOnlineInt());
            statement.setInt(31, this.isIn7sDungeon() ? 1 : 0);
            statement.setInt(32, this.getClanPrivileges());
            statement.setInt(33, this.getWantsPeace());
            statement.setInt(34, this.getBaseClass());
            long totalOnlineTime = this._onlineTime;
            if (this._onlineBeginTime > 0L) {
                totalOnlineTime += (System.currentTimeMillis() - this._onlineBeginTime) / 1000L;
            }
            statement.setLong(35, totalOnlineTime);
            statement.setInt(36, this.getPunishLevel().value());
            statement.setLong(37, this.getPunishTimer());
            statement.setInt(38, this.getNewbie());
            statement.setInt(39, this.isNoble() ? 1 : 0);
            statement.setLong(40, this.getPowerGrade());
            statement.setInt(41, this.getPledgeType());
            statement.setInt(42, this.getLvlJoinedAcademy());
            statement.setLong(43, this.getApprentice());
            statement.setLong(44, this.getSponsor());
            statement.setInt(45, this.getAllianceWithVarkaKetra());
            statement.setLong(46, this.getClanJoinExpiryTime());
            statement.setLong(47, this.getClanCreateExpiryTime());
            statement.setString(48, this.getName());
            statement.setLong(49, this.getDeathPenaltyBuffLevel());
            statement.setInt(50, this.getBookMarkSlot());
            statement.setInt(51, this.getVitalityPoints());
            statement.setString(52, this.getLang());
            statement.setInt(53, this.isHero() ? 1 : 0);
            statement.setInt(54, this.getObjectId());
            statement.execute();
            statement.close();
            L2DatabaseFactory.close(con);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store char base data: " + this + " - " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCharSub() {
        if (this.getTotalSubClasses() <= 0) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(UPDATE_CHAR_SUBCLASS);
            for (SubClass subClass : this.getSubClasses().values()) {
                statement.setLong(1, subClass.getExp());
                statement.setInt(2, subClass.getSp());
                statement.setInt(3, subClass.getLevel());
                statement.setInt(4, subClass.getClassId());
                statement.setInt(5, this.getObjectId());
                statement.setInt(6, subClass.getClassIndex());
                statement.execute();
                statement.clearParameters();
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store sub class data for " + this.getName() + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEffect(boolean storeEffects) {
        if (!Config.STORE_SKILL_COOLTIME) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(DELETE_SKILL_SAVE);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            statement.execute();
            statement.close();
            int buff_index = 0;
            FastList storedSkills = new FastList();
            statement = con.prepareStatement(ADD_SKILL_SAVE);
            if (storeEffects) {
                block8: for (L2Effect effect : this.getAllEffects()) {
                    if (effect == null) continue;
                    switch (effect.getEffectType()) {
                        case HEAL_OVER_TIME: 
                        case COMBAT_POINT_HEAL_OVER_TIME: 
                        case HIDE: {
                            continue block8;
                        }
                        default: {
                            L2Skill skill = effect.getSkill();
                            if (storedSkills.contains(skill.getReuseHashCode())) continue block8;
                            storedSkills.add(skill.getReuseHashCode());
                            if (effect.isHerbEffect() || !effect.getInUse() || skill.isToggle()) continue block8;
                            statement.setInt(1, this.getObjectId());
                            statement.setInt(2, skill.getId());
                            statement.setInt(3, skill.getLevel());
                            statement.setInt(4, effect.getCount());
                            statement.setInt(5, effect.getTime());
                            if (this._reuseTimeStamps.containsKey((Object)skill.getReuseHashCode())) {
                                TimeStamp t = (TimeStamp)this._reuseTimeStamps.get((Object)skill.getReuseHashCode());
                                statement.setLong(6, t.hasNotPassed() ? t.getReuse() : 0L);
                                statement.setDouble(7, t.hasNotPassed() ? (double)t.getStamp() : 0.0);
                            } else {
                                statement.setLong(6, 0L);
                                statement.setDouble(7, 0.0);
                            }
                            statement.setInt(8, 0);
                            statement.setInt(9, this.getClassIndex());
                            statement.setInt(10, ++buff_index);
                            statement.execute();
                        }
                    }
                }
            }
            Iterator i$ = this._reuseTimeStamps.keySet().iterator();
            while (i$.hasNext()) {
                TimeStamp t;
                int hash = (Integer)i$.next();
                if (storedSkills.contains(hash) || (t = (TimeStamp)this._reuseTimeStamps.get((Object)hash)) == null || !t.hasNotPassed()) continue;
                storedSkills.add(hash);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, t.getSkillId());
                statement.setInt(3, t.getSkillLvl());
                statement.setInt(4, -1);
                statement.setInt(5, -1);
                statement.setLong(6, t.getReuse());
                statement.setDouble(7, t.getStamp());
                statement.setInt(8, 1);
                statement.setInt(9, this.getClassIndex());
                statement.setInt(10, ++buff_index);
                statement.execute();
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store char effect data: ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean isOnline() {
        return this._isOnline;
    }

    public int isOnlineInt() {
        if (this._isOnline && this.getClient() != null) {
            return this.getClient().isDetached() ? 2 : 1;
        }
        return 0;
    }

    public boolean isIn7sDungeon() {
        return this._isIn7sDungeon;
    }

    public L2Skill addSkill(L2Skill newSkill, boolean store) {
        L2Skill oldSkill = super.addSkill(newSkill);
        if (store) {
            this.storeSkill(newSkill, oldSkill, -1);
        }
        return oldSkill;
    }

    @Override
    public L2Skill removeSkill(L2Skill skill, boolean store) {
        if (store) {
            return this.removeSkill(skill);
        }
        return super.removeSkill(skill, true);
    }

    public L2Skill removeSkill(L2Skill skill, boolean store, boolean cancelEffect) {
        if (store) {
            return this.removeSkill(skill);
        }
        return super.removeSkill(skill, cancelEffect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2Skill removeSkill(L2Skill skill) {
        L2ShortCut[] allShortCuts;
        L2Skill oldSkill = super.removeSkill(skill);
        if (oldSkill != null) {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(DELETE_SKILL_FROM_CHAR);
                statement.setInt(1, oldSkill.getId());
                statement.setInt(2, this.getObjectId());
                statement.setInt(3, this.getClassIndex());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Error could not delete skill: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
        if (this.transformId() > 0 || this.isCursedWeaponEquipped()) {
            return oldSkill;
        }
        for (L2ShortCut sc : allShortCuts = this.getAllShortCuts()) {
            if (sc == null || skill == null || sc.getId() != skill.getId() || sc.getType() != 2) continue;
            this.deleteShortCut(sc.getSlot(), sc.getPage());
        }
        return oldSkill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSkill(L2Skill newSkill, L2Skill oldSkill, int newClassIndex) {
        int classIndex = this._classIndex;
        if (newClassIndex > -1) {
            classIndex = newClassIndex;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            if (oldSkill != null && newSkill != null) {
                PreparedStatement statement = con.prepareStatement(UPDATE_CHARACTER_SKILL_LEVEL);
                statement.setInt(1, newSkill.getLevel());
                statement.setInt(2, oldSkill.getId());
                statement.setInt(3, this.getObjectId());
                statement.setInt(4, classIndex);
                statement.execute();
                statement.close();
            } else if (newSkill != null) {
                PreparedStatement statement = con.prepareStatement(ADD_NEW_SKILL);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, newSkill.getId());
                statement.setInt(3, newSkill.getLevel());
                statement.setInt(4, classIndex);
                statement.execute();
                statement.close();
            } else {
                _log.warning("could not store new skill. its NULL");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error could not store char skills: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSkills() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_SKILLS_FOR_CHAR);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt("skill_id");
                int level = rset.getInt("skill_level");
                L2Skill skill = SkillTable.getInstance().getInfo(id, level);
                if (skill == null) {
                    _log.warning("Skipped null skill Id: " + id + " Level: " + level + " while restoring player skills for playerObjId: " + this.getObjectId());
                    continue;
                }
                super.addSkill(skill);
                if (!Config.SKILL_CHECK_ENABLE || this.isGM() && !Config.SKILL_CHECK_GM || SkillTreesData.getInstance().isSkillAllowed(this, skill)) continue;
                Util.handleIllegalPlayerAction(this, "Player " + this.getName() + " has invalid skill " + skill.getName() + " (" + skill.getId() + "/" + skill.getLevel() + "), class:" + this.getTemplate().className, 1);
                if (!Config.SKILL_CHECK_REMOVE) continue;
                this.removeSkill(skill);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore character " + this + " skills: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreEffects() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_SKILL_SAVE);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int effectCount = rset.getInt("effect_count");
                int effectCurTime = rset.getInt("effect_cur_time");
                long reuseDelay = rset.getLong("reuse_delay");
                long systime = rset.getLong("systime");
                int restoreType = rset.getInt("restore_type");
                L2Skill skill = SkillTable.getInstance().getInfo(rset.getInt("skill_id"), rset.getInt("skill_level"));
                if (skill == null) continue;
                long remainingTime = systime - System.currentTimeMillis();
                if (remainingTime > 10L) {
                    this.disableSkill(skill, remainingTime);
                    this.addTimeStamp(skill, reuseDelay, systime);
                }
                if (restoreType > 0 || !skill.hasEffects()) continue;
                Env env = new Env();
                env.player = this;
                env.target = this;
                env.skill = skill;
                for (EffectTemplate et : skill.getEffectTemplates()) {
                    L2Effect ef = et.getEffect(env);
                    if (ef == null) continue;
                    ef.setCount(effectCount);
                    ef.setFirstTime(effectCurTime);
                    ef.scheduleEffect();
                }
            }
            rset.close();
            statement.close();
            statement = con.prepareStatement(DELETE_SKILL_SAVE);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore " + this + " active effect data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreHenna() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_CHAR_HENNAS);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            ResultSet rset = statement.executeQuery();
            for (int i = 0; i < 3; ++i) {
                this._henna[i] = null;
            }
            while (rset.next()) {
                L2Henna tpl;
                int slot = rset.getInt("slot");
                if (slot < 1 || slot > 3) continue;
                int symbol_id = rset.getInt("symbol_id");
                L2HennaInstance sym = null;
                if (symbol_id == 0 || (tpl = HennaTable.getInstance().getTemplate(symbol_id)) == null) continue;
                this._henna[slot - 1] = sym = new L2HennaInstance(tpl);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed restoing character " + this + " hennas.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.recalcHennaStats();
    }

    public int getHennaEmptySlots() {
        int totalSlots = 0;
        totalSlots = this.getClassId().level() == 1 ? 2 : 3;
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] == null) continue;
            --totalSlots;
        }
        if (totalSlots <= 0) {
            return 0;
        }
        return totalSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHenna(int slot) {
        if (slot < 1 || slot > 3) {
            return false;
        }
        if (this._henna[--slot] == null) {
            return false;
        }
        L2HennaInstance henna = this._henna[slot];
        this._henna[slot] = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(DELETE_CHAR_HENNA);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, slot + 1);
            statement.setInt(3, this.getClassIndex());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed remocing character henna.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.recalcHennaStats();
        this.sendPacket(new HennaInfo(this));
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        this.getInventory().addItem("Henna", henna.getItemIdDye(), henna.getAmountDyeRequire() / 2, this, null);
        this.reduceAdena("Henna", henna.getPrice() / 5, this, false);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
        sm.addItemName(henna.getItemIdDye());
        sm.addItemNumber(henna.getAmountDyeRequire() / 2);
        this.sendPacket(sm);
        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SYMBOL_DELETED));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHenna(L2HennaInstance henna) {
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] != null) continue;
            this._henna[i] = henna;
            this.recalcHennaStats();
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(ADD_CHAR_HENNA);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, henna.getSymbolId());
                statement.setInt(3, i + 1);
                statement.setInt(4, this.getClassIndex());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed saving character henna.", e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            this.sendPacket(new HennaInfo(this));
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
            return true;
        }
        return false;
    }

    private void recalcHennaStats() {
        this._hennaINT = 0;
        this._hennaSTR = 0;
        this._hennaCON = 0;
        this._hennaMEN = 0;
        this._hennaWIT = 0;
        this._hennaDEX = 0;
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] == null) continue;
            this._hennaINT += this._henna[i].getStatINT();
            this._hennaSTR += this._henna[i].getStatSTR();
            this._hennaMEN += this._henna[i].getStatMEM();
            this._hennaCON += this._henna[i].getStatCON();
            this._hennaWIT += this._henna[i].getStatWIT();
            this._hennaDEX += this._henna[i].getStatDEX();
        }
        if (this._hennaINT > 5) {
            this._hennaINT = 5;
        }
        if (this._hennaSTR > 5) {
            this._hennaSTR = 5;
        }
        if (this._hennaMEN > 5) {
            this._hennaMEN = 5;
        }
        if (this._hennaCON > 5) {
            this._hennaCON = 5;
        }
        if (this._hennaWIT > 5) {
            this._hennaWIT = 5;
        }
        if (this._hennaDEX > 5) {
            this._hennaDEX = 5;
        }
    }

    public L2HennaInstance getHenna(int slot) {
        if (slot < 1 || slot > 3) {
            return null;
        }
        return this._henna[slot - 1];
    }

    public int getHennaStatINT() {
        return this._hennaINT;
    }

    public int getHennaStatSTR() {
        return this._hennaSTR;
    }

    public int getHennaStatCON() {
        return this._hennaCON;
    }

    public int getHennaStatMEN() {
        return this._hennaMEN;
    }

    public int getHennaStatWIT() {
        return this._hennaWIT;
    }

    public int getHennaStatDEX() {
        return this._hennaDEX;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker == this || attacker == this.getPet()) {
            return false;
        }
        if (attacker instanceof L2MonsterInstance) {
            return true;
        }
        if (this.getParty() != null && this.getParty().getPartyMembers().contains((Object)attacker)) {
            return false;
        }
        if (attacker instanceof L2PcInstance && ((L2PcInstance)attacker).isInOlympiadMode()) {
            return this.isInOlympiadMode() && this.isOlympiadStart() && ((L2PcInstance)attacker).getOlympiadGameId() == this.getOlympiadGameId();
        }
        if (TvTEvent.isStarted() && TvTEvent.isPlayerParticipant(this.getObjectId())) {
            return true;
        }
        if (this.getClan() != null && attacker != null && this.getClan().isMember(attacker.getObjectId())) {
            return false;
        }
        if (attacker instanceof L2Playable && this.isInsideZone((byte)1)) {
            return false;
        }
        if (this.getKarma() > 0 || this.getPvpFlag() > 0) {
            return true;
        }
        if (attacker instanceof L2Playable) {
            L2PcInstance cha = attacker.getActingPlayer();
            if (this.getDuelState() == 1 && this.getDuelId() == cha.getDuelId()) {
                return true;
            }
            if (this.isInsideZone((byte)0) && cha.isInsideZone((byte)0)) {
                return true;
            }
            if (this.getClan() != null) {
                Siege siege = SiegeManager.getInstance().getSiege(this.getX(), this.getY(), this.getZ());
                if (siege != null) {
                    if (siege.checkIsDefender(cha.getClan()) && siege.checkIsDefender(this.getClan())) {
                        return false;
                    }
                    if (siege.checkIsAttacker(cha.getClan()) && siege.checkIsAttacker(this.getClan())) {
                        return false;
                    }
                }
                if (this.getClan() != null && cha.getClan() != null && this.getClan().isAtWarWith(cha.getClanId()) && cha.getClan().isAtWarWith(this.getClanId()) && this.getWantsPeace() == 0 && cha.getWantsPeace() == 0 && !this.isAcademyMember()) {
                    return true;
                }
            }
        } else if (attacker instanceof L2DefenderInstance && this.getClan() != null) {
            Siege siege = SiegeManager.getInstance().getSiege(this);
            return siege != null && siege.checkIsAttacker(this.getClan());
        }
        return false;
    }

    @Override
    public boolean useMagic(L2Skill skill, boolean forceUse, boolean dontMove) {
        if (skill.isPassive()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isCastingNow()) {
            SkillDat currentSkill = this.getCurrentSkill();
            if (currentSkill != null && skill.getId() == currentSkill.getSkillId()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (Config.DEBUG && this.getQueuedSkill() != null) {
                _log.info(this.getQueuedSkill().getSkill().getName() + " is already queued for " + this.getName() + ".");
            }
            this.setQueuedSkill(skill, forceUse, dontMove);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        this.setIsCastingNow(true);
        this.setCurrentSkill(skill, forceUse, dontMove);
        if (this.getQueuedSkill() != null) {
            this.setQueuedSkill(null, false, false);
        }
        if (!this.checkUseMagicConditions(skill, forceUse, dontMove)) {
            this.setIsCastingNow(false);
            return false;
        }
        L2Object target = null;
        switch (skill.getTargetType()) {
            case TARGET_AURA: 
            case TARGET_FRONT_AURA: 
            case TARGET_BEHIND_AURA: 
            case TARGET_GROUND: 
            case TARGET_SELF: {
                target = this;
                break;
            }
            default: {
                target = skill.getFirstOfTargetList(this);
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        return true;
    }

    private boolean checkUseMagicConditions(L2Skill skill, boolean forceUse, boolean dontMove) {
        L2PcInstance cha;
        L2Effect effect;
        L2SkillType sklType = skill.getSkillType();
        if (this.isOutOfControl() || this.isParalyzed() || this.isStunned() || this.isSleeping()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isDead()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isFishing() && sklType != L2SkillType.PUMPING && sklType != L2SkillType.REELING && sklType != L2SkillType.FISHING) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ONLY_FISHING_SKILLS_NOW));
            return false;
        }
        if (this.inObserverMode()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE));
            this.abortCast();
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isSitting()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_MOVE_SITTING));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.isToggle() && (effect = this.getFirstEffect(skill.getId())) != null) {
            effect.exit();
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isFakeDeath()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        L2Object target = null;
        L2Skill.SkillTargetType sklTargetType = skill.getTargetType();
        Point3D worldPosition = this.getCurrentSkillWorldPosition();
        if (sklTargetType == L2Skill.SkillTargetType.TARGET_GROUND && worldPosition == null) {
            _log.info("WorldPosition is null for skill: " + skill.getName() + ", player: " + this.getName() + ".");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        switch (sklTargetType) {
            case TARGET_AURA: 
            case TARGET_FRONT_AURA: 
            case TARGET_BEHIND_AURA: 
            case TARGET_GROUND: 
            case TARGET_SELF: 
            case TARGET_PARTY: 
            case TARGET_ALLY: 
            case TARGET_CLAN: 
            case TARGET_PARTY_CLAN: 
            case TARGET_AREA_SUMMON: {
                target = this;
                break;
            }
            case TARGET_PET: 
            case TARGET_SUMMON: {
                target = this.getPet();
                break;
            }
            default: {
                target = this.getTarget();
            }
        }
        if (target == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (target instanceof L2DoorInstance) {
            boolean isFort;
            boolean isCastle = ((L2DoorInstance)target).getCastle() != null && ((L2DoorInstance)target).getCastle().getCastleId() > 0 && ((L2DoorInstance)target).getCastle().getSiege().getIsInProgress();
            boolean bl = isFort = ((L2DoorInstance)target).getFort() != null && ((L2DoorInstance)target).getFort().getFortId() > 0 && ((L2DoorInstance)target).getFort().getSiege().getIsInProgress() && !((L2DoorInstance)target).getIsCommanderDoor();
            if (!isCastle && !isFort && ((L2DoorInstance)target).isUnlockable() && skill.getSkillType() != L2SkillType.UNLOCK) {
                return false;
            }
        }
        if (this.isInDuel() && target instanceof L2Playable && (cha = target.getActingPlayer()).getDuelId() != this.getDuelId()) {
            this.sendMessage("You cannot do this while duelling.");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (!(skill.getId() != 13 && skill.getId() != 299 && skill.getId() != 448 || (SiegeManager.getInstance().checkIfOkToSummon(this, false) || FortSiegeManager.getInstance().checkIfOkToSummon(this, false)) && !SevenSigns.getInstance().checkSummonConditions(this))) {
            return false;
        }
        if (this.isSkillDisabled(skill)) {
            SystemMessage sm = null;
            if (this._reuseTimeStamps.containsKey((Object)skill.getReuseHashCode())) {
                int remainingTime = (int)(((TimeStamp)this._reuseTimeStamps.get((Object)skill.getReuseHashCode())).getRemaining() / 1000L);
                int hours = remainingTime / 3600;
                int minutes = remainingTime % 3600 / 60;
                int seconds = remainingTime % 60;
                if (hours > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_HOURS_S3_MINUTES_S4_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                    sm.addNumber(hours);
                    sm.addNumber(minutes);
                } else if (minutes > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_MINUTES_S3_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                    sm.addNumber(minutes);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                }
                sm.addNumber(seconds);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_PREPARED_FOR_REUSE);
                sm.addSkillName(skill);
            }
            this.sendPacket(sm);
            return false;
        }
        if (skill.getSoulConsumeCount() > 0 && this.getSouls() < skill.getSoulConsumeCount()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THERE_IS_NOT_ENOUGH_SOUL));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (!skill.checkCondition(this, target, false)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.isOffensive() && sklType != L2SkillType.UNLOCK) {
            if (this.isInsidePeaceZone(this, target) && !this.getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IN_PEACEZONE));
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isInOlympiadMode() && !this.isOlympiadStart()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target.getActingPlayer() != null && this.getSiegeState() > 0 && this.isInsideZone((byte)2) && target.getActingPlayer().getSiegeState() == this.getSiegeState() && target.getActingPlayer() != this && target.getActingPlayer().getSiegeSide() == this.getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY));
                } else {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS));
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (!target.isAttackable() && !this.getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target instanceof L2EventMonsterInstance && ((L2EventMonsterInstance)target).eventSkillAttackBlocked()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (!target.isAutoAttackable(this) && !forceUse) {
                switch (sklTargetType) {
                    case TARGET_AURA: 
                    case TARGET_FRONT_AURA: 
                    case TARGET_BEHIND_AURA: 
                    case TARGET_GROUND: 
                    case TARGET_SELF: 
                    case TARGET_PARTY: 
                    case TARGET_ALLY: 
                    case TARGET_CLAN: 
                    case TARGET_PARTY_CLAN: 
                    case TARGET_AREA_SUMMON: {
                        break;
                    }
                    default: {
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return false;
                    }
                }
            }
            if (dontMove) {
                if (sklTargetType == L2Skill.SkillTargetType.TARGET_GROUND) {
                    if (!this.isInsideRadius(worldPosition.getX(), worldPosition.getY(), worldPosition.getZ(), skill.getCastRange() + this.getTemplate().collisionRadius, false, false)) {
                        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_TOO_FAR));
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return false;
                    }
                } else if (skill.getCastRange() > 0 && !this.isInsideRadius(target, skill.getCastRange() + this.getTemplate().collisionRadius, false, false)) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_TOO_FAR));
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            }
        }
        if (skill.getSkillType() == L2SkillType.INSTANT_JUMP) {
            if (this.isMovementDisabled()) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                sm.addSkillName(skill.getId());
                this.sendPacket(sm);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isInsideZone((byte)1)) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IN_PEACEZONE));
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (!skill.isOffensive() && target instanceof L2MonsterInstance && !forceUse && !skill.isNeutral()) {
            block7 : switch (sklTargetType) {
                case TARGET_AURA: 
                case TARGET_FRONT_AURA: 
                case TARGET_BEHIND_AURA: 
                case TARGET_GROUND: 
                case TARGET_SELF: 
                case TARGET_PARTY: 
                case TARGET_ALLY: 
                case TARGET_CLAN: 
                case TARGET_PARTY_CLAN: 
                case TARGET_PET: 
                case TARGET_SUMMON: 
                case TARGET_CORPSE_MOB: 
                case TARGET_AREA_CORPSE_MOB: {
                    break;
                }
                default: {
                    switch (sklType) {
                        case BEAST_FEED: 
                        case DELUXE_KEY_UNLOCK: 
                        case UNLOCK: {
                            break block7;
                        }
                    }
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            }
        }
        if (sklType == L2SkillType.SPOIL && !(target instanceof L2MonsterInstance)) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (sklType == L2SkillType.SWEEP && target instanceof L2Attackable) {
            int spoilerId = ((L2Attackable)target).getIsSpoiledBy();
            if (((L2Attackable)target).isDead()) {
                if (!((L2Attackable)target).isSpoil()) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SWEEPER_FAILED_TARGET_NOT_SPOILED));
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
                if (this.getObjectId() != spoilerId && !this.isInLooterParty(spoilerId)) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SWEEP_NOT_ALLOWED));
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            }
        }
        if (sklType == L2SkillType.DRAIN_SOUL && !(target instanceof L2MonsterInstance)) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        switch (sklTargetType) {
            case TARGET_AURA: 
            case TARGET_FRONT_AURA: 
            case TARGET_BEHIND_AURA: 
            case TARGET_GROUND: 
            case TARGET_SELF: 
            case TARGET_PARTY: 
            case TARGET_ALLY: 
            case TARGET_CLAN: 
            case TARGET_PARTY_CLAN: {
                break;
            }
            default: {
                if (this.checkPvpSkill(target, skill) || this.getAccessLevel().allowPeaceAttack()) break;
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (sklTargetType == L2Skill.SkillTargetType.TARGET_HOLY && !this.checkIfOkToCastSealOfRule(CastleManager.getInstance().getCastle(this), false, skill) || sklTargetType == L2Skill.SkillTargetType.TARGET_FLAGPOLE && !this.checkIfOkToCastFlagDisplay(FortManager.getInstance().getFort(this), false, skill) || sklType == L2SkillType.SIEGEFLAG && !L2SkillSiegeFlag.checkIfOkToPlaceFlag((L2Character)this, false, skill.getId() == 844) || sklType == L2SkillType.STRSIEGEASSAULT && !this.checkIfOkToUseStriderSiegeAssault() || sklType == L2SkillType.SUMMON_FRIEND && (!L2PcInstance.checkSummonerStatus(this) || !L2PcInstance.checkSummonTargetStatus(target, this))) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            this.abortCast();
            return false;
        }
        if (skill.getCastRange() > 0) {
            if (sklTargetType == L2Skill.SkillTargetType.TARGET_GROUND) {
                if (!GeoData.getInstance().canSeeTarget((L2Object)this, worldPosition)) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_SEE_TARGET));
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            } else if (!GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_SEE_TARGET));
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        return true;
    }

    public boolean checkIfOkToUseStriderSiegeAssault() {
        Castle castle = CastleManager.getInstance().getCastle(this);
        Fort fort = FortManager.getInstance().getFort(this);
        if (castle == null && fort == null) {
            return false;
        }
        if (castle != null) {
            return this.checkIfOkToUseStriderSiegeAssault(castle);
        }
        return this.checkIfOkToUseStriderSiegeAssault(fort);
    }

    public boolean checkIfOkToUseStriderSiegeAssault(Castle castle) {
        String text = "";
        if (castle == null || castle.getCastleId() <= 0) {
            text = "You must be on castle ground to use strider siege assault";
        } else if (!castle.getSiege().getIsInProgress()) {
            text = "You can only use strider siege assault during a siege.";
        } else if (!(this.getTarget() instanceof L2DoorInstance)) {
            text = "You can only use strider siege assault on doors and walls.";
        } else if (!this.isRidingStrider()) {
            text = "You can only use strider siege assault when on strider.";
        } else {
            return true;
        }
        this.sendMessage(text);
        return false;
    }

    public boolean checkIfOkToUseStriderSiegeAssault(Fort fort) {
        String text = "";
        if (fort == null || fort.getFortId() <= 0) {
            text = "You must be on fort ground to use strider siege assault";
        } else if (!fort.getSiege().getIsInProgress()) {
            text = "You can only use strider siege assault during a siege.";
        } else if (!(this.getTarget() instanceof L2DoorInstance)) {
            text = "You can only use strider siege assault on doors and walls.";
        } else if (!this.isRidingStrider()) {
            text = "You can only use strider siege assault when on strider.";
        } else {
            return true;
        }
        this.sendMessage(text);
        return false;
    }

    public boolean checkIfOkToCastSealOfRule(Castle castle, boolean isCheckOnly, L2Skill skill) {
        SystemMessage sm;
        if (castle == null || castle.getCastleId() <= 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
        } else if (!castle.getArtefacts().contains(this.getTarget())) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET);
        } else if (!castle.getSiege().getIsInProgress()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
        } else if (!Util.checkIfInRange(200, this, this.getTarget(), true)) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
        } else if (castle.getSiege().getAttackerClan(this.getClan()) == null) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
        } else {
            if (!isCheckOnly) {
                SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.OPPONENT_STARTED_ENGRAVING);
                castle.getSiege().announceToPlayer(sm2, false);
            }
            return true;
        }
        this.sendPacket(sm);
        return false;
    }

    public boolean checkIfOkToCastFlagDisplay(Fort fort, boolean isCheckOnly, L2Skill skill) {
        SystemMessage sm;
        if (fort == null || fort.getFortId() <= 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
        } else if (fort.getFlagPole() != this.getTarget()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET);
        } else if (!fort.getSiege().getIsInProgress()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
        } else if (!Util.checkIfInRange(200, this, this.getTarget(), true)) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
        } else if (fort.getSiege().getAttackerClan(this.getClan()) == null) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
        } else {
            if (!isCheckOnly) {
                fort.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.S1_TRYING_RAISE_FLAG), this.getClan().getName());
            }
            return true;
        }
        this.sendPacket(sm);
        return false;
    }

    public boolean isInLooterParty(int LooterId) {
        L2PcInstance looter = L2World.getInstance().getPlayer(LooterId);
        if (this.isInParty() && this.getParty().isInCommandChannel() && looter != null) {
            return this.getParty().getCommandChannel().getMembers().contains(looter);
        }
        if (this.isInParty() && looter != null) {
            return this.getParty().getPartyMembers().contains((Object)looter);
        }
        return false;
    }

    public boolean checkPvpSkill(L2Object target, L2Skill skill) {
        return this.checkPvpSkill(target, skill, false);
    }

    public boolean checkPvpSkill(L2Object target, L2Skill skill, boolean srcIsSummon) {
        if (target instanceof L2Summon) {
            target = target.getActingPlayer();
        }
        if (!(target == null || target == this || !(target instanceof L2PcInstance) || this.isInDuel() && ((L2PcInstance)target).getDuelId() == this.getDuelId() || this.isInsideZone((byte)0) || ((L2PcInstance)target).isInsideZone((byte)0))) {
            SkillDat skilldat = this.getCurrentSkill();
            SkillDat skilldatpet = this.getCurrentPetSkill();
            if (skill.isPvpSkill()) {
                if (this.getClan() != null && ((L2PcInstance)target).getClan() != null && this.getClan().isAtWarWith(((L2PcInstance)target).getClan().getClanId()) && ((L2PcInstance)target).getClan().isAtWarWith(this.getClan().getClanId())) {
                    return true;
                }
                if (((L2PcInstance)target).getPvpFlag() == 0 && ((L2PcInstance)target).getKarma() == 0) {
                    return false;
                }
            } else if (skilldat != null && !skilldat.isCtrlPressed() && skill.isOffensive() && !srcIsSummon || skilldatpet != null && !skilldatpet.isCtrlPressed() && skill.isOffensive() && srcIsSummon) {
                if (this.getClan() != null && ((L2PcInstance)target).getClan() != null && this.getClan().isAtWarWith(((L2PcInstance)target).getClan().getClanId()) && ((L2PcInstance)target).getClan().isAtWarWith(this.getClan().getClanId())) {
                    return true;
                }
                if (((L2PcInstance)target).getPvpFlag() == 0 && ((L2PcInstance)target).getKarma() == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isMageClass() {
        return this.getClassId().isMage();
    }

    public boolean isMounted() {
        return this._mountType > 0;
    }

    public boolean checkLandingState() {
        if (this.isInsideZone((byte)6)) {
            return true;
        }
        return this.isInsideZone((byte)2) && (this.getClan() == null || CastleManager.getInstance().getCastle(this) != CastleManager.getInstance().getCastleByOwner(this.getClan()) || this != this.getClan().getLeader().getPlayerInstance());
    }

    public boolean setMount(int npcId, int npcLevel, int mountType) {
        switch (mountType) {
            case 0: {
                this.setIsFlying(false);
                this.setIsRidingStrider(false);
                break;
            }
            case 1: {
                this.setIsRidingStrider(true);
                if (!this.isNoble()) break;
                L2Skill striderAssaultSkill = SkillTable.FrequentSkill.STRIDER_SIEGE_ASSAULT.getSkill();
                this.addSkill(striderAssaultSkill, false);
                break;
            }
            case 2: {
                this.setIsFlying(true);
                break;
            }
        }
        this._mountType = mountType;
        this._mountNpcId = npcId;
        this._mountLevel = npcLevel;
        return true;
    }

    public int getMountType() {
        return this._mountType;
    }

    @Override
    public final void stopAllEffects() {
        super.stopAllEffects();
        this.updateAndBroadcastStatus(2);
    }

    @Override
    public final void stopAllEffectsExceptThoseThatLastThroughDeath() {
        super.stopAllEffectsExceptThoseThatLastThroughDeath();
        this.updateAndBroadcastStatus(2);
    }

    public final void stopAllToggles() {
        this._effects.stopAllToggles();
    }

    public final void stopCubics() {
        if (this.getCubics() != null) {
            boolean removed = false;
            for (L2CubicInstance cubic : this.getCubics().values()) {
                cubic.stopAction();
                this.delCubic(cubic.getId());
                removed = true;
            }
            if (removed) {
                this.broadcastUserInfo();
            }
        }
    }

    public final void stopCubicsByOthers() {
        if (this.getCubics() != null) {
            boolean removed = false;
            for (L2CubicInstance cubic : this.getCubics().values()) {
                if (!cubic.givenByOther()) continue;
                cubic.stopAction();
                this.delCubic(cubic.getId());
                removed = true;
            }
            if (removed) {
                this.broadcastUserInfo();
            }
        }
    }

    @Override
    public void updateAbnormalEffect() {
        this.broadcastUserInfo();
    }

    public void tempInventoryDisable() {
        this._inventoryDisable = true;
        ThreadPoolManager.getInstance().scheduleGeneral(new InventoryEnable(), 1500L);
    }

    public boolean isInventoryDisabled() {
        return this._inventoryDisable;
    }

    public Map<Integer, L2CubicInstance> getCubics() {
        return this._cubics;
    }

    public void addCubic(int id, int level, double matk, int activationtime, int activationchance, int maxcount, int totalLifetime, boolean givenByOther) {
        if (Config.DEBUG) {
            _log.info("L2PcInstance(" + this.getName() + "): addCubic(" + id + "|" + level + "|" + matk + ")");
        }
        L2CubicInstance cubic = new L2CubicInstance(this, id, level, (int)matk, activationtime, activationchance, maxcount, totalLifetime, givenByOther);
        this._cubics.put(id, cubic);
    }

    public void delCubic(int id) {
        this._cubics.remove(id);
    }

    public L2CubicInstance getCubic(int id) {
        return this._cubics.get(id);
    }

    public int getEnchantEffect() {
        L2ItemInstance wpn = this.getActiveWeaponInstance();
        if (wpn == null) {
            return 0;
        }
        return Math.min(127, wpn.getEnchantLevel());
    }

    public void setLastFolkNPC(L2Npc folkNpc) {
        this._lastFolkNpc = folkNpc;
    }

    public L2Npc getLastFolkNPC() {
        return this._lastFolkNpc;
    }

    public boolean isFestivalParticipant() {
        return SevenSignsFestival.getInstance().isParticipant(this);
    }

    public void addAutoSoulShot(int itemId) {
        this._activeSoulShots.add((Object)itemId);
    }

    public boolean removeAutoSoulShot(int itemId) {
        return this._activeSoulShots.remove((Object)itemId);
    }

    public Set<Integer> getAutoSoulShot() {
        return this._activeSoulShots;
    }

    public void rechargeAutoSoulShot(boolean physical, boolean magic, boolean summon) {
        if (this._activeSoulShots == null || this._activeSoulShots.isEmpty()) {
            return;
        }
        try {
            Iterator i$ = this._activeSoulShots.iterator();
            while (i$.hasNext()) {
                int itemId = (Integer)i$.next();
                L2ItemInstance item = this.getInventory().getItemByItemId(itemId);
                if (item != null) {
                    IItemHandler handler;
                    if (magic) {
                        if (!summon) {
                            switch (itemId) {
                                case 2509: 
                                case 2510: 
                                case 2511: 
                                case 2512: 
                                case 2513: 
                                case 2514: 
                                case 3947: 
                                case 3948: 
                                case 3949: 
                                case 3950: 
                                case 3951: 
                                case 3952: 
                                case 5790: 
                                case 22072: 
                                case 22073: 
                                case 22074: 
                                case 22075: 
                                case 22076: 
                                case 22077: 
                                case 22078: 
                                case 22079: 
                                case 22080: 
                                case 22081: {
                                    handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem());
                                    if (handler == null) break;
                                    handler.useItem(this, item, false);
                                }
                            }
                        } else {
                            switch (itemId) {
                                case 6646: 
                                case 6647: 
                                case 20333: 
                                case 20334: {
                                    handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem());
                                    if (handler == null) break;
                                    handler.useItem(this, item, false);
                                }
                            }
                        }
                    }
                    if (!physical) continue;
                    if (!summon) {
                        switch (itemId) {
                            case 1463: 
                            case 1464: 
                            case 1465: 
                            case 1466: 
                            case 1467: 
                            case 1835: 
                            case 5789: 
                            case 22082: 
                            case 22083: 
                            case 22084: 
                            case 22085: 
                            case 22086: {
                                handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem());
                                if (handler == null) break;
                                handler.useItem(this, item, false);
                            }
                        }
                        continue;
                    }
                    if (itemId != 6645 && itemId != 20332 || (handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem())) == null) continue;
                    handler.useItem(this, item, false);
                    continue;
                }
                this.removeAutoSoulShot(itemId);
            }
        }
        catch (NullPointerException npe) {
            _log.log(Level.WARNING, this.toString(), npe);
        }
    }

    public void disableAutoShotByCrystalType(int crystalType) {
        Iterator i$ = this._activeSoulShots.iterator();
        while (i$.hasNext()) {
            int itemId = (Integer)i$.next();
            if (ItemTable.getInstance().getTemplate(itemId).getCrystalType() != crystalType) continue;
            this.disableAutoShot(itemId);
        }
    }

    public boolean disableAutoShot(int itemId) {
        if (this._activeSoulShots.contains((Object)itemId)) {
            this.removeAutoSoulShot(itemId);
            this.sendPacket(new ExAutoSoulShot(itemId, 0));
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED).addItemName(itemId));
            return true;
        }
        return false;
    }

    public void disableAutoShotsAll() {
        Iterator i$ = this._activeSoulShots.iterator();
        while (i$.hasNext()) {
            int itemId = (Integer)i$.next();
            this.sendPacket(new ExAutoSoulShot(itemId, 0));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED);
            sm.addItemName(itemId);
            this.sendPacket(sm);
        }
        this._activeSoulShots.clear();
    }

    public int getClanPrivileges() {
        return this._clanPrivileges;
    }

    public void setClanPrivileges(int n) {
        this._clanPrivileges = n;
    }

    public void setPledgeClass(int classId) {
        this._pledgeClass = classId;
        this.checkItemRestriction();
    }

    public int getPledgeClass() {
        return this._pledgeClass;
    }

    public void setPledgeType(int typeId) {
        this._pledgeType = typeId;
    }

    public int getPledgeType() {
        return this._pledgeType;
    }

    public int getApprentice() {
        return this._apprentice;
    }

    public void setApprentice(int apprentice_id) {
        this._apprentice = apprentice_id;
    }

    public int getSponsor() {
        return this._sponsor;
    }

    public void setSponsor(int sponsor_id) {
        this._sponsor = sponsor_id;
    }

    public int getBookMarkSlot() {
        return this._bookmarkslot;
    }

    public void setBookMarkSlot(int slot) {
        this._bookmarkslot = slot;
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    @Override
    public void sendMessage(String message) {
        this.sendPacket(SystemMessage.sendString(message));
    }

    @Deprecated
    public void TRACE(String message) {
        this.TRACE("", message);
    }

    @Deprecated
    public void TRACE(String title, String message) {
    }

    public void enterObserverMode(int x, int y, int z) {
        this._lastX = this.getX();
        this._lastY = this.getY();
        this._lastZ = this.getZ();
        this._observerMode = true;
        this.setTarget(null);
        this.setIsParalyzed(true);
        this.startParalyze();
        this.setIsInvul(true);
        this.getAppearance().setInvisible();
        this.sendPacket(new ObservationMode(x, y, z));
        this.getKnownList().removeAllKnownObjects();
        this.setXYZ(x, y, z);
        this.broadcastUserInfo();
    }

    public void setLastCords(int x, int y, int z) {
        this._lastX = this.getX();
        this._lastY = this.getY();
        this._lastZ = this.getZ();
    }

    public void enterOlympiadObserverMode(Location loc, int id) {
        if (this.getPet() != null) {
            this.getPet().unSummon(this);
        }
        if (!this.getCubics().isEmpty()) {
            for (L2CubicInstance cubic : this.getCubics().values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this.getCubics().clear();
        }
        if (this.getParty() != null) {
            this.getParty().removePartyMember(this);
        }
        this._olympiadGameId = id;
        if (this.isSitting()) {
            this.standUp();
        }
        if (!this._observerMode) {
            this._lastX = this.getX();
            this._lastY = this.getY();
            this._lastZ = this.getZ();
        }
        this._observerMode = true;
        this.setTarget(null);
        this.setIsInvul(true);
        this.getAppearance().setInvisible();
        this.teleToLocation(loc, false);
        this.sendPacket(new ExOlympiadMode(3));
        this.broadcastUserInfo();
    }

    public void leaveObserverMode() {
        this.setTarget(null);
        this.getKnownList().removeAllKnownObjects();
        this.setXYZ(this._lastX, this._lastY, this._lastZ);
        this.setIsParalyzed(false);
        this.stopParalyze(false);
        if (!AdminCommandAccessRights.getInstance().hasAccess("admin_invis", this.getAccessLevel())) {
            this.getAppearance().setVisible();
        }
        if (!AdminCommandAccessRights.getInstance().hasAccess("admin_invul", this.getAccessLevel())) {
            this.setIsInvul(false);
        }
        if (this.getAI() != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.setFalling();
        this._observerMode = false;
        this.setLastCords(0, 0, 0);
        this.sendPacket(new ObservationReturn(this));
        this.broadcastUserInfo();
    }

    public void leaveOlympiadObserverMode() {
        if (this._olympiadGameId == -1) {
            return;
        }
        this._olympiadGameId = -1;
        this._observerMode = false;
        this.setTarget(null);
        this.sendPacket(new ExOlympiadMode(0));
        this.teleToLocation(this._lastX, this._lastY, this._lastZ, true);
        if (!AdminCommandAccessRights.getInstance().hasAccess("admin_invis", this.getAccessLevel())) {
            this.getAppearance().setVisible();
        }
        if (!AdminCommandAccessRights.getInstance().hasAccess("admin_invul", this.getAccessLevel())) {
            this.setIsInvul(false);
        }
        if (this.getAI() != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.setLastCords(0, 0, 0);
        this.broadcastUserInfo();
    }

    public void setOlympiadSide(int i) {
        this._olympiadSide = i;
    }

    public int getOlympiadSide() {
        return this._olympiadSide;
    }

    public void setOlympiadGameId(int id) {
        this._olympiadGameId = id;
    }

    public int getOlympiadGameId() {
        return this._olympiadGameId;
    }

    public int getLastX() {
        return this._lastX;
    }

    public int getLastY() {
        return this._lastY;
    }

    public int getLastZ() {
        return this._lastZ;
    }

    public boolean inObserverMode() {
        return this._observerMode;
    }

    public int getTeleMode() {
        return this._telemode;
    }

    public void setTeleMode(int mode) {
        this._telemode = mode;
    }

    public void setLoto(int i, int val) {
        this._loto[i] = val;
    }

    public int getLoto(int i) {
        return this._loto[i];
    }

    public void setRace(int i, int val) {
        this._race[i] = val;
    }

    public int getRace(int i) {
        return this._race[i];
    }

    public boolean getMessageRefusal() {
        return this._messageRefusal;
    }

    public void setMessageRefusal(boolean mode) {
        this._messageRefusal = mode;
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public void setDietMode(boolean mode) {
        this._dietMode = mode;
    }

    public boolean getDietMode() {
        return this._dietMode;
    }

    public void setTradeRefusal(boolean mode) {
        this._tradeRefusal = mode;
    }

    public boolean getTradeRefusal() {
        return this._tradeRefusal;
    }

    public void setExchangeRefusal(boolean mode) {
        this._exchangeRefusal = mode;
    }

    public boolean getExchangeRefusal() {
        return this._exchangeRefusal;
    }

    public BlockList getBlockList() {
        return this._blockList;
    }

    public void setHero(boolean hero) {
        if (hero && this._baseClass == this._activeClass) {
            for (L2Skill s : HeroSkillTable.getHeroSkills()) {
                this.addSkill(s, false);
            }
        } else {
            for (L2Skill s : HeroSkillTable.getHeroSkills()) {
                super.removeSkill(s);
            }
        }
        this._hero = hero;
        this.sendSkillList();
    }

    private boolean isAuraItem(L2ItemInstance item) {
        return false;
    }

    public void checkAuraItemEquipped() {
        for (L2ItemInstance item : this.getInventory().getItems()) {
            if (item == null || !item.isEquipped() || !this.isAuraItem(item)) continue;
            this.aura = true;
            return;
        }
        this.aura = false;
    }

    public void setIsInOlympiadMode(boolean b) {
        this._inOlympiadMode = b;
    }

    public void setIsOlympiadStart(boolean b) {
        this._OlympiadStart = b;
    }

    public boolean isOlympiadStart() {
        return this._OlympiadStart;
    }

    public boolean isHero() {
        return this._hero;
    }

    public boolean isInOlympiadMode() {
        return this._inOlympiadMode;
    }

    public boolean isInDuel() {
        return this._isInDuel;
    }

    public int getDuelId() {
        return this._duelId;
    }

    public void setDuelState(int mode) {
        this._duelState = mode;
    }

    public int getDuelState() {
        return this._duelState;
    }

    public void setIsInDuel(int duelId) {
        if (duelId > 0) {
            this._isInDuel = true;
            this._duelState = 1;
            this._duelId = duelId;
        } else {
            if (this._duelState == 2) {
                this.enableAllSkills();
                this.getStatus().startHpMpRegeneration();
            }
            this._isInDuel = false;
            this._duelState = 0;
            this._duelId = 0;
        }
    }

    public SystemMessage getNoDuelReason() {
        SystemMessage sm = SystemMessage.getSystemMessage(this._noDuelReason);
        sm.addPcName(this);
        this._noDuelReason = SystemMessageId.THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL;
        return sm;
    }

    public boolean canDuel() {
        if (this.isInCombat() || this.getPunishLevel() == PunishLevel.JAIL) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_BATTLE;
            return false;
        }
        if (this.isDead() || this.isAlikeDead() || this.getCurrentHp() < (double)(this.getMaxHp() / 2) || this.getCurrentMp() < (double)(this.getMaxMp() / 2)) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_HP_OR_MP_IS_BELOW_50_PERCENT;
            return false;
        }
        if (this.isInDuel()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_ALREADY_ENGAGED_IN_A_DUEL;
            return false;
        }
        if (this.isInOlympiadMode()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_THE_OLYMPIAD;
            return false;
        }
        if (this.isCursedWeaponEquipped()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_IN_A_CHAOTIC_STATE;
            return false;
        }
        if (this.getPrivateStoreType() != 0) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_A_PRIVATE_STORE_OR_MANUFACTURE;
            return false;
        }
        if (this.isMounted() || this.isInBoat()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_RIDING_A_BOAT_WYVERN_OR_STRIDER;
            return false;
        }
        if (this.isFishing()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_FISHING;
            return false;
        }
        if (this.isInsideZone((byte)0) || this.isInsideZone((byte)1) || this.isInsideZone((byte)2)) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_MAKE_A_CHALLANGE_TO_A_DUEL_BECAUSE_C1_IS_CURRENTLY_IN_A_DUEL_PROHIBITED_AREA;
            return false;
        }
        return true;
    }

    public boolean isNoble() {
        return this._noble;
    }

    public void setNoble(boolean val) {
        if (val) {
            for (L2Skill s : NobleSkillTable.getInstance().getNobleSkills()) {
                this.addSkill(s, false);
            }
        } else {
            for (L2Skill s : NobleSkillTable.getInstance().getNobleSkills()) {
                super.removeSkill(s);
            }
        }
        this._noble = val;
        this.sendSkillList();
    }

    public void setLvlJoinedAcademy(int lvl) {
        this._lvlJoinedAcademy = lvl;
    }

    public int getLvlJoinedAcademy() {
        return this._lvlJoinedAcademy;
    }

    public boolean isAcademyMember() {
        return this._lvlJoinedAcademy > 0;
    }

    public void setTeam(int team) {
        this._team = team;
        if (this.getPet() != null) {
            this.getPet().broadcastStatusUpdate();
        }
    }

    public int getTeam() {
        return this._team;
    }

    public void setWantsPeace(int wantsPeace) {
        this._wantsPeace = wantsPeace;
    }

    public int getWantsPeace() {
        return this._wantsPeace;
    }

    public boolean isFishing() {
        return this._fishing;
    }

    public void setFishing(boolean fishing) {
        this._fishing = fishing;
    }

    public void setAllianceWithVarkaKetra(int sideAndLvlOfAlliance) {
        this._alliedVarkaKetra = sideAndLvlOfAlliance;
    }

    public int getAllianceWithVarkaKetra() {
        return this._alliedVarkaKetra;
    }

    public boolean isAlliedWithVarka() {
        return this._alliedVarkaKetra < 0;
    }

    public boolean isAlliedWithKetra() {
        return this._alliedVarkaKetra > 0;
    }

    public void sendSkillList() {
        this.sendSkillList(this);
    }

    public void sendSkillList(L2PcInstance player) {
        boolean isDisabled = false;
        SkillList sl = new SkillList();
        if (player != null) {
            for (L2Skill s : player.getAllSkills()) {
                boolean isEnchantable;
                if (s == null || s.getId() > 9000 && s.getId() < 9007 || this._transformation != null && !this.containsAllowedTransformSkill(s.getId()) && !s.allowOnTransform()) continue;
                if (player.getClan() != null) {
                    boolean bl = isDisabled = s.isClanSkill() && player.getClan().getReputationScore() < 0;
                }
                if (isEnchantable = SkillTable.getInstance().isEnchantable(s.getId())) {
                    L2EnchantSkillLearn esl = EnchantGroupsTable.getInstance().getSkillEnchantmentBySkillId(s.getId());
                    if (esl != null) {
                        if (s.getLevel() < esl.getBaseLevel()) {
                            isEnchantable = false;
                        }
                    } else {
                        isEnchantable = false;
                    }
                }
                sl.addSkill(s.getId(), s.getLevel(), s.isPassive(), isDisabled, isEnchantable);
            }
        }
        this.sendPacket(sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubClass(int classId, int classIndex) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        if (this.getTotalSubClasses() == Config.MAX_SUBCLASS || classIndex == 0) {
            boolean bl = false;
            return bl;
        }
        if (this.getSubClasses().containsKey(classIndex)) {
            boolean bl = false;
            return bl;
        }
        SubClass newClass = new SubClass();
        newClass.setClassId(classId);
        newClass.setClassIndex(classIndex);
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(ADD_CHAR_SUBCLASS);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, newClass.getClassId());
            statement.setLong(3, newClass.getExp());
            statement.setInt(4, newClass.getSp());
            statement.setInt(5, newClass.getLevel());
            statement.setInt(6, newClass.getClassIndex());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "WARNING: Could not add character sub class for " + this.getName() + ": " + e.getMessage(), e);
            boolean bl = false;
            this._subclassLock.unlock();
            return bl;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.getSubClasses().put(newClass.getClassIndex(), newClass);
        if (Config.DEBUG) {
            _log.info(this.getName() + " added class ID " + classId + " as a sub class at index " + classIndex + ".");
        }
        ClassId subTemplate = ClassId.values()[classId];
        FastMap<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(subTemplate);
        FastMap prevSkillList = new FastMap();
        for (L2SkillLearn skillInfo : skillTree.values()) {
            if (skillInfo.getGetLevel() > 40) continue;
            L2Skill prevSkill = (L2Skill)prevSkillList.get((Object)skillInfo.getSkillId());
            L2Skill newSkill = SkillTable.getInstance().getInfo(skillInfo.getSkillId(), skillInfo.getSkillLevel());
            if (prevSkill != null && prevSkill.getLevel() > newSkill.getLevel()) continue;
            prevSkillList.put((Object)newSkill.getId(), (Object)newSkill);
            this.storeSkill(newSkill, prevSkill, classIndex);
        }
        if (Config.DEBUG) {
            _log.info(this.getName() + " was given " + this.getAllSkills().length + " skills for their new sub class.");
        }
        boolean bl = true;
        return bl;
        finally {
            this._subclassLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifySubClass(int classIndex, int newClassId) {
        block12: {
            if (!this._subclassLock.tryLock()) {
                return false;
            }
            int oldClassId = this.getSubClasses().get(classIndex).getClassId();
            if (Config.DEBUG) {
                _log.info(this.getName() + " has requested to modify sub class index " + classIndex + " from class ID " + oldClassId + " to " + newClassId + ".");
            }
            Connection con = null;
            PreparedStatement statement = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(DELETE_CHAR_HENNAS);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, classIndex);
                statement.execute();
                statement.close();
                statement = con.prepareStatement(DELETE_CHAR_SHORTCUTS);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, classIndex);
                statement.execute();
                statement.close();
                statement = con.prepareStatement(DELETE_SKILL_SAVE);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, classIndex);
                statement.execute();
                statement.close();
                statement = con.prepareStatement(DELETE_CHAR_SKILLS);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, classIndex);
                statement.execute();
                statement.close();
                statement = con.prepareStatement(DELETE_CHAR_SUBCLASS);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, classIndex);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not modify sub class for " + this.getName() + " to class index " + classIndex + ": " + e.getMessage(), e);
                this.getSubClasses().remove(classIndex);
                boolean bl = false;
                this._subclassLock.unlock();
                return bl;
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            this.getSubClasses().remove(classIndex);
            break block12;
            finally {
                this._subclassLock.unlock();
            }
        }
        return this.addSubClass(newClassId, classIndex);
    }

    public boolean isSubClassActive() {
        return this._classIndex > 0;
    }

    public Map<Integer, SubClass> getSubClasses() {
        if (this._subClasses == null) {
            this._subClasses = new FastMap();
        }
        return this._subClasses;
    }

    public int getTotalSubClasses() {
        return this.getSubClasses().size();
    }

    public int getBaseClass() {
        return this._baseClass;
    }

    public int getActiveClass() {
        return this._activeClass;
    }

    public int getClassIndex() {
        return this._classIndex;
    }

    private void setClassTemplate(int classId) {
        this._activeClass = classId;
        L2PcTemplate t = CharTemplateTable.getInstance().getTemplate(classId, this.getAppearance().getSex());
        if (t == null) {
            _log.severe("Missing template for classId: " + classId);
            throw new Error();
        }
        this.setTemplate(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActiveClass(int classIndex) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            if (this._transformation != null) {
                boolean bl = false;
                return bl;
            }
            for (L2ItemInstance item : this.getInventory().getAugmentedItems()) {
                if (item == null || !item.isEquipped()) continue;
                item.getAugmentation().removeBonus(this);
            }
            this.abortCast();
            for (L2Character character : this.getKnownList().getKnownCharacters()) {
                if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != this) continue;
                character.abortCast();
            }
            this.store(Config.SUBCLASS_STORE_SKILL_COOLTIME);
            this._reuseTimeStamps.clear();
            this._charges.set(0);
            this.stopChargeTask();
            if (classIndex == 0) {
                this.setClassTemplate(this.getBaseClass());
            } else {
                try {
                    this.setClassTemplate(this.getSubClasses().get(classIndex).getClassId());
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Could not switch " + this.getName() + "'s sub class to class index " + classIndex + ": " + e.getMessage(), e);
                    boolean character = false;
                    this._subclassLock.unlock();
                    return character;
                }
            }
            this._classIndex = classIndex;
            if (this.isInParty()) {
                this.getParty().recalculatePartyLevel();
            }
            if (this.getPet() instanceof L2SummonInstance) {
                this.getPet().unSummon(this);
            }
            for (L2Skill oldSkill : this.getAllSkills()) {
                super.removeSkill(oldSkill);
            }
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
            this.stopCubics();
            this.restoreRecipeBook(false);
            this.restoreDeathPenaltyBuffLevel();
            this.restoreSkills();
            this.rewardSkills();
            this.regiveTemporarySkills();
            if (this._disabledSkills != null && !this._disabledSkills.isEmpty()) {
                this._disabledSkills.clear();
            }
            this.restoreEffects();
            this.updateEffectIcons();
            this.sendPacket(new EtcStatusUpdate(this));
            QuestState st = this.getQuestState("422_RepentYourSins");
            if (st != null) {
                st.exitQuest(true);
            }
            for (int i = 0; i < 3; ++i) {
                this._henna[i] = null;
            }
            this.restoreHenna();
            this.sendPacket(new HennaInfo(this));
            if (this.getCurrentHp() > (double)this.getMaxHp()) {
                this.setCurrentHp(this.getMaxHp());
            }
            if (this.getCurrentMp() > (double)this.getMaxMp()) {
                this.setCurrentMp(this.getMaxMp());
            }
            if (this.getCurrentCp() > (double)this.getMaxCp()) {
                this.setCurrentCp(this.getMaxCp());
            }
            this.refreshOverloaded();
            this.refreshExpertisePenalty();
            this.broadcastUserInfo();
            this.setExpBeforeDeath(0L);
            this._shortCuts.restore();
            this.sendPacket(new ShortCutInit(this));
            this.broadcastPacket(new SocialAction(this, 2122));
            this.sendPacket(new SkillCoolTime(this));
            this.sendPacket(new ExStorageMaxCount(this));
            boolean bl = true;
            return bl;
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    public boolean isLocked() {
        return this._subclassLock.isLocked();
    }

    public void stopWarnUserTakeBreak() {
        if (this._taskWarnUserTakeBreak != null) {
            this._taskWarnUserTakeBreak.cancel(true);
            this._taskWarnUserTakeBreak = null;
        }
    }

    public void startWarnUserTakeBreak() {
        if (this._taskWarnUserTakeBreak == null) {
            this._taskWarnUserTakeBreak = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new WarnUserTakeBreak(), 0x6DDD00L, 0x6DDD00L);
        }
    }

    public void stopRentPet() {
        if (this._taskRentPet != null) {
            if (this.checkLandingState() && this.getMountType() == 2) {
                this.teleToLocation(MapRegionTable.TeleportWhereType.Town);
            }
            if (this.dismount()) {
                this._taskRentPet.cancel(true);
                this._taskRentPet = null;
            }
        }
    }

    public void startRentPet(int seconds) {
        if (this._taskRentPet == null) {
            this._taskRentPet = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RentPetTask(), (long)seconds * 1000L, (long)seconds * 1000L);
        }
    }

    public boolean isRentedPet() {
        return this._taskRentPet != null;
    }

    public void stopWaterTask() {
        if (this._taskWater != null) {
            this._taskWater.cancel(false);
            this._taskWater = null;
            this.sendPacket(new SetupGauge(2, 0));
        }
    }

    public void startWaterTask() {
        if (!this.isDead() && this._taskWater == null) {
            int timeinwater = (int)this.calcStat(Stats.BREATH, 60000.0, this, null);
            this.sendPacket(new SetupGauge(2, timeinwater));
            this._taskWater = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new WaterTask(), timeinwater, 1000L);
        }
    }

    public boolean isInWater() {
        return this._taskWater != null;
    }

    public void checkWaterState() {
        if (this.isInsideZone((byte)7)) {
            this.startWaterTask();
        } else {
            this.stopWaterTask();
        }
    }

    public void onPlayerEnter() {
        this.startWarnUserTakeBreak();
        if (SevenSigns.getInstance().isSealValidationPeriod() || SevenSigns.getInstance().isCompResultsPeriod()) {
            if (!this.isGM() && this.isIn7sDungeon() && SevenSigns.getInstance().getPlayerCabal(this.getObjectId()) != SevenSigns.getInstance().getCabalHighestScore()) {
                this.teleToLocation(MapRegionTable.TeleportWhereType.Town);
                this.setIsIn7sDungeon(false);
                this.sendMessage("You have been teleported to the nearest town due to the beginning of the Seal Validation period.");
            }
        } else if (!this.isGM() && this.isIn7sDungeon() && SevenSigns.getInstance().getPlayerCabal(this.getObjectId()) == 0) {
            this.teleToLocation(MapRegionTable.TeleportWhereType.Town);
            this.setIsIn7sDungeon(false);
            this.sendMessage("You have been teleported to the nearest town because you have not signed for any cabal.");
        }
        this.updatePunishState();
        if (this.isGM()) {
            if (this.isInvul()) {
                this.sendMessage("Entering world in Invulnerable mode.");
            }
            if (this.getAppearance().getInvisible()) {
                this.sendMessage("Entering world in Invisible mode.");
            }
            if (this.isSilenceMode()) {
                this.sendMessage("Entering world in Silence mode.");
            }
        }
        this.revalidateZone(true);
        this.notifyFriends();
        if (!this.isGM() && Config.DECREASE_SKILL_LEVEL) {
            this.checkPlayerSkills();
        }
        if (Config.CACHE_CHAR_NAMES) {
            CharNameTable.getInstance().addName(this);
        }
    }

    public long getLastAccess() {
        return this._lastAccess;
    }

    @Override
    public void doRevive() {
        super.doRevive();
        this.stopEffects(L2EffectType.CHARMOFCOURAGE);
        this.updateEffectIcons();
        this.sendPacket(new EtcStatusUpdate(this));
        this._reviveRequested = 0;
        this._revivePower = 0.0;
        if (this.isMounted()) {
            this.startFeed(this._mountNpcId);
        }
        if (this.isInParty() && this.getParty().isInDimensionalRift() && !DimensionalRiftManager.getInstance().checkIfInPeaceZone(this.getX(), this.getY(), this.getZ())) {
            this.getParty().getDimensionalRift().memberRessurected(this);
        }
    }

    @Override
    public void doRevive(double revivePower) {
        this.restoreExp(revivePower);
        this.doRevive();
    }

    public void reviveRequest(L2PcInstance Reviver, L2Skill skill, boolean Pet) {
        if (this.isResurrectionBlocked()) {
            return;
        }
        if (this._reviveRequested == 1) {
            if (this._revivePet == Pet) {
                Reviver.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED));
            } else if (Pet) {
                Reviver.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_RES_PET2));
            } else {
                Reviver.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.MASTER_CANNOT_RES));
            }
            return;
        }
        if (Pet && this.getPet() != null && this.getPet().isDead() || !Pet && this.isDead()) {
            this._reviveRequested = 1;
            int restoreExp = 0;
            this._revivePower = this.isPhoenixBlessed() ? 100.0 : (this.isAffected(1) ? 0.0 : Formulas.calculateSkillResurrectRestorePercent(skill.getPower(), Reviver));
            restoreExp = (int)Math.round((double)(this.getExpBeforeDeath() - this.getExp()) * this._revivePower / 100.0);
            this._revivePet = Pet;
            if (this.isAffected(1)) {
                ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.RESURRECT_USING_CHARM_OF_COURAGE.getId());
                dlg.addTime(60000);
                this.sendPacket(dlg);
                return;
            }
            ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.RESSURECTION_REQUEST_BY_C1_FOR_S2_XP.getId());
            dlg.addPcName(Reviver);
            dlg.addString(String.valueOf(restoreExp));
            this.sendPacket(dlg);
        }
    }

    public void reviveAnswer(int answer) {
        if (this._reviveRequested != 1 || !this.isDead() && !this._revivePet || this._revivePet && this.getPet() != null && !this.getPet().isDead()) {
            return;
        }
        if (answer == 0 && this.isPhoenixBlessed()) {
            this.stopPhoenixBlessing(null);
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        if (answer == 1) {
            if (!this._revivePet) {
                if (this._revivePower != 0.0) {
                    this.doRevive(this._revivePower);
                } else {
                    this.doRevive();
                }
            } else if (this.getPet() != null) {
                if (this._revivePower != 0.0) {
                    this.getPet().doRevive(this._revivePower);
                } else {
                    this.getPet().doRevive();
                }
            }
        }
        this._reviveRequested = 0;
        this._revivePower = 0.0;
    }

    public boolean isReviveRequested() {
        return this._reviveRequested == 1;
    }

    public boolean isRevivingPet() {
        return this._revivePet;
    }

    public void removeReviving() {
        this._reviveRequested = 0;
        this._revivePower = 0.0;
    }

    public void onActionRequest() {
        if (this.isSpawnProtected()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NO_LONGER_PROTECTED_FROM_AGGRESSIVE_MONSTERS));
        }
        if (this.isTeleportProtected()) {
            this.sendMessage("Teleport spawn protection ended.");
        }
        this.setProtection(false);
        this.setTeleportProtection(false);
    }

    public int getExpertiseLevel() {
        int level = this.getSkillLevel(239);
        if (level < 0) {
            level = 0;
        }
        return level;
    }

    @Override
    public void teleToLocation(int x, int y, int z, int heading, boolean allowRandomOffset) {
        if (this.getVehicle() != null && !this.getVehicle().isTeleporting()) {
            this.setVehicle(null);
        }
        if (this.isFlyingMounted() && z < -1005) {
            z = -1005;
        }
        super.teleToLocation(x, y, z, heading, allowRandomOffset);
    }

    @Override
    public final void onTeleported() {
        L2Summon pet;
        super.onTeleported();
        if (this.isInAirShip()) {
            this.getAirShip().sendInfo(this);
        }
        this.revalidateZone(true);
        this.checkItemRestriction();
        if (Config.PLAYER_TELEPORT_PROTECTION > 0 && !this.isInOlympiadMode()) {
            this.setTeleportProtection(true);
        }
        if (this.getTrainedBeasts() != null) {
            for (L2TamedBeastInstance tamedBeast : this.getTrainedBeasts()) {
                tamedBeast.deleteMe();
            }
            this.getTrainedBeasts().clear();
        }
        if ((pet = this.getPet()) != null) {
            pet.setFollowStatus(false);
            pet.teleToLocation(this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ(), false);
            ((L2SummonAI)pet.getAI()).setStartFollowController(true);
            pet.setFollowStatus(true);
            pet.updateAndBroadcastStatus(0);
        }
        TvTEvent.onTeleported(this);
    }

    @Override
    public void setIsTeleporting(boolean teleport) {
        this.setIsTeleporting(teleport, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsTeleporting(boolean teleport, boolean useWatchDog) {
        super.setIsTeleporting(teleport);
        if (!useWatchDog) {
            return;
        }
        if (teleport) {
            if (this._teleportWatchdog == null && Config.TELEPORT_WATCHDOG_TIMEOUT > 0) {
                L2PcInstance l2PcInstance = this;
                synchronized (l2PcInstance) {
                    if (this._teleportWatchdog == null) {
                        this._teleportWatchdog = ThreadPoolManager.getInstance().scheduleGeneral(new TeleportWatchdog(), Config.TELEPORT_WATCHDOG_TIMEOUT * 1000);
                    }
                }
            }
        } else if (this._teleportWatchdog != null) {
            this._teleportWatchdog.cancel(false);
            this._teleportWatchdog = null;
        }
    }

    public void setLastServerPosition(int x, int y, int z) {
        this._lastServerPosition.setXYZ(x, y, z);
    }

    public Point3D getLastServerPosition() {
        return this._lastServerPosition;
    }

    public boolean checkLastServerPosition(int x, int y, int z) {
        return this._lastServerPosition.equals(x, y, z);
    }

    public int getLastServerDistance(int x, int y, int z) {
        double dx = x - this._lastServerPosition.getX();
        double dy = y - this._lastServerPosition.getY();
        double dz = z - this._lastServerPosition.getZ();
        return (int)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public void addExpAndSp(long addToExp, int addToSp) {
        this.getStat().addExpAndSp(addToExp, addToSp, false);
    }

    public void addExpAndSp(long addToExp, int addToSp, boolean useVitality) {
        if (!this._expGainOn) {
            return;
        }
        int experienceMaxLevel = this.getLevel() + Config.LIMIT_LEVEL_STEPUP;
        if (experienceMaxLevel <= 86) {
            addToExp = Math.min(addToExp, Experience.LEVEL[experienceMaxLevel] - Experience.LEVEL[this.getLevel()]);
        }
        this.getStat().addExpAndSp(addToExp, addToSp, useVitality);
    }

    public void removeExpAndSp(long removeExp, int removeSp) {
        this.getStat().removeExpAndSp(removeExp, removeSp, true);
    }

    public void removeExpAndSp(long removeExp, int removeSp, boolean sendMessage) {
        this.getStat().removeExpAndSp(removeExp, removeSp, sendMessage);
    }

    @Override
    public void reduceCurrentHp(double value, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (skill != null) {
            this.getStatus().reduceHp(value, attacker, awake, isDOT, skill.isToggle(), skill.getDmgDirectlyToHP());
        } else {
            this.getStatus().reduceHp(value, attacker, awake, isDOT, false, false);
        }
        if (this.getTrainedBeasts() != null) {
            for (L2TamedBeastInstance tamedBeast : this.getTrainedBeasts()) {
                tamedBeast.onOwnerGotAttacked(attacker);
            }
        }
    }

    public void broadcastSnoop(int type, String name, String _text) {
        if (!this._snoopListener.isEmpty()) {
            Snoop sn = new Snoop(this.getObjectId(), this.getName(), type, name, _text);
            for (L2PcInstance pci : this._snoopListener) {
                if (pci == null) continue;
                pci.sendPacket(sn);
            }
        }
    }

    public void addSnooper(L2PcInstance pci) {
        if (!this._snoopListener.contains(pci)) {
            this._snoopListener.add(pci);
        }
    }

    public void removeSnooper(L2PcInstance pci) {
        this._snoopListener.remove(pci);
    }

    public void addSnooped(L2PcInstance pci) {
        if (!this._snoopedPlayer.contains(pci)) {
            this._snoopedPlayer.add(pci);
        }
    }

    public void removeSnooped(L2PcInstance pci) {
        this._snoopedPlayer.remove(pci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBypass(String bypass) {
        if (bypass == null) {
            return;
        }
        List<String> list = this._validBypass;
        synchronized (list) {
            this._validBypass.add(bypass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBypass2(String bypass) {
        if (bypass == null) {
            return;
        }
        List<String> list = this._validBypass2;
        synchronized (list) {
            this._validBypass2.add(bypass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateBypass(String cmd) {
        if (!Config.BYPASS_VALIDATION) {
            return true;
        }
        List<String> list = this._validBypass;
        synchronized (list) {
            for (String bp : this._validBypass) {
                if (bp == null || !bp.equals(cmd)) continue;
                return true;
            }
        }
        list = this._validBypass2;
        synchronized (list) {
            for (String bp : this._validBypass2) {
                if (bp == null || !cmd.startsWith(bp)) continue;
                return true;
            }
        }
        _log.warning("[L2PcInstance] player [" + this.getName() + "] sent invalid bypass '" + cmd + "'.");
        return false;
    }

    public boolean validateItemManipulation(int objectId, String action) {
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null || item.getOwnerId() != this.getObjectId()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item he is not owner of");
            return false;
        }
        if (this.getPet() != null && this.getPet().getControlObjectId() == objectId || this.getMountObjectID() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ": player tried to " + action + " item controling pet");
            }
            return false;
        }
        if (this.getActiveEnchantItem() != null && this.getActiveEnchantItem().getObjectId() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ":player tried to " + action + " an enchant scroll he was using");
            }
            return false;
        }
        return !CursedWeaponsManager.getInstance().isCursed(item.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBypass() {
        List<String> list = this._validBypass;
        synchronized (list) {
            this._validBypass.clear();
        }
        list = this._validBypass2;
        synchronized (list) {
            this._validBypass2.clear();
        }
    }

    public boolean isInBoat() {
        return this._vehicle != null && this._vehicle.isBoat();
    }

    public L2BoatInstance getBoat() {
        return (L2BoatInstance)this._vehicle;
    }

    public boolean isInAirShip() {
        return this._vehicle != null && this._vehicle.isAirShip();
    }

    public L2AirShipInstance getAirShip() {
        return (L2AirShipInstance)this._vehicle;
    }

    public L2Vehicle getVehicle() {
        return this._vehicle;
    }

    public void setVehicle(L2Vehicle v) {
        if (v == null && this._vehicle != null) {
            this._vehicle.removePassenger(this);
        }
        this._vehicle = v;
    }

    public void setInCrystallize(boolean inCrystallize) {
        this._inCrystallize = inCrystallize;
    }

    public boolean isInCrystallize() {
        return this._inCrystallize;
    }

    public Point3D getInVehiclePosition() {
        return this._inVehiclePosition;
    }

    public void setInVehiclePosition(Point3D pt) {
        this._inVehiclePosition = pt;
    }

    @Override
    public void deleteMe() {
        this.cleanup();
        this.store();
        super.deleteMe();
    }

    private synchronized void cleanup() {
        try {
            if (!this.isOnline()) {
                _log.log(Level.SEVERE, "deleteMe() called on offline character " + this, new RuntimeException());
            }
            this.setOnlineStatus(false, true);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (Config.ENABLE_BLOCK_CHECKER_EVENT && this.getBlockCheckerArena() != -1) {
                HandysBlockCheckerManager.getInstance().onDisconnect(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this._isOnline = false;
            this.abortAttack();
            this.abortCast();
            this.stopMove(null);
            this.setDebug(null);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (this.getInventory().getItemByItemId(9819) != null) {
                Fort fort = FortManager.getInstance().getFort(this);
                if (fort != null) {
                    FortSiegeManager.getInstance().dropCombatFlag(this, fort.getFortId());
                } else {
                    int slot = this.getInventory().getSlotFromItem(this.getInventory().getItemByItemId(9819));
                    this.getInventory().unEquipItemInBodySlot(slot);
                    this.destroyItem("CombatFlag", this.getInventory().getItemByItemId(9819), null, true);
                }
            } else if (this.isCombatFlagEquipped()) {
                TerritoryWarManager.getInstance().dropCombatFlag(this, false, false);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            PartyMatchRoom room;
            PartyMatchWaitingList.getInstance().removePlayer(this);
            if (this._partyroom != 0 && (room = PartyMatchRoomList.getInstance().getRoom(this._partyroom)) != null) {
                room.deleteMember(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (this.isFlying()) {
                this.removeSkill(SkillTable.getInstance().getInfo(4289, 1));
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            CommunityServerThread.getInstance().sendPacket(new WorldInfo(this, null, 2));
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.storeRecommendations();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.stopAllTimers();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.setIsTeleporting(false);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            RecipeController.getInstance().requestMakeItemAbort(this);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.setTarget(null);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (this._fusionSkill != null) {
                this.abortCast();
            }
            for (L2Character character : this.getKnownList().getKnownCharacters()) {
                if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != this) continue;
                character.abortCast();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            for (L2Effect effect : this.getAllEffects()) {
                if (effect.getSkill().isToggle()) {
                    effect.exit();
                    continue;
                }
                switch (effect.getEffectType()) {
                    case SIGNET_GROUND: 
                    case SIGNET_EFFECT: {
                        effect.exit();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        L2WorldRegion oldRegion = this.getWorldRegion();
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.decayMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.isInParty()) {
            try {
                this.leaveParty();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        if (OlympiadManager.getInstance().isRegistered(this) || this.getOlympiadGameId() != -1) {
            OlympiadManager.getInstance().removeDisconnectedCompetitor(this);
        }
        if (this.getPet() != null) {
            try {
                this.getPet().unSummon(this);
                if (this.getPet() != null) {
                    this.getPet().broadcastNpcInfo(0);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        if (this.getClan() != null) {
            try {
                L2ClanMember clanMember = this.getClan().getClanMember(this.getObjectId());
                if (clanMember != null) {
                    clanMember.setPlayerInstance(null);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        if (this.getActiveRequester() != null) {
            this.setActiveRequester(null);
            this.cancelActiveTrade();
        }
        if (this.getL2AccessLevel().isGm()) {
            try {
                GmListTable.getInstance().deleteGm(this);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        try {
            if (this.inObserverMode()) {
                this.setXYZInvisible(this._lastX, this._lastY, this._lastZ);
            }
            if (this.getVehicle() != null) {
                this.getVehicle().oustPlayer(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            Instance inst;
            int instanceId = this.getInstanceId();
            if (instanceId != 0 && !Config.RESTORE_PLAYER_INSTANCE && (inst = InstanceManager.getInstance().getInstance(instanceId)) != null) {
                inst.removePlayer(this.getObjectId());
                int[] spawn = inst.getSpawnLoc();
                if (spawn[0] != 0 && spawn[1] != 0 && spawn[2] != 0) {
                    int x = spawn[0] + Rnd.get(-30, 30);
                    int y = spawn[1] + Rnd.get(-30, 30);
                    this.setXYZInvisible(x, y, spawn[2]);
                    if (this.getPet() != null) {
                        this.getPet().teleToLocation(x, y, spawn[2]);
                        this.getPet().setInstanceId(0);
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            TvTEvent.onLogout(this);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.getInventory().deleteMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.clearWarehouse();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (Config.WAREHOUSE_CACHE) {
            WarehouseCacheManager.getInstance().remCacheTask(this);
        }
        try {
            this.clearRefund();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.isCursedWeaponEquipped()) {
            try {
                CursedWeaponsManager.getInstance().getCursedWeapon(this._cursedWeaponEquippedId).setPlayer(null);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.getClanId() > 0) {
            this.getClan().broadcastToOtherOnlineMembers(new PledgeShowMemberListUpdate(this), this);
        }
        for (L2PcInstance player : this._snoopedPlayer) {
            player.removeSnooper(this);
        }
        for (L2PcInstance player : this._snoopListener) {
            player.removeSnooped(this);
        }
        L2World.getInstance().removeObject(this);
        L2World.getInstance().removeFromAllPlayers(this);
        try {
            RegionBBSManager.getInstance().changeCommunityBoard();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on deleteMe() changeCommunityBoard: " + e.getMessage(), e);
        }
        try {
            this.notifyFriends();
            this.getBlockList().playerLogout();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on deleteMe() notifyFriends: " + e.getMessage(), e);
        }
    }

    public void startFishing(int _x, int _y, int _z) {
        this.stopMove(null);
        this.setIsImmobilized(true);
        this._fishing = true;
        this._fishx = _x;
        this._fishy = _y;
        this._fishz = _z;
        int lvl = this.GetRandomFishLvl();
        int group = this.GetRandomGroup();
        int type = this.GetRandomFishType(group);
        List<FishData> fishs = FishTable.getInstance().getfish(lvl, type, group);
        if (fishs == null || fishs.isEmpty()) {
            this.sendMessage("Error - Fishes are not definied");
            this.endFishing(false);
            return;
        }
        int check = Rnd.get(fishs.size());
        this._fish = new FishData(fishs.get(check));
        fishs.clear();
        fishs = null;
        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CAST_LINE_AND_START_FISHING));
        if (!GameTimeController.getInstance().isNowNight() && this._lure.isNightLure()) {
            this._fish.setType(-1);
        }
        this.broadcastPacket(new ExFishingStart(this, this._fish.getType(), _x, _y, _z, this._lure.isNightLure()));
        this.sendPacket(new PlaySound(1, "SF_P_01", 0, 0, 0, 0, 0));
        this.startLookingForFishTask();
    }

    public void stopLookingForFishTask() {
        if (this._taskforfish != null) {
            this._taskforfish.cancel(false);
            this._taskforfish = null;
        }
    }

    public void startLookingForFishTask() {
        if (!this.isDead() && this._taskforfish == null) {
            int checkDelay = 0;
            boolean isNoob = false;
            boolean isUpperGrade = false;
            if (this._lure != null) {
                int lureid = this._lure.getItemId();
                isNoob = this._fish.getGroup() == 0;
                boolean bl = isUpperGrade = this._fish.getGroup() == 2;
                if (lureid == 6519 || lureid == 6522 || lureid == 6525 || lureid == 8505 || lureid == 8508 || lureid == 8511) {
                    checkDelay = Math.round((float)((double)this._fish.getGutsCheckTime() * 1.33));
                } else if (lureid == 6520 || lureid == 6523 || lureid == 6526 || lureid >= 8505 && lureid <= 8513 || lureid >= 7610 && lureid <= 7613 || lureid >= 7807 && lureid <= 7809 || lureid >= 8484 && lureid <= 8486) {
                    checkDelay = Math.round((float)((double)this._fish.getGutsCheckTime() * 1.0));
                } else if (lureid == 6521 || lureid == 6524 || lureid == 6527 || lureid == 8507 || lureid == 8510 || lureid == 8513) {
                    checkDelay = Math.round((float)((double)this._fish.getGutsCheckTime() * 0.66));
                }
            }
            this._taskforfish = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new LookingForFishTask(this._fish.getWaitTime(), this._fish.getFishGuts(), this._fish.getType(), isNoob, isUpperGrade), 10000L, checkDelay);
        }
    }

    private int GetRandomGroup() {
        switch (this._lure.getItemId()) {
            case 7807: 
            case 7808: 
            case 7809: 
            case 8486: {
                return 0;
            }
            case 8485: 
            case 8506: 
            case 8509: 
            case 8512: {
                return 2;
            }
        }
        return 1;
    }

    private int GetRandomFishType(int group) {
        int check = Rnd.get(100);
        int type = 1;
        block0 : switch (group) {
            case 0: {
                switch (this._lure.getItemId()) {
                    case 7807: {
                        if (check <= 54) {
                            type = 5;
                            break;
                        }
                        if (check <= 77) {
                            type = 4;
                            break;
                        }
                        type = 6;
                        break;
                    }
                    case 7808: {
                        if (check <= 54) {
                            type = 4;
                            break;
                        }
                        if (check <= 77) {
                            type = 6;
                            break;
                        }
                        type = 5;
                        break;
                    }
                    case 7809: {
                        if (check <= 54) {
                            type = 6;
                            break;
                        }
                        if (check <= 77) {
                            type = 5;
                            break;
                        }
                        type = 4;
                        break;
                    }
                    case 8486: {
                        type = check <= 33 ? 4 : (check <= 66 ? 5 : 6);
                    }
                }
                break;
            }
            case 1: {
                switch (this._lure.getItemId()) {
                    case 7610: 
                    case 7611: 
                    case 7612: 
                    case 7613: {
                        type = 3;
                        break;
                    }
                    case 6519: 
                    case 6520: 
                    case 6521: 
                    case 8505: 
                    case 8507: {
                        if (check <= 54) {
                            type = 1;
                            break;
                        }
                        if (check <= 74) {
                            type = 0;
                            break;
                        }
                        if (check <= 94) {
                            type = 2;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6522: 
                    case 6523: 
                    case 6524: 
                    case 8508: 
                    case 8510: {
                        if (check <= 54) {
                            type = 0;
                            break;
                        }
                        if (check <= 74) {
                            type = 1;
                            break;
                        }
                        if (check <= 94) {
                            type = 2;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6525: 
                    case 6526: 
                    case 6527: 
                    case 8511: 
                    case 8513: {
                        if (check <= 55) {
                            type = 2;
                            break;
                        }
                        if (check <= 74) {
                            type = 1;
                            break;
                        }
                        if (check <= 94) {
                            type = 0;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 8484: {
                        type = check <= 33 ? 0 : (check <= 66 ? 1 : 2);
                    }
                }
                break;
            }
            case 2: {
                switch (this._lure.getItemId()) {
                    case 8506: {
                        if (check <= 54) {
                            type = 8;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 7;
                            break block0;
                        }
                        type = 9;
                        break block0;
                    }
                    case 8509: {
                        if (check <= 54) {
                            type = 7;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 9;
                            break block0;
                        }
                        type = 8;
                        break block0;
                    }
                    case 8512: {
                        if (check <= 54) {
                            type = 9;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 8;
                            break block0;
                        }
                        type = 7;
                        break block0;
                    }
                    case 8485: {
                        type = check <= 33 ? 7 : (check <= 66 ? 8 : 9);
                    }
                }
            }
        }
        return type;
    }

    private int GetRandomFishLvl() {
        int randomlvl;
        int skilllvl = this.getSkillLevel(1315);
        L2Effect e = this.getFirstEffect(2274);
        if (e != null) {
            skilllvl = (int)e.getSkill().getPower();
        }
        if (skilllvl <= 0) {
            return 1;
        }
        int check = Rnd.get(100);
        if (check <= 50) {
            randomlvl = skilllvl;
        } else if (check <= 85) {
            randomlvl = skilllvl - 1;
            if (randomlvl <= 0) {
                randomlvl = 1;
            }
        } else {
            randomlvl = skilllvl + 1;
            if (randomlvl > 27) {
                randomlvl = 27;
            }
        }
        return randomlvl;
    }

    public void startFishCombat(boolean isNoob, boolean isUpperGrade) {
        this._fishCombat = new L2Fishing(this, this._fish, isNoob, isUpperGrade);
    }

    public void endFishing(boolean win) {
        this._fishing = false;
        this._fishx = 0;
        this._fishy = 0;
        this._fishz = 0;
        if (this._fishCombat == null) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.BAIT_LOST_FISH_GOT_AWAY));
        }
        this._fishCombat = null;
        this._lure = null;
        this.broadcastPacket(new ExFishingEnd(win, this));
        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.REEL_LINE_AND_STOP_FISHING));
        this.setIsImmobilized(false);
        this.stopLookingForFishTask();
    }

    public L2Fishing getFishCombat() {
        return this._fishCombat;
    }

    public int getFishx() {
        return this._fishx;
    }

    public int getFishy() {
        return this._fishy;
    }

    public int getFishz() {
        return this._fishz;
    }

    public void setLure(L2ItemInstance lure) {
        this._lure = lure;
    }

    public L2ItemInstance getLure() {
        return this._lure;
    }

    public int getInventoryLimit() {
        int ivlim = this.isGM() ? Config.INVENTORY_MAXIMUM_GM : (this.getRace() == Race.Dwarf ? Config.INVENTORY_MAXIMUM_DWARF : Config.INVENTORY_MAXIMUM_NO_DWARF);
        return ivlim += (int)this.getStat().calcStat(Stats.INV_LIM, 0.0, null, null);
    }

    public int getWareHouseLimit() {
        int whlim = this.getRace() == Race.Dwarf ? Config.WAREHOUSE_SLOTS_DWARF : Config.WAREHOUSE_SLOTS_NO_DWARF;
        return whlim += (int)this.getStat().calcStat(Stats.WH_LIM, 0.0, null, null);
    }

    public int getPrivateSellStoreLimit() {
        int pslim = this.getRace() == Race.Dwarf ? Config.MAX_PVTSTORESELL_SLOTS_DWARF : Config.MAX_PVTSTORESELL_SLOTS_OTHER;
        return pslim += (int)this.getStat().calcStat(Stats.P_SELL_LIM, 0.0, null, null);
    }

    public int getPrivateBuyStoreLimit() {
        int pblim = this.getRace() == Race.Dwarf ? Config.MAX_PVTSTOREBUY_SLOTS_DWARF : Config.MAX_PVTSTOREBUY_SLOTS_OTHER;
        return pblim += (int)this.getStat().calcStat(Stats.P_BUY_LIM, 0.0, null, null);
    }

    public int getDwarfRecipeLimit() {
        int recdlim = Config.DWARF_RECIPE_LIMIT;
        return recdlim += (int)this.getStat().calcStat(Stats.REC_D_LIM, 0.0, null, null);
    }

    public int getCommonRecipeLimit() {
        int recclim = Config.COMMON_RECIPE_LIMIT;
        return recclim += (int)this.getStat().calcStat(Stats.REC_C_LIM, 0.0, null, null);
    }

    public int getMountNpcId() {
        return this._mountNpcId;
    }

    public int getMountLevel() {
        return this._mountLevel;
    }

    public void setMountObjectID(int newID) {
        this._mountObjectID = newID;
    }

    public int getMountObjectID() {
        return this._mountObjectID;
    }

    public SkillDat getCurrentSkill() {
        return this._currentSkill;
    }

    public void setCurrentSkill(L2Skill currentSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (currentSkill == null) {
            if (Config.DEBUG) {
                _log.info("Setting current skill: NULL for " + this.getName() + ".");
            }
            this._currentSkill = null;
            return;
        }
        if (Config.DEBUG) {
            _log.info("Setting current skill: " + currentSkill.getName() + " (ID: " + currentSkill.getId() + ") for " + this.getName() + ".");
        }
        this._currentSkill = new SkillDat(currentSkill, ctrlPressed, shiftPressed);
    }

    public SkillDat getCurrentPetSkill() {
        return this._currentPetSkill;
    }

    public void setCurrentPetSkill(L2Skill currentSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (currentSkill == null) {
            if (Config.DEBUG) {
                _log.info("Setting current pet skill: NULL for " + this.getName() + ".");
            }
            this._currentPetSkill = null;
            return;
        }
        if (Config.DEBUG) {
            _log.info("Setting current Pet skill: " + currentSkill.getName() + " (ID: " + currentSkill.getId() + ") for " + this.getName() + ".");
        }
        this._currentPetSkill = new SkillDat(currentSkill, ctrlPressed, shiftPressed);
    }

    public SkillDat getQueuedSkill() {
        return this._queuedSkill;
    }

    public void setQueuedSkill(L2Skill queuedSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (queuedSkill == null) {
            if (Config.DEBUG) {
                _log.info("Setting queued skill: NULL for " + this.getName() + ".");
            }
            this._queuedSkill = null;
            return;
        }
        if (Config.DEBUG) {
            _log.info("Setting queued skill: " + queuedSkill.getName() + " (ID: " + queuedSkill.getId() + ") for " + this.getName() + ".");
        }
        this._queuedSkill = new SkillDat(queuedSkill, ctrlPressed, shiftPressed);
    }

    public PunishLevel getPunishLevel() {
        return this._punishLevel;
    }

    public boolean isInJail() {
        return this._punishLevel == PunishLevel.JAIL;
    }

    public boolean isChatBanned() {
        return this._punishLevel == PunishLevel.CHAT;
    }

    public void setPunishLevel(int state) {
        switch (state) {
            case 0: {
                this._punishLevel = PunishLevel.NONE;
                break;
            }
            case 1: {
                this._punishLevel = PunishLevel.CHAT;
                break;
            }
            case 2: {
                this._punishLevel = PunishLevel.JAIL;
                break;
            }
            case 3: {
                this._punishLevel = PunishLevel.CHAR;
                break;
            }
            case 4: {
                this._punishLevel = PunishLevel.ACC;
            }
        }
    }

    public void setPunishLevel(PunishLevel state, int delayInMinutes) {
        long delayInMilliseconds = (long)delayInMinutes * 60000L;
        block0 : switch (state) {
            case NONE: {
                switch (this._punishLevel) {
                    case CHAT: {
                        this._punishLevel = state;
                        this.stopPunishTask(true);
                        this.sendPacket(new EtcStatusUpdate(this));
                        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CHATBAN_REMOVED));
                        break block0;
                    }
                    case JAIL: {
                        this._punishLevel = state;
                        NpcHtmlMessage htmlMsg = new NpcHtmlMessage(0);
                        String jailInfos = HtmCache.getInstance().getHtm(this.getHtmlPrefix(), "data/html/jail_out.htm");
                        if (jailInfos != null) {
                            htmlMsg.setHtml(jailInfos);
                        } else {
                            htmlMsg.setHtml("<html><body>You are free for now, respect server rules!</body></html>");
                        }
                        this.sendPacket(htmlMsg);
                        this.stopPunishTask(true);
                        this.teleToLocation(17836, 170178, -3507, true);
                        break block0;
                    }
                }
                break;
            }
            case CHAT: {
                if (this._punishLevel == PunishLevel.JAIL) break;
                this._punishLevel = state;
                this._punishTimer = 0L;
                this.sendPacket(new EtcStatusUpdate(this));
                this.stopPunishTask(false);
                if (delayInMinutes > 0) {
                    this._punishTimer = delayInMilliseconds;
                    this._punishTask = ThreadPoolManager.getInstance().scheduleGeneral(new PunishTask(), this._punishTimer);
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CHATTING_PROHIBITED));
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CHAT_AVAILABLE_S1_MINUTE).addNumber(delayInMinutes));
                    break;
                }
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CHATTING_PROHIBITED));
                break;
            }
            case JAIL: {
                this._punishLevel = state;
                this._punishTimer = 0L;
                this.stopPunishTask(false);
                if (delayInMinutes > 0) {
                    this._punishTimer = delayInMilliseconds;
                    this._punishTask = ThreadPoolManager.getInstance().scheduleGeneral(new PunishTask(), this._punishTimer);
                    this.sendMessage(delayInMinutes + "\u5206\u9593GM\u76f8\u8ac7\u6240\u306b\u53ce\u5bb9\u3055\u308c\u307e\u3059\u3002");
                }
                if (!TvTEvent.isInactive() && TvTEvent.isPlayerParticipant(this.getObjectId())) {
                    TvTEvent.removeParticipant(this.getObjectId());
                }
                if (OlympiadManager.getInstance().isRegisteredInComp(this)) {
                    OlympiadManager.getInstance().removeDisconnectedCompetitor(this);
                }
                NpcHtmlMessage htmlMsg = new NpcHtmlMessage(0);
                String jailInfos = HtmCache.getInstance().getHtm(this.getHtmlPrefix(), "data/html/jail_in.htm");
                if (jailInfos != null) {
                    htmlMsg.setHtml(jailInfos);
                } else {
                    htmlMsg.setHtml("<html><body>GM\u76f8\u8ac7\u6240\u306b\u53ce\u5bb9\u3055\u308c\u3066\u3044\u307e\u3059\u3002</body></html>");
                }
                this.sendPacket(htmlMsg);
                this.setInstanceId(0);
                this.setIsIn7sDungeon(false);
                this.teleToLocation(-114356, -249645, -2984, false);
                break;
            }
            case CHAR: {
                this.setAccessLevel(-100);
                this.logout();
                break;
            }
            case ACC: {
                this.setAccountAccesslevel(-100);
                this.logout();
                break;
            }
            default: {
                this._punishLevel = state;
            }
        }
        this.storeCharBase();
    }

    public long getPunishTimer() {
        return this._punishTimer;
    }

    public void setPunishTimer(long time) {
        this._punishTimer = time;
    }

    private void updatePunishState() {
        if (this.getPunishLevel() != PunishLevel.NONE) {
            if (this._punishTimer > 0L) {
                this._punishTask = ThreadPoolManager.getInstance().scheduleGeneral(new PunishTask(), this._punishTimer);
                this.sendMessage(Math.round(this._punishTimer / 60000L) + "\u5206\u9593\u306e" + this.getPunishLevel().string() + "\u4e2d\u3067\u3059\u3002");
            }
            if (this.getPunishLevel() == PunishLevel.JAIL && !this.isInsideZone((byte)8)) {
                this.teleToLocation(-114356, -249645, -2984, true);
            }
        }
    }

    public void stopPunishTask(boolean save) {
        if (this._punishTask != null) {
            if (save) {
                long delay = this._punishTask.getDelay(TimeUnit.MILLISECONDS);
                if (delay < 0L) {
                    delay = 0L;
                }
                this.setPunishTimer(delay);
            }
            this._punishTask.cancel(false);
            this._punishTask = null;
        }
    }

    public void startFameTask(long delay, int fameFixRate) {
        if (this.getLevel() < 40 || this.getClassId().level() < 2) {
            return;
        }
        if (this._fameTask == null) {
            this._fameTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FameTask(fameFixRate), delay, delay);
        }
    }

    public void stopFameTask() {
        if (this._fameTask != null) {
            this._fameTask.cancel(false);
            this._fameTask = null;
        }
    }

    public void startVitalityTask() {
        if (Config.ENABLE_VITALITY && this._vitalityTask == null) {
            this._vitalityTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new VitalityTask(this), 1000L, 60000L);
        }
    }

    public void stopVitalityTask() {
        if (this._vitalityTask != null) {
            this._vitalityTask.cancel(false);
            this._vitalityTask = null;
        }
    }

    public int getPowerGrade() {
        return this._powerGrade;
    }

    public void setPowerGrade(int power) {
        this._powerGrade = power;
    }

    public boolean isCursedWeaponEquipped() {
        return this._cursedWeaponEquippedId != 0;
    }

    public void setCursedWeaponEquippedId(int value) {
        this._cursedWeaponEquippedId = value;
    }

    public int getCursedWeaponEquippedId() {
        return this._cursedWeaponEquippedId;
    }

    @Override
    public boolean isAttackingDisabled() {
        return super.isAttackingDisabled() || this._combatFlagEquippedId;
    }

    public boolean isCombatFlagEquipped() {
        return this._combatFlagEquippedId;
    }

    public void setCombatFlagEquipped(boolean value) {
        this._combatFlagEquippedId = value;
    }

    public final void setIsRidingStrider(boolean mode) {
        this._isRidingStrider = mode;
    }

    public final boolean isRidingStrider() {
        return this._isRidingStrider;
    }

    public int getSouls() {
        return this._souls;
    }

    public void absorbSoul(L2Skill skill, L2Npc npc) {
        if (this._souls >= skill.getNumSouls()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SOUL_CANNOT_BE_INCREASED_ANYMORE);
            this.sendPacket(sm);
            return;
        }
        this.increaseSouls(1);
        if (npc != null) {
            this.broadcastPacket(new ExSpawnEmitter(this, npc), 500);
        }
    }

    public void increaseSouls(int count) {
        if (count < 0 || count > 45) {
            return;
        }
        this._souls += count;
        if (this.getSouls() > 45) {
            this._souls = 45;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOUR_SOUL_HAS_INCREASED_BY_S1_SO_IT_IS_NOW_AT_S2);
        sm.addNumber(count);
        sm.addNumber(this._souls);
        this.sendPacket(sm);
        this.restartSoulTask();
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public boolean decreaseSouls(int count, L2Skill skill) {
        if (this.getSouls() <= 0 && skill.getSoulConsumeCount() > 0) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THERE_IS_NOT_ENOUGH_SOUL));
            return false;
        }
        this._souls -= count;
        if (this.getSouls() < 0) {
            this._souls = 0;
        }
        if (this.getSouls() == 0) {
            this.stopSoulTask();
        } else {
            this.restartSoulTask();
        }
        this.sendPacket(new EtcStatusUpdate(this));
        return true;
    }

    public void clearSouls() {
        this._souls = 0;
        this.stopSoulTask();
        this.sendPacket(new EtcStatusUpdate(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartSoulTask() {
        L2PcInstance l2PcInstance = this;
        synchronized (l2PcInstance) {
            if (this._soulTask != null) {
                this._soulTask.cancel(false);
                this._soulTask = null;
            }
            this._soulTask = ThreadPoolManager.getInstance().scheduleGeneral(new SoulTask(), 600000L);
        }
    }

    public void stopSoulTask() {
        if (this._soulTask != null) {
            this._soulTask.cancel(false);
            this._soulTask = null;
        }
    }

    public void shortBuffStatusUpdate(int magicId, int level, int time) {
        if (this._shortBuffTask != null) {
            this._shortBuffTask.cancel(false);
            this._shortBuffTask = null;
        }
        this._shortBuffTask = ThreadPoolManager.getInstance().scheduleGeneral(new ShortBuffTask(), time * 1000);
        this.setShortBuffTaskSkillId(magicId);
        this.sendPacket(new ShortBuffStatusUpdate(magicId, level, time));
    }

    public void setShortBuffTaskSkillId(int id) {
        this._shortBuffTaskSkillId = id;
    }

    public int getDeathPenaltyBuffLevel() {
        return this._deathPenaltyBuffLevel;
    }

    public void setDeathPenaltyBuffLevel(int level) {
        this._deathPenaltyBuffLevel = level;
    }

    public void calculateDeathPenaltyBuffLevel(L2Character killer) {
        if (!(this.getKarma() <= 0 && Rnd.get(1, 100) > Config.DEATH_PENALTY_CHANCE || killer instanceof L2PcInstance || this.isGM() || this.getCharmOfLuck() && killer.isRaid() || this.isPhoenixBlessed() || this.isLucky() || TvTEvent.isStarted() && TvTEvent.isPlayerParticipant(this.getObjectId()) || this.isInsideZone((byte)0) || this.isInsideZone((byte)2))) {
            this.increaseDeathPenaltyBuffLevel();
        }
    }

    public void increaseDeathPenaltyBuffLevel() {
        L2Skill skill;
        if (this.getDeathPenaltyBuffLevel() >= 15) {
            return;
        }
        if (this.getDeathPenaltyBuffLevel() != 0 && (skill = SkillTable.getInstance().getInfo(5076, this.getDeathPenaltyBuffLevel())) != null) {
            this.removeSkill(skill, true);
        }
        ++this._deathPenaltyBuffLevel;
        this.addSkill(SkillTable.getInstance().getInfo(5076, this.getDeathPenaltyBuffLevel()), false);
        this.sendPacket(new EtcStatusUpdate(this));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LEVEL_S1_ADDED);
        sm.addNumber(this.getDeathPenaltyBuffLevel());
        this.sendPacket(sm);
    }

    public void reduceDeathPenaltyBuffLevel() {
        if (this.getDeathPenaltyBuffLevel() <= 0) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(5076, this.getDeathPenaltyBuffLevel());
        if (skill != null) {
            this.removeSkill(skill, true);
        }
        --this._deathPenaltyBuffLevel;
        if (this.getDeathPenaltyBuffLevel() > 0) {
            this.addSkill(SkillTable.getInstance().getInfo(5076, this.getDeathPenaltyBuffLevel()), false);
            this.sendPacket(new EtcStatusUpdate(this));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LEVEL_S1_ADDED);
            sm.addNumber(this.getDeathPenaltyBuffLevel());
            this.sendPacket(sm);
        } else {
            this.sendPacket(new EtcStatusUpdate(this));
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LIFTED));
        }
    }

    public void restoreDeathPenaltyBuffLevel() {
        if (this.getDeathPenaltyBuffLevel() > 0) {
            this.addSkill(SkillTable.getInstance().getInfo(5076, this.getDeathPenaltyBuffLevel()), false);
        }
    }

    public Collection<TimeStamp> getReuseTimeStamps() {
        return this._reuseTimeStamps.values();
    }

    public FastMap<Integer, TimeStamp> getReuseTimeStamp() {
        return this._reuseTimeStamps;
    }

    @Override
    public void addTimeStamp(L2Skill skill, long reuse) {
        this._reuseTimeStamps.put((Object)skill.getReuseHashCode(), (Object)new TimeStamp(skill, reuse));
    }

    public void addTimeStamp(L2Skill skill, long reuse, long systime) {
        this._reuseTimeStamps.put((Object)skill.getReuseHashCode(), (Object)new TimeStamp(skill, reuse, systime));
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this;
    }

    @Override
    public final void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        SystemMessage sm;
        if (miss) {
            if (target instanceof L2PcInstance) {
                SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_EVADED_C2_ATTACK);
                sm2.addPcName((L2PcInstance)target);
                sm2.addCharName(this);
                target.sendPacket(sm2);
            }
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.C1_ATTACK_WENT_ASTRAY).addPcName(this));
            return;
        }
        if (pcrit) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.C1_HAD_CRITICAL_HIT).addPcName(this));
            if (target instanceof L2Npc && this.getSkillLevel(467) > 0) {
                L2Skill skill = SkillTable.getInstance().getInfo(467, this.getSkillLevel(467));
                if (Rnd.get(100) < skill.getCritChance()) {
                    this.absorbSoul(skill, (L2Npc)target);
                }
            }
        }
        if (mcrit) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CRITICAL_HIT_MAGIC));
        }
        if (this.isInOlympiadMode() && target instanceof L2PcInstance && ((L2PcInstance)target).isInOlympiadMode() && ((L2PcInstance)target).getOlympiadGameId() == this.getOlympiadGameId()) {
            OlympiadGameManager.getInstance().notifyCompetitorDamage(this, damage);
        }
        if (target.isInvul() && !(target instanceof L2Npc)) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED);
        } else if (target instanceof L2DoorInstance || target instanceof L2ControlTowerInstance) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DID_S1_DMG);
            sm.addNumber(damage);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_GAVE_C2_DAMAGE_OF_S3);
            sm.addPcName(this);
            sm.addCharName(target);
            sm.addNumber(damage);
        }
        this.sendPacket(sm);
    }

    public void setAgathionId(int npcId) {
        this._agathionId = npcId;
    }

    public int getAgathionId() {
        return this._agathionId;
    }

    public int getVitalityPoints() {
        return this.getStat().getVitalityPoints();
    }

    public int getVitalityLevel() {
        return this.getStat().getVitalityLevel();
    }

    public void setVitalityPoints(int points, boolean quiet) {
        this.getStat().setVitalityPoints(points, quiet);
    }

    public void updateVitalityPoints(float points, boolean useRates, boolean quiet) {
        this.getStat().updateVitalityPoints(points, useRates, quiet);
    }

    public boolean teleportRequest(L2PcInstance requester, L2Skill skill) {
        if (this._summonRequest.getTarget() != null && requester != null) {
            return false;
        }
        this._summonRequest.setTarget(requester, skill);
        return true;
    }

    public void teleportAnswer(int answer, int requesterId) {
        if (this._summonRequest.getTarget() == null) {
            return;
        }
        if (answer == 1 && this._summonRequest.getTarget().getObjectId() == requesterId) {
            L2PcInstance.teleToTarget(this, this._summonRequest.getTarget(), this._summonRequest.getSkill());
        }
        this._summonRequest.setTarget(null, null);
    }

    public static void teleToTarget(L2PcInstance targetChar, L2PcInstance summonerChar, L2Skill summonSkill) {
        if (targetChar == null || summonerChar == null || summonSkill == null) {
            return;
        }
        if (!L2PcInstance.checkSummonerStatus(summonerChar)) {
            return;
        }
        if (!L2PcInstance.checkSummonTargetStatus(targetChar, summonerChar)) {
            return;
        }
        int itemConsumeId = summonSkill.getTargetConsumeId();
        int itemConsumeCount = summonSkill.getTargetConsume();
        if (itemConsumeId != 0 && itemConsumeCount != 0) {
            if (targetChar.getInventory().getInventoryItemCount(itemConsumeId, 0) < (long)itemConsumeCount) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_REQUIRED_FOR_SUMMONING);
                sm.addItemName(summonSkill.getTargetConsumeId());
                targetChar.sendPacket(sm);
                return;
            }
            targetChar.getInventory().destroyItemByItemId("Consume", itemConsumeId, itemConsumeCount, summonerChar, targetChar);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
            sm.addItemName(summonSkill.getTargetConsumeId());
            targetChar.sendPacket(sm);
        }
        targetChar.teleToLocation(summonerChar.getX(), summonerChar.getY(), summonerChar.getZ(), true);
    }

    public static boolean checkSummonerStatus(L2PcInstance summonerChar) {
        if (summonerChar == null) {
            return false;
        }
        if (summonerChar.isInOlympiadMode()) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THIS_ITEM_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT));
            return false;
        }
        if (summonerChar.inObserverMode()) {
            return false;
        }
        if (!TvTEvent.onEscapeUse(summonerChar.getObjectId())) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
            return false;
        }
        if (summonerChar.isInsideZone((byte)12) || summonerChar.isFlyingMounted()) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
            return false;
        }
        return true;
    }

    public static boolean checkSummonTargetStatus(L2Object target, L2PcInstance summonerChar) {
        if (target == null || !(target instanceof L2PcInstance)) {
            return false;
        }
        L2PcInstance targetChar = (L2PcInstance)target;
        if (targetChar.isAlikeDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_DEAD_AT_THE_MOMENT_AND_CANNOT_BE_SUMMONED);
            sm.addPcName(targetChar);
            summonerChar.sendPacket(sm);
            return false;
        }
        if (targetChar.isInStoreMode()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CURRENTLY_TRADING_OR_OPERATING_PRIVATE_STORE_AND_CANNOT_BE_SUMMONED);
            sm.addPcName(targetChar);
            summonerChar.sendPacket(sm);
            return false;
        }
        if (targetChar.isRooted() || targetChar.isInCombat()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ENGAGED_IN_COMBAT_AND_CANNOT_BE_SUMMONED);
            sm.addPcName(targetChar);
            summonerChar.sendPacket(sm);
            return false;
        }
        if (targetChar.isInOlympiadMode()) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_SUMMON_PLAYERS_WHO_ARE_IN_OLYMPIAD));
            return false;
        }
        if (targetChar.isFestivalParticipant() || targetChar.isFlyingMounted()) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
            return false;
        }
        if (targetChar.inObserverMode()) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.C1_STATE_FORBIDS_SUMMONING).addCharName(targetChar));
            return false;
        }
        if (targetChar.isCombatFlagEquipped()) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
            return false;
        }
        if (!TvTEvent.onEscapeUse(targetChar.getObjectId())) {
            summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
            return false;
        }
        if (targetChar.isInsideZone((byte)12)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IN_SUMMON_BLOCKING_AREA);
            sm.addString(targetChar.getName());
            summonerChar.sendPacket(sm);
            return false;
        }
        if (summonerChar.getInstanceId() > 0) {
            Instance summonerInstance = InstanceManager.getInstance().getInstance(summonerChar.getInstanceId());
            if (!Config.ALLOW_SUMMON_TO_INSTANCE || !summonerInstance.isSummonAllowed()) {
                summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_MAY_NOT_SUMMON_FROM_YOUR_CURRENT_LOCATION));
                return false;
            }
        }
        if (summonerChar.isIn7sDungeon()) {
            int targetCabal = SevenSigns.getInstance().getPlayerCabal(targetChar.getObjectId());
            if (SevenSigns.getInstance().isSealValidationPeriod()) {
                if (targetCabal != SevenSigns.getInstance().getCabalHighestScore()) {
                    summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
                    return false;
                }
            } else if (targetCabal == 0) {
                summonerChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING));
                return false;
            }
        }
        return true;
    }

    public void gatesRequest(L2DoorInstance door) {
        this._gatesRequest.setTarget(door);
    }

    public void gatesAnswer(int answer, int type) {
        if (this._gatesRequest.getDoor() == null) {
            return;
        }
        if (answer == 1 && this.getTarget() == this._gatesRequest.getDoor() && type == 1) {
            this._gatesRequest.getDoor().openMe();
        } else if (answer == 1 && this.getTarget() == this._gatesRequest.getDoor() && type == 0) {
            this._gatesRequest.getDoor().closeMe();
        }
        this._gatesRequest.setTarget(null);
    }

    public void setExpGainOn(boolean value) {
        this._expGainOn = value;
    }

    public void checkItemRestriction() {
        for (int i = 0; i < 25; ++i) {
            L2ItemInstance equippedItem = this.getInventory().getPaperdollItem(i);
            if (equippedItem == null || equippedItem.getItem().checkCondition(this, this, false) && (!this.isInOlympiadMode() || !equippedItem.isOlyRestrictedItem())) continue;
            this.getInventory().unEquipItemInSlot(i);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(equippedItem);
            this.sendPacket(iu);
            SystemMessage sm = null;
            if (equippedItem.getItem().getBodyPart() == 8192) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLOAK_REMOVED_BECAUSE_ARMOR_SET_REMOVED));
                return;
            }
            if (equippedItem.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addNumber(equippedItem.getEnchantLevel());
                sm.addItemName(equippedItem);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(equippedItem);
            }
            this.sendPacket(sm);
        }
    }

    public void setTransformAllowedSkills(int[] ids) {
        this._transformAllowedSkills = ids;
    }

    public boolean containsAllowedTransformSkill(int id) {
        for (int i = 0; i < this._transformAllowedSkills.length; ++i) {
            if (this._transformAllowedSkills[i] != id) continue;
            return true;
        }
        return false;
    }

    protected synchronized void startFeed(int npcId) {
        boolean bl = this._canFeed = npcId > 0;
        if (!this.isMounted()) {
            return;
        }
        if (this.getPet() != null) {
            this.setCurrentFeed(((L2PetInstance)this.getPet()).getCurrentFed());
            this._controlItemId = this.getPet().getControlObjectId();
            this.sendPacket(new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume()));
            if (!this.isDead()) {
                this._mountFeedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FeedTask(), 10000L, 10000L);
            }
        } else if (this._canFeed) {
            this.setCurrentFeed(this.getMaxFeed());
            SetupGauge sg = new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume());
            this.sendPacket(sg);
            if (!this.isDead()) {
                this._mountFeedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FeedTask(), 10000L, 10000L);
            }
        }
    }

    protected synchronized void stopFeed() {
        if (this._mountFeedTask != null) {
            this._mountFeedTask.cancel(false);
            this._mountFeedTask = null;
            if (Config.DEBUG) {
                _log.fine("Pet [#" + this._mountNpcId + "] feed task stop");
            }
        }
    }

    private final void clearPetData() {
        this._data = null;
    }

    private final L2PetData getPetData(int npcId) {
        if (this._data == null) {
            this._data = PetDataTable.getInstance().getPetData(npcId);
        }
        return this._data;
    }

    private final L2PetLevelData getPetLevelData(int npcId) {
        if (this._leveldata == null) {
            this._leveldata = PetDataTable.getInstance().getPetData(npcId).getPetLevelData(this.getMountLevel());
        }
        return this._leveldata;
    }

    public int getCurrentFeed() {
        return this._curFeed;
    }

    private int getFeedConsume() {
        if (this.isAttackingNow()) {
            return this.getPetLevelData(this._mountNpcId).getPetFeedBattle();
        }
        return this.getPetLevelData(this._mountNpcId).getPetFeedNormal();
    }

    public void setCurrentFeed(int num) {
        this._curFeed = num > this.getMaxFeed() ? this.getMaxFeed() : num;
        SetupGauge sg = new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume());
        this.sendPacket(sg);
    }

    private int getMaxFeed() {
        return this.getPetLevelData(this._mountNpcId).getPetMaxFeed();
    }

    private boolean isHungry() {
        return this._canFeed ? (float)this.getCurrentFeed() < (float)this.getPetData(this.getMountNpcId()).getHungry_limit() / 100.0f * (float)this.getPetLevelData(this.getMountNpcId()).getPetMaxFeed() : false;
    }

    public void enteredNoLanding(int delay) {
        this._dismountTask = ThreadPoolManager.getInstance().scheduleGeneral(new Dismount(), delay * 1000);
    }

    public void exitedNoLanding() {
        if (this._dismountTask != null) {
            this._dismountTask.cancel(true);
            this._dismountTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePetFood(int petId) {
        if (this._controlItemId != 0 && petId != 0) {
            String req = "UPDATE pets SET fed=? WHERE item_obj_id = ?";
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(req);
                statement.setInt(1, this.getCurrentFeed());
                statement.setInt(2, this._controlItemId);
                statement.executeUpdate();
                statement.close();
                this._controlItemId = 0;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed to store Pet [NpcId: " + petId + "] data", e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    @Override
    public int getAttackElementValue(byte attribute) {
        int value = super.getAttackElementValue(attribute);
        if (this.getPet() != null && this.getClassId().isSummoner() && this.getPet() instanceof L2SummonInstance) {
            return value / 5;
        }
        return value;
    }

    public int getEventEffectId() {
        return this._eventEffectId;
    }

    public void startEventEffect(AbnormalEffect mask) {
        this._eventEffectId |= mask.getMask();
        this.broadcastUserInfo();
    }

    public void stopEventEffect(AbnormalEffect mask) {
        this._eventEffectId &= ~mask.getMask();
        this.broadcastUserInfo();
    }

    public void setIsInSiege(boolean b) {
        this._isInSiege = b;
    }

    public boolean isInSiege() {
        return this._isInSiege;
    }

    public FloodProtectors getFloodProtectors() {
        return this.getClient().getFloodProtectors();
    }

    public boolean isFlyingMounted() {
        return this._isFlyingMounted;
    }

    public void setIsFlyingMounted(boolean val) {
        this._isFlyingMounted = val;
        this.setIsFlying(val);
    }

    public int getCharges() {
        return this._charges.get();
    }

    public synchronized void increaseCharges(int count, int max) {
        if (this._charges.get() >= max) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FORCE_MAXLEVEL_REACHED));
            return;
        }
        if (this._charges.get() == 0) {
            this.restartChargeTask();
        }
        if (this._charges.addAndGet(count) >= max) {
            this._charges.set(max);
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FORCE_MAXLEVEL_REACHED));
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FORCE_INCREASED_TO_S1);
            sm.addNumber(this._charges.get());
            this.sendPacket(sm);
        }
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public synchronized boolean decreaseCharges(int count) {
        if (this._charges.get() < count) {
            return false;
        }
        if (this._charges.addAndGet(-count) == 0) {
            this.stopChargeTask();
        }
        this.sendPacket(new EtcStatusUpdate(this));
        return true;
    }

    public void clearCharges() {
        this._charges.set(0);
        this.sendPacket(new EtcStatusUpdate(this));
    }

    private void restartChargeTask() {
        if (this._chargeTask != null) {
            this._chargeTask.cancel(false);
            this._chargeTask = null;
        }
        this._chargeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ChargeTask(), 600000L);
    }

    public void stopChargeTask() {
        if (this._chargeTask != null) {
            this._chargeTask.cancel(false);
            this._chargeTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void teleportBookmarkModify(int Id, int icon, String tag, String name) {
        int size = this.tpbookmark.size();
        for (int count = 0; size > count; ++count) {
            if (this.tpbookmark.get((int)count)._id != Id) continue;
            this.tpbookmark.get((int)count)._icon = icon;
            this.tpbookmark.get((int)count)._tag = tag;
            this.tpbookmark.get((int)count)._name = name;
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(UPDATE_TP_BOOKMARK);
                statement.setInt(1, icon);
                statement.setString(2, tag);
                statement.setString(3, name);
                statement.setInt(4, this.getObjectId());
                statement.setInt(5, Id);
                statement.execute();
                statement.close();
                continue;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not update character teleport bookmark data: " + e.getMessage(), e);
                continue;
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void teleportBookmarkDelete(int Id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(DELETE_TP_BOOKMARK);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, Id);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not delete character teleport bookmark data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        int size = this.tpbookmark.size();
        for (int count = 0; size > count; ++count) {
            if (this.tpbookmark.get((int)count)._id != Id) continue;
            this.tpbookmark.remove(count);
            break;
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    public void teleportBookmarkGo(int Id) {
        if (!this.teleportBookmarkCondition(0) || this == null) {
            return;
        }
        if (this.getInventory().getInventoryItemCount(13016, 0) == 0L) {
            this.sendPacket(SystemMessage.getSystemMessage(2359));
            return;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
        sm.addItemName(13016);
        this.sendPacket(sm);
        int size = this.tpbookmark.size();
        for (int count = 0; size > count; ++count) {
            if (this.tpbookmark.get((int)count)._id != Id) continue;
            this.destroyItem("Consume", this.getInventory().getItemByItemId(13016).getObjectId(), 1L, null, false);
            this.teleToLocation(this.tpbookmark.get((int)count)._x, this.tpbookmark.get((int)count)._y, this.tpbookmark.get((int)count)._z);
            break;
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    public boolean teleportBookmarkCondition(int type) {
        if (this.isInCombat()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_BATTLE));
            return false;
        }
        if (this.isInSiege() || this.getSiegeState() != 0) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING));
            return false;
        }
        if (this.isInDuel()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_DUEL));
            return false;
        }
        if (this.isFlying()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_FLYING));
            return false;
        }
        if (this.isInOlympiadMode()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING_IN_AN_OLYMPIAD_MATCH));
            return false;
        }
        if (this.isParalyzed()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_PARALYZED));
            return false;
        }
        if (this.isDead()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_DEAD));
            return false;
        }
        if (type == 1 && (this.isIn7sDungeon() || this.isInParty() && this.getParty().isInDimensionalRift())) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA));
            return false;
        }
        if (this.isInBoat() || this.isInAirShip() || this.isInJail() || this.isInsideZone((byte)12)) {
            if (type == 0) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_IN_THIS_AREA));
            } else if (type == 1) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA));
            }
            return false;
        }
        if (this.isInWater()) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_UNDERWATER));
            return false;
        }
        if (type == 1 && (this.isInsideZone((byte)2) || this.isInsideZone((byte)4) || this.isInsideZone((byte)8) || this.isInsideZone((byte)10) || this.isInsideZone((byte)12) || this.isInsideZone((byte)13))) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA));
            return false;
        }
        if (this.isInsideZone((byte)20)) {
            if (type == 0) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_IN_THIS_AREA));
            } else if (type == 1) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void teleportBookmarkAdd(int x, int y, int z, int icon, String tag, String name) {
        if (this == null) {
            return;
        }
        if (!this.teleportBookmarkCondition(1)) {
            return;
        }
        if (this.tpbookmark.size() >= this._bookmarkslot) {
            this.sendPacket(SystemMessage.getSystemMessage(2358));
            return;
        }
        if (this.getInventory().getInventoryItemCount(20033, 0) == 0L) {
            this.sendPacket(SystemMessage.getSystemMessage(6501));
            return;
        }
        int id = 1;
        FastList idlist = new FastList();
        int size = this.tpbookmark.size();
        for (int count = 0; size > count; ++count) {
            idlist.add((Object)this.tpbookmark.get((int)count)._id);
        }
        for (int i = 1; i < 10; ++i) {
            if (idlist.contains((Object)i)) continue;
            id = i;
            break;
        }
        TeleportBookmark tpadd = new TeleportBookmark(id, x, y, z, icon, tag, name);
        if (this.tpbookmark == null) {
            this.tpbookmark = new FastList();
        }
        this.tpbookmark.add(tpadd);
        this.destroyItem("Consume", this.getInventory().getItemByItemId(20033).getObjectId(), 1L, null, false);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
        sm.addItemName(20033);
        this.sendPacket(sm);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(INSERT_TP_BOOKMARK);
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, id);
            statement.setInt(3, x);
            statement.setInt(4, y);
            statement.setInt(5, z);
            statement.setInt(6, icon);
            statement.setString(7, tag);
            statement.setString(8, name);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not insert character teleport bookmark data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTeleportBookmark() {
        if (this.tpbookmark == null) {
            this.tpbookmark = new FastList();
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(RESTORE_TP_BOOKMARK);
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                this.tpbookmark.add(new TeleportBookmark(rset.getInt("Id"), rset.getInt("x"), rset.getInt("y"), rset.getInt("z"), rset.getInt("icon"), rset.getString("tag"), rset.getString("name")));
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed restoing character teleport bookmark.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this.isInBoat()) {
            this.getPosition().setWorldPosition(this.getBoat().getPosition().getWorldPosition());
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.getPet() != null) {
                    activeChar.sendPacket(new RelationChanged(this.getPet(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.getPet() != null) {
                    this.sendPacket(new RelationChanged(activeChar.getPet(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
            activeChar.sendPacket(new GetOnVehicle(this.getObjectId(), this.getBoat().getObjectId(), this.getInVehiclePosition()));
        } else if (this.isInAirShip()) {
            this.getPosition().setWorldPosition(this.getAirShip().getPosition().getWorldPosition());
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.getPet() != null) {
                    activeChar.sendPacket(new RelationChanged(this.getPet(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.getPet() != null) {
                    this.sendPacket(new RelationChanged(activeChar.getPet(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
            activeChar.sendPacket(new ExGetOnAirShip(this, this.getAirShip()));
        } else {
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.getPet() != null) {
                    activeChar.sendPacket(new RelationChanged(this.getPet(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.getPet() != null) {
                    this.sendPacket(new RelationChanged(activeChar.getPet(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
        }
        if (this.getMountType() == 4) {
            activeChar.sendPacket(new Ride(this, false, 0));
            activeChar.sendPacket(new Ride(this, true, this.getMountNpcId()));
        }
        switch (this.getPrivateStoreType()) {
            case 1: {
                activeChar.sendPacket(new PrivateStoreMsgSell(this));
                break;
            }
            case 8: {
                activeChar.sendPacket(new ExPrivateStoreSetWholeMsg(this));
                break;
            }
            case 3: {
                activeChar.sendPacket(new PrivateStoreMsgBuy(this));
                break;
            }
            case 5: {
                activeChar.sendPacket(new RecipeShopMsg(this));
            }
        }
    }

    public void showQuestMovie(int id) {
        if (this._movieId > 0) {
            return;
        }
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this._movieId = id;
        this.sendPacket(new ExStartScenePlayer(id));
    }

    public boolean isAllowedToEnchantSkills() {
        if (this.isLocked()) {
            return false;
        }
        if (this.isTransformed() || this.isInStance()) {
            return false;
        }
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(this)) {
            return false;
        }
        if (this.isCastingNow() || this.isCastingSimultaneouslyNow()) {
            return false;
        }
        return !this.isInBoat() && !this.isInAirShip();
    }

    public void setCreateTime(long creationTime) {
        this._creationTime = creationTime;
    }

    public long getCreateTime() {
        return this._creationTime;
    }

    public int checkBirthDay() {
        return this.checkBirthDay(true);
    }

    public int checkBirthDayA() {
        return this.checkBirthDay(false);
    }

    private int checkBirthDay(boolean checkState) {
        QuestState _state;
        GregorianCalendar now = new GregorianCalendar();
        if (checkState && (_state = this.getQuestState("CharacterBirthday")) != null && _state.getInt("Birthday") > now.get(1)) {
            return -1;
        }
        Calendar birth = Calendar.getInstance();
        birth.setTimeInMillis(this._creationTime);
        if (birth.get(2) == 1 && birth.get(5) == 29 && !now.isLeapYear(now.get(1))) {
            birth.add(5, -1);
        }
        for (int i = 0; i <= 5; ++i) {
            if (now.get(2) == birth.get(2) && now.get(5) == birth.get(5) && now.get(1) != birth.get(1)) {
                return i;
            }
            now.add(5, 1);
        }
        return -1;
    }

    public List<Integer> getFriendList() {
        return this._friendList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFriendList() {
        this._friendList.clear();
        Connection con = null;
        try {
            String sqlQuery = "SELECT friendId FROM character_friends WHERE charId=? AND relation=0";
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(sqlQuery);
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int friendId = rset.getInt("friendId");
                if (friendId == this.getObjectId()) continue;
                this._friendList.add(friendId);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            try {
                _log.log(Level.WARNING, "Error found in " + this.getName() + "'s FriendList: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                L2DatabaseFactory.close(con);
                throw throwable;
            }
            L2DatabaseFactory.close(con);
        }
        L2DatabaseFactory.close(con);
    }

    private void notifyFriends() {
        FriendStatusPacket pkt = new FriendStatusPacket(this.getObjectId());
        for (int id : this._friendList) {
            L2PcInstance friend = L2World.getInstance().getPlayer(id);
            if (friend == null) continue;
            friend.sendPacket(pkt);
        }
    }

    public boolean isSilenceMode() {
        return this._silenceMode;
    }

    public void setSilenceMode(boolean mode) {
        this._silenceMode = mode;
        this.sendPacket(new EtcStatusUpdate(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeRecipeShopList() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            L2ManufactureList list = this.getCreateList();
            if (list != null && list.size() > 0) {
                int _position = 1;
                PreparedStatement statement = con.prepareStatement("DELETE FROM character_recipeshoplist WHERE charId=? ");
                statement.setInt(1, this.getObjectId());
                statement.execute();
                statement.close();
                PreparedStatement statement2 = con.prepareStatement("INSERT INTO character_recipeshoplist (charId, Recipeid, Price, Pos) VALUES (?, ?, ?, ?)");
                for (L2ManufactureItem item : list.getList()) {
                    statement2.setInt(1, this.getObjectId());
                    statement2.setInt(2, item.getRecipeId());
                    statement2.setLong(3, item.getCost());
                    statement2.setInt(4, _position);
                    statement2.execute();
                    statement2.clearParameters();
                    ++_position;
                }
                statement2.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not store recipe shop for playerID " + this.getObjectId() + ": ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRecipeShopList() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT Recipeid,Price FROM character_recipeshoplist WHERE charId=? ORDER BY Pos ASC");
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            L2ManufactureList createList = new L2ManufactureList();
            while (rset.next()) {
                createList.add(new L2ManufactureItem(rset.getInt("Recipeid"), rset.getLong("Price")));
            }
            this.setCreateList(createList);
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore recipe shop list data for playerId: " + this.getObjectId(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public double getCollisionRadius() {
        if (this.getAppearance().getSex()) {
            return this.getBaseTemplate().fCollisionRadius_female;
        }
        return this.getBaseTemplate().fCollisionRadius;
    }

    public double getCollisionHeight() {
        if (this.getAppearance().getSex()) {
            return this.getBaseTemplate().fCollisionHeight_female;
        }
        return this.getBaseTemplate().fCollisionHeight;
    }

    public final int getClientX() {
        return this._clientX;
    }

    public final int getClientY() {
        return this._clientY;
    }

    public final int getClientZ() {
        return this._clientZ;
    }

    public final int getClientHeading() {
        return this._clientHeading;
    }

    public final void setClientX(int val) {
        this._clientX = val;
    }

    public final void setClientY(int val) {
        this._clientY = val;
    }

    public final void setClientZ(int val) {
        this._clientZ = val;
    }

    public final void setClientHeading(int val) {
        this._clientHeading = val;
    }

    public final boolean isFalling(int z) {
        if (this.isDead() || this.isFlying() || this.isFlyingMounted() || this.isInsideZone((byte)7)) {
            return false;
        }
        if (System.currentTimeMillis() < this._fallingTimestamp) {
            return true;
        }
        int deltaZ = this.getZ() - z;
        if (deltaZ <= this.getBaseTemplate().getFallHeight()) {
            return false;
        }
        int damage = (int)Formulas.calcFallDam(this, deltaZ);
        if (damage > 0) {
            this.reduceCurrentHp(Math.min((double)damage, this.getCurrentHp() - 1.0), null, false, true, null);
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FALL_DAMAGE_S1).addNumber(damage));
        }
        this.setFalling();
        return false;
    }

    public final void setFalling() {
        this._fallingTimestamp = System.currentTimeMillis() + 10000L;
    }

    public int getMovieId() {
        return this._movieId;
    }

    public void setMovieId(int id) {
        this._movieId = id;
    }

    public void updateLastItemAuctionRequest() {
        this._lastItemAuctionInfoRequest = System.currentTimeMillis();
    }

    public boolean isItemAuctionPolling() {
        return System.currentTimeMillis() - this._lastItemAuctionInfoRequest < 2000L;
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || this._movieId > 0;
    }

    private void restoreUISettings() {
        this._uiKeySettings = new L2UIKeysSettings(this);
    }

    private void storeUISettings() {
        if (this._uiKeySettings == null) {
            return;
        }
        if (!this._uiKeySettings.isSaved()) {
            this._uiKeySettings.saveInDB();
        }
    }

    public L2UIKeysSettings getUISettings() {
        return this._uiKeySettings;
    }

    public String getHtmlPrefix() {
        if (!Config.L2JMOD_MULTILANG_ENABLE) {
            return null;
        }
        return this._htmlPrefix;
    }

    public String getLang() {
        return this._lang;
    }

    public boolean setLang(String lang) {
        boolean result = false;
        if (Config.L2JMOD_MULTILANG_ENABLE) {
            if (Config.L2JMOD_MULTILANG_ALLOWED.contains(lang)) {
                this._lang = lang;
                result = true;
            } else {
                this._lang = Config.L2JMOD_MULTILANG_DEFAULT;
            }
            this._htmlPrefix = "data/lang/" + this._lang + "/";
        } else {
            this._lang = null;
            this._htmlPrefix = null;
        }
        return result;
    }

    public long getOfflineStartTime() {
        return this._offlineShopStart;
    }

    public void setOfflineStartTime(long time) {
        this._offlineShopStart = time;
    }

    public void removeFromBossZone() {
        try {
            Iterator i$ = GrandBossManager.getInstance().getZones().iterator();
            while (i$.hasNext()) {
                L2BossZone _zone = (L2BossZone)i$.next();
                _zone.removePlayer(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on removeFromBossZone(): " + e.getMessage(), e);
        }
    }

    public void checkPlayerSkills() {
        Iterator i$ = this._skills.keySet().iterator();
        while (i$.hasNext()) {
            L2SkillLearn learn;
            int id = (Integer)i$.next();
            int level = this.getSkillLevel(id);
            if (level >= 100) {
                level = SkillTable.getInstance().getMaxLevel(id);
            }
            if ((learn = SkillTreesData.getInstance().getClassSkill(id, level, this.getClassId())) == null || this.getLevel() >= learn.getGetLevel() - 9) continue;
            this.deacreaseSkillLevel(id);
        }
    }

    private void deacreaseSkillLevel(int id) {
        int nextLevel = -1;
        FastMap<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(this.getClassId());
        for (L2SkillLearn sl : skillTree.values()) {
            if (sl.getSkillId() != id || nextLevel >= sl.getSkillLevel() || this.getLevel() < sl.getGetLevel() - 9) continue;
            nextLevel = sl.getSkillLevel();
        }
        if (nextLevel == -1) {
            _log.info("Removing skill id " + id + " level " + this.getSkillLevel(id) + " from player " + this);
            this.removeSkill((L2Skill)this._skills.get(id), true);
        } else {
            _log.info("Decreasing skill id " + id + " from " + this.getSkillLevel(id) + " to " + nextLevel + " for " + this);
            this.addSkill(SkillTable.getInstance().getInfo(id, nextLevel), true);
        }
    }

    public boolean canMakeSocialAction() {
        return this.getPrivateStoreType() == 0 && this.getActiveRequester() == null && !this.isAlikeDead() && (!this.isAllSkillsDisabled() || this.isInDuel()) && !this.isCastingNow() && !this.isCastingSimultaneouslyNow() && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE && !AttackStanceTaskManager.getInstance().getAttackStanceTask(this) && !this.isInOlympiadMode();
    }

    public void setMultiSocialAction(int id, int targetId) {
        this._multiSociaAction = id;
        this._multiSocialTarget = targetId;
    }

    public int getMultiSociaAction() {
        return this._multiSociaAction;
    }

    public int getMultiSocialTarget() {
        return this._multiSocialTarget;
    }

    public List<TeleportBookmark> getTpbookmark() {
        return this.tpbookmark;
    }

    public int getBookmarkslot() {
        return this._bookmarkslot;
    }

    public int getQuestInventoryLimit() {
        return Config.INVENTORY_MAXIMUM_QUEST_ITEMS;
    }

    public boolean canAttackCharacter(L2Character cha) {
        if (cha instanceof L2Attackable) {
            return true;
        }
        if (cha instanceof L2Playable) {
            if (cha.isInsideZone((byte)0) && !cha.isInsideZone((byte)2)) {
                return true;
            }
            L2PcInstance target = cha instanceof L2Summon ? ((L2Summon)cha).getOwner() : (L2PcInstance)cha;
            if (this.isInDuel() && target.isInDuel() && target.getDuelId() == this.getDuelId()) {
                return true;
            }
            if (this.isInParty() && target.isInParty()) {
                if (this.getParty() == target.getParty()) {
                    return false;
                }
                if ((this.getParty().getCommandChannel() != null || target.getParty().getCommandChannel() != null) && this.getParty().getCommandChannel() == target.getParty().getCommandChannel()) {
                    return false;
                }
            } else if (this.getClan() != null && target.getClan() != null) {
                if (this.getClanId() == target.getClanId()) {
                    return false;
                }
                if ((this.getAllyId() > 0 || target.getAllyId() > 0) && this.getAllyId() == target.getAllyId()) {
                    return false;
                }
                if (this.getClan().isAtWarWith(target.getClan().getClanId()) && target.getClan().isAtWarWith(this.getClan().getClanId())) {
                    return true;
                }
            } else if ((this.getClan() == null || target.getClan() == null) && target.getPvpFlag() == 0 && target.getKarma() == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isInventoryUnder80(boolean includeQuestInv) {
        if ((double)this.getInventory().getSize(false) <= (double)this.getInventoryLimit() * 0.8) {
            if (includeQuestInv) {
                if ((double)this.getInventory().getSize(true) <= (double)this.getQuestInventoryLimit() * 0.8) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean havePetInvItems() {
        return this._petItems;
    }

    public void setPetInvItems(boolean haveit) {
        this._petItems = haveit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPetInvItems() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id FROM `items` WHERE `owner_id`=? AND (`loc`='PET' OR `loc`='PET_EQUIP') LIMIT 1;");
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            if (rset.next() && rset.getInt("object_id") > 0) {
                this.setPetInvItems(true);
            } else {
                this.setPetInvItems(false);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not check Items in Pet Inventory for playerId: " + this.getObjectId(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public String getAdminConfirmCmd() {
        return this._adminConfirmCmd;
    }

    public void setAdminConfirmCmd(String adminConfirmCmd) {
        this._adminConfirmCmd = adminConfirmCmd;
    }

    public void setBlockCheckerArena(byte arena) {
        this._handysBlockCheckerEventArena = arena;
    }

    public int getBlockCheckerArena() {
        return this._handysBlockCheckerEventArena;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadRecommendations() {
        long _time_left = 0L;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT rec_have,rec_left,time_left FROM character_reco_bonus WHERE charId=? LIMIT 1");
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                this.setRecomHave(rset.getInt("rec_have"));
                this.setRecomLeft(rset.getInt("rec_left"));
                _time_left = rset.getLong("time_left");
            } else {
                _time_left = 3600000L;
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore Recommendations for player: " + this.getObjectId(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return _time_left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRecommendations() {
        long _recoTaskEnd = 0L;
        if (this._recoBonusTask != null) {
            _recoTaskEnd = Math.max(0L, this._recoBonusTask.getDelay(TimeUnit.MILLISECONDS));
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO character_reco_bonus (charId,rec_have,rec_left,time_left) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE rec_have=?, rec_left=?, time_left=?");
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getRecomHave());
            statement.setInt(3, this.getRecomLeft());
            statement.setLong(4, _recoTaskEnd);
            statement.setInt(5, this.getRecomHave());
            statement.setInt(6, this.getRecomLeft());
            statement.setLong(7, _recoTaskEnd);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not update Recommendations for player: " + this.getObjectId(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void checkRecoBonusTask() {
        long _task_time = this.loadRecommendations();
        if (_task_time > 0L) {
            if (_task_time == 3600000L) {
                this.setRecomLeft(this.getRecomLeft() + 20);
            }
            this._recoBonusTask = ThreadPoolManager.getInstance().scheduleGeneral(new RecoBonusTaskEnd(), _task_time);
        }
        this._recoGiveTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RecoGiveTask(), 0x6DDD00L, 3600000L);
        this.storeRecommendations();
    }

    public void stopRecoBonusTask() {
        if (this._recoBonusTask != null) {
            this._recoBonusTask.cancel(false);
            this._recoBonusTask = null;
        }
    }

    public void stopRecoGiveTask() {
        if (this._recoGiveTask != null) {
            this._recoGiveTask.cancel(false);
            this._recoGiveTask = null;
        }
    }

    public int getRecomBonusTime() {
        if (this._recoBonusTask != null) {
            return (int)Math.max(0L, this._recoBonusTask.getDelay(TimeUnit.SECONDS));
        }
        return 0;
    }

    public int getRecomBonusType() {
        return 0;
    }

    private class RecoBonusTaskEnd
    implements Runnable {
        private RecoBonusTaskEnd() {
        }

        @Override
        public void run() {
            if (L2PcInstance.this == null) {
                return;
            }
            L2PcInstance.this.sendPacket(new ExVoteSystemInfo(L2PcInstance.this));
        }
    }

    private class RecoGiveTask
    implements Runnable {
        private RecoGiveTask() {
        }

        @Override
        public void run() {
            if (L2PcInstance.this == null) {
                L2PcInstance.this.stopRecoGiveTask();
                return;
            }
            int reco_to_give = L2PcInstance.this._recoTwoHoursGiven ? 1 : 10;
            L2PcInstance.this._recoTwoHoursGiven = true;
            L2PcInstance.this.setRecomLeft(L2PcInstance.this.getRecomLeft() + reco_to_give);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_OBTAINED_S1_RECOMMENDATIONS);
            sm.addNumber(reco_to_give);
            L2PcInstance.this.sendPacket(sm);
            L2PcInstance.this.sendPacket(new UserInfo(L2PcInstance.this));
        }
    }

    public static class TeleportBookmark {
        public int _id;
        public int _x;
        public int _y;
        public int _z;
        public int _icon;
        public String _name;
        public String _tag;

        TeleportBookmark(int id, int x, int y, int z, int icon, String tag, String name) {
            this._id = id;
            this._x = x;
            this._y = y;
            this._z = z;
            this._icon = icon;
            this._name = name;
            this._tag = tag;
        }
    }

    private class ChargeTask
    implements Runnable {
        private ChargeTask() {
        }

        @Override
        public void run() {
            L2PcInstance.this.clearCharges();
        }
    }

    private class Dismount
    implements Runnable {
        private Dismount() {
        }

        @Override
        public void run() {
            try {
                L2PcInstance.this.dismount();
            }
            catch (Exception e) {
                L2Character._log.log(Level.WARNING, "Exception on dismount(): " + e.getMessage(), e);
            }
        }
    }

    private class FeedTask
    implements Runnable {
        private FeedTask() {
        }

        @Override
        public void run() {
            try {
                IItemHandler handler;
                if (!L2PcInstance.this.isMounted()) {
                    L2PcInstance.this.stopFeed();
                    return;
                }
                if (L2PcInstance.this.getCurrentFeed() > L2PcInstance.this.getFeedConsume()) {
                    L2PcInstance.this.setCurrentFeed(L2PcInstance.this.getCurrentFeed() - L2PcInstance.this.getFeedConsume());
                } else {
                    L2PcInstance.this.setCurrentFeed(0);
                    L2PcInstance.this.stopFeed();
                    L2PcInstance.this.dismount();
                    L2PcInstance.this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.OUT_OF_FEED_MOUNT_CANCELED));
                }
                int[] foodIds = L2PcInstance.this.getPetData(L2PcInstance.this.getMountNpcId()).getFood();
                if (foodIds.length == 0) {
                    return;
                }
                L2ItemInstance food = null;
                for (int id : foodIds) {
                    food = L2PcInstance.this.getInventory().getItemByItemId(id);
                    if (food != null) break;
                }
                if (food != null && L2PcInstance.this.isHungry() && (handler = ItemHandler.getInstance().getItemHandler(food.getEtcItem())) != null) {
                    handler.useItem(L2PcInstance.this, food, false);
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY);
                    sm.addItemName(food.getItemId());
                    L2PcInstance.this.sendPacket(sm);
                }
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "Mounted Pet [NpcId: " + L2PcInstance.this.getMountNpcId() + "] a feed task error has occurred", e);
            }
        }
    }

    public static class TimeStamp {
        private final int _skillId;
        private final int _skillLvl;
        private final long _reuse;
        private final long _stamp;

        public TimeStamp(L2Skill skill, long reuse) {
            this._skillId = skill.getId();
            this._skillLvl = skill.getLevel();
            this._reuse = reuse;
            this._stamp = System.currentTimeMillis() + reuse;
        }

        public TimeStamp(L2Skill skill, long reuse, long systime) {
            this._skillId = skill.getId();
            this._skillLvl = skill.getLevel();
            this._reuse = reuse;
            this._stamp = systime;
        }

        public long getStamp() {
            return this._stamp;
        }

        public int getSkillId() {
            return this._skillId;
        }

        public int getSkillLvl() {
            return this._skillLvl;
        }

        public long getReuse() {
            return this._reuse;
        }

        public long getRemaining() {
            return Math.max(this._stamp - System.currentTimeMillis(), 0L);
        }

        public boolean hasNotPassed() {
            return System.currentTimeMillis() < this._stamp;
        }
    }

    private class SoulTask
    implements Runnable {
        private SoulTask() {
        }

        @Override
        public void run() {
            L2PcInstance.this.clearSouls();
        }
    }

    private class VitalityTask
    implements Runnable {
        private final L2PcInstance _player;

        protected VitalityTask(L2PcInstance player) {
            this._player = player;
        }

        @Override
        public void run() {
            if (!this._player.isInsideZone((byte)1)) {
                return;
            }
            if (this._player.getVitalityPoints() >= PcStat.MAX_VITALITY_POINTS) {
                return;
            }
            this._player.updateVitalityPoints(Config.RATE_RECOVERY_VITALITY_PEACE_ZONE, false, false);
            this._player.sendPacket(new ExVitalityPointInfo(L2PcInstance.this.getVitalityPoints()));
        }
    }

    private class FameTask
    implements Runnable {
        private final L2PcInstance _player;
        private final int _value;

        protected FameTask(int value) {
            this._player = L2PcInstance.this;
            this._value = value;
        }

        @Override
        public void run() {
            if (this._player == null || this._player.isDead() && !Config.FAME_FOR_DEAD_PLAYERS) {
                return;
            }
            if ((this._player.getClient() == null || this._player.getClient().isDetached()) && !Config.OFFLINE_FAME) {
                return;
            }
            this._player.setFame(this._player.getFame() + this._value);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.ACQUIRED_S1_REPUTATION_SCORE);
            sm.addNumber(this._value);
            this._player.sendPacket(sm);
            this._player.sendPacket(new UserInfo(this._player));
        }
    }

    private class PunishTask
    implements Runnable {
        private PunishTask() {
        }

        @Override
        public void run() {
            L2PcInstance.this.setPunishLevel(PunishLevel.NONE, 0);
        }
    }

    private class TeleportWatchdog
    implements Runnable {
        private final L2PcInstance _player;

        TeleportWatchdog() {
            this._player = L2PcInstance.this;
        }

        @Override
        public void run() {
            if (this._player == null || !this._player.isTeleporting()) {
                return;
            }
            if (Config.DEBUG) {
                L2Character._log.warning("Player " + this._player.getName() + " teleport timeout expired");
            }
            this._player.onTeleported();
        }
    }

    private class LookingForFishTask
    implements Runnable {
        boolean _isNoob;
        boolean _isUpperGrade;
        int _fishType;
        int _fishGutsCheck;
        long _endTaskTime;

        protected LookingForFishTask(int fishWaitTime, int fishGutsCheck, int fishType, boolean isNoob, boolean isUpperGrade) {
            this._fishGutsCheck = fishGutsCheck;
            this._endTaskTime = System.currentTimeMillis() + (long)fishWaitTime + 10000L;
            this._fishType = fishType;
            this._isNoob = isNoob;
            this._isUpperGrade = isUpperGrade;
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() >= this._endTaskTime) {
                L2PcInstance.this.endFishing(false);
                return;
            }
            if (this._fishType == -1) {
                return;
            }
            int check = Rnd.get(1000);
            if (this._fishGutsCheck > check) {
                L2PcInstance.this.stopLookingForFishTask();
                L2PcInstance.this.startFishCombat(this._isNoob, this._isUpperGrade);
            }
        }
    }

    private class WaterTask
    implements Runnable {
        private WaterTask() {
        }

        @Override
        public void run() {
            double reduceHp = (double)L2PcInstance.this.getMaxHp() / 100.0;
            if (reduceHp < 1.0) {
                reduceHp = 1.0;
            }
            L2PcInstance.this.reduceCurrentHp(reduceHp, L2PcInstance.this, false, false, null);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DROWN_DAMAGE_S1);
            sm.addNumber((int)reduceHp);
            L2PcInstance.this.sendPacket(sm);
        }
    }

    private class RentPetTask
    implements Runnable {
        private RentPetTask() {
        }

        @Override
        public void run() {
            L2PcInstance.this.stopRentPet();
        }
    }

    private class WarnUserTakeBreak
    implements Runnable {
        private WarnUserTakeBreak() {
        }

        @Override
        public void run() {
            if (L2PcInstance.this.isOnline()) {
                SystemMessageId.PLAYING_FOR_LONG_TIME.setParamCount(1);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.PLAYING_FOR_LONG_TIME);
                msg.addNumber((int)(L2PcInstance.this.getUptime() / 3600000L));
                L2PcInstance.this.sendPacket(msg);
            } else {
                L2PcInstance.this.stopWarnUserTakeBreak();
            }
        }
    }

    private class InventoryEnable
    implements Runnable {
        private InventoryEnable() {
        }

        @Override
        public void run() {
            L2PcInstance.this._inventoryDisable = false;
        }
    }

    private class GameGuardCheck
    implements Runnable {
        private GameGuardCheck() {
        }

        @Override
        public void run() {
            L2GameClient client = L2PcInstance.this.getClient();
            if (client != null && !client.isAuthedGG() && L2PcInstance.this.isOnline()) {
                GmListTable.broadcastMessageToGMs("Client " + client + " failed to reply GameGuard query and is being kicked!");
                L2Character._log.info("Client " + client + " failed to reply GameGuard query and is being kicked!");
                client.close(LeaveWorld.STATIC_PACKET);
            }
        }
    }

    private class StandUpTask
    implements Runnable {
        private StandUpTask() {
        }

        @Override
        public void run() {
            L2PcInstance.this.setIsSitting(false);
            L2PcInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
    }

    private class SitDownTask
    implements Runnable {
        private SitDownTask() {
        }

        @Override
        public void run() {
            L2PcInstance.this.setIsParalyzed(false);
            L2PcInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
        }
    }

    private static class GatesRequest {
        private L2DoorInstance _target = null;

        private GatesRequest() {
        }

        public void setTarget(L2DoorInstance door) {
            this._target = door;
        }

        public L2DoorInstance getDoor() {
            return this._target;
        }
    }

    private static class SummonRequest {
        private L2PcInstance _target = null;
        private L2Skill _skill = null;

        private SummonRequest() {
        }

        public void setTarget(L2PcInstance destination, L2Skill skill) {
            this._target = destination;
            this._skill = skill;
        }

        public L2PcInstance getTarget() {
            return this._target;
        }

        public L2Skill getSkill() {
            return this._skill;
        }
    }

    public static class SkillDat {
        private final L2Skill _skill;
        private final boolean _ctrlPressed;
        private final boolean _shiftPressed;

        protected SkillDat(L2Skill skill, boolean ctrlPressed, boolean shiftPressed) {
            this._skill = skill;
            this._ctrlPressed = ctrlPressed;
            this._shiftPressed = shiftPressed;
        }

        public boolean isCtrlPressed() {
            return this._ctrlPressed;
        }

        public boolean isShiftPressed() {
            return this._shiftPressed;
        }

        public L2Skill getSkill() {
            return this._skill;
        }

        public int getSkillId() {
            return this.getSkill() != null ? this.getSkill().getId() : -1;
        }
    }

    private class ShortBuffTask
    implements Runnable {
        private ShortBuffTask() {
        }

        @Override
        public void run() {
            if (L2PcInstance.this == null) {
                return;
            }
            L2PcInstance.this.sendPacket(new ShortBuffStatusUpdate(0, 0, 0));
            L2PcInstance.this.setShortBuffTaskSkillId(0);
        }
    }

    private class HerbTask
    implements Runnable {
        private final String _process;
        private final int _itemId;
        private final long _count;
        private final L2Object _reference;
        private final boolean _sendMessage;

        HerbTask(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
            this._process = process;
            this._itemId = itemId;
            this._count = count;
            this._reference = reference;
            this._sendMessage = sendMessage;
        }

        @Override
        public void run() {
            try {
                L2PcInstance.this.addItem(this._process, this._itemId, this._count, this._reference, this._sendMessage);
            }
            catch (Exception e) {
                L2Character._log.log(Level.WARNING, "", e);
            }
        }
    }

    private class PvPFlag
    implements Runnable {
        @Override
        public void run() {
            try {
                if (System.currentTimeMillis() > L2PcInstance.this.getPvpFlagLasts()) {
                    L2PcInstance.this.stopPvPFlag();
                } else if (System.currentTimeMillis() > L2PcInstance.this.getPvpFlagLasts() - 20000L) {
                    L2PcInstance.this.updatePvPFlag(2);
                } else {
                    L2PcInstance.this.updatePvPFlag(1);
                }
            }
            catch (Exception e) {
                L2Character._log.log(Level.WARNING, "error in pvp flag task:", e);
            }
        }
    }

    public static enum PunishLevel {
        NONE(0, ""),
        CHAT(1, "\u30c1\u30e3\u30c3\u30c8\u7981\u6b62"),
        JAIL(2, "GM\u76f8\u8ac7\u6240"),
        CHAR(3, "\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u51cd\u7d50"),
        ACC(4, "\u30a2\u30ab\u30a6\u30f3\u30c8\u51cd\u7d50");

        private final int punValue;
        private final String punString;

        private PunishLevel(int value, String string2) {
            this.punValue = value;
            this.punString = string2;
        }

        public int value() {
            return this.punValue;
        }

        public String string() {
            return this.punString;
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        public L2PcInstance getPlayer() {
            return L2PcInstance.this;
        }

        public void doPickupItem(L2Object object) {
            L2PcInstance.this.doPickupItem(object);
        }

        public void doInteract(L2Character target) {
            L2PcInstance.this.doInteract(target);
        }

        @Override
        public void doAttack(L2Character target) {
            super.doAttack(target);
            this.getPlayer().setRecentFakeDeath(false);
        }

        @Override
        public void doCast(L2Skill skill) {
            super.doCast(skill);
            this.getPlayer().setRecentFakeDeath(false);
        }
    }
}

