/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExCloseMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExMPCCPartyInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOpenMPCC;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import javolution.util.FastList;

public class L2CommandChannel {
    private final List<L2Party> _partys;
    private L2PcInstance _commandLeader = null;
    private int _channelLvl;

    public L2CommandChannel(L2PcInstance leader) {
        this._commandLeader = leader;
        this._partys = new FastList();
        this._partys.add(leader.getParty());
        this._channelLvl = leader.getParty().getLevel();
        leader.getParty().setCommandChannel(this);
        leader.getParty().broadcastToPartyMembers(SystemMessage.getSystemMessage(SystemMessageId.COMMAND_CHANNEL_FORMED));
        leader.getParty().broadcastToPartyMembers(new ExOpenMPCC());
    }

    public void addParty(L2Party party) {
        if (party == null) {
            return;
        }
        this.broadcastToChannelMembers(new ExMPCCPartyInfoUpdate(party, 1));
        this._partys.add(party);
        if (party.getLevel() > this._channelLvl) {
            this._channelLvl = party.getLevel();
        }
        party.setCommandChannel(this);
        party.broadcastToPartyMembers(SystemMessage.getSystemMessage(SystemMessageId.JOINED_COMMAND_CHANNEL));
        party.broadcastToPartyMembers(new ExOpenMPCC());
    }

    public void removeParty(L2Party party) {
        if (party == null) {
            return;
        }
        this._partys.remove(party);
        this._channelLvl = 0;
        for (L2Party pty : this._partys) {
            if (pty.getLevel() <= this._channelLvl) continue;
            this._channelLvl = pty.getLevel();
        }
        party.setCommandChannel(null);
        party.broadcastToPartyMembers(new ExCloseMPCC());
        if (this._partys.size() < 2) {
            this.broadcastToChannelMembers(SystemMessage.getSystemMessage(SystemMessageId.COMMAND_CHANNEL_DISBANDED));
            this.disbandChannel();
        } else {
            this.broadcastToChannelMembers(new ExMPCCPartyInfoUpdate(party, 0));
        }
    }

    public void disbandChannel() {
        if (this._partys != null) {
            for (L2Party party : this._partys) {
                if (party == null) continue;
                this.removeParty(party);
            }
        }
        this._partys.clear();
    }

    public int getMemberCount() {
        int count = 0;
        for (L2Party party : this._partys) {
            if (party == null) continue;
            count += party.getMemberCount();
        }
        return count;
    }

    public void broadcastToChannelMembers(L2GameServerPacket gsp) {
        if (this._partys != null && !this._partys.isEmpty()) {
            for (L2Party party : this._partys) {
                if (party == null) continue;
                party.broadcastToPartyMembers(gsp);
            }
        }
    }

    public void broadcastCSToChannelMembers(CreatureSay gsp, L2PcInstance broadcaster) {
        if (this._partys != null && !this._partys.isEmpty()) {
            for (L2Party party : this._partys) {
                if (party == null) continue;
                party.broadcastCSToPartyMembers(gsp, broadcaster);
            }
        }
    }

    public List<L2Party> getPartys() {
        return this._partys;
    }

    public List<L2PcInstance> getMembers() {
        FastList members = new FastList();
        for (L2Party party : this.getPartys()) {
            members.addAll(party.getPartyMembers());
        }
        return members;
    }

    public int getLevel() {
        return this._channelLvl;
    }

    public void setChannelLeader(L2PcInstance leader) {
        this._commandLeader = leader;
    }

    public L2PcInstance getChannelLeader() {
        return this._commandLeader;
    }

    public boolean meetRaidWarCondition(L2Object obj) {
        if (!(obj instanceof L2Character) || !((L2Character)obj).isRaid()) {
            return false;
        }
        return this.getMemberCount() >= Config.LOOT_RAIDS_PRIVILEGE_CC_SIZE;
    }
}

