/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.geoeditorcon;

import com.l2jserver.gameserver.geoeditorcon.GeoEditorThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoEditorListener
extends Thread {
    private static GeoEditorListener _instance;
    private static final int PORT = 9011;
    private static Logger _log;
    private ServerSocket _serverSocket = new ServerSocket(9011);
    private static GeoEditorThread _geoEditor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoEditorListener getInstance() {
        Class<GeoEditorListener> clazz = GeoEditorListener.class;
        synchronized (GeoEditorListener.class) {
            if (_instance == null) {
                try {
                    _instance = new GeoEditorListener();
                    _instance.start();
                    _log.info("GeoEditorListener Initialized.");
                }
                catch (IOException e) {
                    _log.log(Level.SEVERE, "Error creating geoeditor listener! " + e.getMessage(), e);
                    System.exit(1);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private GeoEditorListener() throws IOException {
    }

    public GeoEditorThread getThread() {
        return _geoEditor;
    }

    public String getStatus() {
        if (_geoEditor != null && _geoEditor.isWorking()) {
            return "Geoeditor connected.";
        }
        return "Geoeditor not connected.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket connection = null;
        try {
            try {
                while (true) {
                    connection = this._serverSocket.accept();
                    if (_geoEditor != null && _geoEditor.isWorking()) {
                        _log.warning("Geoeditor already connected!");
                        connection.close();
                        continue;
                    }
                    _log.info("Received geoeditor connection from: " + connection.getInetAddress().getHostAddress());
                    _geoEditor = new GeoEditorThread(connection);
                    _geoEditor.start();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "GeoEditorListener: " + e.getMessage(), e);
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this._serverSocket.close();
                }
                catch (IOException io) {
                    _log.log(Level.INFO, "", io);
                }
                _log.warning("GeoEditorListener Closed!");
            }
        }
        catch (Throwable throwable) {
            try {
                this._serverSocket.close();
            }
            catch (IOException io) {
                _log.log(Level.INFO, "", io);
            }
            _log.warning("GeoEditorListener Closed!");
            throw throwable;
        }
    }

    static {
        _log = Logger.getLogger(GeoEditorListener.class.getName());
    }
}

