﻿## Active Perl 5.8.8

# 目的：
#   サーバを待機状態にする。
#   サーバプログラムやデータベースの入れ替え作業用。
# 詳細：
#   __wait__ という名のファイルが存在すれば waitServer.bat に制御を移す。
#   waitServer.bat は __wait__ ファイルが存在する間中 sleep し続ける。
#   __wait__ ファイルが削除されると指定した動作を開始する。

use utf8;
use strict;
use warnings;
use Encode;

binmode STDOUT,':encoding(cp932)';
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

&start('gameserver/startGameServer.bat');
&start('login/startLoginServer.bat');
exit 0;

sub start {
	my ($filepath) = @_;

	print $filepath,"\n";
	open FILE,'<:encoding(cp932)',FS($filepath)  or die;
	read FILE, my $bat, -s FILE;
	close FILE;

	return if $bat =~ m/__wait__/;

	$bat =~ s/^:start$/:start
\@\@DEL __wait__ 2>NUL/m;
	$bat =~ s/^:end$/:end
\@\@IF EXIST __wait__ waitServer.bat \%0/m;

	open FILE,'>:encoding(cp932)',FS($filepath);
	print FILE $bat;
	close FILE;
}
