/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.ChristmasTree;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * NX}XKT^ 2004 ̏
 * @author  2006/12/05 EvolutionIǗl@[GM] тɂ http://l2je.ath.cx
 * @author  2010/07/23 JOJO  5802_Christmas/__init__.py  java ɏ
 */
public class ChristmasTree extends Quest
{
	private static final String qn = "ChristmasTree";

	//NPC
	private static final int SANTA_TRAINEE_A	= 31863;	//KT^()
	private static final int SANTA_TRAINEE_B	= 31864;	//KT^

	//ITEM
	private static final int ITEM_STAR_ORNAMENT		= 5556;	//c[FX^[ x4
	private static final int ITEM_BEAD_ORNAMENT		= 5557;	//c[F{[ x4
	private static final int ITEM_FIR_TREE_BRANCH	= 5558;	//c[F}   x10
	private static final int ITEM_FLOWER_POT		= 5559;	//c[F     x1

	private static final int ITEM_CHRISTMAS_TREE			= 5560;	//NX}X c[
	private static final int ITEM_SPECIAL_CHRISTMAS_TREE	= 5561;	//NX}X c[

	//OMAKE
	private static final int[][] REWARDS1 = {
	/*	{chance%,item,qty}	*/
		{ 10,  728, 10 },	//  2,000A }i |[V
		{ 10, 1539, 20 },	//    900A ̗͉񕜍
		{ 10, 6035, 10 },	//  2,400A @rx|[V
		{ 10, 1374,  8 },	//  3,000A ړx|[V
		{ 10,  735, 10 },	//  2,400A Ux|[V
		{ 10, 1540, 10 },	// 10,000A uԑ̗͉񕜍
		{ 10, 1375,  4 },	//  6,000A Ux|[V
		{ 10, 6036,  4 },	//  6,000A @rx|[V
		{ 99, 5234, 10 },	// 10,000A ~XeAX |[V
	};
	private static final int[][] REWARDS2 = {
	/*	{chance%,item,qty}	*/
		{  1, 6660,  1 },	//   616,000A NC[Ag O
		{  2, 6662,  1 },	//   870,000A RA O
		{  3,  959,  1 },	// 5,000,000A 틭XN[FSO[h
		{  4,  729,  1 },	// 1,800,000A 틭XN[FAO[h
		{  5,  947,  1 },	//   500,000A 틭XN[FBO[h
		{  6,  960,  1 },	//   500,000A hXN[FSO[h
		{  7,  730,  1 },	//   240,000A hXN[FAO[h
		{  8,  951,  1 },	//   110,000A 틭XN[FCO[h
		{  9,  948,  1 },	//    80,000A hXN[FBO[h
		{ 10,  955,  1 },	//    50,000A 틭XN[FDO[h
		{ 11,  952,  1 },	//    15,000A hXN[FCO[h
		{ 14,  956,  1 },	//     6,000A hXN[FDO[h
		{ 99, 1458,100 },	//       650A NX^FDO[h
	};
	private void giveRandamReward(QuestState st, int[][] rewardTable)
	{
		int rnd = st.getRandom(100);
		for (int[] e : rewardTable)
		{
			if ((rnd -= e[0]) < 0)
			{
				for (int i = 1; i < e.length; i+=2)
					st.giveItems(e[i + 0], e[i + 1]);
				break;
			}
		}
	}

	public ChristmasTree(int questId, String name, String descr)
	{
		super(questId, name, descr);
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		switch (npc.getNpcId())
		{
		case SANTA_TRAINEE_A: return "31863.htm";
		case SANTA_TRAINEE_B: return "31864.htm";
		}
		throw new AssertionError();
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		return "main.htm";
	}

	@Override
	public String onEvent(String event, QuestState st)
	{
		String htmltext = event;

		//iiƌ
		if (event.equals("1"))
		{
			if (st.getQuestItemsCount(ITEM_STAR_ORNAMENT) >= 4
			 && st.getQuestItemsCount(ITEM_BEAD_ORNAMENT) >= 4
			 && st.getQuestItemsCount(ITEM_FIR_TREE_BRANCH) >= 10
			 && st.getQuestItemsCount(ITEM_FLOWER_POT) >= 1)
			{
				st.takeItems(ITEM_STAR_ORNAMENT,4);		//c[FX^[
				st.takeItems(ITEM_BEAD_ORNAMENT,4);		//c[F{[
				st.takeItems(ITEM_FIR_TREE_BRANCH,10);	//c[F}
				st.takeItems(ITEM_FLOWER_POT,1);		//c[F
				
				st.giveItems(ITEM_CHRISTMAS_TREE,1);		//NX}X c[
				giveRandamReward(st, REWARDS1);				//܂
				
				return "1OK.htm";
			}
			else
			{
				return "1NG.htm";
			}
		}
		else if (event.equals("2"))
		{
			if (st.getQuestItemsCount(ITEM_CHRISTMAS_TREE) >= 10)
			{
				st.takeItems(ITEM_CHRISTMAS_TREE,10);
				
				st.giveItems(ITEM_SPECIAL_CHRISTMAS_TREE,1);	//NX}X c[
				giveRandamReward(st, REWARDS2);					//܂
				
				return "2OK.htm";
			}
			else
			{
				return "2NG.htm";
			}
		}
		else if (event.equals("3"))
		{
			if (st.getQuestItemsCount(ITEM_CHRISTMAS_TREE) >= 10)
			{
				st.takeItems(ITEM_CHRISTMAS_TREE,10);
			//	st.giveItems(5555,1);		//2004̏
			//	st.giveItems(7836,1);		//T^Xq
				st.giveItems(8936,1);		//T^̂Ƃ񂪂Xq
				return "3OK.htm";
			}
			else
			{
				return "3NG.htm";
			}
		}
		else if (event.equals("0"))
		{
			htmltext = "Trade has been canceled.";
		}
		
		return htmltext;
	}

	public static void main(String[] args)
	{
		Quest QUEST = new ChristmasTree(-1, qn, "events");
		QUEST.addStartNpc(SANTA_TRAINEE_A);
		QUEST.addStartNpc(SANTA_TRAINEE_B);
		QUEST.addFirstTalkId(SANTA_TRAINEE_A);
		QUEST.addFirstTalkId(SANTA_TRAINEE_B);
		QUEST.addTalkId(SANTA_TRAINEE_A);
		QUEST.addTalkId(SANTA_TRAINEE_B);
	}
}