/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.PyExtendedCursor;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class Procedure {
    protected static final int NAME = 3;
    protected static final int COLUMN_TYPE = 4;
    protected static final int DATA_TYPE = 5;
    protected static final int DATA_TYPE_NAME = 6;
    protected static final int PRECISION = 7;
    protected static final int LENGTH = 8;
    protected static final int SCALE = 9;
    protected static final int NULLABLE = 11;
    protected PyCursor cursor;
    protected PyObject columns;
    protected PyObject procedureCatalog;
    protected PyObject procedureSchema;
    protected PyObject procedureName;
    protected BitSet inputSet;

    public Procedure(PyCursor pyCursor, PyObject pyObject) throws SQLException {
        this.cursor = pyCursor;
        this.inputSet = new BitSet();
        if (pyObject instanceof PyString) {
            this.procedureCatalog = this.getDefault();
            this.procedureSchema = this.getDefault();
            this.procedureName = pyObject;
        } else if (PyCursor.isSeq(pyObject) && pyObject.__len__() == 3) {
            this.procedureCatalog = pyObject.__getitem__(0);
            this.procedureSchema = pyObject.__getitem__(1);
            this.procedureName = pyObject.__getitem__(2);
        }
        this.fetchColumns();
    }

    public CallableStatement prepareCall() throws SQLException {
        return this.prepareCall(Py.None, Py.None);
    }

    public CallableStatement prepareCall(PyObject pyObject, PyObject pyObject2) throws SQLException {
        Statement statement = null;
        boolean bl = pyObject == Py.None && pyObject2 == Py.None;
        try {
            String string = this.toSql();
            if (bl) {
                statement = this.cursor.connection.connection.prepareCall(string);
            } else {
                int n = ((PyInteger)pyObject.__int__()).getValue();
                int n2 = ((PyInteger)pyObject2.__int__()).getValue();
                statement = this.cursor.connection.connection.prepareCall(string, n, n2);
            }
            this.registerOutParameters((CallableStatement)statement);
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw sQLException;
        }
        return statement;
    }

    public void normalizeInput(PyObject pyObject, PyObject pyObject2) throws SQLException {
        if (this.columns == Py.None) {
            return;
        }
        int n = this.columns.__len__();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PyObject pyObject3 = this.columns.__getitem__(i);
            int n3 = ((PyInteger)pyObject3.__getitem__(4).__int__()).getValue();
            switch (n3) {
                case 1: 
                case 2: {
                    PyInteger pyInteger = Py.newInteger(n2++);
                    if (pyObject2.__finditem__(pyInteger) == null) {
                        int n4 = ((PyInteger)pyObject3.__getitem__(5).__int__()).getValue();
                        pyObject2.__setitem__(pyInteger, (PyObject)Py.newInteger(n4));
                    }
                    this.inputSet.set(i + 1);
                }
            }
        }
    }

    public boolean isInput(int n) throws SQLException {
        return this.inputSet.get(n);
    }

    public String toSql() throws SQLException {
        PyObject pyObject;
        int n = 0;
        int n2 = 0;
        if (this.columns != Py.None) {
            int n3 = this.columns.__len__();
            block6: for (int i = 0; i < n3; ++i) {
                pyObject = this.columns.__getitem__(i);
                int n4 = ((PyInteger)pyObject.__getitem__(4).__int__()).getValue();
                switch (n4) {
                    case 0: {
                        throw zxJDBC.makeException(zxJDBC.NotSupportedError, "procedureColumnUnknown");
                    }
                    case 3: {
                        throw zxJDBC.makeException(zxJDBC.NotSupportedError, "procedureColumnResult");
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        ++n;
                        continue block6;
                    }
                    case 5: {
                        ++n2;
                        continue block6;
                    }
                    default: {
                        throw zxJDBC.makeException(zxJDBC.DataError, "unknown column type [" + n4 + "]");
                    }
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        if (n2 > 0) {
            PyList pyList = new PyList();
            while (n2 > 0) {
                pyList.append(Py.newString("?"));
                --n2;
            }
            stringBuffer.append(Py.newString(",").join(pyList)).append(" = ");
        }
        String string = this.getProcedureName();
        stringBuffer.append("call ").append(string).append("(");
        if (n > 0) {
            pyObject = new PyList();
            while (n > 0) {
                ((PyList)pyObject).append(Py.newString("?"));
                --n;
            }
            stringBuffer.append(Py.newString(",").join(pyObject));
        }
        return stringBuffer.append(")}").toString();
    }

    protected void registerOutParameters(CallableStatement callableStatement) throws SQLException {
        if (this.columns == Py.None) {
            return;
        }
        int n = this.columns.__len__();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = this.columns.__getitem__(i);
            int n2 = ((PyInteger)pyObject.__getitem__(4).__int__()).getValue();
            int n3 = ((PyInteger)pyObject.__getitem__(5).__int__()).getValue();
            String string = pyObject.__getitem__(6).toString();
            switch (n2) {
                case 2: 
                case 4: 
                case 5: {
                    this.cursor.datahandler.registerOut(callableStatement, i + 1, n2, n3, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchColumns() throws SQLException {
        PyExtendedCursor pyExtendedCursor = (PyExtendedCursor)this.cursor.connection.cursor();
        try {
            pyExtendedCursor.datahandler = this.cursor.datahandler;
            pyExtendedCursor.procedurecolumns(this.procedureCatalog, this.procedureSchema, this.procedureName, Py.None);
            this.columns = pyExtendedCursor.fetchall();
        }
        finally {
            pyExtendedCursor.close();
        }
    }

    protected PyObject getDefault() {
        return Py.EmptyString;
    }

    protected String getProcedureName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.procedureCatalog.__nonzero__()) {
            stringBuffer.append(this.procedureCatalog.toString()).append(".");
        }
        return stringBuffer.append(this.procedureName.toString()).toString();
    }
}

