/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javolution.lang.Reusable;
import javolution.util.FastSet;

public class WeakFastSet<E>
implements Set<E>,
Reusable {
    private ReferenceQueue<E> queue = new ReferenceQueue();
    private FastSet<WeakReference<E>> set;

    public WeakFastSet() {
        this.set = new FastSet();
    }

    public WeakFastSet(boolean shared) {
        this();
        if (shared) {
            this.set.shared();
        }
    }

    public WeakFastSet(int capacity, boolean shared) {
        this.set = new FastSet(capacity);
        if (shared) {
            this.set.shared();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.processQueue();
        final Iterator<WeakReference<E>> i = this.set.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public E next() {
                return WeakFastSet.this.getReferenceObject((WeakElement)i.next());
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(WeakElement.create(o));
    }

    @Override
    public boolean add(E o) {
        this.processQueue();
        return this.set.add(WeakElement.create(o, this.queue));
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.set.remove(WeakElement.create(o));
        this.processQueue();
        return ret;
    }

    private final E getReferenceObject(WeakReference<E> ref) {
        return ref == null ? null : (E)ref.get();
    }

    private final void processQueue() {
        WeakElement we = null;
        while ((we = (WeakElement)this.queue.poll()) != null) {
            this.set.remove(we);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.set.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.set.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (size != a.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    @Override
    public void reset() {
        this.clear();
    }

    private static class WeakElement<E>
    extends WeakReference<E> {
        private int hash;

        private WeakElement(E o) {
            super(o);
            this.hash = o.hashCode();
        }

        private WeakElement(E o, ReferenceQueue<E> q) {
            super(o, q);
            this.hash = o.hashCode();
        }

        private static <E> WeakElement<E> create(E o) {
            return o == null ? null : new WeakElement<E>(o);
        }

        private static <E> WeakElement<E> create(E o, ReferenceQueue<E> q) {
            return o == null ? null : new WeakElement<E>(o, q);
        }

        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakElement)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((WeakElement)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

