/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public enum BaseStats {
    STR(new STR()),
    INT(new INT()),
    DEX(new DEX()),
    WIT(new WIT()),
    CON(new CON()),
    MEN(new MEN()),
    NULL(new NULL());

    protected static final Logger _log;
    public static final int MAX_STAT_VALUE = 100;
    private static final double[] STRbonus;
    private static final double[] INTbonus;
    private static final double[] DEXbonus;
    private static final double[] WITbonus;
    private static final double[] CONbonus;
    private static final double[] MENbonus;
    private final BaseStat _stat;

    public final String getValue() {
        return this._stat.getClass().getSimpleName();
    }

    private BaseStats(BaseStat s) {
        this._stat = s;
    }

    public final double calcBonus(L2Character actor) {
        if (actor != null) {
            return this._stat.calcBonus(actor);
        }
        return 1.0;
    }

    public static final BaseStats valueOfXml(String name) {
        name = name.intern();
        for (BaseStats s : BaseStats.values()) {
            if (!s.getValue().equalsIgnoreCase(name)) continue;
            return s;
        }
        throw new NoSuchElementException("Unknown name '" + name + "' for enum BaseStats");
    }

    static {
        _log = Logger.getLogger(BaseStats.class.getName());
        STRbonus = new double[100];
        INTbonus = new double[100];
        DEXbonus = new double[100];
        WITbonus = new double[100];
        CONbonus = new double[100];
        MENbonus = new double[100];
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/statBonus.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "[BaseStats] Could not parse file: " + e.getMessage(), e);
            }
            for (Node list = doc.getFirstChild(); list != null; list = list.getNextSibling()) {
                if (!"list".equalsIgnoreCase(list.getNodeName())) continue;
                for (Node stat = list.getFirstChild(); stat != null; stat = stat.getNextSibling()) {
                    String statName = stat.getNodeName();
                    for (Node value = stat.getFirstChild(); value != null; value = value.getNextSibling()) {
                        double bonus;
                        if (!"stat".equalsIgnoreCase(value.getNodeName())) continue;
                        NamedNodeMap attrs = value.getAttributes();
                        try {
                            int val = Integer.parseInt(attrs.getNamedItem("value").getNodeValue());
                            bonus = Double.parseDouble(attrs.getNamedItem("bonus").getNodeValue());
                        }
                        catch (Exception e) {
                            _log.severe("[BaseStats] Invalid stats value: " + value.getNodeValue() + ", skipping");
                            continue;
                        }
                        if ("STR".equalsIgnoreCase(statName)) {
                            BaseStats.STRbonus[val] = bonus;
                            continue;
                        }
                        if ("INT".equalsIgnoreCase(statName)) {
                            BaseStats.INTbonus[val] = bonus;
                            continue;
                        }
                        if ("DEX".equalsIgnoreCase(statName)) {
                            BaseStats.DEXbonus[val] = bonus;
                            continue;
                        }
                        if ("WIT".equalsIgnoreCase(statName)) {
                            BaseStats.WITbonus[val] = bonus;
                            continue;
                        }
                        if ("CON".equalsIgnoreCase(statName)) {
                            BaseStats.CONbonus[val] = bonus;
                            continue;
                        }
                        if ("MEN".equalsIgnoreCase(statName)) {
                            BaseStats.MENbonus[val] = bonus;
                            continue;
                        }
                        _log.severe("[BaseStats] Invalid stats name: " + statName + ", skipping");
                    }
                }
            }
        } else {
            throw new Error("[BaseStats] File not found: " + file.getName());
        }
    }

    private static final class NULL
    implements BaseStat {
        private NULL() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return 1.0;
        }
    }

    private static final class MEN
    implements BaseStat {
        private MEN() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return MENbonus[actor.getMEN()];
        }
    }

    private static final class CON
    implements BaseStat {
        private CON() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return CONbonus[actor.getCON()];
        }
    }

    private static final class WIT
    implements BaseStat {
        private WIT() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return WITbonus[actor.getWIT()];
        }
    }

    private static final class DEX
    implements BaseStat {
        private DEX() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return DEXbonus[actor.getDEX()];
        }
    }

    private static final class INT
    implements BaseStat {
        private INT() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return INTbonus[actor.getINT()];
        }
    }

    private static final class STR
    implements BaseStat {
        private STR() {
        }

        @Override
        public final double calcBonus(L2Character actor) {
            return STRbonus[actor.getSTR()];
        }
    }

    private static interface BaseStat {
        public double calcBonus(L2Character var1);
    }
}

