/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Transformation;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public final class UserInfo
extends L2GameServerPacket {
    private static final String _S__04_USERINFO = "[S] 32 UserInfo";
    private L2PcInstance _activeChar;
    private int _runSpd;
    private int _walkSpd;
    private int _relation;
    private float _moveMultiplier;
    private int _territoryId;
    private boolean _isDisguised;
    private int _airShipHelm;

    public UserInfo(L2PcInstance character) {
        this._activeChar = character;
        this._moveMultiplier = this._activeChar.getMovementSpeedMultiplier();
        this._runSpd = Math.round((float)this._activeChar.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = (int)((float)this._activeChar.getWalkSpeed() / this._moveMultiplier);
        this._territoryId = TerritoryWarManager.getInstance().getRegisteredTerritoryId(character);
        int n = this._relation = this._activeChar.isClanLeader() ? 64 : 0;
        if (this._activeChar.getSiegeState() == 1) {
            this._relation = this._territoryId == 0 ? (this._relation |= 0x180) : (this._relation |= 0x1000);
        }
        if (this._activeChar.getSiegeState() == 2) {
            this._relation |= 0x80;
        }
        this._isDisguised = TerritoryWarManager.getInstance().isDisguised(character.getObjectId());
        this._airShipHelm = this._activeChar.isInAirShip() && this._activeChar.getAirShip().isCaptain(this._activeChar) ? this._activeChar.getAirShip().getHelmItemId() : 0;
    }

    @Override
    protected final void writeImpl() {
        L2NpcTemplate polyObj;
        this.writeC(50);
        this.writeD(this._activeChar.getX());
        this.writeD(this._activeChar.getY());
        this.writeD(this._activeChar.getZ());
        if (this._activeChar.getVehicle() != null) {
            this.writeD(this._activeChar.getVehicle().getObjectId());
        } else {
            this.writeD(0);
        }
        this.writeD(this._activeChar.getObjectId());
        this.writeS(this._activeChar.getName());
        this.writeD(this._activeChar.getRace().ordinal());
        this.writeD(this._activeChar.getAppearance().getSex() ? 1 : 0);
        if (this._activeChar.getClassIndex() == 0) {
            this.writeD(this._activeChar.getClassId().getId());
        } else {
            this.writeD(this._activeChar.getBaseClass());
        }
        this.writeD(this._activeChar.getLevel());
        this.writeQ(this._activeChar.getExp());
        this.writeD(this._activeChar.getSTR());
        this.writeD(this._activeChar.getDEX());
        this.writeD(this._activeChar.getCON());
        this.writeD(this._activeChar.getINT());
        this.writeD(this._activeChar.getWIT());
        this.writeD(this._activeChar.getMEN());
        this.writeD(this._activeChar.getMaxVisibleHp());
        this.writeD((int)this._activeChar.getCurrentHp());
        this.writeD(this._activeChar.getMaxMp());
        this.writeD((int)this._activeChar.getCurrentMp());
        this.writeD(this._activeChar.getSp());
        this.writeD(this._activeChar.getCurrentLoad());
        this.writeD(this._activeChar.getMaxLoad());
        this.writeD(this._activeChar.getActiveWeaponItem() != null ? 40 : 20);
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(0));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(1));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(2));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(4));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(6));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(5));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(8));
        if (this._airShipHelm == 0) {
            this.writeD(this._activeChar.getInventory().getPaperdollObjectId(9));
            this.writeD(this._activeChar.getInventory().getPaperdollObjectId(10));
        } else {
            this.writeD(0);
            this.writeD(0);
        }
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(11));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(12));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(13));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(14));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(15));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(16));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(18));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(20));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(22));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(23));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(24));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(25));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(26));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(27));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(28));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(29));
        this.writeD(this._activeChar.getInventory().getPaperdollObjectId(30));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(0));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(1));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(2));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(4));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(6));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(5));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(8));
        if (this._airShipHelm == 0) {
            this.writeD(this._activeChar.getInventory().getPaperdollItemId(9));
            this.writeD(this._activeChar.getInventory().getPaperdollItemId(10));
        } else {
            this.writeD(this._airShipHelm);
            this.writeD(0);
        }
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(11));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(12));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(13));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(14));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(15));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(16));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(18));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(20));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(22));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(23));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(24));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(25));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(26));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(27));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(28));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(29));
        this.writeD(this._activeChar.getInventory().getPaperdollItemId(30));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(0));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(1));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(2));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(4));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(6));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(5));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(8));
        if (this._airShipHelm == 0) {
            this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(9));
            this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(10));
        } else {
            this.writeD(0);
            this.writeD(0);
        }
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(11));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(12));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(13));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(14));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(15));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(16));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(18));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(20));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(22));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(23));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(24));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(25));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(26));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(27));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(28));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(29));
        this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(30));
        this.writeD(this._activeChar.getInventory().getMaxTalismanCount());
        this.writeD(this._activeChar.getInventory().getCloakStatus());
        this.writeD(this._activeChar.getPAtk(null));
        this.writeD(this._activeChar.getPAtkSpd());
        this.writeD(this._activeChar.getPDef(null));
        this.writeD(this._activeChar.getEvasionRate(null));
        this.writeD(this._activeChar.getAccuracy());
        this.writeD(this._activeChar.getCriticalHit(null, null));
        this.writeD(this._activeChar.getMAtk(null, null));
        this.writeD(this._activeChar.getMAtkSpd());
        this.writeD(this._activeChar.getPAtkSpd());
        this.writeD(this._activeChar.getMDef(null, null));
        this.writeD(this._activeChar.getPvpFlag());
        this.writeD(this._activeChar.getKarma());
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(0);
        this.writeD(0);
        this.writeD(this._activeChar.isFlying() ? this._runSpd : 0);
        this.writeD(this._activeChar.isFlying() ? this._walkSpd : 0);
        this.writeF(this._moveMultiplier);
        this.writeF(this._activeChar.getAttackSpeedMultiplier());
        L2Summon pet = this._activeChar.getPet();
        if (this._activeChar.getMountType() != 0 && pet != null) {
            this.writeF(pet.getTemplate().fCollisionRadius);
            this.writeF(pet.getTemplate().fCollisionHeight);
        } else {
            L2Transformation trans = this._activeChar.getTransformation();
            if (trans != null) {
                this.writeF(trans.getCollisionRadius());
                this.writeF(trans.getCollisionHeight());
            } else {
                this.writeF(this._activeChar.getCollisionRadius());
                this.writeF(this._activeChar.getCollisionHeight());
            }
        }
        this.writeD(this._activeChar.getAppearance().getHairStyle());
        this.writeD(this._activeChar.getAppearance().getHairColor());
        this.writeD(this._activeChar.getAppearance().getFace());
        this.writeD(this._activeChar.isGM() ? 1 : 0);
        String title = this._activeChar.getTitle();
        if (this._activeChar.getAppearance().getInvisible() && this._activeChar.isGM()) {
            title = "Invisible";
        }
        if (this._activeChar.getPoly().isMorphed() && (polyObj = NpcTable.getInstance().getTemplate(this._activeChar.getPoly().getPolyId())) != null) {
            title = title + " - " + polyObj.name;
        }
        this.writeS(title);
        this.writeD(this._activeChar.getClanId());
        this.writeD(this._activeChar.getClanCrestId());
        this.writeD(this._activeChar.getAllyId());
        this.writeD(this._activeChar.getAllyCrestId());
        this.writeD(this._relation);
        this.writeC(this._activeChar.getMountType());
        this.writeC(this._activeChar.getPrivateStoreType());
        this.writeC(this._activeChar.hasDwarvenCraft() ? 1 : 0);
        this.writeD(this._activeChar.getPkKills());
        this.writeD(this._activeChar.getPvpKills());
        this.writeH(this._activeChar.getCubics().size());
        for (int id : this._activeChar.getCubics().keySet()) {
            this.writeH(id);
        }
        this.writeC(this._activeChar.isInPartyMatchRoom() ? 1 : 0);
        if (this._activeChar.getAppearance().getInvisible() && this._activeChar.isGM()) {
            this.writeD(this._activeChar.getAbnormalEffect() | AbnormalEffect.STEALTH.getMask());
        } else {
            this.writeD(this._activeChar.getAbnormalEffect());
        }
        this.writeC(this._activeChar.isFlyingMounted() ? 2 : 0);
        this.writeD(this._activeChar.getClanPrivileges());
        this.writeH(this._activeChar.getRecomLeft());
        this.writeH(this._activeChar.getRecomHave());
        this.writeD(this._activeChar.getMountNpcId() > 0 ? this._activeChar.getMountNpcId() + 1000000 : 0);
        this.writeH(this._activeChar.getInventoryLimit());
        this.writeD(this._activeChar.getClassId().getId());
        this.writeD(0);
        this.writeD(this._activeChar.getMaxCp());
        this.writeD((int)this._activeChar.getCurrentCp());
        this.writeC(this._activeChar.isMounted() || this._airShipHelm != 0 ? 0 : this._activeChar.getEnchantEffect());
        if (this._activeChar.getTeam() == 1) {
            this.writeC(1);
        } else if (this._activeChar.getTeam() == 2) {
            this.writeC(2);
        } else {
            this.writeC(0);
        }
        this.writeD(this._activeChar.getClanCrestLargeId());
        this.writeC(this._activeChar.isNoble() ? 1 : 0);
        this.writeC(this._activeChar.isHero() || this._activeChar.isGM() && Config.GM_HERO_AURA || this._activeChar.aura ? 1 : 0);
        this.writeC(this._activeChar.isFishing() ? 1 : 0);
        this.writeD(this._activeChar.getFishx());
        this.writeD(this._activeChar.getFishy());
        this.writeD(this._activeChar.getFishz());
        this.writeD(this._activeChar.getAppearance().getNameColor());
        this.writeC(this._activeChar.isRunning() ? 1 : 0);
        this.writeD(this._activeChar.getPledgeClass());
        this.writeD(this._activeChar.getPledgeType());
        this.writeD(this._activeChar.getAppearance().getTitleColor());
        if (this._activeChar.isCursedWeaponEquipped()) {
            this.writeD(CursedWeaponsManager.getInstance().getLevel(this._activeChar.getCursedWeaponEquippedId()));
        } else {
            this.writeD(0);
        }
        this.writeD(this._activeChar.getTransformationId());
        byte attackAttribute = this._activeChar.getAttackElement();
        this.writeH(attackAttribute);
        this.writeH(this._activeChar.getAttackElementValue(attackAttribute));
        this.writeH(this._activeChar.getDefenseElementValue((byte)0));
        this.writeH(this._activeChar.getDefenseElementValue((byte)1));
        this.writeH(this._activeChar.getDefenseElementValue((byte)2));
        this.writeH(this._activeChar.getDefenseElementValue((byte)3));
        this.writeH(this._activeChar.getDefenseElementValue((byte)4));
        this.writeH(this._activeChar.getDefenseElementValue((byte)5));
        this.writeD(this._activeChar.getAgathionId());
        this.writeD(this._activeChar.getFame());
        this.writeD(this._activeChar.isMinimapAllowed() ? 1 : 0);
        this.writeD(this._activeChar.getVitalityPoints());
        this.writeD(this._activeChar.getSpecialEffect());
        this.writeD(this._territoryId);
        this.writeD(this._isDisguised ? 1 : 0);
        this.writeD(this._territoryId);
    }

    @Override
    public String getType() {
        return _S__04_USERINFO;
    }
}

