/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;

public final class StatusUpdate
extends L2GameServerPacket {
    private static final String _S__1A_STATUSUPDATE = "[S] 18 StatusUpdate";
    private static final int HP_MOD = 10000000;
    public static final int LEVEL = 1;
    public static final int EXP = 2;
    public static final int STR = 3;
    public static final int DEX = 4;
    public static final int CON = 5;
    public static final int INT = 6;
    public static final int WIT = 7;
    public static final int MEN = 8;
    public static final int CUR_HP = 9;
    public static final int MAX_HP = 10;
    public static final int CUR_MP = 11;
    public static final int MAX_MP = 12;
    public static final int SP = 13;
    public static final int CUR_LOAD = 14;
    public static final int MAX_LOAD = 15;
    public static final int P_ATK = 17;
    public static final int ATK_SPD = 18;
    public static final int P_DEF = 19;
    public static final int EVASION = 20;
    public static final int ACCURACY = 21;
    public static final int CRITICAL = 22;
    public static final int M_ATK = 23;
    public static final int CAST_SPD = 24;
    public static final int M_DEF = 25;
    public static final int PVP_FLAG = 26;
    public static final int KARMA = 27;
    public static final int CUR_CP = 33;
    public static final int MAX_CP = 34;
    private int _objectId;
    private int _maxHp = -1;
    private ArrayList<Attribute> _attributes = new ArrayList();

    public StatusUpdate(int objectId) {
        this._objectId = objectId;
        L2Object obj = L2World.getInstance().findObject(objectId);
        if (obj != null && obj instanceof L2Attackable) {
            this._maxHp = ((L2Character)obj).getMaxVisibleHp();
        }
    }

    public StatusUpdate(L2Object object) {
        this._objectId = object.getObjectId();
        if (object instanceof L2Attackable) {
            this._maxHp = ((L2Character)object).getMaxVisibleHp();
        }
    }

    public void addAttribute(int id, int level) {
        if (this._maxHp != -1) {
            if (id == 10) {
                level = 10000000;
            } else if (id == 9) {
                level = (int)((float)level / (float)this._maxHp * 1.0E7f);
            }
        }
        this._attributes.add(new Attribute(id, level));
    }

    @Override
    protected final void writeImpl() {
        this.writeC(24);
        this.writeD(this._objectId);
        this.writeD(this._attributes.size());
        for (Attribute temp : this._attributes) {
            this.writeD(temp.id);
            this.writeD(temp.value);
        }
    }

    @Override
    public String getType() {
        return _S__1A_STATUSUPDATE;
    }

    class Attribute {
        public int id;
        public int value;

        Attribute(int pId, int pValue) {
            this.id = pId;
            this.value = pValue;
        }
    }
}

