/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellListPacket;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.util.Util;
import java.util.List;

public final class RequestSellItem
extends L2GameClientPacket {
    private static final String _C__1E_REQUESTSELLITEM = "[C] 1E RequestSellItem";
    private static final int BATCH_LENGTH = 16;
    private int _listId;
    private Item[] _items = null;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 16 != this._buf.remaining()) {
            return;
        }
        this._items = new Item[count];
        for (int i = 0; i < count; ++i) {
            int objectId = this.readD();
            int itemId = this.readD();
            long cnt = this.readQ();
            if (objectId < 1 || itemId < 1 || cnt < 1L) {
                this._items = null;
                return;
            }
            this._items[i] = new Item(objectId, itemId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        this.processSell();
    }

    protected void processSell() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("buy")) {
            player.sendMessage("You buying too fast.");
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && player.getKarma() > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object target = player.getTarget();
        if (!(player.isGM() || target != null && (target instanceof L2MerchantInstance || target instanceof L2MerchantSummonInstance) && target.getInstanceId() == player.getInstanceId() && player.isInsideRadius(target, 150, true, false))) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Character merchant = null;
        double taxRate = 0.0;
        if (target instanceof L2MerchantInstance || target instanceof L2MerchantSummonInstance) {
            merchant = (L2Character)target;
        } else if (!player.isGM()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2TradeList list = null;
        if (merchant != null) {
            List<L2TradeList> lists;
            if (merchant instanceof L2MerchantInstance) {
                lists = TradeController.getInstance().getBuyListByNpcId(((L2MerchantInstance)merchant).getNpcId());
                taxRate = ((L2MerchantInstance)merchant).getMpc().getTotalTaxRate();
            } else {
                lists = TradeController.getInstance().getBuyListByNpcId(((L2MerchantSummonInstance)merchant).getNpcId());
                taxRate = 50.0;
            }
            if (!player.isGM()) {
                if (lists == null) {
                    Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
                    return;
                }
                for (L2TradeList tradeList : lists) {
                    if (tradeList.getListId() != this._listId) continue;
                    list = tradeList;
                }
            } else {
                list = TradeController.getInstance().getBuyList(this._listId);
            }
        } else {
            list = TradeController.getInstance().getBuyList(this._listId);
        }
        if (list == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        long totalPrice = 0L;
        for (Item i : this._items) {
            L2ItemInstance item = player.checkItemManipulation(i.getObjectId(), i.getCount(), "sell");
            if (item == null || !item.isSellable()) continue;
            long price = item.getReferencePrice() / 2;
            if (99900000000L / i.getCount() < price || (totalPrice += price * i.getCount()) > 99900000000L) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + 99900000000L + " adena worth of goods.", Config.DEFAULT_PUNISH);
                return;
            }
            item = Config.ALLOW_REFUND ? player.getInventory().transferItem("Sell", i.getObjectId(), i.getCount(), player.getRefund(), player, merchant) : player.getInventory().destroyItem("Sell", i.getObjectId(), i.getCount(), player, (L2Object)merchant);
        }
        player.addAdena("Sell", totalPrice, merchant, false);
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.sendPacket(new ExBuySellListPacket(player, list, taxRate, true));
    }

    @Override
    public String getType() {
        return _C__1E_REQUESTSELLITEM;
    }

    private class Item {
        private final int _objectId;
        private final int _itemId;
        private final long _count;

        public Item(int objId, int id, long num) {
            this._objectId = objId;
            this._itemId = id;
            this._count = num;
        }

        public int getObjectId() {
            return this._objectId;
        }

        public int getItemId() {
            return this._itemId;
        }

        public long getCount() {
            return this._count;
        }
    }
}

