/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.ArrayList;
import java.util.List;

public final class RequestSaveInventoryOrder
extends L2GameClientPacket {
    private List<InventoryOrder> _order;
    private static final int LIMIT = 125;

    @Override
    protected void readImpl() {
        int sz = this.readD();
        sz = Math.min(sz, 125);
        this._order = new ArrayList<InventoryOrder>(sz);
        for (int i = 0; i < sz; ++i) {
            int objectId = this.readD();
            int order = this.readD();
            this._order.add(new InventoryOrder(objectId, order));
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player != null) {
            PcInventory inventory = player.getInventory();
            for (InventoryOrder order : this._order) {
                L2ItemInstance item = inventory.getItemByObjectId(order.objectID);
                if (item == null || item.getLocation() != L2ItemInstance.ItemLocation.INVENTORY) continue;
                item.setLocation(L2ItemInstance.ItemLocation.INVENTORY, order.order);
            }
        }
    }

    @Override
    public String getType() {
        return "[C] D0:49 RequestSaveInventoryOrder";
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }

    private class InventoryOrder {
        int order;
        int objectID;

        public InventoryOrder(int id, int ord) {
            this.objectID = id;
            this.order = ord;
        }
    }
}

