/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExShowBaseAttributeCancelWindow;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.item.L2Weapon;

public class RequestExRemoveItemAttribute
extends L2GameClientPacket {
    private static String _C__D0_23_REQUESTEXREMOVEITEMATTRIBUTE = "[C] D0:23 RequestExRemoveItemAttribute";
    private int _objectId;
    private long _price;

    @Override
    public void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    public void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance targetItem = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (targetItem == null) {
            return;
        }
        if (targetItem.getElementals() == null) {
            return;
        }
        if (activeChar.reduceAdena("RemoveElement", this.getPrice(targetItem), activeChar, true)) {
            if (targetItem.isEquipped()) {
                targetItem.getElementals().removeBonus(activeChar);
            }
            targetItem.clearElementAttr();
            activeChar.sendPacket(new UserInfo(activeChar));
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(targetItem);
            activeChar.sendPacket(iu);
            if (targetItem.getEnchantLevel() > 0) {
                SystemMessage sm = new SystemMessage(SystemMessageId.S1_S2_ELEMENTAL_POWER_REMOVED);
                sm.addNumber(targetItem.getEnchantLevel());
                sm.addItemName(targetItem);
                activeChar.sendPacket(sm);
            } else {
                SystemMessage sm = new SystemMessage(SystemMessageId.S1_ELEMENTAL_POWER_REMOVED);
                sm.addItemName(targetItem);
                activeChar.sendPacket(sm);
            }
            activeChar.sendPacket(new ExShowBaseAttributeCancelWindow(activeChar));
            return;
        }
        activeChar.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
    }

    private long getPrice(L2ItemInstance item) {
        switch (item.getItem().getCrystalType()) {
            case 5: {
                if (item.getItem() instanceof L2Weapon) {
                    this._price = 50000L;
                    break;
                }
                this._price = 40000L;
                break;
            }
            case 6: {
                if (item.getItem() instanceof L2Weapon) {
                    this._price = 100000L;
                    break;
                }
                this._price = 80000L;
                break;
            }
            case 7: {
                this._price = item.getItem() instanceof L2Weapon ? 200000L : 160000L;
            }
        }
        return this._price;
    }

    @Override
    public String getType() {
        return _C__D0_23_REQUESTEXREMOVEITEMATTRIBUTE;
    }
}

