/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2ManorManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.util.Util;

public class RequestBuySeed
extends L2GameClientPacket {
    private static final String _C__C4_REQUESTBUYSEED = "[C] C4 RequestBuySeed";
    private static final int BATCH_LENGTH = 12;
    private int _manorId;
    private Seed[] _seeds = null;

    @Override
    protected void readImpl() {
        this._manorId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._seeds = new Seed[count];
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long cnt = this.readQ();
            if (cnt < 1L) {
                this._seeds = null;
                return;
            }
            this._seeds[i] = new Seed(itemId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getManor().tryPerformAction("BuySeed")) {
            return;
        }
        if (this._seeds == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object manager = player.getTarget();
        if (!(manager instanceof L2ManorManagerInstance)) {
            manager = player.getLastFolkNPC();
        }
        if (!(manager instanceof L2ManorManagerInstance)) {
            return;
        }
        if (!player.isInsideRadius(manager, 150, true, false)) {
            return;
        }
        Castle castle = CastleManager.getInstance().getCastleById(this._manorId);
        long totalPrice = 0L;
        int slots = 0;
        int totalWeight = 0;
        for (Seed i : this._seeds) {
            if (!i.setProduction(castle)) {
                return;
            }
            if ((totalPrice += i.getPrice()) > 99900000000L) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + 99900000000L + " adena worth of goods.", Config.DEFAULT_PUNISH);
                return;
            }
            L2Item template = ItemTable.getInstance().getTemplate(i.getSeedId());
            totalWeight = (int)((long)totalWeight + i.getCount() * (long)template.getWeight());
            if (!template.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (player.getInventory().getItemByItemId(i.getSeedId()) != null) continue;
            ++slots;
        }
        if (!player.getInventory().validateWeight(totalWeight)) {
            this.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            this.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return;
        }
        if (totalPrice < 0L || !player.reduceAdena("Buy", totalPrice, manager, false)) {
            this.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            return;
        }
        castle.addToTreasuryNoTax(totalPrice);
        InventoryUpdate playerIU = new InventoryUpdate();
        for (Seed i : this._seeds) {
            i.updateProduction(castle);
            L2ItemInstance item = player.getInventory().addItem("Buy", i.getSeedId(), i.getCount(), player, manager);
            if (item.getCount() > i.getCount()) {
                playerIU.addModifiedItem(item);
            } else {
                playerIU.addNewItem(item);
            }
            SystemMessage sm = null;
            sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
            sm.addItemName(item);
            sm.addItemNumber(i.getCount());
            player.sendPacket(sm);
        }
        player.sendPacket(playerIU);
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__C4_REQUESTBUYSEED;
    }

    private class Seed {
        private final int _seedId;
        private final long _count;
        CastleManorManager.SeedProduction _seed;

        public Seed(int id, long num) {
            this._seedId = id;
            this._count = num;
        }

        public int getSeedId() {
            return this._seedId;
        }

        public long getCount() {
            return this._count;
        }

        public long getPrice() {
            return this._seed.getPrice() * this._count;
        }

        public boolean setProduction(Castle c) {
            this._seed = c.getSeed(this._seedId, 0);
            if (this._seed.getPrice() <= 0L) {
                return false;
            }
            if (this._seed.getCanProduce() < this._count) {
                return false;
            }
            return 99900000000L / this._count >= this._seed.getPrice();
        }

        public void updateProduction(Castle c) {
            this._seed.setCanProduce(this._seed.getCanProduce() - this._count);
            if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
                c.updateSeed(this._seedId, this._seed.getCanProduce(), 0);
            }
        }
    }
}

