/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Multisell;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.util.logging.Logger;
import javolution.util.FastList;

public class MultiSellChoose
extends L2GameClientPacket {
    private static final String _C__A7_MULTISELLCHOOSE = "[C] A7 MultiSellChoose";
    private static Logger _log = Logger.getLogger(MultiSellChoose.class.getName());
    private int _listId;
    private int _entryId;
    private long _amount;
    private int _enchantment;
    private long _transactionTax;
    private int _unk1;
    private int _unk2;
    private int _unk3;
    private int _unk7;
    private int _unk4;
    private int _unk5;
    private int _unk6;
    private int _unk8;
    private int _unk9;
    private int _unk10;
    private int _unk11;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        this._entryId = this.readD();
        this._amount = this.readQ();
        this._unk1 = this.readH();
        this._unk2 = this.readD();
        this._unk3 = this.readD();
        this._unk4 = this.readH();
        this._unk5 = this.readH();
        this._unk6 = this.readH();
        this._unk7 = this.readH();
        this._unk8 = this.readH();
        this._unk9 = this.readH();
        this._unk10 = this.readH();
        this._unk11 = this.readH();
        this._enchantment = this._entryId % 100000;
        this._entryId /= 100000;
        this._transactionTax = 0L;
    }

    @Override
    public void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getMultiSell().tryPerformAction("multisell choose")) {
            return;
        }
        if (this._amount < 1L || this._amount > 5000L) {
            return;
        }
        L2Multisell.MultiSellListContainer list = L2Multisell.getInstance().getList(this._listId);
        if (list == null) {
            return;
        }
        L2Object target = player.getTarget();
        if (!(player.isGM() || target != null && target instanceof L2Npc && list.checkNpcId(((L2Npc)target).getNpcId()) && ((L2Npc)target).canInteract(player))) {
            return;
        }
        for (L2Multisell.MultiSellEntry entry : list.getEntries()) {
            if (entry.getEntryId() != this._entryId) continue;
            this.doExchange(player, entry, list.getApplyTaxes(), list.getMaintainEnchantment(), this._enchantment);
            return;
        }
    }

    private void doExchange(L2PcInstance player, L2Multisell.MultiSellEntry templateEntry, boolean applyTaxes, boolean maintainEnchantment, int enchantment) {
        int i;
        L2Npc merchant;
        PcInventory inv = player.getInventory();
        L2Npc l2Npc = merchant = player.getTarget() instanceof L2Npc ? (L2Npc)player.getTarget() : null;
        if (merchant == null) {
            return;
        }
        L2Multisell.MultiSellEntry entry = this.prepareEntry(merchant, templateEntry, applyTaxes, maintainEnchantment, enchantment);
        int slots = 0;
        int weight = 0;
        for (L2Multisell.MultiSellIngredient e : entry.getProducts()) {
            L2Item template;
            if (e.getItemId() < 0 || (template = ItemTable.getInstance().getTemplate(e.getItemId())) == null) continue;
            if (!template.isStackable()) {
                slots = (int)((long)slots + e.getItemCount() * this._amount);
            } else if (player.getInventory().getItemByItemId(e.getItemId()) == null) {
                ++slots;
            }
            weight = (int)((long)weight + e.getItemCount() * this._amount * (long)template.getWeight());
        }
        if (!inv.validateWeight(weight)) {
            player.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return;
        }
        if (!inv.validateCapacity(slots)) {
            player.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return;
        }
        FastList _ingredientsList = FastList.newInstance();
        boolean newIng = true;
        for (L2Multisell.MultiSellIngredient e : entry.getIngredients()) {
            newIng = true;
            for (L2Multisell.MultiSellIngredient ex : _ingredientsList) {
                if (ex.getItemId() != e.getItemId() || ex.getEnchantmentLevel() != e.getEnchantmentLevel()) continue;
                if ((double)ex.getItemCount() + (double)e.getItemCount() > 2.147483647E9) {
                    player.sendPacket(new SystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
                    _ingredientsList.clear();
                    _ingredientsList = null;
                    return;
                }
                ex.setItemCount(ex.getItemCount() + e.getItemCount());
                newIng = false;
            }
            if (!newIng) continue;
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            _ingredientsList.add((Object)l2Multisell.new L2Multisell.MultiSellIngredient(e));
        }
        block15: for (L2Multisell.MultiSellIngredient e : _ingredientsList) {
            if ((double)e.getItemCount() * (double)this._amount > 2.147483647E9) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
                _ingredientsList.clear();
                _ingredientsList = null;
                return;
            }
            switch (e.getItemId()) {
                case -200: {
                    if (player.getClan() == null) {
                        player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER));
                        return;
                    }
                    if (!player.isClanLeader()) {
                        player.sendPacket(new SystemMessage(SystemMessageId.ONLY_THE_CLAN_LEADER_IS_ENABLED));
                        return;
                    }
                    if ((long)player.getClan().getReputationScore() >= e.getItemCount() * this._amount) continue block15;
                    player.sendPacket(new SystemMessage(SystemMessageId.THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW));
                    return;
                }
                case -300: {
                    if ((long)player.getFame() >= e.getItemCount() * this._amount) continue block15;
                    player.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_FAME_POINTS));
                    return;
                }
            }
            if (inv.getInventoryItemCount(e.getItemId(), maintainEnchantment ? e.getEnchantmentLevel() : -1, false) >= (Config.ALT_BLACKSMITH_USE_RECIPES || !e.getMaintainIngredient() ? e.getItemCount() * this._amount : e.getItemCount())) continue;
            player.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            _ingredientsList.clear();
            _ingredientsList = null;
            return;
        }
        FastList.recycle((FastList)_ingredientsList);
        FastList augmentation = FastList.newInstance();
        Elementals elemental = null;
        block16: for (L2Multisell.MultiSellIngredient e : entry.getIngredients()) {
            switch (e.getItemId()) {
                case -200: {
                    int repCost = (int)(e.getItemCount() * this._amount);
                    player.getClan().takeReputationScore(repCost, true);
                    SystemMessage smsg = new SystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    smsg.addItemNumber(e.getItemCount() * this._amount);
                    player.sendPacket(smsg);
                    continue block16;
                }
                case -300: {
                    int fameCost = (int)((long)player.getFame() - e.getItemCount() * this._amount);
                    player.setFame(fameCost);
                    player.sendPacket(new UserInfo(player));
                    player.sendPacket(new ExBrExtraUserInfo(player));
                    continue block16;
                }
            }
            L2ItemInstance itemToTake = inv.getItemByItemId(e.getItemId());
            if (itemToTake == null) {
                _log.severe("Character: " + player.getName() + " is trying to cheat in multisell, merchatnt id:" + merchant.getNpcId());
                return;
            }
            if (itemToTake.isWear()) {
                _log.severe("Character: " + player.getName() + " is trying to cheat in multisell, merchatnt id:" + merchant.getNpcId());
                return;
            }
            if (!Config.ALT_BLACKSMITH_USE_RECIPES && e.getMaintainIngredient()) continue;
            if (itemToTake.isStackable()) {
                if (player.destroyItem("Multisell", itemToTake.getObjectId(), e.getItemCount() * this._amount, player.getTarget(), true)) continue;
                return;
            }
            if (maintainEnchantment) {
                L2ItemInstance[] inventoryContents = inv.getAllItemsByItemId(e.getItemId(), e.getEnchantmentLevel(), false);
                i = 0;
                while ((long)i < e.getItemCount() * this._amount) {
                    if (inventoryContents[i].isAugmented()) {
                        augmentation.add((Object)inventoryContents[i].getAugmentation());
                    }
                    if (inventoryContents[i].getElementals() != null) {
                        elemental = inventoryContents[i].getElementals();
                    }
                    if (!player.destroyItem("Multisell", inventoryContents[i].getObjectId(), 1L, player.getTarget(), true)) {
                        return;
                    }
                    ++i;
                }
                continue;
            }
            int i2 = 1;
            while ((long)i2 <= e.getItemCount() * this._amount) {
                L2ItemInstance[] inventoryContents = inv.getAllItemsByItemId(e.getItemId(), false);
                itemToTake = inventoryContents[0];
                if (itemToTake.getEnchantLevel() > 0) {
                    for (L2ItemInstance item : inventoryContents) {
                        if (item.getEnchantLevel() < itemToTake.getEnchantLevel() && (itemToTake = item).getEnchantLevel() == 0) break;
                    }
                }
                if (!player.destroyItem("Multisell", itemToTake.getObjectId(), 1L, player.getTarget(), true)) {
                    return;
                }
                ++i2;
            }
        }
        block20: for (L2Multisell.MultiSellIngredient e : entry.getProducts()) {
            SystemMessage sm;
            switch (e.getItemId()) {
                case -200: {
                    continue block20;
                }
                case -300: {
                    player.setFame((int)((long)player.getFame() + e.getItemCount() * this._amount));
                    player.sendPacket(new UserInfo(player));
                    player.sendPacket(new ExBrExtraUserInfo(player));
                    continue block20;
                }
            }
            L2ItemInstance tempItem = ItemTable.getInstance().createDummyItem(e.getItemId());
            if (tempItem == null) {
                _log.severe("Problem with multisell ID:" + this._listId + " entry ID:" + this._entryId + " - Product ID:" + e.getItemId() + " not exist.");
                return;
            }
            if (tempItem.isStackable()) {
                inv.addItem("Multisell", e.getItemId(), e.getItemCount() * this._amount, player, player.getTarget());
            } else {
                L2ItemInstance product = null;
                i = 0;
                while ((long)i < e.getItemCount() * this._amount) {
                    product = inv.addItem("Multisell", e.getItemId(), 1L, player, player.getTarget());
                    if (maintainEnchantment) {
                        if (i < augmentation.size()) {
                            product.setAugmentation(new L2Augmentation(((L2Augmentation)augmentation.get(i)).getAugmentationId(), ((L2Augmentation)augmentation.get(i)).getSkill()));
                        }
                        if (elemental != null) {
                            product.setElementAttr(elemental.getElement(), elemental.getValue());
                        }
                        product.setEnchantLevel(e.getEnchantmentLevel());
                        product.updateDatabase();
                    }
                    ++i;
                }
            }
            if (e.getItemCount() * this._amount > 1L) {
                sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
                sm.addItemName(e.getItemId());
                sm.addItemNumber(e.getItemCount() * this._amount);
                player.sendPacket(sm);
                sm = null;
                continue;
            }
            if (maintainEnchantment && e.getEnchantmentLevel() > 0) {
                sm = new SystemMessage(SystemMessageId.ACQUIRED_S1_S2);
                sm.addItemNumber(e.getEnchantmentLevel());
                sm.addItemName(e.getItemId());
            } else {
                sm = new SystemMessage(SystemMessageId.EARNED_ITEM);
                sm.addItemName(e.getItemId());
            }
            player.sendPacket(sm);
            sm = null;
        }
        player.sendPacket(new ItemList(player, false));
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        su = null;
        if (merchant.getIsInTown() && merchant.getCastle().getOwnerId() > 0) {
            merchant.getCastle().addToTreasury(this._transactionTax * this._amount);
        }
        FastList.recycle((FastList)augmentation);
    }

    private L2Multisell.MultiSellEntry prepareEntry(L2Npc merchant, L2Multisell.MultiSellEntry templateEntry, boolean applyTaxes, boolean maintainEnchantment, int enchantLevel) {
        L2Multisell.MultiSellIngredient newIngredient;
        L2Multisell.MultiSellEntry newEntry = L2Multisell.getInstance().new L2Multisell.MultiSellEntry();
        newEntry.setEntryId(templateEntry.getEntryId());
        long totalAdenaCount = 0L;
        boolean hasIngredient = false;
        for (L2Multisell.MultiSellIngredient ing : templateEntry.getIngredients()) {
            L2Item tempItem;
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            newIngredient = l2Multisell.new L2Multisell.MultiSellIngredient(ing);
            if (newIngredient.getItemId() == 57 && newIngredient.isTaxIngredient()) {
                double taxRate = 0.0;
                if (applyTaxes && merchant != null && merchant.getIsInTown()) {
                    taxRate = merchant.getCastle().getTaxRate();
                }
                this._transactionTax = Math.round((double)newIngredient.getItemCount() * taxRate);
                totalAdenaCount += this._transactionTax;
                continue;
            }
            if (ing.getItemId() == 57) {
                totalAdenaCount += newIngredient.getItemCount();
                continue;
            }
            if (maintainEnchantment && newIngredient.getItemId() > 0 && ((tempItem = ItemTable.getInstance().createDummyItem(newIngredient.getItemId()).getItem()) instanceof L2Armor || tempItem instanceof L2Weapon)) {
                newIngredient.setEnchantmentLevel(enchantLevel);
                hasIngredient = true;
            }
            newEntry.addIngredient(newIngredient);
        }
        if (totalAdenaCount > 0L) {
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            newEntry.addIngredient(l2Multisell.new L2Multisell.MultiSellIngredient(57, totalAdenaCount, false, false));
        }
        for (L2Multisell.MultiSellIngredient ing : templateEntry.getProducts()) {
            L2Item tempItem;
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            newIngredient = l2Multisell.new L2Multisell.MultiSellIngredient(ing);
            if (maintainEnchantment && hasIngredient && ((tempItem = ItemTable.getInstance().createDummyItem(newIngredient.getItemId()).getItem()) instanceof L2Armor || tempItem instanceof L2Weapon)) {
                newIngredient.setEnchantmentLevel(enchantLevel);
            }
            newEntry.addProduct(newIngredient);
        }
        return newEntry;
    }

    @Override
    public String getType() {
        return _C__A7_MULTISELLCHOOSE;
    }
}

