/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.debug;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcQuestHtmlMessage;
import com.l2jserver.gameserver.scripting.ManagedScript;
import com.l2jserver.gameserver.scripting.ScriptManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Quest
extends ManagedScript {
    protected static final Logger _log = Logger.getLogger(Quest.class.getName());
    private static Map<String, Quest> _allEventsS = new FastMap();
    private FastMap<String, FastList<QuestTimer>> _allEventTimers = new FastMap();
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final int _questId;
    private final String _name;
    private final String _descr;
    private final byte _initialState = 0;
    protected boolean _onEnterWorld = false;
    public int[] questItemIds = null;

    public static Collection<Quest> findAllEvents() {
        return _allEventsS.values();
    }

    public Quest(int questId, String name, String descr) {
        this._questId = questId;
        this._name = name;
        this._descr = descr;
        if (questId != 0) {
            QuestManager.getInstance().addQuest(this);
        } else {
            _allEventsS.put(name, this);
        }
        this.init_LoadGlobalData();
    }

    protected void init_LoadGlobalData() {
    }

    public void saveGlobalData() {
    }

    public int getQuestIntId() {
        return this._questId;
    }

    public QuestState newQuestState(L2PcInstance player) {
        QuestState qs = new QuestState(this, player, this.getInitialState());
        return qs;
    }

    public byte getInitialState() {
        return 0;
    }

    public String getName() {
        return this._name;
    }

    public String getDescr() {
        return this._descr;
    }

    public FastMap<String, FastList<QuestTimer>> getAllQuestTimers() {
        return this._allEventTimers;
    }

    public boolean isQuests() {
        int questId = this._questId;
        return questId > 0 && questId < 20000;
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player) {
        this.startQuestTimer(name, time, npc, player, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, boolean repeating) {
        FastList timers = this.getQuestTimers(name);
        if (timers == null) {
            timers = new FastList();
            timers.add((Object)new QuestTimer(this, name, time, npc, player, repeating));
            this._allEventTimers.put((Object)name, (Object)timers);
        } else if (this.getQuestTimer(name, npc, player) == null) {
            try {
                this._rwLock.writeLock().lock();
                timers.add((Object)new QuestTimer(this, name, time, npc, player, repeating));
            }
            finally {
                this._rwLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuestTimer getQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        FastList<QuestTimer> qt = this.getQuestTimers(name);
        if (qt == null || qt.isEmpty()) {
            return null;
        }
        try {
            this._rwLock.readLock().lock();
            for (QuestTimer timer : qt) {
                if (timer == null || !timer.isMatch(this, name, npc, player)) continue;
                QuestTimer questTimer = timer;
                return questTimer;
            }
        }
        finally {
            this._rwLock.readLock().unlock();
        }
        return null;
    }

    private FastList<QuestTimer> getQuestTimers(String name) {
        return (FastList)this._allEventTimers.get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name) {
        FastList<QuestTimer> timers = this.getQuestTimers(name);
        if (timers == null) {
            return;
        }
        try {
            this._rwLock.writeLock().lock();
            for (QuestTimer timer : timers) {
                if (timer == null) continue;
                timer.cancel();
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name, int instanceId) {
        FastList<QuestTimer> timers = this.getQuestTimers(name);
        if (timers == null) {
            return;
        }
        try {
            this._rwLock.writeLock().lock();
            for (QuestTimer timer : timers) {
                if (timer == null || timer.getInstanceId() != instanceId) continue;
                timer.cancel();
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    public void cancelQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        QuestTimer timer = this.getQuestTimer(name, npc, player);
        if (timer != null) {
            timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuestTimer(QuestTimer timer) {
        if (timer == null) {
            return;
        }
        FastList<QuestTimer> timers = this.getQuestTimers(timer.getName());
        if (timers == null) {
            return;
        }
        try {
            this._rwLock.writeLock().lock();
            timers.remove((Object)timer);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    public final boolean notifyAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet, L2Skill skill) {
        String res = null;
        try {
            res = this.onAttack(npc, attacker, damage, isPet, skill);
        }
        catch (Exception e) {
            return this.showError(attacker, e);
        }
        return this.showResult(attacker, res);
    }

    public final boolean notifyDeath(L2Character killer, L2Character victim, QuestState qs) {
        String res = null;
        try {
            res = this.onDeath(killer, victim, qs);
        }
        catch (Exception e) {
            return this.showError(qs.getPlayer(), e);
        }
        return this.showResult(qs.getPlayer(), res);
    }

    public final boolean notifySpellFinished(L2Npc instance, L2PcInstance player, L2Skill skill) {
        String res = null;
        try {
            res = this.onSpellFinished(instance, player, skill);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final boolean notifySpawn(L2Npc npc) {
        try {
            this.onSpawn(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onSpawn() in notifySpawn(): " + e.getMessage(), e);
            return true;
        }
        return false;
    }

    public final boolean notifyEvent(String event, L2Npc npc, L2PcInstance player) {
        String res = null;
        try {
            res = this.onAdvEvent(event, npc, player);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final boolean notifyEnterWorld(L2PcInstance player) {
        String res = null;
        try {
            res = this.onEnterWorld(player);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final boolean notifyKill(L2Npc npc, L2PcInstance killer, boolean isPet) {
        String res = null;
        try {
            res = this.onKill(npc, killer, isPet);
        }
        catch (Exception e) {
            return this.showError(killer, e);
        }
        return this.showResult(killer, res);
    }

    public final boolean notifyTalk(L2Npc npc, QuestState qs) {
        String res = null;
        try {
            res = this.onTalk(npc, qs.getPlayer());
        }
        catch (Exception e) {
            return this.showError(qs.getPlayer(), e);
        }
        qs.getPlayer().setLastQuestNpcObject(npc.getObjectId());
        return this.showResult(qs.getPlayer(), res);
    }

    public final boolean notifyFirstTalk(L2Npc npc, L2PcInstance player) {
        String res = null;
        try {
            res = this.onFirstTalk(npc, player);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        if (res != null && res.length() > 0) {
            return this.showResult(player, res);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
        return true;
    }

    public final boolean notifyAcquireSkillList(L2Npc npc, L2PcInstance player) {
        String res = null;
        try {
            res = this.onAcquireSkillList(npc, player);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final boolean notifyAcquireSkillInfo(L2Npc npc, L2PcInstance player, L2Skill skill) {
        String res = null;
        try {
            res = this.onAcquireSkillInfo(npc, player, skill);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final boolean notifyAcquireSkill(L2Npc npc, L2PcInstance player, L2Skill skill) {
        String res = null;
        try {
            res = this.onAcquireSkill(npc, player, skill);
            if (res == "true") {
                return true;
            }
            if (res == "false") {
                return false;
            }
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final boolean notifySkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet) {
        ThreadPoolManager.getInstance().executeAi(new TmpOnSkillSee(npc, caster, skill, targets, isPet));
        return true;
    }

    public final boolean notifyFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isPet) {
        String res = null;
        try {
            res = this.onFactionCall(npc, caller, attacker, isPet);
        }
        catch (Exception e) {
            return this.showError(attacker, e);
        }
        return this.showResult(attacker, res);
    }

    public final boolean notifyAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isPet) {
        ThreadPoolManager.getInstance().executeAi(new TmpOnAggroEnter(npc, player, isPet));
        return true;
    }

    public final boolean notifyEnterZone(L2Character character, L2ZoneType zone) {
        String res;
        L2PcInstance player;
        block3: {
            player = character.getActingPlayer();
            res = null;
            try {
                res = this.onEnterZone(character, zone);
            }
            catch (Exception e) {
                if (player == null) break block3;
                return this.showError(player, e);
            }
        }
        if (player != null) {
            return this.showResult(player, res);
        }
        return true;
    }

    public final boolean notifyExitZone(L2Character character, L2ZoneType zone) {
        String res;
        L2PcInstance player;
        block3: {
            player = character.getActingPlayer();
            res = null;
            try {
                res = this.onExitZone(character, zone);
            }
            catch (Exception e) {
                if (player == null) break block3;
                return this.showError(player, e);
            }
        }
        if (player != null) {
            return this.showResult(player, res);
        }
        return true;
    }

    public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet) {
        return null;
    }

    public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet, L2Skill skill) {
        return this.onAttack(npc, attacker, damage, isPet);
    }

    public String onDeath(L2Character killer, L2Character victim, QuestState qs) {
        if (killer instanceof L2Npc) {
            return this.onAdvEvent("", (L2Npc)killer, qs.getPlayer());
        }
        return this.onAdvEvent("", null, qs.getPlayer());
    }

    public String onAdvEvent(String event, L2Npc npc, L2PcInstance player) {
        QuestState qs = player.getQuestState(this.getName());
        if (qs != null) {
            return this.onEvent(event, qs);
        }
        return null;
    }

    public String onEvent(String event, QuestState qs) {
        return null;
    }

    public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet) {
        return null;
    }

    public String onTalk(L2Npc npc, L2PcInstance talker) {
        return null;
    }

    public String onFirstTalk(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onAcquireSkillList(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onAcquireSkillInfo(L2Npc npc, L2PcInstance player, L2Skill skill) {
        return null;
    }

    public String onAcquireSkill(L2Npc npc, L2PcInstance player, L2Skill skill) {
        return null;
    }

    public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet) {
        return null;
    }

    public String onSpellFinished(L2Npc npc, L2PcInstance player, L2Skill skill) {
        return null;
    }

    public String onSpawn(L2Npc npc) {
        return null;
    }

    public String onFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isPet) {
        return null;
    }

    public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isPet) {
        return null;
    }

    public String onEnterWorld(L2PcInstance player) {
        return null;
    }

    public String onEnterZone(L2Character character, L2ZoneType zone) {
        return null;
    }

    public String onExitZone(L2Character character, L2ZoneType zone) {
        return null;
    }

    public boolean showError(L2PcInstance player, Throwable t) {
        _log.log(Level.WARNING, this.getScriptFile().getAbsolutePath(), t);
        if (player != null && player.getAccessLevel().isGm()) {
            String res = "<html><body><title>Script error</title>" + Util.getStackTrace(t) + "</body></html>";
            return this.showResult(player, res);
        }
        t.printStackTrace();
        return false;
    }

    public boolean showResult(L2PcInstance player, String res) {
        if (res == null || res.isEmpty() || player == null) {
            return true;
        }
        if (res.endsWith(".htm")) {
            this.showHtmlFile(player, res);
        } else if (res.startsWith("<html>")) {
            NpcHtmlMessage npcReply = new NpcHtmlMessage(5);
            npcReply.setHtml(res);
            npcReply.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(npcReply);
            player.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            player.sendMessage(res);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void playerEnter(L2PcInstance player) {
        Connection con = null;
        try {
            String questId;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement invalidQuestData = con.prepareStatement("DELETE FROM character_quests WHERE charId=? and name=?");
            PreparedStatement invalidQuestDataVar = con.prepareStatement("delete FROM character_quests WHERE charId=? and name=? and var=?");
            PreparedStatement statement = con.prepareStatement("SELECT name,value FROM character_quests WHERE charId=? AND var=?");
            statement.setInt(1, player.getObjectId());
            statement.setString(2, "<state>");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                questId = rs.getString("name");
                String statename = rs.getString("value");
                Quest q = QuestManager.getInstance().getQuest(questId);
                if (q == null) {
                    _log.finer("Unknown quest " + questId + " for player " + player.getName());
                    if (!Config.AUTODELETE_INVALID_QUEST_DATA) continue;
                    invalidQuestData.setInt(1, player.getObjectId());
                    invalidQuestData.setString(2, questId);
                    invalidQuestData.executeUpdate();
                    continue;
                }
                new QuestState(q, player, State.getStateId(statename));
            }
            rs.close();
            invalidQuestData.close();
            statement.close();
            statement = con.prepareStatement("SELECT name,var,value FROM character_quests WHERE charId=? AND var<>?");
            statement.setInt(1, player.getObjectId());
            statement.setString(2, "<state>");
            rs = statement.executeQuery();
            while (rs.next()) {
                questId = rs.getString("name");
                String var = rs.getString("var");
                String value = rs.getString("value");
                QuestState qs = player.getQuestState(questId);
                if (qs == null) {
                    _log.finer("Lost variable " + var + " in quest " + questId + " for player " + player.getName());
                    if (!Config.AUTODELETE_INVALID_QUEST_DATA) continue;
                    invalidQuestDataVar.setInt(1, player.getObjectId());
                    invalidQuestDataVar.setString(2, questId);
                    invalidQuestDataVar.setString(3, var);
                    invalidQuestDataVar.executeUpdate();
                    continue;
                }
                qs.setInternal(var, value);
            }
            rs.close();
            invalidQuestDataVar.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char quest:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        for (String name : _allEventsS.keySet()) {
            player.processQuestEvent(name, "enter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveGlobalQuestVar(String var, String value) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("REPLACE INTO quest_global_data (quest_name,var,value) VALUES (?,?,?)");
            statement.setString(1, this.getName());
            statement.setString(2, var);
            statement.setString(3, value);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert global quest variable:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadGlobalQuestVar(String var) {
        String result = "";
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT value FROM quest_global_data WHERE quest_name = ? AND var = ?");
            statement.setString(1, this.getName());
            statement.setString(2, var);
            ResultSet rs = statement.executeQuery();
            if (rs.first()) {
                result = rs.getString(1);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not load global quest variable:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteGlobalQuestVar(String var) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ? AND var = ?");
            statement.setString(1, this.getName());
            statement.setString(2, var);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete global quest variable:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteAllGlobalQuestVars() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ?");
            statement.setString(1, this.getName());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete global quest variables:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createQuestVarInDb(QuestState qs, String var, String value) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO character_quests (charId,name,var,value) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE value=?");
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.setString(3, var);
            statement.setString(4, value);
            statement.setString(5, value);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char quest:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateQuestVarInDb(QuestState qs, String var, String value) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE character_quests SET value=? WHERE charId=? AND name=? AND var = ?");
            statement.setString(1, value);
            statement.setInt(2, qs.getPlayer().getObjectId());
            statement.setString(3, qs.getQuestName());
            statement.setString(4, var);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not update char quest:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteQuestVarInDb(QuestState qs, String var) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=? AND name=? AND var=?");
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.setString(3, var);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete char quest:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteQuestInDb(QuestState qs) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=? AND name=?");
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete char quest:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public static void createQuestInDb(QuestState qs) {
        Quest.createQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static void updateQuestInDb(QuestState qs) {
        String val = State.getStateName(qs.getState());
        Quest.updateQuestVarInDb(qs, "<state>", val);
    }

    public L2NpcTemplate addEventId(int npcId, QuestEventType eventType) {
        try {
            L2NpcTemplate t = NpcTable.getInstance().getTemplate(npcId);
            if (t != null) {
                t.addQuestEvent(eventType, this);
            }
            return t;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on addEventId(): " + e.getMessage(), e);
            return null;
        }
    }

    public L2NpcTemplate addStartNpc(int npcId) {
        return this.addEventId(npcId, QuestEventType.QUEST_START);
    }

    public L2NpcTemplate addFirstTalkId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_FIRST_TALK);
    }

    public L2NpcTemplate addAcquireSkillId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_SKILL_LEARN);
    }

    public L2NpcTemplate addAttackId(int attackId) {
        return this.addEventId(attackId, QuestEventType.ON_ATTACK);
    }

    public L2NpcTemplate addKillId(int killId) {
        return this.addEventId(killId, QuestEventType.ON_KILL);
    }

    public L2NpcTemplate addTalkId(int talkId) {
        return this.addEventId(talkId, QuestEventType.ON_TALK);
    }

    public L2NpcTemplate addSpawnId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_SPAWN);
    }

    public L2NpcTemplate addSkillSeeId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_SKILL_SEE);
    }

    public L2NpcTemplate addSpellFinishedId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_SPELL_FINISHED);
    }

    public L2NpcTemplate addFactionCallId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_FACTION_CALL);
    }

    public L2NpcTemplate addAggroRangeEnterId(int npcId) {
        return this.addEventId(npcId, QuestEventType.ON_AGGRO_RANGE_ENTER);
    }

    public L2ZoneType addEnterZoneId(int zoneId) {
        try {
            L2ZoneType zone = ZoneManager.getInstance().getZoneById(zoneId);
            if (zone != null) {
                zone.addQuestEvent(QuestEventType.ON_ENTER_ZONE, this);
            }
            return zone;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on addEnterZoneId(): " + e.getMessage(), e);
            return null;
        }
    }

    public L2ZoneType addExitZoneId(int zoneId) {
        try {
            L2ZoneType zone = ZoneManager.getInstance().getZoneById(zoneId);
            if (zone != null) {
                zone.addQuestEvent(QuestEventType.ON_EXIT_ZONE, this);
            }
            return zone;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on addExitZoneId(): " + e.getMessage(), e);
            return null;
        }
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player) {
        if (player == null) {
            return null;
        }
        if (player.getParty() == null || player.getParty().getPartyMembers().isEmpty()) {
            return player;
        }
        L2Party party = player.getParty();
        return (L2PcInstance)party.getPartyMembers().get(Rnd.get(party.getPartyMembers().size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String value) {
        return this.getRandomPartyMember(player, "cond", value);
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String var, String value) {
        if (player == null) {
            return null;
        }
        if (var == null) {
            return this.getRandomPartyMember(player);
        }
        QuestState temp = null;
        L2Party party = player.getParty();
        if (party == null || party.getPartyMembers().isEmpty()) {
            temp = player.getQuestState(this.getName());
            if (temp != null && temp.get(var) != null && temp.get(var).equalsIgnoreCase(value)) {
                return player;
            }
            return null;
        }
        FastList candidates = new FastList();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getPartyMembers()) {
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || temp.get(var) == null || !temp.get(var).equalsIgnoreCase(value) || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add((Object)partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get(candidates.size()));
    }

    public L2PcInstance getRandomPartyMemberState(L2PcInstance player, byte state) {
        if (player == null) {
            return null;
        }
        QuestState temp = null;
        L2Party party = player.getParty();
        if (party == null || party.getPartyMembers().isEmpty()) {
            temp = player.getQuestState(this.getName());
            if (temp != null && temp.getState() == state) {
                return player;
            }
            return null;
        }
        FastList candidates = new FastList();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getPartyMembers()) {
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || temp.getState() != state || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add((Object)partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get(candidates.size()));
    }

    public String showHtmlFile(L2PcInstance player, String fileName) {
        int questId = this.getQuestIntId();
        String content = this.getHtm(player.getHtmlPrefix(), fileName);
        if (player.getTarget() != null) {
            content = content.replaceAll("%objectId%", String.valueOf(player.getTarget().getObjectId()));
        }
        if (content != null) {
            if (this.isQuests()) {
                NpcQuestHtmlMessage npcReply = new NpcQuestHtmlMessage(5, questId);
                npcReply.setHtml(content);
                npcReply.replace("%playername%", player.getName());
                player.sendPacket(npcReply);
            } else {
                NpcHtmlMessage npcReply = new NpcHtmlMessage(5);
                npcReply.setHtml(content);
                npcReply.replace((CharSequence)"%playername%", player.getName());
                player.sendPacket(npcReply);
            }
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
        return content;
    }

    public String getHtm(String prefix, String fileName) {
        String content = HtmCache.getInstance().getHtm(prefix, "data/scripts/" + this.getDescr().toLowerCase() + "/" + this.getName() + "/" + fileName);
        if (content == null) {
            content = HtmCache.getInstance().getHtmForce(prefix, "data/scripts/quests/" + this.getName() + "/" + fileName);
        }
        return content;
    }

    public L2Npc addSpawn(int npcId, L2Character cha) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), false, 0L, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, boolean isSummonSpawn) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), false, 0L, isSummonSpawn);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffSet, long despawnDelay) {
        return this.addSpawn(npcId, x, y, z, heading, randomOffSet, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return this.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        L2Npc result = null;
        try {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(npcId);
            if (template != null) {
                if (x == 0 && y == 0) {
                    _log.log(Level.SEVERE, "Failed to adjust bad locks for quest spawn!  Spawn aborted!");
                    return null;
                }
                if (randomOffset) {
                    x += Rnd.sign() * Rnd.get(50, 100);
                    y += Rnd.sign() * Rnd.get(50, 100);
                }
                L2Spawn spawn = new L2Spawn(template);
                spawn.setInstanceId(instanceId);
                spawn.setHeading(heading);
                spawn.setLocx(x);
                spawn.setLocy(y);
                spawn.setLocz(z + 20);
                spawn.stopRespawn();
                result = spawn.spawnOne(isSummonSpawn);
                if (despawnDelay > 0L) {
                    result.scheduleDespawn(despawnDelay);
                }
                return result;
            }
        }
        catch (Exception e1) {
            _log.warning("Could not spawn Npc " + npcId);
        }
        return null;
    }

    public int[] getRegisteredItemIds() {
        return this.questItemIds;
    }

    @Override
    public String getScriptName() {
        return this.getName();
    }

    @Override
    public void setActive(boolean status) {
    }

    @Override
    public boolean reload() {
        this.unload();
        return super.reload();
    }

    @Override
    public boolean unload() {
        return this.unload(true);
    }

    public boolean unload(boolean removeFromList) {
        this.saveGlobalData();
        for (FastList timers : this._allEventTimers.values()) {
            for (QuestTimer timer : timers) {
                timer.cancel();
            }
        }
        this._allEventTimers.clear();
        if (removeFromList) {
            return QuestManager.getInstance().removeQuest(this);
        }
        return true;
    }

    @Override
    public ScriptManager<?> getScriptManager() {
        return QuestManager.getInstance();
    }

    public void setOnEnterWorld(boolean val) {
        this._onEnterWorld = val;
    }

    public boolean getOnEnterWorld() {
        return this._onEnterWorld;
    }

    @Deprecated
    protected void TRACE(String message) {
        this.TRACE("", message);
    }

    @Deprecated
    protected void TRACE(String title, String message) {
        debug.TRACE(title, message);
    }

    @Deprecated
    protected String STR(L2Npc npc) {
        return debug.STR(npc);
    }

    @Deprecated
    protected String STR(L2Object obj) {
        return debug.STR(obj);
    }

    @Deprecated
    protected String STR(L2Skill skill) {
        return debug.STR(skill);
    }

    @Deprecated
    protected String STR(L2Object[] targets) {
        return debug.STR(targets);
    }

    public class TmpOnAggroEnter
    implements Runnable {
        private L2Npc _npc;
        private L2PcInstance _pc;
        private boolean _isPet;

        public TmpOnAggroEnter(L2Npc npc, L2PcInstance pc, boolean isPet) {
            this._npc = npc;
            this._pc = pc;
            this._isPet = isPet;
        }

        @Override
        public void run() {
            String res = null;
            try {
                res = Quest.this.onAggroRangeEnter(this._npc, this._pc, this._isPet);
            }
            catch (Exception e) {
                Quest.this.showError(this._pc, e);
            }
            Quest.this.showResult(this._pc, res);
        }
    }

    public class TmpOnSkillSee
    implements Runnable {
        private L2Npc _npc;
        private L2PcInstance _caster;
        private L2Skill _skill;
        private L2Object[] _targets;
        private boolean _isPet;

        public TmpOnSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet) {
            this._npc = npc;
            this._caster = caster;
            this._skill = skill;
            this._targets = targets;
            this._isPet = isPet;
        }

        @Override
        public void run() {
            String res = null;
            try {
                res = Quest.this.onSkillSee(this._npc, this._caster, this._skill, this._targets, this._isPet);
            }
            catch (Exception e) {
                Quest.this.showError(this._caster, e);
            }
            Quest.this.showResult(this._caster, res);
        }
    }

    public static enum QuestEventType {
        ON_FIRST_TALK(false),
        QUEST_START(true),
        ON_TALK(true),
        ON_ATTACK(true),
        ON_KILL(true),
        ON_SPAWN(true),
        ON_SKILL_SEE(true),
        ON_FACTION_CALL(true),
        ON_AGGRO_RANGE_ENTER(true),
        ON_SPELL_FINISHED(true),
        ON_SKILL_LEARN(false),
        ON_ENTER_ZONE(true),
        ON_EXIT_ZONE(true);

        private boolean _allowMultipleRegistration;

        private QuestEventType(boolean allowMultipleRegistration) {
            this._allowMultipleRegistration = allowMultipleRegistration;
        }

        public boolean isMultipleRegistrationAllowed() {
            return this._allowMultipleRegistration;
        }
    }
}

