/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public final class L2TerritoryWardInstance
extends L2Attackable {
    public L2TerritoryWardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.disableCoreAI(true);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (this.isInvul()) {
            return false;
        }
        if (this.getCastle() == null || !this.getCastle().getZone().isActive()) {
            return false;
        }
        L2PcInstance actingPlayer = attacker.getActingPlayer();
        if (actingPlayer == null) {
            return false;
        }
        if (actingPlayer.getSiegeSide() == 0) {
            return false;
        }
        return !TerritoryWarManager.getInstance().isAllyField(actingPlayer, this.getCastle().getCastleId());
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this.getCastle() == null) {
            _log.warning("L2TerritoryWardInstance(" + this.getName() + ") spawned outside Castle Zone!");
        }
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (skill != null || !TerritoryWarManager.getInstance().isTWInProgress()) {
            return;
        }
        L2PcInstance actingPlayer = attacker.getActingPlayer();
        if (actingPlayer == null) {
            return;
        }
        if (actingPlayer.isCombatFlagEquipped()) {
            return;
        }
        if (actingPlayer.getSiegeSide() == 0) {
            return;
        }
        if (this.getCastle() == null) {
            return;
        }
        if (TerritoryWarManager.getInstance().isAllyField(actingPlayer, this.getCastle().getCastleId())) {
            return;
        }
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    @Override
    public void reduceCurrentHpByDOT(double i, L2Character attacker, L2Skill skill) {
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer) || this.getCastle() == null || !TerritoryWarManager.getInstance().isTWInProgress()) {
            return false;
        }
        if (killer instanceof L2PcInstance) {
            if (((L2PcInstance)killer).getSiegeSide() > 0 && !((L2PcInstance)killer).isCombatFlagEquipped()) {
                ((L2PcInstance)killer).addItem("Pickup", this.getNpcId() - 23012, 1L, null, false);
            } else {
                TerritoryWarManager.getInstance().getTerritoryWard(this.getNpcId() - 36491).spawnMe();
            }
            SystemMessage sm = new SystemMessage(SystemMessageId.THE_S1_WARD_HAS_BEEN_DESTROYED);
            sm.addString(this.getName().replace(" Ward", "").replace("\u306e\u5b88\u8b77\u7269", "\u9818\u5730"));
            sm.addPcName((L2PcInstance)killer);
            TerritoryWarManager.getInstance().announceToParticipants(sm, 0, 0);
        } else {
            TerritoryWarManager.getInstance().getTerritoryWard(this.getNpcId() - 36491).spawnMe();
        }
        this.decayMe();
        return true;
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        this.onAction(player);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player == null || !this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else {
                player.sendPacket(ActionFailed.STATIC_PACKET);
            }
        }
    }
}

