/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2ControllableMobAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2ControllableMobInstance
extends L2MonsterInstance {
    private boolean _isInvul;
    private L2ControllableMobAI _aiBackup;

    @Override
    public boolean isAggressive() {
        return true;
    }

    @Override
    public int getAggroRange() {
        return 500;
    }

    public L2ControllableMobInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2ControllableMobInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2ControllableMobInstance l2ControllableMobInstance = this;
            synchronized (l2ControllableMobInstance) {
                if (this._ai == null && this._aiBackup == null) {
                    this._ai = new L2ControllableMobAI(new ControllableAIAcessor());
                    this._aiBackup = (L2ControllableMobAI)this._ai;
                } else {
                    this._ai = this._aiBackup;
                }
                return this._ai;
            }
        }
        return ai;
    }

    @Override
    public boolean isInvul() {
        return this._isInvul;
    }

    public void setInvul(boolean isInvul) {
        this._isInvul = isInvul;
    }

    @Override
    public void reduceCurrentHp(double i, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (this.isInvul() || this.isDead()) {
            return;
        }
        if (awake) {
            this.stopSleeping(null);
        }
        if (this.isImmobileUntilAttacked()) {
            this.stopImmobileUntilAttacked(null);
        }
        if ((i = this.getCurrentHp() - i) < 0.0) {
            i = 0.0;
        }
        this.setCurrentHp(i);
        if (this.getCurrentHp() < 0.5) {
            if (Config.DEBUG) {
                _log.fine("char is dead.");
            }
            this.stopMove(null);
            this.doDie(attacker);
            this.setCurrentHp(0.0);
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.removeAI();
        return true;
    }

    @Override
    public void deleteMe() {
        this.removeAI();
        super.deleteMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAI() {
        L2ControllableMobInstance l2ControllableMobInstance = this;
        synchronized (l2ControllableMobInstance) {
            if (this._aiBackup != null) {
                this._aiBackup.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                this._aiBackup = null;
                this._ai = null;
            }
        }
    }

    protected class ControllableAIAcessor
    extends L2Character.AIAccessor {
        protected ControllableAIAcessor() {
        }

        @Override
        public void detachAI() {
        }
    }
}

