/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import java.util.List;

import javolution.util.FastList;
import ai.group_template.L2AttackableAIScript;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo.NpcInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillCanceld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;

/**
 * Frintezza AI
 * 
 * @author Darki699
 * @author SANDMAN L2J_JP(modified)
 * @author JOJO
 * 
 * Update by rocknow
 * Updated by L2jOff team
 * 
 */
public class FrintezzaDEBUG extends L2AttackableAIScript
{
	private static final long Frintezza_Wait_Time = 180000;	//TODO: Grandboss.properties "FrintezzaWaitTime = 3"

	// Music title (skill 5007 & 5008)
	static final String[] MUSIC_TITLE = {
			null					//0
			, "̃NCG"	//1 Healing Rhapsody
			, "̃gbJ[^"	//2 Rampaging Opus
			, "ǓƂ̃h"		//3 Power Concerto
			, "̃t[K"		//4 Plagued Concerto
			, "f̃}YJ"		//5 Psycho Symphony
		};

	private static final int[][] _invadeLoc =
	{
		{ 174102, -76039, -5105 },
		{ 173235, -76884, -5105 },
		{ 175003, -76933, -5105 },
		{ 174196, -76190, -5105 },
		{ 174013, -76120, -5105 },
		{ 173263, -75161, -5105 }
	};

	private static final int[][] DAEMON1_SKILLS =
	{
	//	{ 5014, 1 },	//f[1 ʍUB
		{ 5015, 1 },	//f[1 ˌB
		{ 5015, 4 },	//f[1 ˌB
	};
	private static final int[][] DAEMON2_SKILLS =
	{
	//	{ 5014, 2 },	//f[2 ʍUB
		{ 5015, 2 },	//f[2 ˌB
		{ 5015, 5 },	//f[2 ˌB
		{ 5018, 1 },	//f[2 @wB
		{ 5016, 1 },	//XJ[bg̑
	};
	private static final int[][] DAEMON3_SKILLS =
	{
	//	{ 5014, 3 },	//f[3 ʍUB
		{ 5015, 3 },	//f[3 ˌB
		{ 5015, 6 },	//f[3 ˌB
		{ 5018, 2 },	//f[3 @wB
		{ 5019, 1 },	//f[3 ͈HPzB
		{ 5016, 1 },	//XJ[bg̑
	};

	private static final int[][] ROOM1_SPAWN =
	{
		{ 18328,172894,-76019,-5107,243 },
		{ 18328,174095,-77279,-5107,16216 },
		{ 18328,174111,-74833,-5107,49043 },
		{ 18328,175344,-76042,-5107,32847 },
		{ 18330,173489,-76227,-5134,63565 },
		{ 18330,173498,-75724,-5107,58498 },
		{ 18330,174365,-76745,-5107,22424 },
		{ 18330,174570,-75584,-5107,31968 },
		{ 18330,174613,-76179,-5107,31471 },
		{ 18332,173620,-75981,-5107,4588 },
		{ 18332,173630,-76340,-5107,62454 },
		{ 18332,173755,-75613,-5107,57892 },
		{ 18332,173823,-76688,-5107,2411 },
		{ 18332,174000,-75411,-5107,54718 },
		{ 18332,174487,-75555,-5107,33861 },
		{ 18332,174517,-76471,-5107,21893 },
		{ 18332,174576,-76122,-5107,31176 },
		{ 18332,174600,-75841,-5134,35927 },
	};
	private static final int[][] ROOM1_SPAWN2 =
	{
		{ 18329,173481,-76043,-5107,61312 },
		{ 18329,173539,-75678,-5107,59524 },
		{ 18329,173584,-76386,-5107,3041 },
		{ 18329,173773,-75420,-5107,51115 },
		{ 18329,173777,-76650,-5107,12588 },
		{ 18329,174585,-76510,-5107,21704 },
		{ 18329,174623,-75571,-5107,40141 },
		{ 18329,174744,-76240,-5107,29202 },
		{ 18329,174769,-75895,-5107,29572 },
	};
	private static final int[][] ROOM1_SPAWN3 =
	{
		{ 18333,173861,-76011,-5107,383 },
		{ 18333,173872,-76461,-5107,8041 },
		{ 18333,173898,-75668,-5107,51856 },
		{ 18333,174422,-75689,-5107,42878 },
		{ 18333,174460,-76355,-5107,27311 },
		{ 18333,174483,-76041,-5107,30947 },
	};
	private static final int[][] ROOM1_SPAWN4 =
	{
		{ 18331,173515,-76184,-5107,6971 },
		{ 18331,173516,-75790,-5134,3142 },
		{ 18331,173696,-76675,-5107,6757 },
		{ 18331,173766,-75502,-5134,60827 },
		{ 18331,174473,-75321,-5107,37147 },
		{ 18331,174493,-76505,-5107,34503 },
		{ 18331,174568,-75654,-5134,41661 },
		{ 18331,174584,-76263,-5107,31729 },
	};
	private static final int[][] ROOM2_SPAWN =
	{
		{ 18339,173892,-81592,-5123,50849 },
		{ 18339,173958,-81820,-5123,7459 },
		{ 18339,174128,-81805,-5150,21495 },
		{ 18339,174245,-81566,-5123,41760 },
	};
	private static final int[][] ROOM2_SPAWN2 =
	{
		{ 18334,173264,-81529,-5072,1646 },
		{ 18334,173265,-81656,-5072,441 },
		{ 18334,173267,-81889,-5072,0 },
		{ 18334,173271,-82015,-5072,65382 },
		{ 18334,174867,-81655,-5073,32537 },
		{ 18334,174868,-81890,-5073,32768 },
		{ 18334,174869,-81485,-5073,32315 },
		{ 18334,174871,-82017,-5073,33007 },
		{ 18335,173074,-80817,-5107,8353 },
		{ 18335,173128,-82702,-5107,5345 },
		{ 18335,173181,-82544,-5107,65135 },
		{ 18335,173191,-80981,-5107,6947 },
		{ 18335,174859,-80889,-5134,24103 },
		{ 18335,174924,-82666,-5107,38710 },
		{ 18335,174947,-80733,-5107,22449 },
		{ 18335,175096,-82724,-5107,42205 },
		{ 18336,173435,-80512,-5107,65215 },
		{ 18336,173440,-82948,-5107,417 },
		{ 18336,173443,-83120,-5107,1094 },
		{ 18336,173463,-83064,-5107,286 },
		{ 18336,173465,-80453,-5107,174 },
		{ 18336,173465,-83006,-5107,2604 },
		{ 18336,173468,-82889,-5107,316 },
		{ 18336,173469,-80570,-5107,65353 },
		{ 18336,173469,-80628,-5107,166 },
		{ 18336,173492,-83121,-5107,394 },
		{ 18336,173493,-80683,-5107,0 },
		{ 18336,173497,-80510,-5134,417 },
		{ 18336,173499,-82947,-5107,0 },
		{ 18336,173521,-83063,-5107,316 },
		{ 18336,173523,-82889,-5107,128 },
		{ 18336,173524,-80627,-5134,65027 },
		{ 18336,173524,-83007,-5107,0 },
		{ 18336,173526,-80452,-5107,64735 },
		{ 18336,173527,-80569,-5134,65062 },
		{ 18336,174602,-83122,-5107,33104 },
		{ 18336,174604,-82949,-5107,33184 },
		{ 18336,174609,-80514,-5107,33234 },
		{ 18336,174609,-80684,-5107,32851 },
		{ 18336,174629,-80627,-5107,33346 },
		{ 18336,174632,-80570,-5107,32896 },
		{ 18336,174632,-83066,-5107,32768 },
		{ 18336,174635,-82893,-5107,33594 },
		{ 18336,174636,-80456,-5107,32065 },
		{ 18336,174639,-83008,-5107,33057 },
		{ 18336,174660,-80512,-5107,33057 },
		{ 18336,174661,-83121,-5107,32768 },
		{ 18336,174663,-82948,-5107,32768 },
		{ 18336,174664,-80685,-5107,32676 },
		{ 18336,174687,-83008,-5107,32520 },
		{ 18336,174691,-83066,-5107,32961 },
		{ 18336,174692,-80455,-5107,33202 },
		{ 18336,174692,-80571,-5107,32768 },
		{ 18336,174693,-80630,-5107,32994 },
		{ 18336,174693,-82889,-5107,32622 },
		{ 18337,172837,-82382,-5107,58363 },
		{ 18337,172867,-81123,-5107,64055 },
		{ 18337,172883,-82495,-5107,64764 },
		{ 18337,172916,-81033,-5107,7099 },
		{ 18337,172940,-82325,-5107,58998 },
		{ 18337,172946,-82435,-5107,58038 },
		{ 18337,172971,-81198,-5107,14768 },
		{ 18337,172992,-81091,-5107,9438 },
		{ 18337,173032,-82365,-5107,59041 },
		{ 18337,173064,-81125,-5107,5827 },
		{ 18337,175014,-81173,-5107,26398 },
		{ 18337,175061,-82374,-5107,43290 },
		{ 18337,175096,-81080,-5107,24719 },
		{ 18337,175169,-82453,-5107,37672 },
		{ 18337,175172,-80972,-5107,32315 },
		{ 18337,175174,-82328,-5107,41760 },
		{ 18337,175197,-81157,-5107,27617 },
		{ 18337,175245,-82547,-5107,40275 },
		{ 18337,175249,-81075,-5107,28435 },
		{ 18337,175292,-82432,-5107,42225 },
		{ 18338,173014,-82628,-5107,11874 },
		{ 18338,173033,-80920,-5107,10425 },
		{ 18338,173095,-82520,-5107,49152 },
		{ 18338,173115,-80986,-5107,9611 },
		{ 18338,173144,-80894,-5107,5345 },
		{ 18338,173147,-82602,-5107,51316 },
		{ 18338,174912,-80825,-5107,24270 },
		{ 18338,174935,-80899,-5107,18061 },
		{ 18338,175016,-82697,-5107,39533 },
		{ 18338,175041,-80834,-5107,25420 },
		{ 18338,175071,-82549,-5107,39163 },
		{ 18338,175154,-82619,-5107,36345 }
	};

	//NPC
	private static final int SCARLET1 = 29046;
	private static final int SCARLET2 = 29047;
	private static final int FRINTEZZA = 29045;
	private static final int GUIDE = 32011;
	private static final int CUBE = 29061;
	private static final int ALARM_DEVICE = 18328;
	private static final int CHOIR_CAPTAIN = 18334;
	private static final int CHOIR_PRAYER  = 18339;

	//Items
	private static final int FRINTEZZA_SCROLL = 8073;	//Frintezza's Magic Force Field Removal Scroll.
	private static final int SOUL_BREAKING_ARROW = 8192;	//j̖
	private static final int DEWDROP_OF_DESTRUCTION = 8556;	//j̘I

	//Frintezza Status Tracking :
	private static final byte DORMANT = 0;		//Frintezza is spawned and no one has entered yet. Entry is unlocked
	private static final byte WAITING = 1;		//Frintezza is spawend and someone has entered, triggering a 30 minute window for additional people to enter
												//before he unleashes his attack. Entry is unlocked
	private static final byte FIGHTING = 2; 	//Frintezza is engaged in battle, annihilating his foes. Entry is locked
	private static final byte DEAD = 3;			//Frintezza has been killed. Entry is locked

	private static long _LastAction = 0;
	private static int _Angle = 0;
	private static int _CheckDie = 0;
	private static int _OnCheck = 0;
	private static int _songLevel = 0;				// 1 ... 5
	private static boolean _isMorphingNow = false;	// true is playing SpecialCamera
	private static int _scarletType = 0;		// 1 ... 3
	private static int _Scarlet_x = 0;
	private static int _Scarlet_y = 0;
	private static int _Scarlet_z = 0;
	private static int _Scarlet_h = 0;
	private static double _Scarlet_hp = 0;
	private static double _Scarlet_mp = 0;
	private static int _KillHallAlarmDevice = 0;
	private static int _KillDarkChoirPlayer = 0;
	private static int _KillDarkChoirCaptain = 0;

	private static L2BossZone _Zone;
	private L2GrandBossInstance frintezza, weakScarlet, strongScarlet, activeScarlet;
	private L2MonsterInstance ghost1, ghost2, ghost3, ghost4, portrait1, portrait2, portrait3, portrait4;
	private L2Npc _frintezzaDummy, _overheadDummy, _portraitDummy1, _portraitDummy3, _scarletDummy;
	private static List<L2PcInstance> _PlayersInside = new FastList<L2PcInstance>();
	private static List<L2Npc> _Room1Mobs = new FastList<L2Npc>();
	private static List<L2Npc> _Room2Mobs = new FastList<L2Npc>();

	// Boss: Frintezza
	public FrintezzaDEBUG(int id, String name, String descr)
	{
		super(id,name,descr);
		int[] mob = {SCARLET1, SCARLET2, FRINTEZZA, ALARM_DEVICE, 18329, 18330, 18331, 18332, 18333, CHOIR_CAPTAIN, 18335, 18336, 18337, 18338, CHOIR_PRAYER, 29048, 29049, 29050, 29051};
		_Zone = GrandBossManager.getInstance().getZone(174232, -88020, -5116);
		registerMobs(mob);
		addStartNpc(GUIDE);
		addTalkId(GUIDE);
		addStartNpc(CUBE);
		addTalkId(CUBE);
		StatsSet info = GrandBossManager.getInstance().getStatsSet(FRINTEZZA);
		int status = GrandBossManager.getInstance().getBossStatus(FRINTEZZA);
		if (status == DEAD)
		{
			long temp = (info.getLong("respawn_time") - System.currentTimeMillis());
			if (temp > 0)
				startQuestTimer("frintezza_unlock", temp, null, null);
			else
				GrandBossManager.getInstance().setBossStatus(FRINTEZZA,DORMANT);
		}
		else if (status != DORMANT)
			GrandBossManager.getInstance().setBossStatus(FRINTEZZA,DORMANT);
		
		//tempfix for messed door cords
		for (int i = 0; i < 8; i++)
			DoorTable.getInstance().getDoor(25150051+i).setRange(0, 0, 0, 0, 0, 0);
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		long temp = 0;
		if (event == "waiting")
		{
			startQuestTimer("close", 27000, null, null);
			startQuestTimer("camera_1", 30000, null, null);
			_Zone.broadcastPacket(new Earthquake(174232, -88020, -5116, 45, 27));
		}
		else if (event == "room1_spawn")
		{
			for (int[] loc : ROOM1_SPAWN)
				_Room1Mobs.add(addSpawn(loc[0], loc[1], loc[2], loc[3], loc[4], false, 0));
		}
		else if (event == "room1_spawn2")
		{
			for (int[] loc : ROOM1_SPAWN2)
				_Room1Mobs.add(addSpawn(loc[0], loc[1], loc[2], loc[3], loc[4], false, 0));
		}
		else if (event == "room1_spawn3")
		{
			for (int[] loc : ROOM1_SPAWN3)
				_Room1Mobs.add(addSpawn(loc[0], loc[1], loc[2], loc[3], loc[4], false, 0));
		}
		else if (event == "room1_spawn4")
		{
			for (int[] loc : ROOM1_SPAWN4)
				_Room1Mobs.add(addSpawn(loc[0], loc[1], loc[2], loc[3], loc[4], false, 0));
		}
		else if (event == "room2_spawn")
		{
			for (int[] loc : ROOM2_SPAWN)
				_Room2Mobs.add(addSpawn(loc[0], loc[1], loc[2], loc[3], loc[4], false, 0));
		}
		else if (event == "room2_spawn2")
		{
			for (int[] loc : ROOM2_SPAWN2)
				_Room2Mobs.add(addSpawn(loc[0], loc[1], loc[2], loc[3], loc[4], false, 0));
		}
		else if (event == "room1_del")
		{
			for (L2Npc mob : _Room1Mobs)
			{
				if (mob != null)
					mob.deleteMe();
			}
			_Room1Mobs.clear();
		}
		else if (event == "room2_del")
		{
			for (L2Npc mob : _Room2Mobs)
			{
				if (mob != null)
					mob.deleteMe();
			}
			_Room2Mobs.clear();
		}
		else if (event == "room3_del")
		{
			if (ghost1 != null)
				ghost1.deleteMe();
			if (ghost2 != null)
				ghost2.deleteMe();
			if (ghost3 != null)
				ghost3.deleteMe();
			if (ghost4 != null)
				ghost4.deleteMe();
			if (portrait1 != null)
				portrait1.deleteMe();
			if (portrait2 != null)
				portrait2.deleteMe();
			if (portrait3 != null)
				portrait3.deleteMe();
			if (portrait4 != null)
				portrait4.deleteMe();
			if (frintezza != null)
				frintezza.deleteMe();
			if (weakScarlet != null)
				weakScarlet.deleteMe();
			if (strongScarlet != null)
				strongScarlet.deleteMe();

			ghost1 = null;
			ghost2 = null;
			ghost3 = null;
			ghost4 = null;
			portrait1 = null;
			portrait2 = null;
			portrait3 = null;
			portrait4 = null;
			frintezza = null;
			weakScarlet = null;
			strongScarlet = null;
			activeScarlet = null;
		}
		else if (event == "clean")
		{
			_LastAction = 0;
			_CheckDie = 0;
			_OnCheck = 0;
			_isMorphingNow = false;
			_scarletType = 0;
			_KillHallAlarmDevice = 0;
			_KillDarkChoirPlayer = 0;
			_KillDarkChoirCaptain = 0;
			_PlayersInside.clear();
		}
		else if (event == "close")
		{
			for (int i = 25150051; i <= 25150058; i++)
				DoorTable.getInstance().getDoor(i).closeMe();
			for (int i = 25150061; i <= 25150070; i++)
				DoorTable.getInstance().getDoor(i).closeMe();

			DoorTable.getInstance().getDoor(25150042).closeMe();
			DoorTable.getInstance().getDoor(25150043).closeMe();
			DoorTable.getInstance().getDoor(25150045).closeMe();
			DoorTable.getInstance().getDoor(25150046).closeMe();
		}
		else if (event == "loc_check")
		{
			if (GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == FIGHTING)
			{
				if (!_Zone.isInsideZone(npc))
					npc.teleToLocation(174232,-88020,-5116);
				if (npc.getX() < 171932 || npc.getX() > 176532 || npc.getY() < -90320 || npc.getY() > -85720 || npc.getZ() < -5130)
					npc.teleToLocation(174232,-88020,-5116);
			}
		}
		else if (event == "camera_1")
		{
			/********************/
			/* START 1ST SPAWN  */
			/********************/
			_isMorphingNow = true;
			_scarletType = 1;
			GrandBossManager.getInstance().setBossStatus(FRINTEZZA,FIGHTING);

			_frintezzaDummy = addSpawn(29052,174240,-89805,-5022,16048,false,0);
			_frintezzaDummy.setIsInvul(true);
			_frintezzaDummy.setIsImmobilized(true);

			_overheadDummy = addSpawn(29052,174232,-88020,-5116,16384,false,0);
			_overheadDummy.setIsInvul(true);
			_overheadDummy.setIsImmobilized(true);
			_overheadDummy.setCollisionHeight(600);
			_Zone.broadcastPacket(new NpcInfo(_overheadDummy, null));

			_portraitDummy1 = addSpawn(29052, 172450, -87890, -5089, 16048,false,0);
			_portraitDummy1.setIsImmobilized(true);
			_portraitDummy1.setIsInvul(true);

			_portraitDummy3 = addSpawn(29052, 176012, -87890, -5089, 16048,false,0);
			_portraitDummy3.setIsImmobilized(true);
			_portraitDummy3.setIsInvul(true);

			_scarletDummy = addSpawn(29053,174232,-88020,-5116,16384,false,0);
			_scarletDummy.setIsInvul(true);
			_scarletDummy.setIsImmobilized(true);

			startQuestTimer("stop_pc", 0, npc, null);
			startQuestTimer("camera_2", 1000, _overheadDummy, null);
		}
		else if (event == "camera_2")
		{
			_Zone.broadcastPacket(new SpecialCamera(_overheadDummy.getObjectId(),0, 75, -89, 0, 100));
			startQuestTimer("camera_2b", 0, _overheadDummy, null);
		}
		else if (event == "camera_2b")
		{
			_Zone.broadcastPacket(new SpecialCamera(_overheadDummy.getObjectId(),0, 75, -89, 0, 100));
			startQuestTimer("camera_3", 0, _overheadDummy, null);
		}
		else if (event == "camera_3")
		{
			_Zone.broadcastPacket(new SpecialCamera(_overheadDummy.getObjectId(),300, 90, -10, 6500, 7000));

			frintezza = (L2GrandBossInstance) addSpawn(FRINTEZZA,174240,-89805,-5022,16048,false,0);
			GrandBossManager.getInstance().addBoss(frintezza);
			frintezza.setIsImmobilized(true);
			frintezza.setIsInvul(true);
		//	frintezza.disableAllSkills();	//-[JOJO]
			_Zone.updateKnownList(frintezza);

			ghost2 = (L2MonsterInstance) addGhostSpawn(29051, 175876, -88713, -5102, 28205,false,0);
			ghost2.setIsImmobilized(true);
			ghost2.disableAllSkills();
			_Zone.updateKnownList(ghost2);

			ghost3 = (L2MonsterInstance) addGhostSpawn(29051, 172608, -88702, -5102, 64817,false,0);
			ghost3.setIsImmobilized(true);
			ghost3.disableAllSkills();
			_Zone.updateKnownList(ghost3);

			ghost1 = (L2MonsterInstance) addGhostSpawn(29050, 175833, -87165, -5102, 35048,false,0);
			ghost1.setIsImmobilized(true);
			ghost1.disableAllSkills();
			_Zone.updateKnownList(ghost1);

			ghost4 = (L2MonsterInstance) addGhostSpawn(29050, 172634, -87165, -5102, 57730,false,0);
			ghost4.setIsImmobilized(true);
			ghost4.disableAllSkills();
			_Zone.updateKnownList(ghost4);

			startQuestTimer("camera_4", 6500, _overheadDummy, null);
		}
		else if (event == "camera_4")
		{
			_Zone.broadcastPacket(new SpecialCamera(_frintezzaDummy.getObjectId(),1800, 90, 8, 6500, 7000));
			startQuestTimer("camera_5", 900, _frintezzaDummy, null);
		}
		else if (event == "camera_5")
		{
			_Zone.broadcastPacket(new SpecialCamera(_frintezzaDummy.getObjectId(),140, 90, 10, 2500, 4500));
			startQuestTimer("camera_5b", 4000, _frintezzaDummy, null);
		}
		else if (event == "camera_5b")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),40, 75, -10, 0, 1000));
			startQuestTimer("camera_6", 0, frintezza, null);
		}
		else if (event == "camera_6")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),40, 75, -10, 0, 12000));
			startQuestTimer("camera_7", 1350, frintezza, null);
		}
		else if (event == "camera_7")
		{
			_Zone.broadcastPacket(new SocialAction(frintezza.getObjectId(),2));
			startQuestTimer("camera_8", 7000, frintezza, null);
		}
		else if (event == "camera_8")
		{
			startQuestTimer("camera_9", 1000, frintezza, null);
			_frintezzaDummy.deleteMe();
			_frintezzaDummy = null;
		}
		else if (event == "camera_9")
		{
			_Zone.broadcastPacket(new SocialAction(ghost2.getObjectId(),1));
			_Zone.broadcastPacket(new SocialAction(ghost3.getObjectId(),1));
			startQuestTimer("camera_9b", 400, frintezza, null);
		}
		else if (event == "camera_9b")
		{
			_Zone.broadcastPacket(new SocialAction(ghost1.getObjectId(),1));
			_Zone.broadcastPacket(new SocialAction(ghost4.getObjectId(),1));

			for (L2Character pc : _Zone.getCharactersInside().values())
			{
				if (pc instanceof L2PcInstance)
				{
					if (pc.getX() < 174232)
						pc.broadcastPacket(new SpecialCamera(_portraitDummy1.getObjectId(),1000, 118, 0, 0, 1000));
					else
						pc.broadcastPacket(new SpecialCamera(_portraitDummy3.getObjectId(),1000, 62, 0, 0, 1000));
				}
			}
			startQuestTimer("camera_9c", 0, frintezza, null);
		}
		else if (event == "camera_9c")
		{
			for (L2Character pc : _Zone.getCharactersInside().values())
			{
				if (pc instanceof L2PcInstance)
				{
					if (pc.getX() < 174232)
						pc.broadcastPacket(new SpecialCamera(_portraitDummy1.getObjectId(),1000, 118, 0, 0, 10000));
					else
						pc.broadcastPacket(new SpecialCamera(_portraitDummy3.getObjectId(),1000, 62, 0, 0, 10000));
				}
			}
			startQuestTimer("camera_10", 2000, frintezza, null);
		}
		else if (event == "camera_10")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),240, 90, 0, 0, 1000));
			startQuestTimer("camera_11", 0, frintezza, null);
		}
		else if (event == "camera_11")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),240, 90, 25, 5500, 10000));
			_Zone.broadcastPacket(new SocialAction(frintezza.getObjectId(),3));
			_portraitDummy1.deleteMe();
			_portraitDummy3.deleteMe();
			_portraitDummy1 = null;
			_portraitDummy3 = null;

			startQuestTimer("camera_12", 4500, frintezza, null);
		}
		else if (event == "camera_12")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),100, 195, 35, 0, 10000));
			startQuestTimer("camera_13", 700, frintezza, null);
		}
		else if (event == "camera_13")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),100, 195, 35, 0, 10000));
			startQuestTimer("camera_14", 1300, frintezza, null);
		}
		else if (event == "camera_14")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),120, 180, 45, 1500, 10000));
			_Zone.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5006, 1, 34000, 0));
			startQuestTimer("camera_16", 1500, frintezza, null);
		}
		else if (event == "camera_16")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),520, 135, 45, 8000, 10000));
			startQuestTimer("camera_17", 7500, frintezza, null);
		}
		else if (event == "camera_17")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),1500, 110, 25, 10000, 13000));
			startQuestTimer("camera_18", 9500, frintezza, null);
		}
		else if (event == "camera_18")
		{
			_Zone.broadcastPacket(new SpecialCamera(_overheadDummy.getObjectId(),930, 160, -20, 0, 1000));
			startQuestTimer("camera_18b", 0, _overheadDummy, null);
		}
		else if (event == "camera_18b")
		{
			_Zone.broadcastPacket(new SpecialCamera(_overheadDummy.getObjectId(),930, 160, -20, 0, 10000));

			weakScarlet = (L2GrandBossInstance) addSpawn(29046,174232,-88020,-5116,16384,false,0);
			weakScarlet.setIsInvul(true);
			weakScarlet.setIsImmobilized(true);
			weakScarlet.disableAllSkills();
			_Zone.updateKnownList(weakScarlet);
			activeScarlet = weakScarlet;

			_Zone.broadcastPacket(new MagicSkillUse(_scarletDummy,_overheadDummy, 5004, 1, 5800, 0));

			startQuestTimer("camera_19", 5500, _scarletDummy, null);
			startQuestTimer("camera_19b", 5400, weakScarlet, null);
		}
		else if (event == "camera_19")
		{
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),800, 160, 5, 1000, 10000));
			startQuestTimer("camera_20", 2100, weakScarlet, null);
		}
		else if (event == "camera_19b")
		{
			_Zone.broadcastPacket(new SocialAction(weakScarlet.getObjectId(),3));
		}
		else if (event == "camera_20")
		{
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),300, 60, 8, 0, 10000));
			startQuestTimer("camera_21", 2000, weakScarlet, null);
		}
		else if (event == "camera_21")
		{
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),500, 90, 10, 3000, 5000));
			startQuestTimer("camera_22", 3000, weakScarlet, null);
		}
		else if (event == "camera_22")
		{
			portrait2 = (L2MonsterInstance) addSpawn(29049, 175876, -88713, -5102, 28205,false,0);
			portrait2.setIsImmobilized(true);
			portrait2.disableAllSkills();
			_Zone.updateKnownList(portrait2);

			portrait3 = (L2MonsterInstance) addSpawn(29049, 172608, -88702, -5102, 64817,false,0);
			portrait3.setIsImmobilized(true);
			portrait3.disableAllSkills();
			_Zone.updateKnownList(portrait3);

			portrait1 = (L2MonsterInstance) addSpawn(29048, 175833, -87165, -5102, 35048,false,0);
			portrait1.setIsImmobilized(true);
			portrait1.disableAllSkills();
			_Zone.updateKnownList(portrait1);

			portrait4 = (L2MonsterInstance) addSpawn(29048, 172634, -87165, -5102, 57730,false,0);
			portrait4.setIsImmobilized(true);
			portrait4.disableAllSkills();
			_Zone.updateKnownList(portrait4);

			_overheadDummy.deleteMe();
			_scarletDummy.deleteMe();
			_overheadDummy = null;
			_scarletDummy = null;

			startQuestTimer("camera_23", 2000, weakScarlet, null);
			startQuestTimer("start_pc", 2000, weakScarlet, null);
			startQuestTimer("loc_check", 60000, weakScarlet, null, true);
			long delay = 10000 + Rnd.get(10000);
			startQuestTimer("songs_play", delay, frintezza, null);
			startQuestTimer("skill01", delay, weakScarlet, null);
		}
		else if (event == "camera_23")
		{
			ghost1.setIsImmobilized(false);
			ghost2.setIsImmobilized(false);
			ghost3.setIsImmobilized(false);
			ghost4.setIsImmobilized(false);
			ghost1.enableAllSkills();
			ghost2.enableAllSkills();
			ghost3.enableAllSkills();
			ghost4.enableAllSkills();
			portrait1.setIsImmobilized(false);
			portrait2.setIsImmobilized(false);
			portrait3.setIsImmobilized(false);
			portrait4.setIsImmobilized(false);
			portrait1.enableAllSkills();
			portrait2.enableAllSkills();
			portrait3.enableAllSkills();
			portrait4.enableAllSkills();
			weakScarlet.setIsInvul(false);
			weakScarlet.setIsImmobilized(false);
			weakScarlet.enableAllSkills();
			weakScarlet.setRunning();

			startQuestTimer("spawn_minion", 20000, portrait1, null);
			startQuestTimer("spawn_minion", 20000, portrait2, null);
			startQuestTimer("spawn_minion", 20000, portrait3, null);
			startQuestTimer("spawn_minion", 20000, portrait4, null);

			startQuestTimer("morph_end", 0, weakScarlet, null);//+[JOJO]
			/********************/
			/* END OF 1ST SPAWN */
			/********************/
		}
		else if (event == "stop_pc")
		{
			for (L2Character cha : _Zone.getCharactersInside().values())
			{
				cha.abortAttack();
				cha.abortCast();
				cha.disableAllSkills();
				cha.setTarget(null);
				cha.stopMove(null);
				cha.setIsImmobilized(true);
				cha.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
			}
		}
		else if (event == "stop_npc")
		{
			int heading = npc.getHeading();
			if (heading < 32768)
				_Angle = Math.abs(180 - (int)(heading / 182.044444444));
			else
				_Angle = Math.abs(540 - (int)(heading / 182.044444444));
		}
		else if (event == "start_pc")
		{
			for (L2Character cha : _Zone.getCharactersInside().values())
			{
				if (cha != frintezza)
				{
					cha.enableAllSkills();
					cha.setIsImmobilized(false);
				}
			}
		}
		else if (event == "start_npc")
		{
			npc.setRunning();
			npc.setIsInvul(false);
		}
		else if (event == "morph_end")
		{
			_isMorphingNow = false;
		}
		else if (event == "morph_01")
		{
			/********************/
			/* START 2ND MORPH  */
			/********************/
		/*	activeScarlet = weakScarlet;	*/
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),250, _Angle, 12, 2000, 15000));
			startQuestTimer("morph_02", 3000, weakScarlet, null);
		}
		else if (event == "morph_02")
		{
			_Zone.broadcastPacket(new SocialAction(weakScarlet.getObjectId(),1));
			weakScarlet.setRHandId(7903);
			startQuestTimer("morph_03", 4000, weakScarlet, null);
		}
		else if (event == "morph_03")
		{
			startQuestTimer("morph_04", 1500, weakScarlet, null);
		}
		else if (event == "morph_04")
		{
			_Zone.broadcastPacket(new SocialAction(weakScarlet.getObjectId(),4));
			L2Skill skill = SkillTable.getInstance().getInfo(5017, 1);
			if (skill != null)
				skill.getEffects(weakScarlet, weakScarlet);

			startQuestTimer("morph_end", 6000, weakScarlet, null);
			startQuestTimer("start_pc", 3000, weakScarlet, null);
			startQuestTimer("start_npc", 3000, weakScarlet, null);
			startQuestTimer("songs_play", 10000 + Rnd.get(10000), frintezza, null);
			startQuestTimer("skill02", 10000 + Rnd.get(10000), weakScarlet, null);
			/********************/
			/* END OF 2ND MORPH */
			/********************/
		}
		else if (event == "morph_05a")
		{
			/********************/
			/* START 3RD MORPH  */
			/********************/
			_Zone.broadcastPacket(new SocialAction(frintezza.getObjectId(),4));
		}
		else if (event == "morph_05")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),250, 120, 15, 0, 1000));
			startQuestTimer("morph_06", 0, frintezza, null);
		}
		else if (event == "morph_06")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),250, 120, 15, 0, 10000));

			cancelQuestTimers("loc_check");

			_Scarlet_x = weakScarlet.getX();
			_Scarlet_y = weakScarlet.getY();
			_Scarlet_z = weakScarlet.getZ();
			_Scarlet_h = weakScarlet.getHeading();
			_Scarlet_hp = weakScarlet.getCurrentHp();
			_Scarlet_mp = weakScarlet.getCurrentMp();
			weakScarlet.deleteMe();
			weakScarlet = null;
			activeScarlet = null;
			weakScarlet = (L2GrandBossInstance) addSpawn(29046, _Scarlet_x, _Scarlet_y, _Scarlet_z, _Scarlet_h, false,0);
			weakScarlet.setIsInvul(true);
			weakScarlet.setIsImmobilized(true);
			weakScarlet.disableAllSkills();
			weakScarlet.setRHandId(7903);
			_Zone.updateKnownList(weakScarlet);

			startQuestTimer("morph_07", 7000, frintezza, null);
		}
		else if (event == "morph_07")
		{
			_Zone.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5006, 1, 34000, 0));
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),500, 70, 15, 3000, 10000));
			startQuestTimer("morph_08", 3000, frintezza, null);
		}
		else if (event == "morph_08")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),2500, 90, 12, 6000, 10000));
			startQuestTimer("morph_09", 3000, frintezza, null);
		}
		else if (event == "morph_09")
		{
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),250, _Angle, 12, 0, 1000));
			startQuestTimer("morph_10", 0, weakScarlet, null);
		}
		else if (event == "morph_10")
		{
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),250, _Angle, 12, 0, 10000));
			startQuestTimer("morph_11", 500, weakScarlet, null);
		}
		else if (event == "morph_11")
		{
			weakScarlet.doDie(weakScarlet);
			_Zone.broadcastPacket(new SpecialCamera(weakScarlet.getObjectId(),450, _Angle, 14, 8000, 8000));

			startQuestTimer("morph_12", 6250, weakScarlet, null);
			startQuestTimer("morph_13", 7200, weakScarlet, null);
		}
		else if (event == "morph_12")
		{
			weakScarlet.deleteMe();
			weakScarlet = null;
		}
		else if (event == "morph_13")
		{
			strongScarlet = (L2GrandBossInstance) addSpawn(SCARLET2, _Scarlet_x, _Scarlet_y, _Scarlet_z, _Scarlet_h, false,0);
			strongScarlet.setIsInvul(true);
			strongScarlet.setIsImmobilized(true);
			strongScarlet.disableAllSkills();
			strongScarlet.setCurrentHpMp(_Scarlet_hp, _Scarlet_mp);
			_Zone.updateKnownList(strongScarlet);
			activeScarlet = strongScarlet;

			_Zone.broadcastPacket(new SpecialCamera(strongScarlet.getObjectId(),450, _Angle, 12, 500, 14000));

			startQuestTimer("morph_14", 3000, strongScarlet, null);
			startQuestTimer("loc_check", 60000, strongScarlet, null, true);
		}
		else if (event == "morph_14")
		{
			startQuestTimer("morph_15", 5100, strongScarlet, null);
		}
		else if (event == "morph_15")
		{
			_Zone.broadcastPacket(new SocialAction(strongScarlet.getObjectId(),2));
			L2Skill skill = SkillTable.getInstance().getInfo(5017, 1);
			if (skill != null)
				skill.getEffects(strongScarlet, strongScarlet);

			startQuestTimer("morph_end", 9000, strongScarlet, null);
			startQuestTimer("start_pc", 6000, strongScarlet, null);
			startQuestTimer("start_npc", 6000, strongScarlet, null);
			startQuestTimer("songs_play", 10000 + Rnd.get(10000), frintezza, null);
			startQuestTimer("skill03", 10000 + Rnd.get(10000), strongScarlet, null);
			/********************/
			/* END OF 3RD MORPH */
			/********************/
		}
		else if (event == "morph_16")
		{
			/********************/
			/*    START DIE     */
			/********************/
			_Zone.broadcastPacket(new SpecialCamera(strongScarlet.getObjectId(),300, _Angle - 180 , 5, 0, 7000));
			startQuestTimer("morph_17", 0, strongScarlet, null);
		}
		else if (event == "morph_17")
		{
			_Zone.broadcastPacket(new SpecialCamera(strongScarlet.getObjectId(),200, _Angle, 85, 4000, 10000));
			startQuestTimer("morph_17b", 7400, frintezza, null);
			startQuestTimer("morph_18", 7500, frintezza, null);
		}
		else if (event == "morph_17b")
		{
			frintezza.doDie(frintezza);
		}
		else if (event == "morph_18")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),100, 120, 5, 0, 7000));
			startQuestTimer("morph_19", 0, frintezza, null);
		}
		else if (event == "morph_19")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),100, 90, 5, 5000, 15000));
			startQuestTimer("morph_20", 7000, frintezza, null);
			startQuestTimer("spawn_cubes", 7000, frintezza, null);
		}
		else if (event == "morph_20")
		{
			_Zone.broadcastPacket(new SpecialCamera(frintezza.getObjectId(),900, 90, 25, 7000, 10000));
			startQuestTimer("start_pc", 7000, frintezza, null);
			/********************/
			/*    END OF DIE    */
			/********************/
		}
		else if (event == "songs_play")
		{
			if (frintezza != null && !frintezza.isDead() && ! _isMorphingNow)
			{
				long delay;
				if ((delay = frintezza.getCastEndTimeLeftMilli()) > 0)
					startQuestTimer(event, delay + 500, npc, player);
				else
				{
					if (_scarletType == 3 && strongScarlet.getCurrentHp() < strongScarlet.getMaxHp() * 0.6 && Rnd.get(100) < 80)
						_songLevel = 1;
					else
						_songLevel = Rnd.get(1, 5);
					
					L2Skill skill = SkillTable.getInstance().getInfo(5007, _songLevel);
					frintezza.doCast(skill);
					_Zone.broadcastPacket(new ExShowScreenMessage(1, -1, 0x02, 0, 0, 0, 0, true, 10000, 0, MUSIC_TITLE[_songLevel]));
					
					delay = skill.getHitTime() + Rnd.get(5000);
					startQuestTimer("songs_play",  delay, frintezza, null);
					startQuestTimer("songs_effect", 0, npc, null);
				}
			}
		}
		else if (event == "songs_effect")
		{
			long delay;
			if ((delay = activeScarlet.getCastEndTimeLeftMilli()) > 0)
				startQuestTimer(event, delay + 500, npc, player);
			else
			{
				L2Skill skill = SkillTable.getInstance().getInfo(5008, _songLevel);
				activeScarlet.doCast(skill);
			}
		}
		else if (event == "stop_effect")
		{
			throw new AssertionError();
		}
		else if (event == "attack_stop")
		{
			cancelQuestTimers("skill01");
			cancelQuestTimers("skill02");
			cancelQuestTimers("skill03");
			cancelQuestTimers("songs_play");
			cancelQuestTimers("songs_effect");

			_Zone.broadcastPacket(new MagicSkillCanceld(frintezza.getObjectId()));
		}
		else if (event == "check_hp")
		{
			if (npc.isDead())
			{
				_isMorphingNow = true;
				_scarletType = 0;
				_Zone.broadcastPacket(new PlaySound(1, "BS01_D", 1, npc.getObjectId(), npc.getX(), npc.getY(), npc.getZ()));

				startQuestTimer("attack_stop", 0, frintezza, null);
				startQuestTimer("stop_pc", 0, npc, null);
				startQuestTimer("stop_npc", 0, npc, null);
				startQuestTimer("morph_16", 0, npc, null);
			}
			else
			{
				_CheckDie = _CheckDie + 10;
				if (_CheckDie < 3000)
					startQuestTimer("check_hp", 10, npc, null);
				else
				{
					_OnCheck = 0;
					_CheckDie = 0;
				}
			}
		}
		else if (event == "skill01")
		{
			if (activeScarlet != null && !activeScarlet.isDead() && _scarletType == 1 && ! _isMorphingNow)
				doDaemonRandomSkill(event, npc, player, DAEMON1_SKILLS);
		}
		else if (event == "skill02")
		{
			if (activeScarlet != null && !activeScarlet.isDead() && _scarletType == 2 && ! _isMorphingNow)
				doDaemonRandomSkill(event, npc, player, DAEMON2_SKILLS);
		}
		else if (event == "skill03")
		{
			if (activeScarlet != null && !activeScarlet.isDead() && _scarletType == 3 && ! _isMorphingNow)
				doDaemonRandomSkill(event, npc, player, DAEMON3_SKILLS);
		}
		else if (event == "float_effect")
		{
			throw new AssertionError();
		}
		else if (event == "action")
		{
			_Zone.broadcastPacket(new SocialAction(npc.getObjectId(),1));
		}
		else if (event == "bomber")
		{
			throw new AssertionError();
		}
		else if (event == "room_final")
		{
			_Zone.broadcastPacket(new NpcSay(npc.getObjectId(),1,npc.getNpcId(),"Exceeded his time limit, challenge failed!"));
			_Zone.oustAllPlayers();

			cancelQuestTimers("waiting");
			cancelQuestTimers("frintezza_despawn");
			startQuestTimer("clean", 1000, npc, null);
			startQuestTimer("close", 1000, npc, null);
			startQuestTimer("room1_del", 1000, npc, null);
			startQuestTimer("room2_del", 1000, npc, null);

			GrandBossManager.getInstance().setBossStatus(FRINTEZZA,DORMANT);
		}
		else if (event == "frintezza_despawn")
		{
			temp = (System.currentTimeMillis() - _LastAction);
			if (temp > 900000)
			{
				_Zone.oustAllPlayers();

				cancelQuestTimers("waiting");
				cancelQuestTimers("loc_check");
				cancelQuestTimers("room_final");
				cancelQuestTimers("spawn_minion");
				startQuestTimer("clean", 1000, npc, null);
				startQuestTimer("close", 1000, npc, null);
				startQuestTimer("attack_stop", 1000, npc, null);
				startQuestTimer("room1_del", 1000, npc, null);
				startQuestTimer("room2_del", 1000, npc, null);
				startQuestTimer("room3_del", 1000, npc, null);
				startQuestTimer("minions_despawn", 1000, npc, null);

				GrandBossManager.getInstance().setBossStatus(FRINTEZZA,DORMANT);

				cancelQuestTimers("frintezza_despawn");
			}
		}
		else if (event == "minions_despawn")
		{
			if (ghost1 != null) { ghost1.deleteMe(); ghost1 = null; }
			if (ghost2 != null) { ghost2.deleteMe(); ghost2 = null; }
			if (ghost3 != null) { ghost3.deleteMe(); ghost3 = null; }
			if (ghost4 != null) { ghost4.deleteMe(); ghost4 = null; }
		}
		else if (event == "spawn_minion")
		{
		/*	throw new AssertionError();	*/
		}
		else if (event == "spawn_cubes")
		{
			addSpawn(CUBE,174232,-88020,-5114,16384,false,900000);
		}
		else if (event == "frintezza_unlock")
		{
			GrandBossManager.getInstance().setBossStatus(FRINTEZZA,DORMANT);
		}
		else if (event == "remove_players")
		{
			_Zone.oustAllPlayers();
		}
		//[JOJO]-------------------------------------------------
		else if (event.equals("invade1")/*html*/)
		{
			L2Party party;
			if ((party = player.getParty()) != null && party.isLeader(player))
			{
				List<List<L2PcInstance>> cc = new FastList<List<L2PcInstance>>();
				cc.add(party.getPartyMembers());
				return doInvade(npc, player, cc, 1);
			}
			else
				return "<html><body>p[eB[𗦂郊[_[utebŤEXN[vĂ΁AtebTľEɓ܂B</body></html>";
		}
		else if (event.equals("invade2")/*html*/)
		{
			List<L2PcInstance> pp = new FastList<L2PcInstance>();
			pp.add(player);
			List<List<L2PcInstance>> cc = new FastList<List<L2PcInstance>>();
			cc.add(pp);
			return doInvade(npc, player, cc, 1);
		}
		else if (event.length() != 0)
			throw new AssertionError(event);
		//-------------------------------------------------------

		return super.onAdvEvent(event, npc, player);
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		if (npc.getNpcId() == CUBE)
		{
			int x = 150037 + Rnd.get(500);
			int y = -57720 + Rnd.get(500);
			player.teleToLocation(x, y, -2976);
			return null;
		}

		/* else if npc.getNpcId() == GUIDE ... */
		if (player.getParty() != null
		 && player.getParty().getCommandChannel() != null
		 && player.getParty().getCommandChannel().getChannelLeader() == player)
		{
			List<List<L2PcInstance>> cc = new FastList<List<L2PcInstance>>();
			for (L2Party party : player.getParty().getCommandChannel().getPartys())
				cc.add(party.getPartyMembers());
			return doInvade(npc, player, cc, 0);
		}
		else
		{
			return "<html><body>tebT e|[^[:<br>"
				+ "1lŌEɓ̂͊댯łB<br>"
				+ "<font color=0080FF>A`lœ</font><br>"
				+ "<a action=\"bypass -h Quest Frintezza invade1\">1p[eB[œ</a><br>"
				+ "<a action=\"bypass -h Quest Frintezza invade2\">1lœ</a>"
				+ "</body></html>";
		}
	}

	private String doInvade(L2Npc npc, L2PcInstance player, List<List<L2PcInstance>> cc, int locCycle)
	{
		String htmltext = null;
		if (GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == DORMANT)
		{
			if (! player.destroyItemByItemId("Quest", FRINTEZZA_SCROLL, 1, player, true))
				htmltext = "<html><body>utebŤEXN[vĂ΁AtebTľEɓ܂B</body></html>";
			//	htmltext = "<html><body>You dont have required item.</body></html>";
			else
			{
				GrandBossManager.getInstance().setBossStatus(FRINTEZZA, WAITING);

				startQuestTimer("close", 0, npc, null);
				startQuestTimer("room1_spawn", 5000, npc, null);
				startQuestTimer("room_final", 2100000, npc, null);				//35 min.
				startQuestTimer("frintezza_despawn", 60000, npc, null, true);

				_LastAction = System.currentTimeMillis();
				for (List<L2PcInstance> pp : cc)
				{
					if (pp == null)
						continue;
					for (L2PcInstance member : pp)
					{
						if (member == null || member.getLevel() < 74)
						{
							member.sendMessage("x74ȏ̃LN^[̂ݓł܂B");
							continue;
						}
						if (!member.isInsideRadius(npc, 700, false, false))
						{
							member.sendMessage("ꂷĂ邽ߓł܂łB");
							continue;
						}
						if (_PlayersInside.size() > 45)
						{
							member.sendMessage("𒴂ߓł܂łB");
						//	member.sendMessage("The number of challenges have been full, so can not enter.");
							continue;
				//			break;
						}
						_PlayersInside.add(member);
						_Zone.allowPlayerEntry(member, 300);
						int[] loc = _invadeLoc[locCycle];
						member.teleToLocation(loc[0] + Rnd.get(50), loc[1] + Rnd.get(50), loc[2]);

						destroyItem(member, SOUL_BREAKING_ARROW);
						destroyItem(member, DEWDROP_OF_DESTRUCTION);
					}
				//	if (_PlayersInside.size() > 45)
				//		break;

					locCycle++;
					if (locCycle >= 6)
						locCycle = 1;
				}
				// Cancel quest if _PlayersInside is empty.
				if (_PlayersInside.size() == 0)
					_LastAction = 0;
			}
		}
		else
			htmltext = "<html><body>Someone else is already inside the Magic Force Field. Try again later.</body></html>";

		return htmltext;
	}

	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		_LastAction = System.currentTimeMillis();
		switch (npc.getNpcId())
		{
		case FRINTEZZA:
			npc.setCurrentHpMp(npc.getMaxHp(), 0);
			return null;

		case SCARLET1:
			if (_scarletType == 1 && ! _isMorphingNow && npc.getCurrentHp() < npc.getMaxHp() * 0.75 && GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == FIGHTING)
			{
				_isMorphingNow = true;
				_scarletType = 2;
				startQuestTimer("attack_stop", 0, frintezza, null);

				startQuestTimer("stop_pc", 1000, npc, null);
				startQuestTimer("stop_npc", 1000, npc, null);
				startQuestTimer("morph_01", 1100, npc, null);
			}
			else if (_scarletType == 2 && ! _isMorphingNow && npc.getCurrentHp() < npc.getMaxHp() * 0.5 && GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == FIGHTING)
			{
				_isMorphingNow = true;
				_scarletType = 3;
				startQuestTimer("attack_stop", 0, frintezza, null);

				startQuestTimer("stop_pc", 2000, npc, null);
				startQuestTimer("stop_npc", 2000, npc, null);
				startQuestTimer("morph_05a", 2000, npc, null);
				startQuestTimer("morph_05", 2100, npc, null);
			}
			break;

		case SCARLET2:
			if (_scarletType == 3 && _OnCheck == 0 && damage >= npc.getCurrentHp() && GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == FIGHTING)
			{
				_OnCheck = 1;
				startQuestTimer("check_hp", 0, npc, null);
			}
			break;

		case 29050:
		case 29051:
			if (npc.getCurrentHp() / npc.getMaxHp() < 0.10 /*TODO:Fine tuning:&& Rnd.get(100) < 30*/)
			{
				L2Skill skill = SkillTable.getInstance().getInfo(5011, 1);
				npc.enableSkill(skill);
			}
			break;
		}

		return super.onAttack(npc, attacker, damage, isPet);
	}

	@Override public String onSpawn(L2Npc npc)
	{
		switch (npc.getNpcId())
		{
		case 29050:
		case 29051:
			L2Skill skill = SkillTable.getInstance().getInfo(5011, 1);
			npc.disableSkill(skill, /*TODO:Fine tuning*/120000);
			break;
		}
		return super.onSpawn(npc);
	}

	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance player, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		if (targets[0] == npc) {
			switch (skill.getId()) {
			case 2234:
				// skills/2200-2299.xml
				//  <skill id="2234" name="Soul Breaking Arrow">
				//  <target npcId="29045"/> <!-- Frintezza -->
				frintezza.abortCast();
				frintezza.doCast(SkillTable.getInstance().getInfo(5005, 1));	//TODO: modify skills/5000-5099.xml hitTime and coolTime
				for (L2Character ch : _Zone.getCharactersInside().values())
				{
					if (ch instanceof L2PcInstance)
					{
						L2PcInstance pc = (L2PcInstance)ch;
						pc.stopSkillEffects(5008);
					}
				}
				break;
			case 2276:
				// skills/2200-2299.xml
				//  <skill id="2276" name="Dewdrop of Destruction">
				//  <target npcId="29048 29049"/> <!-- Evil Spirit -->
				npc.doDie(player);
				break;
			}
		}
		return null;
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		if (npc.getNpcId() == FRINTEZZA)
		{
			return null;
		}
		else if (npc.getNpcId() == SCARLET2 && _OnCheck == 0 && GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == FIGHTING)
		{
			_OnCheck = 1;
			startQuestTimer("stop_pc", 0, npc, null);
			startQuestTimer("stop_npc", 0, npc, null);
			startQuestTimer("morph_16", 0, npc, null);
		}
		else if (npc.getNpcId() == SCARLET2 && _OnCheck == 1 && GrandBossManager.getInstance().getBossStatus(FRINTEZZA) == FIGHTING)
		{
			cancelQuestTimers("loc_check");
			cancelQuestTimers("spawn_minion");
			cancelQuestTimers("frintezza_despawn");
			startQuestTimer("clean", 30000, npc, null);
			startQuestTimer("close", 30000, npc, null);
			startQuestTimer("room3_del", 60000, npc, null);
			startQuestTimer("minions_despawn", 60000, npc, null);
			startQuestTimer("remove_players", 900000, npc, null);		//15min.
			_Zone.broadcastPacket(new CreatureSay(0, Say2.SCREEN_ANNOUNCE, "_W ", "15"));

			GrandBossManager.getInstance().setBossStatus(FRINTEZZA,DEAD);
			long respawnTime = (long)Config.Interval_Of_Frintezza_Spawn + Rnd.get(Config.Random_Of_Frintezza_Spawn);
			startQuestTimer("frintezza_unlock", respawnTime, npc, null);
			// also save the respawn time so that the info is maintained past reboots
			StatsSet info = GrandBossManager.getInstance().getStatsSet(FRINTEZZA);
			info.set("respawn_time", System.currentTimeMillis() + respawnTime);
			GrandBossManager.getInstance().setStatsSet(FRINTEZZA,info);
		}
		else if (npc.getNpcId() == ALARM_DEVICE)
		{
			if (Rnd.get(100) < 33)
				killer.addItem("Quest", DEWDROP_OF_DESTRUCTION, 1, npc, true);	// Dewdrop of Destruction
			
			_KillHallAlarmDevice++;
			if (_KillHallAlarmDevice == 4)
			{
				startQuestTimer("room1_del", 100, npc, null);
				startQuestTimer("room2_spawn", 100, npc, null);

				DoorTable.getInstance().getDoor(25150042).openMe();
				DoorTable.getInstance().getDoor(25150043).openMe();
				// DoorTable.getInstance().getDoor(25150045).openMe();
				// DoorTable.getInstance().getDoor(25150046).openMe();
				for (int i = 25150051; i <= 25150058; i++)
					DoorTable.getInstance().getDoor(i).openMe();
			}
		}
		else if (npc.getNpcId() == CHOIR_PRAYER)
		{
			_KillDarkChoirPlayer ++;
			if (_KillDarkChoirPlayer == 2)
			{
				DoorTable.getInstance().getDoor(25150042).closeMe();
				DoorTable.getInstance().getDoor(25150043).closeMe();
				DoorTable.getInstance().getDoor(25150045).closeMe();
				DoorTable.getInstance().getDoor(25150046).closeMe();
				int outside = 0;
				for (L2PcInstance room2_pc : _PlayersInside)
				{
					if (_Zone.isInsideZone(room2_pc) && room2_pc.getY() > -86130)
						outside++;
				}
				if (outside == 0)
				{
					startQuestTimer("room2_del", 100, npc, null);
					startQuestTimer("waiting", Frintezza_Wait_Time, null, null);
					cancelQuestTimers("room_final");
				}
				else
				{
					for (int i = 25150061; i <= 25150070; i++)
						DoorTable.getInstance().getDoor(i).openMe();

					startQuestTimer("room2_spawn2", 1000, npc, null);
				}
			}
		}
		else if (npc.getNpcId() == CHOIR_CAPTAIN)
		{
			if (Rnd.get(100) < 33)
				killer.addItem("Quest", SOUL_BREAKING_ARROW, 1, npc, true);	// Soul Breaking Arrow
			
			_KillDarkChoirCaptain ++;
			if (_KillDarkChoirCaptain == 8)
			{
				startQuestTimer("room2_del", 100, npc, null);

				DoorTable.getInstance().getDoor(25150045).openMe();
				DoorTable.getInstance().getDoor(25150046).openMe();

				startQuestTimer("waiting", Frintezza_Wait_Time, npc, null);
				cancelQuestTimers("room_final");
			}
			else	//[JOJO]
			{
				for (L2Npc a : _Room2Mobs)
				{
					if (a != null && a.getNpcId() == CHOIR_CAPTAIN && !a.isDead())
					{
						a.broadcastPacket(new CreatureSay(a.getObjectId(), Say2.SHOUT, a.getName(), "̒c̉tWז҂I"));
						break;
					}
				}
			}
		}
		else if (npc == portrait1)
		{
			if (ghost1 != null) { ghost1.doDie(ghost1); ghost1 = null; }
		}
		else if (npc == portrait2)
		{
			if (ghost2 != null) { ghost2.doDie(ghost2); ghost2 = null; }
		}
		else if (npc == portrait3)
		{
			if (ghost3 != null) { ghost3.doDie(ghost3); ghost3 = null; }
		}
		else if (npc == portrait4)
		{
			if (ghost4 != null) { ghost4.doDie(ghost4); ghost4 = null; }
		}

		return super.onKill(npc,killer,isPet);
	}

	private L2Npc addGhostSpawn(int npcId, int x, int y, int z, int heading, boolean dummy1, int dummy2)
	{
		L2Npc result = null;
		try
		{
			L2NpcTemplate template = NpcTable.getInstance().getTemplate(npcId);
			L2Spawn spawn = new L2Spawn(template);
			spawn.setLocx(x);
			spawn.setLocy(y);
			spawn.setLocz(z);
			spawn.setHeading(heading);
			spawn.setAmount(1);
			spawn.setRespawnDelay(60);	//
			spawn.startRespawn();		//
			result = spawn.doSpawn();
		}
		catch (Exception e)
		{
			_log.warning(e.getMessage());
		}
		return result;
	}

	private void doDaemonRandomSkill(String event, L2Npc npc, L2PcInstance player, int[][] daemonSkills)
	{
		long delay;
		if ((delay = npc.getCastEndTimeLeftMilli()) > 0)
			startQuestTimer(event, delay + 500, npc, player);
		else
		{
			int[] t = daemonSkills[Rnd.get(daemonSkills.length)];
			L2Skill skill = SkillTable.getInstance().getInfo(t[0], t[1]);
			npc.doCast(skill);
			startQuestTimer(event, skill.getHitTime() + skill.getReuseDelay() + Rnd.get(10000), npc, null);
		}
	}

	private void destroyItem(L2PcInstance pc, int itemId)
	{
		L2ItemInstance i = pc.getInventory().getItemByItemId(itemId);
		if (i != null)
			pc.destroyItemByItemId("Quest", itemId, i.getCount(), pc, true);
	}

	private void DEBUGSAY(L2Character ch, String message)
	{
	}

	public static void main(String[] args)
	{
		// now call the constructor (starts up the ai)
		new FrintezzaDEBUG(-1,"Frintezza","ai");
	}
}