/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.serverpackets;

import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.L2LoginClient;
import com.l2jserver.loginserver.serverpackets.L2LoginServerPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javolution.util.FastList;

public final class ServerList
extends L2LoginServerPacket {
    private List<ServerData> _servers = new FastList();
    private int _lastServer;

    public ServerList(L2LoginClient client) {
        this._lastServer = client.getLastServer();
        for (GameServerTable.GameServerInfo gsi : GameServerTable.getInstance().getRegisteredGameServers().values()) {
            if (gsi.getStatus() == 5 && client.getAccessLevel() > 0) {
                this.addServer(client.usesInternalIP() ? gsi.getInternalHost() : gsi.getExternalHost(), gsi.getPort(), gsi.isPvp(), gsi.isTestServer(), gsi.getCurrentPlayerCount(), gsi.getMaxPlayers(), gsi.isShowingBrackets(), gsi.isShowingClock(), gsi.getStatus(), gsi.getId());
                continue;
            }
            if (gsi.getStatus() != 5) {
                this.addServer(client.usesInternalIP() ? gsi.getInternalHost() : gsi.getExternalHost(), gsi.getPort(), gsi.isPvp(), gsi.isTestServer(), gsi.getCurrentPlayerCount(), gsi.getMaxPlayers(), gsi.isShowingBrackets(), gsi.isShowingClock(), gsi.getStatus(), gsi.getId());
                continue;
            }
            this.addServer(client.usesInternalIP() ? gsi.getInternalHost() : gsi.getExternalHost(), gsi.getPort(), gsi.isPvp(), gsi.isTestServer(), gsi.getCurrentPlayerCount(), gsi.getMaxPlayers(), gsi.isShowingBrackets(), gsi.isShowingClock(), 4, gsi.getId());
        }
    }

    public void addServer(String ip, int port, boolean pvp, boolean testServer, int currentPlayer, int maxPlayer, boolean brackets, boolean clock, int status, int server_id) {
        this._servers.add(new ServerData(ip, port, pvp, testServer, currentPlayer, maxPlayer, brackets, clock, status, server_id));
    }

    public void write() {
        this.writeC(4);
        this.writeC(this._servers.size());
        this.writeC(this._lastServer);
        for (ServerData server : this._servers) {
            this.writeC(server._serverId);
            try {
                InetAddress i4 = InetAddress.getByName(server._ip);
                byte[] raw = i4.getAddress();
                this.writeC(raw[0] & 0xFF);
                this.writeC(raw[1] & 0xFF);
                this.writeC(raw[2] & 0xFF);
                this.writeC(raw[3] & 0xFF);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                this.writeC(127);
                this.writeC(0);
                this.writeC(0);
                this.writeC(1);
            }
            this.writeD(server._port);
            this.writeC(0);
            this.writeC(server._pvp ? 1 : 0);
            this.writeH(server._currentPlayers);
            this.writeH(server._maxPlayers);
            this.writeC(server._status == 4 ? 0 : 1);
            int bits = 0;
            if (server._testServer) {
                bits |= 4;
            }
            if (server._clock) {
                bits |= 2;
            }
            this.writeD(bits);
            this.writeC(server._brackets ? 1 : 0);
        }
    }

    class ServerData {
        protected String _ip;
        protected int _port;
        protected boolean _pvp;
        protected int _currentPlayers;
        protected int _maxPlayers;
        protected boolean _testServer;
        protected boolean _brackets;
        protected boolean _clock;
        protected int _status;
        protected int _serverId;

        ServerData(String pIp, int pPort, boolean pPvp, boolean pTestServer, int pCurrentPlayers, int pMaxPlayers, boolean pBrackets, boolean pClock, int pStatus, int pServer_id) {
            this._ip = pIp;
            this._port = pPort;
            this._pvp = pPvp;
            this._testServer = pTestServer;
            this._currentPlayers = pCurrentPlayers;
            this._maxPlayers = pMaxPlayers;
            this._brackets = pBrackets;
            this._clock = pClock;
            this._status = pStatus;
            this._serverId = pServer_id;
        }
    }
}

