/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Base64;
import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.HackingException;
import com.l2jserver.loginserver.L2LoginClient;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.serverpackets.LoginFail;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.crypt.ScrambledKeyPair;
import com.l2jserver.util.lib.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;

public class LoginController {
    protected static final Logger _log = Logger.getLogger(LoginController.class.getName());
    private static LoginController _instance;
    private static final int LOGIN_TIMEOUT = 60000;
    protected FastSet<L2LoginClient> _clients = new FastSet();
    protected FastMap<String, L2LoginClient> _loginServerClients = new FastMap().shared();
    protected FastMap<String, String> _loginServerIpAddrs = new FastMap().shared();
    private Map<String, BanInfo> _bannedIps = new FastMap().shared();
    private Map<InetAddress, FailedLoginAttempt> _hackProtection;
    protected ScrambledKeyPair[] _keyPairs;
    protected byte[][] _blowfishKeys;
    private static final int BLOWFISH_KEYS = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws GeneralSecurityException {
        Class<LoginController> clazz = LoginController.class;
        synchronized (LoginController.class) {
            if (_instance != null) {
                throw new IllegalStateException("LoginController can only be loaded a single time.");
            }
            _instance = new LoginController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static LoginController getInstance() {
        return _instance;
    }

    private LoginController() throws GeneralSecurityException {
        _log.info("Loading LoginController...");
        this._hackProtection = new FastMap();
        this._keyPairs = new ScrambledKeyPair[10];
        KeyPairGenerator keygen = null;
        keygen = KeyPairGenerator.getInstance("RSA");
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4);
        keygen.initialize(spec);
        for (int i = 0; i < 10; ++i) {
            this._keyPairs[i] = new ScrambledKeyPair(keygen.generateKeyPair());
        }
        _log.info("Cached 10 KeyPairs for RSA communication");
        this.testCipher((RSAPrivateKey)this._keyPairs[0]._pair.getPrivate());
        this.generateBlowFishKeys();
    }

    private void testCipher(RSAPrivateKey key) throws GeneralSecurityException {
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
        rsaCipher.init(2, key);
    }

    private void generateBlowFishKeys() {
        this._blowfishKeys = new byte[20][16];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < this._blowfishKeys[i].length; ++j) {
                this._blowfishKeys[i][j] = (byte)(Rnd.nextInt(255) + 1);
            }
        }
        _log.info("Stored " + this._blowfishKeys.length + " keys for Blowfish communication");
    }

    public byte[] getBlowfishKey() {
        return this._blowfishKeys[(int)(Math.random() * 20.0)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoginClient(L2LoginClient client) {
        FastSet<L2LoginClient> fastSet = this._clients;
        synchronized (fastSet) {
            this._clients.add((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoginClient(L2LoginClient client) {
        FastSet<L2LoginClient> fastSet = this._clients;
        synchronized (fastSet) {
            this._clients.remove((Object)client);
        }
    }

    public SessionKey assignSessionKeyToClient(String account, L2LoginClient client) {
        SessionKey key = new SessionKey(Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt());
        this._loginServerClients.put((Object)account, (Object)client);
        return key;
    }

    public void removeAuthedLoginClient(String account) {
        this._loginServerClients.remove((Object)account);
    }

    public boolean isAccountInLoginServer(String account) {
        return this._loginServerClients.containsKey((Object)account);
    }

    public L2LoginClient getAuthedClient(String account) {
        return (L2LoginClient)((Object)this._loginServerClients.get((Object)account));
    }

    public void removeLoginIpAddr(String account) {
        this._loginServerIpAddrs.remove((Object)account);
    }

    public String getLoginIpAddr(String account) {
        return (String)this._loginServerIpAddrs.get((Object)account);
    }

    public String[] getAlreadyLoginAccounts(String address) {
        FastList ret = new FastList();
        for (Map.Entry e : this._loginServerIpAddrs.entrySet()) {
            if (!((String)e.getValue()).equals(address)) continue;
            ret.add(e.getKey());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean isIpAddrInGameServer(String account, String address) {
        if (!Config.DENY_MULTI_LOGIN_BY_IPADDR) {
            return false;
        }
        if (!this._loginServerIpAddrs.containsKey((Object)account) && this._loginServerIpAddrs.containsValue((Object)address)) {
            return this.getUserLevel(account) <= 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthLoginResult tryAuthLogin(String account, String password, L2LoginClient client) throws HackingException {
        AuthLoginResult ret = AuthLoginResult.INVALID_PASSWORD;
        String ip = client.getConnection().getInetAddress().getHostAddress();
        if (Config.DENY_BANNED_USER_BY_IPADDR && this.isIPinBanList(account, ip)) {
            return AuthLoginResult.ACCOUNT_BANNED;
        }
        if (this.loginValid(account, password, client)) {
            ret = AuthLoginResult.ALREADY_ON_GS;
            if (!this.isAccountInAnyGameServer(account)) {
                ret = AuthLoginResult.ALREADY_IPADDR;
                Object object = this._loginServerIpAddrs;
                synchronized (object) {
                    if (!this.isIpAddrInGameServer(account, ip)) {
                        if (!this._loginServerIpAddrs.containsKey((Object)account)) {
                            this._loginServerIpAddrs.put((Object)account, (Object)ip);
                        }
                    } else {
                        return ret;
                    }
                }
                ret = AuthLoginResult.ALREADY_ON_LS;
                object = this._loginServerClients;
                synchronized (object) {
                    if (!this._loginServerClients.containsKey((Object)account)) {
                        this._loginServerClients.put((Object)account, (Object)client);
                        ret = AuthLoginResult.AUTH_SUCCESS;
                        this.removeLoginClient(client);
                    }
                }
            }
        } else if (client.getAccessLevel() < 0) {
            ret = AuthLoginResult.ACCOUNT_BANNED;
        }
        return ret;
    }

    public void addBanForAddress(String address, long expiration) throws UnknownHostException {
        InetAddress netAddress = InetAddress.getByName(address);
        if (!this._bannedIps.containsKey(netAddress.getHostAddress())) {
            this._bannedIps.put(netAddress.getHostAddress(), new BanInfo(netAddress, expiration));
        }
    }

    public void addBanForAddress(InetAddress address, long duration) {
        if (!this._bannedIps.containsKey(address.getHostAddress())) {
            this._bannedIps.put(address.getHostAddress(), new BanInfo(address, System.currentTimeMillis() + duration));
        }
    }

    public boolean isBannedAddress(InetAddress address) {
        String[] parts = address.getHostAddress().split("\\.");
        BanInfo bi = this._bannedIps.get(address.getHostAddress());
        if (bi == null) {
            bi = this._bannedIps.get(parts[0] + "." + parts[1] + "." + parts[2] + ".0");
        }
        if (bi == null) {
            bi = this._bannedIps.get(parts[0] + "." + parts[1] + ".0.0");
        }
        if (bi == null) {
            bi = this._bannedIps.get(parts[0] + ".0.0.0");
        }
        if (bi != null) {
            if (bi.hasExpired()) {
                this._bannedIps.remove(address.getHostAddress());
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<String, BanInfo> getBannedIps() {
        return this._bannedIps;
    }

    public boolean removeBanForAddress(InetAddress address) {
        return this._bannedIps.remove(address.getHostAddress()) != null;
    }

    public boolean removeBanForAddress(String address) {
        try {
            return this.removeBanForAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public SessionKey getKeyForAccount(String account) {
        L2LoginClient client = (L2LoginClient)((Object)this._loginServerClients.get((Object)account));
        if (client != null) {
            return client.getSessionKey();
        }
        return null;
    }

    public int getOnlinePlayerCount(int serverId) {
        GameServerTable.GameServerInfo gsi = GameServerTable.getInstance().getRegisteredGameServerById(serverId);
        if (gsi != null && gsi.isAuthed()) {
            return gsi.getCurrentPlayerCount();
        }
        return 0;
    }

    public boolean isAccountInAnyGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return true;
        }
        return false;
    }

    public GameServerTable.GameServerInfo getAccountOnGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return gsi;
        }
        return null;
    }

    public int getTotalOnlinePlayerCount() {
        int total = 0;
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            if (!gsi.isAuthed()) continue;
            total += gsi.getCurrentPlayerCount();
        }
        return total;
    }

    public int getMaxAllowedOnlinePlayers(int id) {
        GameServerTable.GameServerInfo gsi = GameServerTable.getInstance().getRegisteredGameServerById(id);
        if (gsi != null) {
            return gsi.getMaxPlayers();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoginPossible(L2LoginClient client, int serverId) {
        GameServerTable.GameServerInfo gsi = GameServerTable.getInstance().getRegisteredGameServerById(serverId);
        int access = client.getAccessLevel();
        if (gsi != null && gsi.isAuthed()) {
            boolean loginOk;
            boolean bl = loginOk = gsi.getCurrentPlayerCount() < gsi.getMaxPlayers() && gsi.getStatus() != 5 || access > 0;
            if (loginOk && client.getLastServer() != serverId) {
                Connection con = null;
                PreparedStatement statement = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    String stmt = "UPDATE accounts SET lastServer = ? WHERE login = ?";
                    statement = con.prepareStatement(stmt);
                    statement.setInt(1, serverId);
                    statement.setString(2, client.getAccount());
                    statement.executeUpdate();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Could not set lastServer: " + e.getMessage(), e);
                }
                finally {
                    L2DatabaseFactory.close(con);
                }
            }
            return loginOk;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountAccessLevel(String account, int banLevel) {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            String stmt = "UPDATE accounts SET accessLevel=? WHERE login=?";
            statement = con.prepareStatement(stmt);
            statement.setInt(1, banLevel);
            statement.setString(2, account);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not set accessLevel: " + e.getMessage(), e);
        }
        finally {
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountLastTracert(String account, String pcIp, String hop1, String hop2, String hop3, String hop4) {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            String stmt = "UPDATE accounts SET pcIp=?, hop1=?, hop2=?, hop3=?, hop4=? WHERE login=?";
            statement = con.prepareStatement(stmt);
            statement.setString(1, pcIp);
            statement.setString(2, hop1);
            statement.setString(3, hop2);
            statement.setString(4, hop3);
            statement.setString(5, hop4);
            statement.setString(6, account);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not set last tracert: " + e.getMessage(), e);
        }
        finally {
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGM(String user) {
        boolean ok = false;
        Connection con = null;
        PreparedStatement statement = null;
        try {
            int accessLevel;
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT accessLevel FROM accounts WHERE login=?");
            statement.setString(1, user);
            ResultSet rset = statement.executeQuery();
            if (rset.next() && (accessLevel = rset.getInt(1)) > 0) {
                ok = true;
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not check gm state:" + e.getMessage(), e);
            ok = false;
        }
        finally {
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
        return ok;
    }

    public ScrambledKeyPair getScrambledRSAKeyPair() {
        return this._keyPairs[Rnd.nextInt(10)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loginValid(String user, String password, L2LoginClient client) {
        int failedCount;
        FailedLoginAttempt failedAttempt;
        boolean ok = false;
        InetAddress address = client.getConnection().getInetAddress();
        if (address == null) return false;
        if (user == null) {
            return false;
        }
        Connection con = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] raw = password.getBytes("UTF-8");
            byte[] hash = md.digest(raw);
            byte[] expected = null;
            int access = 0;
            int lastServer = 1;
            String userIP = null;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT password, accessLevel, lastServer, userIP FROM accounts WHERE login=?");
            statement.setString(1, user);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                expected = Base64.decode(rset.getString("password"));
                access = rset.getInt("accessLevel");
                lastServer = rset.getInt("lastServer");
                userIP = rset.getString("userIP");
                if (lastServer <= 0) {
                    lastServer = 1;
                }
                if (Config.DEBUG) {
                    _log.fine("account exists");
                }
            }
            rset.close();
            statement.close();
            if (expected == null) {
                int failedCount2;
                if (Config.AUTO_CREATE_ACCOUNTS) {
                    if (user.length() >= 2 && user.length() <= 14) {
                        statement = con.prepareStatement("INSERT INTO accounts (login,password,lastactive,accessLevel,lastIP) values(?,?,?,?,?)");
                        statement.setString(1, user);
                        statement.setString(2, Base64.encodeBytes(hash));
                        statement.setLong(3, System.currentTimeMillis());
                        statement.setInt(4, 0);
                        statement.setString(5, address.getHostAddress());
                        statement.execute();
                        statement.close();
                        if (Config.LOG_LOGIN_CONTROLLER) {
                            Log.add("'" + user + "' " + address.getHostAddress() + " - OK : AccountCreate", "loginlog");
                        }
                        _log.info("Created new account for " + user);
                        boolean bl = true;
                        try {
                            L2DatabaseFactory.close(con);
                            return bl;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return bl;
                    }
                    if (Config.LOG_LOGIN_CONTROLLER) {
                        Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : ErrCreatingACC", "loginlog");
                    }
                    _log.warning("Invalid username creation/use attempt: " + user);
                    boolean bl = false;
                    try {
                        L2DatabaseFactory.close(con);
                        return bl;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return bl;
                }
                if (Config.LOG_LOGIN_CONTROLLER) {
                    Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : AccountMissing", "loginlog");
                }
                _log.warning("Account missing for user " + user);
                FailedLoginAttempt failedAttempt2 = this._hackProtection.get(address);
                if (failedAttempt2 == null) {
                    this._hackProtection.put(address, new FailedLoginAttempt(address, password));
                    failedCount2 = 1;
                } else {
                    failedAttempt2.increaseCounter();
                    failedCount2 = failedAttempt2.getCount();
                }
                if (failedCount2 >= Config.LOGIN_TRY_BEFORE_BAN) {
                    _log.info("Banning '" + address.getHostAddress() + "' for " + Config.LOGIN_BLOCK_AFTER_BAN + " seconds due to " + failedCount2 + " invalid user name attempts");
                    this.addBanForAddress(address, (long)(Config.LOGIN_BLOCK_AFTER_BAN * 1000));
                }
                boolean bl = false;
                try {
                    L2DatabaseFactory.close(con);
                    return bl;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl;
            }
            if (access < 0) {
                if (Config.LOG_LOGIN_CONTROLLER) {
                    Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : AccountBanned", "loginlog");
                }
                client.setAccessLevel(access);
                boolean failedAttempt2 = false;
                try {
                    L2DatabaseFactory.close(con);
                    return failedAttempt2;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return failedAttempt2;
            }
            if (userIP != null && !address.getHostAddress().equalsIgnoreCase(userIP)) {
                if (Config.LOG_LOGIN_CONTROLLER) {
                    Log.add("'" + user + "' " + address.getHostAddress() + "/" + userIP + " - ERR : INCORRECT IP", "loginlog");
                }
                boolean failedAttempt2 = false;
                try {
                    L2DatabaseFactory.close(con);
                    return failedAttempt2;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return failedAttempt2;
            }
            ok = true;
            for (int i = 0; i < expected.length; ++i) {
                if (hash[i] == expected[i]) continue;
                ok = false;
                break;
            }
            if (ok) {
                client.setAccessLevel(access);
                client.setLastServer(lastServer);
                statement = con.prepareStatement("UPDATE accounts SET lastactive=?, lastIP=? WHERE login=?");
                statement.setLong(1, System.currentTimeMillis());
                statement.setString(2, address.getHostAddress());
                statement.setString(3, user);
                statement.execute();
                statement.close();
            }
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not check password:" + e.getMessage(), e);
            ok = false;
        }
        finally {
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
        if (ok) {
            this._hackProtection.remove(address);
            if (!Config.LOG_LOGIN_CONTROLLER) return ok;
            Log.add("'" + user + "' " + address.getHostAddress() + " - OK : LoginOk", "loginlog");
            return ok;
        }
        if (Config.LOG_LOGIN_CONTROLLER) {
            Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : LoginFailed", "loginlog");
        }
        if ((failedAttempt = this._hackProtection.get(address)) == null) {
            this._hackProtection.put(address, new FailedLoginAttempt(address, password));
            failedCount = 1;
        } else {
            failedAttempt.increaseCounter(password);
            failedCount = failedAttempt.getCount();
        }
        if (failedCount < Config.LOGIN_TRY_BEFORE_BAN) return ok;
        _log.info("Banning '" + address.getHostAddress() + "' for " + Config.LOGIN_BLOCK_AFTER_BAN + " seconds due to " + failedCount + " invalid user/pass attempts");
        this.addBanForAddress(address, (long)(Config.LOGIN_BLOCK_AFTER_BAN * 1000));
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginBanned(String user) {
        boolean ok = false;
        Connection con = null;
        try {
            int accessLevel;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT accessLevel FROM accounts WHERE login=?");
            statement.setString(1, user);
            ResultSet rset = statement.executeQuery();
            if (rset.next() && (accessLevel = rset.getInt(1)) < 0) {
                ok = true;
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not check ban state:" + e.getMessage(), e);
            ok = false;
        }
        finally {
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserLevel(String account) {
        int ret = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT userLevel FROM accounts WHERE login=?");
            statement.setString(1, account);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                ret = rset.getInt(1);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not check userlevel state:" + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIPinBanList(String user, String address) {
        boolean ok = false;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT login FROM accounts WHERE lastIP=? and accessLevel = -100");
            statement.setString(1, address);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                ok = true;
                _log.warning("connection from IP exists in BAN List (ID:" + user + ", IP:" + address + ")");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not check IP in BanList:" + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return ok;
    }

    class PurgeThread
    extends Thread {
        PurgeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                L2LoginClient client;
                FastCollection.Record end;
                FastCollection.Record e;
                FastSet<L2LoginClient> fastSet = LoginController.this._clients;
                synchronized (fastSet) {
                    e = LoginController.this._clients.head();
                    end = LoginController.this._clients.tail();
                    while ((e = e.getNext()) != end) {
                        client = (L2LoginClient)((Object)LoginController.this._clients.valueOf(e));
                        if (client.getConnectionStartTime() + 60000L < System.currentTimeMillis()) continue;
                        client.close(LoginFail.LoginFailReason.REASON_ACCESS_FAILED);
                    }
                }
                fastSet = LoginController.this._loginServerClients;
                synchronized (fastSet) {
                    e = LoginController.this._loginServerClients.head();
                    end = LoginController.this._loginServerClients.tail();
                    while ((e = e.getNext()) != end) {
                        client = (L2LoginClient)((Object)e.getValue());
                        if (client.getConnectionStartTime() + 60000L < System.currentTimeMillis()) continue;
                        client.close(LoginFail.LoginFailReason.REASON_ACCESS_FAILED);
                    }
                }
                try {
                    Thread.sleep(120000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class BanInfo {
        private InetAddress _ipAddress;
        private long _expiration;

        public BanInfo(InetAddress ipAddress, long expiration) {
            this._ipAddress = ipAddress;
            this._expiration = expiration;
        }

        public InetAddress getAddress() {
            return this._ipAddress;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this._expiration && this._expiration > 0L;
        }
    }

    class FailedLoginAttempt {
        private int _count = 1;
        private long _lastAttempTime = System.currentTimeMillis();
        private String _lastPassword;

        public FailedLoginAttempt(InetAddress address, String lastPassword) {
            this._lastPassword = lastPassword;
        }

        public void increaseCounter(String password) {
            if (!this._lastPassword.equals(password)) {
                this._count = System.currentTimeMillis() - this._lastAttempTime < 300000L ? ++this._count : 1;
                this._lastPassword = password;
                this._lastAttempTime = System.currentTimeMillis();
            } else {
                this._lastAttempTime = System.currentTimeMillis();
            }
        }

        public int getCount() {
            return this._count;
        }

        public void increaseCounter() {
            ++this._count;
        }
    }

    public static enum AuthLoginResult {
        INVALID_PASSWORD,
        ACCOUNT_BANNED,
        ALREADY_IPADDR,
        ALREADY_ON_LS,
        ALREADY_ON_GS,
        AUTH_SUCCESS;

    }
}

