/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.loginserver.L2LoginClient;
import com.l2jserver.loginserver.clientpackets.AuthGameGuard;
import com.l2jserver.loginserver.clientpackets.L2LoginClientPacket;
import com.l2jserver.loginserver.clientpackets.RequestAuthLogin;
import com.l2jserver.loginserver.clientpackets.RequestServerList;
import com.l2jserver.loginserver.clientpackets.RequestServerLogin;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.ReceivablePacket;

public final class L2LoginPacketHandler
implements IPacketHandler<L2LoginClient> {
    protected static final Logger _log = Logger.getLogger(L2LoginPacketHandler.class.getName());

    public ReceivablePacket<L2LoginClient> handlePacket(ByteBuffer buf, L2LoginClient client) {
        int opcode = buf.get() & 0xFF;
        L2LoginClientPacket packet = null;
        L2LoginClient.LoginClientState state = client.getState();
        switch (state) {
            case CONNECTED: {
                if (opcode == 7) {
                    packet = new AuthGameGuard();
                    break;
                }
                this.debugOpcode(opcode, state);
                break;
            }
            case AUTHED_GG: {
                if (opcode == 0) {
                    packet = new RequestAuthLogin();
                    break;
                }
                this.debugOpcode(opcode, state);
                break;
            }
            case AUTHED_LOGIN: {
                if (opcode == 5) {
                    packet = new RequestServerList();
                    break;
                }
                if (opcode == 2) {
                    packet = new RequestServerLogin();
                    break;
                }
                this.debugOpcode(opcode, state);
            }
        }
        return packet;
    }

    private void debugOpcode(int opcode, L2LoginClient.LoginClientState state) {
        _log.info("Unknown Opcode: " + opcode + " for state: " + state.name());
    }
}

