/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SummonItemsData;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2SummonItem;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;

public final class Evolve {
    public static final boolean doEvolve(L2PcInstance player, L2Npc npc, int itemIdtake, int itemIdgive, int petminlvl) {
        if (itemIdtake == 0 || itemIdgive == 0 || petminlvl == 0) {
            return false;
        }
        L2Summon summon = player.getPet();
        if (summon == null || !(summon instanceof L2PetInstance)) {
            return false;
        }
        L2PetInstance currentPet = (L2PetInstance)summon;
        if (currentPet.isAlikeDead()) {
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use death pet exploit!", Config.DEFAULT_PUNISH);
            return false;
        }
        L2ItemInstance item = null;
        long petexp = currentPet.getStat().getExp();
        String oldname = currentPet.getName();
        int oldX = currentPet.getX();
        int oldY = currentPet.getY();
        int oldZ = currentPet.getZ();
        L2SummonItem olditem = SummonItemsData.getInstance().getSummonItem(itemIdtake);
        if (olditem == null) {
            return false;
        }
        int oldnpcID = olditem.getNpcId();
        if (currentPet.getStat().getLevel() < petminlvl || currentPet.getNpcId() != oldnpcID) {
            return false;
        }
        L2SummonItem sitem = SummonItemsData.getInstance().getSummonItem(itemIdgive);
        if (sitem == null) {
            return false;
        }
        int npcID = sitem.getNpcId();
        if (npcID == 0) {
            return false;
        }
        L2NpcTemplate npcTemplate = NpcTable.getInstance().getTemplate(npcID);
        currentPet.unSummon(player);
        currentPet.destroyControlItem(player, true);
        item = player.getInventory().addItem("Evolve", itemIdgive, 1L, player, npc);
        L2PetInstance petSummon = L2PetInstance.spawnPet(npcTemplate, player, item);
        if (petSummon == null) {
            return false;
        }
        long _minimumexp = petSummon.getStat().getExpForLevel(petminlvl);
        if (petexp < _minimumexp) {
            petexp = _minimumexp;
        }
        petSummon.getStat().addExp(petexp);
        petSummon.setCurrentHp(petSummon.getMaxHp());
        petSummon.setCurrentMp(petSummon.getMaxMp());
        petSummon.setCurrentFed(petSummon.getMaxFed());
        petSummon.setTitle(player.getName());
        petSummon.setName(oldname);
        petSummon.setRunning();
        petSummon.store();
        player.setPet(petSummon);
        player.sendPacket(new MagicSkillUse(npc, 2046, 1, 1000, 600000));
        player.sendPacket(new SystemMessage(SystemMessageId.SUMMON_A_PET));
        L2World.getInstance().storeObject(petSummon);
        petSummon.spawnMe(oldX, oldY, oldZ);
        petSummon.startFeed();
        item.setEnchantLevel(petSummon.getLevel());
        ThreadPoolManager.getInstance().scheduleGeneral(new EvolveFinalizer(player, petSummon), 900L);
        if (petSummon.getCurrentFed() <= 0) {
            ThreadPoolManager.getInstance().scheduleGeneral(new EvolveFeedWait(player, petSummon), 60000L);
        } else {
            petSummon.startFeed();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean doRestore(L2PcInstance player, L2Npc npc, int itemIdtake, int itemIdgive, int petminlvl) {
        L2SummonItem oldItem;
        if (itemIdtake == 0 || itemIdgive == 0 || petminlvl == 0) {
            return false;
        }
        L2ItemInstance item = player.getInventory().getItemByItemId(itemIdtake);
        if (item == null) {
            return false;
        }
        int oldpetlvl = item.getEnchantLevel();
        if (oldpetlvl < petminlvl) {
            oldpetlvl = petminlvl;
        }
        if ((oldItem = SummonItemsData.getInstance().getSummonItem(itemIdtake)) == null) {
            return false;
        }
        L2SummonItem sItem = SummonItemsData.getInstance().getSummonItem(itemIdgive);
        if (sItem == null) {
            return false;
        }
        int npcId = sItem.getNpcId();
        if (npcId == 0) {
            return false;
        }
        L2NpcTemplate npcTemplate = NpcTable.getInstance().getTemplate(npcId);
        L2ItemInstance removedItem = player.getInventory().destroyItem("PetRestore", item, player, npc);
        player.sendPacket(new SystemMessage(SystemMessageId.S1_DISAPPEARED).addItemName(removedItem));
        L2ItemInstance addedItem = player.getInventory().addItem("PetRestore", itemIdgive, 1L, player, npc);
        L2PetInstance petSummon = L2PetInstance.spawnPet(npcTemplate, player, addedItem);
        if (petSummon == null) {
            return false;
        }
        long _maxexp = petSummon.getStat().getExpForLevel(oldpetlvl);
        petSummon.getStat().addExp(_maxexp);
        petSummon.setCurrentHp(petSummon.getMaxHp());
        petSummon.setCurrentMp(petSummon.getMaxMp());
        petSummon.setCurrentFed(petSummon.getMaxFed());
        petSummon.setTitle(player.getName());
        petSummon.setRunning();
        petSummon.store();
        player.setPet(petSummon);
        player.sendPacket(new MagicSkillUse(npc, 2046, 1, 1000, 600000));
        player.sendPacket(new SystemMessage(SystemMessageId.SUMMON_A_PET));
        L2World.getInstance().storeObject(petSummon);
        petSummon.spawnMe(player.getX(), player.getY(), player.getZ());
        petSummon.startFeed();
        addedItem.setEnchantLevel(petSummon.getLevel());
        InventoryUpdate iu = new InventoryUpdate();
        iu.addRemovedItem(removedItem);
        player.sendPacket(iu);
        StatusUpdate su = new StatusUpdate(player.getObjectId());
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.broadcastUserInfo();
        L2World world = L2World.getInstance();
        world.removeObject(removedItem);
        ThreadPoolManager.getInstance().scheduleGeneral(new EvolveFinalizer(player, petSummon), 900L);
        if (petSummon.getCurrentFed() <= 0) {
            ThreadPoolManager.getInstance().scheduleGeneral(new EvolveFeedWait(player, petSummon), 60000L);
        } else {
            petSummon.startFeed();
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
            statement.setInt(1, removedItem.getObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return true;
    }

    static final class EvolveFinalizer
    implements Runnable {
        private final L2PcInstance _activeChar;
        private final L2PetInstance _petSummon;

        EvolveFinalizer(L2PcInstance activeChar, L2PetInstance petSummon) {
            this._activeChar = activeChar;
            this._petSummon = petSummon;
        }

        @Override
        public void run() {
            try {
                this._activeChar.sendPacket(new MagicSkillLaunched(this._activeChar, 2046, 1));
                this._petSummon.setFollowStatus(true);
                this._petSummon.setShowSummonAnimation(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static final class EvolveFeedWait
    implements Runnable {
        private final L2PcInstance _activeChar;
        private final L2PetInstance _petSummon;

        EvolveFeedWait(L2PcInstance activeChar, L2PetInstance petSummon) {
            this._activeChar = activeChar;
            this._petSummon = petSummon;
        }

        @Override
        public void run() {
            try {
                if (this._petSummon.getCurrentFed() <= 0) {
                    this._petSummon.unSummon(this._activeChar);
                } else {
                    this._petSummon.startFeed();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

