/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class AutoAnnounceTaskManager {
    protected static final Logger _log = Logger.getLogger(AutoAnnounceTaskManager.class.getName());
    protected List<AutoAnnouncement> _announces = new FastList();
    private int _nextId = 1;

    public static AutoAnnounceTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private AutoAnnounceTaskManager() {
        this.restore();
    }

    public List<AutoAnnouncement> getAutoAnnouncements() {
        return this._announces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        if (!this._announces.isEmpty()) {
            for (AutoAnnouncement a : this._announces) {
                a.stopAnnounce();
            }
            this._announces.clear();
        }
        Connection conn = null;
        int count = 0;
        try {
            conn = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = conn.prepareStatement("SELECT id, initial, delay, cycle, memo FROM auto_announcements");
            ResultSet data = statement.executeQuery();
            while (data.next()) {
                int id = data.getInt("id");
                long initial = data.getLong("initial");
                long delay = data.getLong("delay");
                int repeat = data.getInt("cycle");
                String memo = data.getString("memo");
                ThreadPoolManager.getInstance().scheduleGeneral(new AutoAnnouncement(id, delay, repeat, memo), initial);
                ++count;
                if (this._nextId >= id) continue;
                this._nextId = id + 1;
            }
            data.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "AutoAnnoucements: Failed to load announcements data.", e);
        }
        finally {
            L2DatabaseFactory.close(conn);
        }
        _log.log(Level.INFO, "AutoAnnoucements: Loaded " + count + " Auto Annoucement Data.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoAnnounce(long initial, long delay, int repeat, String memo) {
        Connection conn = null;
        try {
            conn = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = conn.prepareStatement("INSERT INTO auto_announcements (id, initial, delay, cycle, memo) VALUES (?,?,?,?,?)");
            statement.setInt(1, this._nextId);
            statement.setLong(2, initial);
            statement.setLong(3, delay);
            statement.setInt(4, repeat);
            statement.setString(5, memo);
            statement.execute();
            statement.close();
            ThreadPoolManager.getInstance().scheduleGeneral(new AutoAnnouncement(this._nextId++, delay, repeat, memo), initial);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "AutoAnnoucements: Failed to add announcements data.", e);
        }
        finally {
            L2DatabaseFactory.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAutoAnnounce(int index) {
        Connection conn = null;
        try {
            AutoAnnouncement a = this._announces.get(index);
            a.stopAnnounce();
            conn = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = conn.prepareStatement("DELETE FROM auto_announcements WHERE id = ?");
            statement.setInt(1, a._id);
            statement.execute();
            statement.close();
            this._announces.remove(index);
            L2DatabaseFactory.close(conn);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "AutoAnnoucements: Failed to delete announcements data.", e);
        }
        finally {
            L2DatabaseFactory.close(conn);
        }
    }

    public void announce(String text) {
        Broadcast.announceToOnlinePlayers(text);
        _log.info("AutoAnnounce: " + text);
    }

    private static class SingletonHolder {
        protected static final AutoAnnounceTaskManager _instance = new AutoAnnounceTaskManager();

        private SingletonHolder() {
        }
    }

    public class AutoAnnouncement
    implements Runnable {
        private int _id;
        private long _delay;
        private int _repeat = -1;
        private String[] _memo;
        private boolean _stopped = false;

        public AutoAnnouncement(int id, long delay, int repeat, String[] memo) {
            this._id = id;
            this._delay = delay;
            this._repeat = repeat;
            this._memo = memo;
            if (!AutoAnnounceTaskManager.this._announces.contains(this)) {
                AutoAnnounceTaskManager.this._announces.add(this);
            }
        }

        public AutoAnnouncement(int id, long delay, int repeat, String memo) {
            this(id, delay, repeat, memo.split("(/n|\r\n|\n|\\n|\\\\n|<br>)+"));
        }

        public String[] getMemo() {
            return this._memo;
        }

        public void stopAnnounce() {
            this._stopped = true;
        }

        @Override
        public void run() {
            if (!this._stopped && this._repeat != 0) {
                for (String text : this._memo) {
                    AutoAnnounceTaskManager.this.announce(text);
                }
                if (this._repeat > 0) {
                    --this._repeat;
                }
                ThreadPoolManager.getInstance().scheduleGeneral(this, this._delay);
            } else {
                this.stopAnnounce();
            }
        }
    }
}

