/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.instancemanager.TransformationManager;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectTransformation
extends L2Effect {
    public EffectTransformation(Env env, EffectTemplate template) {
        super(env, template);
    }

    public EffectTransformation(Env env, L2Effect effect) {
        super(env, effect);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.TRANSFORMATION;
    }

    @Override
    public boolean onStart() {
        if (!(this.getEffected() instanceof L2PcInstance)) {
            return false;
        }
        L2PcInstance trg = (L2PcInstance)this.getEffected();
        if (trg == null) {
            return false;
        }
        if (trg.isAlikeDead() || trg.isCursedWeaponEquipped()) {
            return false;
        }
        if (trg.getTransformation() != null) {
            trg.sendPacket(new SystemMessage(SystemMessageId.YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN));
            return false;
        }
        TransformationManager.getInstance().transformPlayer(this.getSkill().getTransformId(), trg);
        return true;
    }

    @Override
    public boolean onActionTime() {
        return false;
    }

    @Override
    public void onExit() {
        this.getEffected().stopTransformation(this);
    }
}

