/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.network.serverpackets.ExRegMax;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectHealOverTime
extends L2Effect {
    public EffectHealOverTime(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.HEAL_OVER_TIME;
    }

    @Override
    public boolean onStart() {
        this.getEffected().sendPacket(new ExRegMax(this.calc(), this.getTotalCount() * this.getPeriod(), this.getPeriod()));
        return true;
    }

    @Override
    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        if (this.getEffected() instanceof L2DoorInstance) {
            return false;
        }
        double hp = this.getEffected().getCurrentHp();
        double maxhp = this.getEffected().getMaxHp();
        if ((hp += this.calc()) > maxhp) {
            hp = maxhp;
        }
        this.getEffected().setCurrentHp(hp);
        StatusUpdate suhp = new StatusUpdate(this.getEffected().getObjectId());
        suhp.addAttribute(9, (int)hp);
        this.getEffected().sendPacket(suhp);
        return true;
    }
}

