/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExChangePostState;
import com.l2jserver.gameserver.network.serverpackets.ExShowReceivedPost;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestReceivedPost
extends L2GameClientPacket {
    private static final String _C__D0_69_REQUESTRECEIVEDPOST = "[C] D0:69 RequestReceivedPost";
    private int _msgId;

    @Override
    protected void readImpl() {
        this._msgId = this.readD();
    }

    @Override
    public void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || !Config.ALLOW_MAIL) {
            return;
        }
        if (!activeChar.isInsideZone((byte)1)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_USE_MAIL_OUTSIDE_PEACE_ZONE));
            return;
        }
        Message msg = MailManager.getInstance().getMessage(this._msgId);
        if (msg == null) {
            return;
        }
        if (msg.getReceiverId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to receive not own post!", Config.DEFAULT_PUNISH);
            return;
        }
        if (msg.isDeletedByReceiver()) {
            return;
        }
        activeChar.sendPacket(new ExShowReceivedPost(msg));
        activeChar.sendPacket(new ExChangePostState(true, this._msgId, 1));
        msg.markAsRead();
    }

    @Override
    public String getType() {
        return _C__D0_69_REQUESTRECEIVEDPOST;
    }
}

