/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Manor;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2ManorManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2Item;

public class RequestBuyProcure
extends L2GameClientPacket {
    private static final String _C__C3_REQUESTBUYPROCURE = "[C] C3 RequestBuyProcure";
    private static final int BATCH_LENGTH = 12;
    private int _listId;
    private Procure[] _items = null;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new Procure[count];
        for (int i = 0; i < count; ++i) {
            this.readD();
            int itemId = this.readD();
            long cnt = this.readQ();
            if (itemId < 1 || cnt < 1L) {
                this._items = null;
                return;
            }
            this._items[i] = new Procure(itemId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && player.getKarma() > 0) {
            return;
        }
        L2Object manager = player.getTarget();
        if (!(manager instanceof L2ManorManagerInstance)) {
            manager = player.getLastFolkNPC();
        }
        if (!(manager instanceof L2ManorManagerInstance)) {
            return;
        }
        if (!player.isInsideRadius(manager, 150, true, false)) {
            return;
        }
        Castle castle = ((L2ManorManagerInstance)manager).getCastle();
        int slots = 0;
        int weight = 0;
        for (Procure i : this._items) {
            i.setReward(castle);
            L2Item template = ItemTable.getInstance().getTemplate(i.getReward());
            weight = (int)((long)weight + i.getCount() * (long)template.getWeight());
            if (!template.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (player.getInventory().getItemByItemId(i.getItemId()) != null) continue;
            ++slots;
        }
        if (!player.getInventory().validateWeight(weight)) {
            this.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            this.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return;
        }
        InventoryUpdate playerIU = new InventoryUpdate();
        for (Procure i : this._items) {
            L2ItemInstance iteme;
            L2ItemInstance item = player.getInventory().getItemByItemId(i.getItemId());
            if (item == null || item.getCount() < i.getCount() || (iteme = player.getInventory().destroyItemByItemId("Manor", i.getItemId(), i.getCount(), player, manager)) == null || (item = player.getInventory().addItem("Manor", i.getReward(), i.getCount(), player, manager)) == null) continue;
            playerIU.addRemovedItem(iteme);
            if (item.getCount() > i.getCount()) {
                playerIU.addModifiedItem(item);
            } else {
                playerIU.addNewItem(item);
            }
            SystemMessage sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
            sm.addItemName(item);
            sm.addItemNumber(i.getCount());
            player.sendPacket(sm);
            sm = null;
        }
        player.sendPacket(playerIU);
        StatusUpdate su = new StatusUpdate(player.getObjectId());
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__C3_REQUESTBUYPROCURE;
    }

    private class Procure {
        private final int _itemId;
        private final long _count;
        private int _reward;

        public Procure(int id, long num) {
            this._itemId = id;
            this._count = num;
        }

        public int getItemId() {
            return this._itemId;
        }

        public long getCount() {
            return this._count;
        }

        public int getReward() {
            return this._reward;
        }

        public void setReward(Castle c) {
            this._reward = L2Manor.getInstance().getRewardItem(this._itemId, c.getCrop(this._itemId, 0).getReward());
        }
    }
}

