/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExManagePartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.JoinParty;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestAnswerJoinParty
extends L2GameClientPacket {
    private static final String _C__2A_REQUESTANSWERPARTY = "[C] 2A RequestAnswerJoinParty";
    private int _response;

    @Override
    protected void readImpl() {
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player != null) {
            L2PcInstance requestor = player.getActiveRequester();
            if (requestor == null) {
                return;
            }
            JoinParty join = new JoinParty(this._response);
            requestor.sendPacket(join);
            if (this._response == 1) {
                PartyMatchRoomList list;
                if (requestor.getParty() != null && requestor.getParty().getMemberCount() >= 9) {
                    player.sendPacket(new SystemMessage(SystemMessageId.PARTY_FULL));
                    requestor.sendPacket(new SystemMessage(SystemMessageId.PARTY_FULL));
                    return;
                }
                player.joinParty(requestor.getParty());
                if (requestor.isInPartyMatchRoom() && player.isInPartyMatchRoom()) {
                    PartyMatchRoomList list2 = PartyMatchRoomList.getInstance();
                    if (list2 != null && list2.getPlayerRoomId(requestor) == list2.getPlayerRoomId(player)) {
                        PartyMatchRoom room = list2.getPlayerRoom(requestor);
                        for (L2PcInstance member : room.getPartyMembers()) {
                            member.sendPacket(new ExManagePartyRoomMember(player, room, 1));
                        }
                    }
                } else if (requestor.isInPartyMatchRoom() && !player.isInPartyMatchRoom() && (list = PartyMatchRoomList.getInstance()) != null) {
                    PartyMatchRoom room = list.getPlayerRoom(requestor);
                    room.addMember(player);
                    for (L2PcInstance member : room.getPartyMembers()) {
                        member.sendPacket(new ExManagePartyRoomMember(player, room, 1));
                    }
                    player.setPartyRoom(room.getId());
                    player.broadcastUserInfo();
                }
            } else {
                requestor.sendPacket(new SystemMessage(SystemMessageId.PLAYER_DECLINED));
                if (requestor.getParty() != null && requestor.getParty().getMemberCount() == 1) {
                    requestor.setParty(null);
                }
            }
            if (requestor.getParty() != null) {
                requestor.getParty().setPendingInvitation(false);
            }
            player.setActiveRequester(null);
            requestor.onTransactionResponse();
        }
    }

    @Override
    public String getType() {
        return _C__2A_REQUESTANSWERPARTY;
    }
}

