/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.CharSelected;
import com.l2jserver.gameserver.network.serverpackets.SSQInfo;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CharacterSelect
extends L2GameClientPacket {
    private static final String _C__0D_CHARACTERSELECT = "[C] 0D CharacterSelect";
    private static final Logger _log = Logger.getLogger(CharacterSelect.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    private int _charSlot;
    private int _unk1;
    private int _unk2;
    private int _unk3;
    private int _unk4;

    @Override
    protected void readImpl() {
        this._charSlot = this.readD();
        this._unk1 = this.readH();
        this._unk2 = this.readD();
        this._unk3 = this.readD();
        this._unk4 = this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        if (((L2GameClient)this.getClient()).getActiveCharLock().tryLock()) {
            try {
                if (((L2GameClient)this.getClient()).getActiveChar() == null) {
                    L2PcInstance cha;
                    if (Config.DEBUG) {
                        _log.fine("selected slot:" + this._charSlot);
                    }
                    if ((cha = ((L2GameClient)this.getClient()).loadCharFromDisk(this._charSlot)) == null) {
                        _log.severe("Character could not be loaded (slot:" + this._charSlot + ")");
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    if (cha.getAccessLevel().getLevel() < 0) {
                        cha.logout();
                        return;
                    }
                    CharNameTable.getInstance().addName(cha);
                    cha.setClient((L2GameClient)this.getClient());
                    ((L2GameClient)this.getClient()).setActiveChar(cha);
                    this.sendPacket(new SSQInfo());
                    ((L2GameClient)this.getClient()).setState(L2GameClient.GameClientState.IN_GAME);
                    CharSelected cs = new CharSelected(cha, ((L2GameClient)this.getClient()).getSessionId().playOkID1);
                    this.sendPacket(cs);
                }
            }
            finally {
                ((L2GameClient)this.getClient()).getActiveCharLock().unlock();
            }
            LogRecord record = new LogRecord(Level.INFO, "Logged in");
            record.setParameters(new Object[]{this.getClient()});
            _logAccounting.log(record);
        }
    }

    @Override
    public String getType() {
        return _C__0D_CHARACTERSELECT;
    }
}

