/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import java.util.Collection;

public class L2WaterZone
extends L2ZoneType {
    public L2WaterZone(int id) {
        super(id);
    }

    @Override
    protected void onEnter(L2Character character) {
        character.setInsideZone((byte)7, true);
        if (character instanceof L2PcInstance) {
            if (((L2PcInstance)character).isTransformed() && !((L2PcInstance)character).isCursedWeaponEquipped()) {
                character.stopTransformation(null);
            } else {
                ((L2PcInstance)character).broadcastUserInfo();
            }
        } else if (character instanceof L2Npc) {
            Collection<L2PcInstance> plrs = character.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (character.getRunSpeed() == 0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)character, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)character, player));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone((byte)7, false);
        if (character instanceof L2PcInstance) {
            ((L2PcInstance)character).broadcastUserInfo();
        } else if (character instanceof L2Npc) {
            Collection<L2PcInstance> plrs = character.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (character.getRunSpeed() == 0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)character, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)character, player));
            }
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public int getWaterZ() {
        return this.getZone().getHighZ();
    }
}

