/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.util.Rnd;
import javolution.util.FastList;

public class L2CastleTeleportZone
extends L2ZoneType {
    private int[] _spawnLoc = new int[5];
    private int _castleId;

    public L2CastleTeleportZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("castleId")) {
            this._castleId = Integer.parseInt(value);
        } else if (name.equals("spawnMinX")) {
            this._spawnLoc[0] = Integer.parseInt(value);
        } else if (name.equals("spawnMaxX")) {
            this._spawnLoc[1] = Integer.parseInt(value);
        } else if (name.equals("spawnMinY")) {
            this._spawnLoc[2] = Integer.parseInt(value);
        } else if (name.equals("spawnMaxY")) {
            this._spawnLoc[3] = Integer.parseInt(value);
        } else if (name.equals("spawnZ")) {
            this._spawnLoc[4] = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        character.setInsideZone((byte)12, true);
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone((byte)12, false);
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public FastList<L2PcInstance> getAllPlayers() {
        FastList players = new FastList();
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            players.add((Object)((L2PcInstance)temp));
        }
        return players;
    }

    public void oustAllPlayers() {
        if (this._characterList == null) {
            return;
        }
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this._characterList.values()) {
            L2PcInstance player;
            if (character == null || !(character instanceof L2PcInstance) || (player = (L2PcInstance)character).isOnline() != 1) continue;
            player.teleToLocation(Rnd.get(this._spawnLoc[0], this._spawnLoc[1]), Rnd.get(this._spawnLoc[2], this._spawnLoc[3]), this._spawnLoc[4]);
        }
    }

    public int getCastleId() {
        return this._castleId;
    }

    public int[] getSpawn() {
        return this._spawnLoc;
    }
}

