/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.BuyListSeed;
import com.l2jserver.gameserver.network.serverpackets.ExShowCropInfo;
import com.l2jserver.gameserver.network.serverpackets.ExShowManorDefaultInfo;
import com.l2jserver.gameserver.network.serverpackets.ExShowProcureCropDetail;
import com.l2jserver.gameserver.network.serverpackets.ExShowSeedInfo;
import com.l2jserver.gameserver.network.serverpackets.ExShowSellCropList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2ManorManagerInstance
extends L2MerchantInstance {
    public L2ManorManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2ManorManagerInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC() == null || player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        if (command.startsWith("manor_menu_select")) {
            if (CastleManorManager.getInstance().isUnderMaintenance()) {
                player.sendPacket(ActionFailed.STATIC_PACKET);
                player.sendPacket(new SystemMessage(SystemMessageId.THE_MANOR_SYSTEM_IS_CURRENTLY_UNDER_MAINTENANCE));
                return;
            }
            String params = command.substring(command.indexOf("?") + 1);
            StringTokenizer st = new StringTokenizer(params, "&");
            int ask = Integer.parseInt(st.nextToken().split("=")[1]);
            int state = Integer.parseInt(st.nextToken().split("=")[1]);
            int time = Integer.parseInt(st.nextToken().split("=")[1]);
            int castleId = state == -1 ? this.getCastle().getCastleId() : state;
            switch (ask) {
                case 1: {
                    if (castleId != this.getCastle().getCastleId()) {
                        player.sendPacket(new SystemMessage(SystemMessageId.HERE_YOU_CAN_BUY_ONLY_SEEDS_OF_S1_MANOR));
                        break;
                    }
                    player.sendPacket(new BuyListSeed(player.getAdena(), castleId, this.getCastle().getSeedProduction(0)));
                    break;
                }
                case 2: {
                    player.sendPacket(new ExShowSellCropList(player, castleId, this.getCastle().getCropProcure(0)));
                    break;
                }
                case 3: {
                    if (time == 1 && !CastleManager.getInstance().getCastleById(castleId).isNextPeriodApproved()) {
                        player.sendPacket(new ExShowSeedInfo(castleId, null));
                        break;
                    }
                    player.sendPacket(new ExShowSeedInfo(castleId, CastleManager.getInstance().getCastleById(castleId).getSeedProduction(time)));
                    break;
                }
                case 4: {
                    if (time == 1 && !CastleManager.getInstance().getCastleById(castleId).isNextPeriodApproved()) {
                        player.sendPacket(new ExShowCropInfo(castleId, null));
                        break;
                    }
                    player.sendPacket(new ExShowCropInfo(castleId, CastleManager.getInstance().getCastleById(castleId).getCropProcure(time)));
                    break;
                }
                case 5: {
                    player.sendPacket(new ExShowManorDefaultInfo());
                    break;
                }
                case 6: {
                    this.showBuyWindow(player, Integer.parseInt("3" + this.getNpcId()));
                    break;
                }
                case 9: {
                    player.sendPacket(new ExShowProcureCropDetail(state));
                }
            }
        } else if (command.startsWith("help")) {
            StringTokenizer st = new StringTokenizer(command, " ");
            st.nextToken();
            String filename = "manor_client_help00" + st.nextToken() + ".htm";
            this.showChatWindow(player, filename);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public String getHtmlPath() {
        return "data/html/manormanager/";
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return "data/html/manormanager/manager.htm";
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        if (CastleManorManager.getInstance().isDisabled()) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/npcdefault.htm");
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            html.replace((CharSequence)"%npcname%", this.getName());
            player.sendPacket(html);
        } else if (!player.isGM() && this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null && this.getCastle().getOwnerId() == player.getClanId() && player.isClanLeader()) {
            this.showChatWindow(player, "manager-lord.htm");
        } else {
            this.showChatWindow(player, "manager.htm");
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player, String filename) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), this.getHtmlPath() + filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getNpcId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }
}

