/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;

public final class L2ArmorSet {
    private final int _chest;
    private final int _legs;
    private final int _head;
    private final int _gloves;
    private final int _feet;
    private final int _mw_legs;
    private final int _mw_head;
    private final int _mw_gloves;
    private final int _mw_feet;
    private final String[] _skills;
    private final int _shield;
    private final int _mw_shield;
    private final int _shieldSkillId;
    private final int _enchant6Skill;

    public L2ArmorSet(int chest, int legs, int head, int gloves, int feet, String[] skills, int shield, int shield_skill_id, int enchant6skill, int mw_legs, int mw_head, int mw_gloves, int mw_feet, int mw_shield) {
        this._chest = chest;
        this._legs = legs;
        this._head = head;
        this._gloves = gloves;
        this._feet = feet;
        this._mw_legs = mw_legs;
        this._mw_head = mw_head;
        this._mw_gloves = mw_gloves;
        this._mw_feet = mw_feet;
        this._mw_shield = mw_shield;
        this._skills = skills;
        this._shield = shield;
        this._shieldSkillId = shield_skill_id;
        this._enchant6Skill = enchant6skill;
    }

    public boolean containAll(L2PcInstance player) {
        PcInventory inv = player.getInventory();
        L2ItemInstance legsItem = inv.getPaperdollItem(13);
        L2ItemInstance headItem = inv.getPaperdollItem(8);
        L2ItemInstance glovesItem = inv.getPaperdollItem(11);
        L2ItemInstance feetItem = inv.getPaperdollItem(14);
        int legs = 0;
        int head = 0;
        int gloves = 0;
        int feet = 0;
        if (legsItem != null) {
            legs = legsItem.getItemId();
        }
        if (headItem != null) {
            head = headItem.getItemId();
        }
        if (glovesItem != null) {
            gloves = glovesItem.getItemId();
        }
        if (feetItem != null) {
            feet = feetItem.getItemId();
        }
        return this.containAll(this._chest, legs, head, gloves, feet);
    }

    public boolean containAll(int chest, int legs, int head, int gloves, int feet) {
        if (this._chest != 0 && this._chest != chest) {
            return false;
        }
        if (this._legs != 0 && this._legs != legs && (this._mw_legs == 0 || this._mw_legs != legs)) {
            return false;
        }
        if (this._head != 0 && this._head != head && (this._mw_head == 0 || this._mw_head != head)) {
            return false;
        }
        if (this._gloves != 0 && this._gloves != gloves && (this._mw_gloves == 0 || this._mw_gloves != gloves)) {
            return false;
        }
        return this._feet == 0 || this._feet == feet || this._mw_feet != 0 && this._mw_feet == feet;
    }

    public boolean containItem(int slot, int itemId) {
        switch (slot) {
            case 12: {
                return this._chest == itemId;
            }
            case 13: {
                return this._legs == itemId || this._mw_legs == itemId;
            }
            case 8: {
                return this._head == itemId || this._mw_head == itemId;
            }
            case 11: {
                return this._gloves == itemId || this._mw_gloves == itemId;
            }
            case 14: {
                return this._feet == itemId || this._mw_feet == itemId;
            }
        }
        return false;
    }

    public String[] getSkills() {
        return this._skills;
    }

    public boolean containShield(L2PcInstance player) {
        PcInventory inv = player.getInventory();
        L2ItemInstance shieldItem = inv.getPaperdollItem(10);
        return shieldItem != null && (shieldItem.getItemId() == this._shield || shieldItem.getItemId() == this._mw_shield);
    }

    public boolean containShield(int shield_id) {
        if (this._shield == 0) {
            return false;
        }
        return this._shield == shield_id || this._mw_shield == shield_id;
    }

    public int getShieldSkillId() {
        return this._shieldSkillId;
    }

    public int getEnchant6skillId() {
        return this._enchant6Skill;
    }

    public boolean isEnchanted6(L2PcInstance player) {
        if (!this.containAll(player)) {
            return false;
        }
        PcInventory inv = player.getInventory();
        L2ItemInstance chestItem = inv.getPaperdollItem(12);
        L2ItemInstance legsItem = inv.getPaperdollItem(13);
        L2ItemInstance headItem = inv.getPaperdollItem(8);
        L2ItemInstance glovesItem = inv.getPaperdollItem(11);
        L2ItemInstance feetItem = inv.getPaperdollItem(14);
        if (chestItem == null || chestItem.getEnchantLevel() < 6) {
            return false;
        }
        if (this._legs != 0 && (legsItem == null || legsItem.getEnchantLevel() < 6)) {
            return false;
        }
        if (this._gloves != 0 && (glovesItem == null || glovesItem.getEnchantLevel() < 6)) {
            return false;
        }
        if (this._head != 0 && (headItem == null || headItem.getEnchantLevel() < 6)) {
            return false;
        }
        return this._feet == 0 || feetItem != null && feetItem.getEnchantLevel() >= 6;
    }
}

