/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.skills.effects.EffectChanceSkillTrigger;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import javolution.util.FastMap;

public class ChanceSkillList
extends FastMap<IChanceSkillTrigger, ChanceCondition> {
    private static final long serialVersionUID = 1L;
    private final L2Character _owner;

    public ChanceSkillList(L2Character owner) {
        this.shared();
        this._owner = owner;
    }

    public L2Character getOwner() {
        return this._owner;
    }

    public void onHit(L2Character target, boolean ownerWasHit, boolean wasCrit) {
        int event;
        if (ownerWasHit) {
            event = 384;
            if (wasCrit) {
                event |= 0x200;
            }
        } else {
            event = 1;
            if (wasCrit) {
                event |= 2;
            }
        }
        this.onEvent(event, target, (byte)-1);
    }

    public void onEvadedHit(L2Character attacker) {
        this.onEvent(8192, attacker, (byte)-1);
    }

    public void onSkillHit(L2Character target, boolean ownerWasHit, boolean wasMagic, boolean wasOffensive, byte element) {
        int event;
        if (ownerWasHit) {
            event = 1024;
            if (wasOffensive) {
                event |= 0x800;
                event |= 0x80;
            } else {
                event |= 0x1000;
            }
        } else {
            event = 4;
            event |= wasMagic ? 16 : 8;
            event |= wasOffensive ? 64 : 32;
        }
        this.onEvent(event, target, element);
    }

    public void onStart(byte element) {
        this.onEvent(16384, this._owner, element);
    }

    public void onActionTime(byte element) {
        this.onEvent(32768, this._owner, element);
    }

    public void onExit(byte element) {
        this.onEvent(65536, this._owner, element);
    }

    public void onEvent(int event, L2Character target, byte element) {
        if (this._owner.isDead()) {
            return;
        }
        boolean playable = target instanceof L2Playable;
        FastMap.Entry e = this.head();
        FastMap.Entry end = this.tail();
        while ((e = e.getNext()) != end) {
            if (e.getValue() == null || !((ChanceCondition)e.getValue()).trigger(event, element, playable)) continue;
            if (e.getKey() instanceof L2Skill) {
                this.makeCast((L2Skill)e.getKey(), target);
                continue;
            }
            if (!(e.getKey() instanceof EffectChanceSkillTrigger)) continue;
            this.makeCast((EffectChanceSkillTrigger)e.getKey(), target);
        }
    }

    private void makeCast(L2Skill skill, L2Character target) {
        try {
            if (skill.getWeaponDependancy(this._owner, true) && skill.checkCondition(this._owner, target, false)) {
                L2Object[] targets;
                if (skill.triggersChanceSkill() && ((skill = SkillTable.getInstance().getInfo(skill.getTriggeredChanceId(), skill.getTriggeredChanceLevel())) == null || skill.getSkillType() == L2SkillType.NOTDONE)) {
                    return;
                }
                if (this._owner.isSkillDisabled(skill)) {
                    return;
                }
                if (skill.getReuseDelay() > 0) {
                    this._owner.disableSkill(skill, skill.getReuseDelay());
                }
                if ((targets = skill.getTargetList(this._owner, false, target)).length == 0) {
                    return;
                }
                L2Character firstTarget = (L2Character)targets[0];
                ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(skill.getSkillType());
                this._owner.broadcastPacket(new MagicSkillLaunched(this._owner, skill.getDisplayId(), skill.getLevel(), targets));
                this._owner.broadcastPacket(new MagicSkillUse(this._owner, firstTarget, skill.getDisplayId(), skill.getLevel(), 0, 0));
                if (handler != null) {
                    handler.useSkill(this._owner, skill, targets);
                } else {
                    skill.useSkill(this._owner, targets);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeCast(EffectChanceSkillTrigger effect, L2Character target) {
        try {
            L2Object[] targets;
            L2Character caster;
            if (effect == null || !effect.triggersChanceSkill()) {
                return;
            }
            L2Skill triggered = SkillTable.getInstance().getInfo(effect.getTriggeredChanceId(), effect.getTriggeredChanceLevel());
            if (triggered == null) {
                return;
            }
            L2Character l2Character = caster = triggered.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF ? this._owner : effect.getEffector();
            if (caster == null || triggered.getSkillType() == L2SkillType.NOTDONE || caster.isSkillDisabled(triggered)) {
                return;
            }
            if (triggered.getReuseDelay() > 0) {
                caster.disableSkill(triggered, triggered.getReuseDelay());
            }
            if ((targets = triggered.getTargetList(caster, false, target)).length == 0) {
                return;
            }
            L2Character firstTarget = (L2Character)targets[0];
            ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(triggered.getSkillType());
            this._owner.broadcastPacket(new MagicSkillLaunched(this._owner, triggered.getDisplayId(), triggered.getLevel(), targets));
            this._owner.broadcastPacket(new MagicSkillUse(this._owner, firstTarget, triggered.getDisplayId(), triggered.getLevel(), 0, 0));
            if (handler != null) {
                handler.useSkill(caster, triggered, targets);
            } else {
                triggered.useSkill(caster, targets);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

