/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.zone.L2SpawnZone;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.form.ZoneCuboid;
import com.l2jserver.gameserver.model.zone.form.ZoneCylinder;
import com.l2jserver.gameserver.model.zone.form.ZoneNPoly;
import com.l2jserver.gameserver.model.zone.type.L2ArenaZone;
import com.l2jserver.gameserver.model.zone.type.L2BigheadZone;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.model.zone.type.L2CastleTeleportZone;
import com.l2jserver.gameserver.model.zone.type.L2CastleZone;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.model.zone.type.L2DamageZone;
import com.l2jserver.gameserver.model.zone.type.L2DerbyTrackZone;
import com.l2jserver.gameserver.model.zone.type.L2FishingZone;
import com.l2jserver.gameserver.model.zone.type.L2FortZone;
import com.l2jserver.gameserver.model.zone.type.L2JailZone;
import com.l2jserver.gameserver.model.zone.type.L2LandingZone;
import com.l2jserver.gameserver.model.zone.type.L2MotherTreeZone;
import com.l2jserver.gameserver.model.zone.type.L2NoHqZone;
import com.l2jserver.gameserver.model.zone.type.L2NoLandingZone;
import com.l2jserver.gameserver.model.zone.type.L2NoStoreZone;
import com.l2jserver.gameserver.model.zone.type.L2NoSummonFriendZone;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.model.zone.type.L2PaganZone;
import com.l2jserver.gameserver.model.zone.type.L2PeaceZone;
import com.l2jserver.gameserver.model.zone.type.L2PoisonZone;
import com.l2jserver.gameserver.model.zone.type.L2ScriptZone;
import com.l2jserver.gameserver.model.zone.type.L2SwampZone;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import com.l2jserver.gameserver.model.zone.type.L2WaterZone;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ZoneManager {
    private static final Logger _log = Logger.getLogger(ZoneManager.class.getName());
    private final FastMap<Integer, L2ZoneType> _zones = new FastMap();

    public static final ZoneManager getInstance() {
        return SingletonHolder._instance;
    }

    private ZoneManager() {
        _log.info("Initializing ZoneManager");
        this.load();
    }

    public void reload() {
        int count = 0;
        L2WorldRegion[][] worldRegions = L2World.getInstance().getAllWorldRegions();
        for (int x = 0; x < worldRegions.length; ++x) {
            for (int y = 0; y < worldRegions[x].length; ++y) {
                worldRegions[x][y].getZones().clear();
                ++count;
            }
        }
        GrandBossManager.getInstance().getZones().clear();
        _log.info("Removed zones in " + count + " regions.");
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        _log.info("Loading zones...");
        Connection con = null;
        PreparedStatement statement = null;
        this._zones.clear();
        L2WorldRegion[][] worldRegions = L2World.getInstance().getAllWorldRegions();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT `x`, `y` FROM `zone_vertices` WHERE `id` = ? ORDER BY `order` ASC");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Config.DATAPACK_ROOT + "/data/zones/zone.xml");
            if (!file.exists()) {
                if (Config.DEBUG) {
                    _log.info("The zone.xml file is missing.");
                }
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    L2ZoneType temp;
                    int zoneId;
                    NamedNodeMap attrs;
                    block77: {
                        if (!"zone".equalsIgnoreCase(d.getNodeName())) continue;
                        attrs = d.getAttributes();
                        zoneId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                        int minZ = Integer.parseInt(attrs.getNamedItem("minZ").getNodeValue());
                        int maxZ = Integer.parseInt(attrs.getNamedItem("maxZ").getNodeValue());
                        String zoneType = attrs.getNamedItem("type").getNodeValue();
                        String zoneShape = attrs.getNamedItem("shape").getNodeValue();
                        temp = null;
                        if (zoneType.equals("FishingZone")) {
                            temp = new L2FishingZone(zoneId);
                        } else if (zoneType.equals("ClanHallZone")) {
                            temp = new L2ClanHallZone(zoneId);
                        } else if (zoneType.equals("PeaceZone")) {
                            temp = new L2PeaceZone(zoneId);
                        } else if (zoneType.equals("Town")) {
                            temp = new L2TownZone(zoneId);
                        } else if (zoneType.equals("OlympiadStadium")) {
                            temp = new L2OlympiadStadiumZone(zoneId);
                        } else if (zoneType.equals("CastleZone")) {
                            temp = new L2CastleZone(zoneId);
                        } else if (zoneType.equals("CastleTeleportZone")) {
                            temp = new L2CastleTeleportZone(zoneId);
                        } else if (zoneType.equals("FortZone")) {
                            temp = new L2FortZone(zoneId);
                        } else if (zoneType.equals("DamageZone")) {
                            temp = new L2DamageZone(zoneId);
                        } else if (zoneType.equals("PoisonZone")) {
                            temp = new L2PoisonZone(zoneId);
                        } else if (zoneType.equals("SwampZone")) {
                            temp = new L2SwampZone(zoneId);
                        } else if (zoneType.equals("Arena")) {
                            temp = new L2ArenaZone(zoneId);
                        } else if (zoneType.equals("MotherTree")) {
                            temp = new L2MotherTreeZone(zoneId);
                        } else if (zoneType.equals("BigheadZone")) {
                            temp = new L2BigheadZone(zoneId);
                        } else if (zoneType.equals("LandingZone")) {
                            temp = new L2LandingZone(zoneId);
                        } else if (zoneType.equals("NoLandingZone")) {
                            temp = new L2NoLandingZone(zoneId);
                        } else if (zoneType.equals("JailZone")) {
                            temp = new L2JailZone(zoneId);
                        } else if (zoneType.equals("DerbyTrackZone")) {
                            temp = new L2DerbyTrackZone(zoneId);
                        } else if (zoneType.equals("BossZone")) {
                            temp = new L2BossZone(zoneId);
                        } else if (zoneType.equals("WaterZone")) {
                            temp = new L2WaterZone(zoneId);
                        } else if (zoneType.equals("NoStoreZone")) {
                            temp = new L2NoStoreZone(zoneId);
                        } else if (zoneType.equals("ScriptZone")) {
                            temp = new L2ScriptZone(zoneId);
                        } else if (zoneType.equals("PaganZone")) {
                            temp = new L2PaganZone(zoneId);
                        } else if (zoneType.equals("NoHqZone")) {
                            temp = new L2NoHqZone(zoneId);
                        } else if (zoneType.equals("NoSummonZone")) {
                            temp = new L2NoSummonFriendZone(zoneId);
                        }
                        if (temp == null) {
                            _log.warning("ZoneData: No such zone type: " + zoneType);
                            continue;
                        }
                        try {
                            statement.setInt(1, zoneId);
                            ResultSet rset = statement.executeQuery();
                            statement.clearParameters();
                            if (zoneShape.equalsIgnoreCase("Cuboid")) {
                                int[] x = new int[]{0, 0};
                                int[] y = new int[]{0, 0};
                                boolean successfulLoad = true;
                                for (int i = 0; i < 2; ++i) {
                                    if (!rset.next()) {
                                        _log.warning("ZoneData: Missing cuboid vertex in sql data for zone: " + zoneId);
                                        successfulLoad = false;
                                        break;
                                    }
                                    x[i] = rset.getInt("x");
                                    y[i] = rset.getInt("y");
                                }
                                rset.close();
                                if (!successfulLoad) continue;
                                temp.setZone(new ZoneCuboid(x[0], x[1], y[0], y[1], minZ, maxZ));
                                break block77;
                            }
                            if (zoneShape.equalsIgnoreCase("NPoly")) {
                                FastList fl_x = new FastList();
                                FastList fl_y = new FastList();
                                while (rset.next()) {
                                    fl_x.add((Object)rset.getInt("x"));
                                    fl_y.add((Object)rset.getInt("y"));
                                }
                                rset.close();
                                if (fl_x.size() == fl_y.size() && fl_x.size() > 2) {
                                    int[] aX = new int[fl_x.size()];
                                    int[] aY = new int[fl_y.size()];
                                    for (int i = 0; i < fl_x.size(); ++i) {
                                        aX[i] = (Integer)fl_x.get(i);
                                        aY[i] = (Integer)fl_y.get(i);
                                    }
                                    temp.setZone(new ZoneNPoly(aX, aY, minZ, maxZ));
                                    break block77;
                                }
                                _log.warning("ZoneData: Bad sql data for zone: " + zoneId);
                                continue;
                            }
                            if (zoneShape.equalsIgnoreCase("Cylinder")) {
                                int zoneRad = Integer.parseInt(attrs.getNamedItem("rad").getNodeValue());
                                if (rset.next() && zoneRad > 0) {
                                    int zoneX = rset.getInt("x");
                                    int zoneY = rset.getInt("y");
                                    rset.close();
                                    temp.setZone(new ZoneCylinder(zoneX, zoneY, minZ, maxZ, zoneRad));
                                    break block77;
                                }
                                _log.warning("ZoneData: Bad sql data for zone: " + zoneId);
                                continue;
                            }
                            _log.warning("ZoneData: Unknown shape: " + zoneShape);
                            rset.close();
                            continue;
                        }
                        catch (Exception e) {
                            _log.log(Level.WARNING, "ZoneData: Failed to load zone coordinates: " + e.getMessage(), e);
                        }
                    }
                    for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                        if ("stat".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            String name = attrs.getNamedItem("name").getNodeValue();
                            String val = attrs.getNamedItem("val").getNodeValue();
                            temp.setParameter(name, val);
                            continue;
                        }
                        if (!"spawn".equalsIgnoreCase(cd.getNodeName()) || !(temp instanceof L2SpawnZone)) continue;
                        attrs = cd.getAttributes();
                        int spawnX = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                        int spawnY = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                        int spawnZ = Integer.parseInt(attrs.getNamedItem("Z").getNodeValue());
                        Node val = attrs.getNamedItem("isChaotic");
                        if (val != null && Boolean.parseBoolean(val.getNodeValue())) {
                            ((L2SpawnZone)temp).addChaoticSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        ((L2SpawnZone)temp).addSpawn(spawnX, spawnY, spawnZ);
                    }
                    this.addZone(zoneId, temp);
                    for (int x = 0; x < worldRegions.length; ++x) {
                        for (int y = 0; y < worldRegions[x].length; ++y) {
                            int ax = x - L2World.OFFSET_X << 12;
                            int bx = x + 1 - L2World.OFFSET_X << 12;
                            int ay = y - L2World.OFFSET_Y << 12;
                            int by = y + 1 - L2World.OFFSET_Y << 12;
                            if (!temp.getZone().intersectsRectangle(ax, bx, ay, by)) continue;
                            if (Config.DEBUG) {
                                _log.info("Zone (" + zoneId + ") added to: " + x + " " + y);
                            }
                            worldRegions[x][y].addZone(temp);
                        }
                    }
                    if (!(temp instanceof L2BossZone)) continue;
                    GrandBossManager.getInstance().addZone((L2BossZone)temp);
                }
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while loading zones.", e);
            return;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("Done: loaded " + this._zones.size() + " zones.");
    }

    public void addZone(Integer id, L2ZoneType zone) {
        this._zones.put((Object)id, (Object)zone);
    }

    public Collection<L2ZoneType> getAllZones() {
        return this._zones.values();
    }

    public L2ZoneType getZoneById(int id) {
        return (L2ZoneType)this._zones.get((Object)id);
    }

    public FastList<L2ZoneType> getZones(L2Object object) {
        return this.getZones(object.getX(), object.getY(), object.getZ());
    }

    public L2ZoneType getZone(L2Object object, Class<? extends L2ZoneType> type) {
        return this.getZone(object.getX(), object.getY(), object.getZ(), type);
    }

    public FastList<L2ZoneType> getZones(int x, int y) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        FastList temp = new FastList();
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y)) continue;
            temp.add((Object)zone);
        }
        return temp;
    }

    public FastList<L2ZoneType> getZones(int x, int y, int z) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        FastList temp = new FastList();
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y, z)) continue;
            temp.add((Object)zone);
        }
        return temp;
    }

    public L2ZoneType getZone(int x, int y, int z, Class<? extends L2ZoneType> type) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y, z) || !zone.getClass().equals(type)) continue;
            return zone;
        }
        return null;
    }

    public final L2ArenaZone getArena(L2Character character) {
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(character.getX(), character.getY(), character.getZ())) {
            if (!(temp instanceof L2ArenaZone) || !temp.isCharacterInZone(character)) continue;
            return (L2ArenaZone)temp;
        }
        return null;
    }

    public final L2OlympiadStadiumZone getOlympiadStadium(L2Character character) {
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(character.getX(), character.getY(), character.getZ())) {
            if (!(temp instanceof L2OlympiadStadiumZone) || !temp.isCharacterInZone(character)) continue;
            return (L2OlympiadStadiumZone)temp;
        }
        return null;
    }

    private static class SingletonHolder {
        protected static final ZoneManager _instance = new ZoneManager();

        private SingletonHolder() {
        }
    }
}

