/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import com.l2jserver.gameserver.scripting.ScriptManager;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class QuestManager
extends ScriptManager<Quest> {
    protected static final Logger _log = Logger.getLogger(QuestManager.class.getName());
    private Map<String, Quest> _quests = new FastMap();

    public static final QuestManager getInstance() {
        return SingletonHolder._instance;
    }

    private QuestManager() {
        _log.info("Initializing QuestManager");
    }

    @Override
    public final boolean reload(String questFolder) {
        Quest q = this.getQuest(questFolder);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    @Override
    public final boolean reload(int questId) {
        Quest q = this.getQuest(questId);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    public final void reloadAllQuests() {
        _log.info("Reloading Server Scripts");
        try {
            for (Quest quest : this._quests.values()) {
                if (quest == null) continue;
                quest.unload(false);
            }
            this._quests.clear();
            File scripts = new File(Config.DATAPACK_ROOT + "/data/scripts.cfg");
            L2ScriptEngineManager.getInstance().executeScriptList(scripts);
            QuestManager.getInstance().report();
        }
        catch (IOException ioe) {
            _log.severe("Failed loading scripts.cfg, no script going to be loaded");
        }
    }

    public final void report() {
        _log.info("Loaded: " + this._quests.size() + " quests");
    }

    public final void save() {
        for (Quest q : this._quests.values()) {
            q.saveGlobalData();
        }
    }

    public final Quest getQuest(String name) {
        return this._quests.get(name);
    }

    public final Quest getQuest(int questId) {
        for (Quest q : this._quests.values()) {
            if (q.getQuestIntId() != questId) continue;
            return q;
        }
        return null;
    }

    public final void addQuest(Quest newQuest) {
        if (newQuest == null) {
            throw new IllegalArgumentException("Quest argument cannot be null");
        }
        Quest old = this._quests.get(newQuest.getName());
        if (old != null) {
            old.unload();
            _log.info("Replaced: (" + old.getName() + ") with a new version (" + newQuest.getName() + ")");
        }
        this._quests.put(newQuest.getName(), newQuest);
    }

    public final boolean removeQuest(Quest q) {
        return this._quests.remove(q.getName()) != null;
    }

    @Override
    public Iterable<Quest> getAllManagedScripts() {
        return this._quests.values();
    }

    @Override
    public boolean unload(Quest ms) {
        ms.saveGlobalData();
        return this.removeQuest(ms);
    }

    @Override
    public String getScriptManagerName() {
        return "QuestManager";
    }

    private static class SingletonHolder {
        protected static final QuestManager _instance = new QuestManager();

        private SingletonHolder() {
        }
    }
}

