/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ExtractableProductItem;
import com.l2jserver.gameserver.model.L2ExtractableSkill;
import com.l2jserver.gameserver.model.L2Skill;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.Scanner;
import java.util.logging.Logger;
import javolution.util.FastList;

public class ExtractableSkillsData {
    protected static final Logger _log = Logger.getLogger(ExtractableSkillsData.class.getName());
    private TIntObjectHashMap<L2ExtractableSkill> _items = new TIntObjectHashMap();

    public static ExtractableSkillsData getInstance() {
        return SingletonHolder._instance;
    }

    public ExtractableSkillsData() {
        Scanner s;
        this._items.clear();
        try {
            s = new Scanner(new File(Config.DATAPACK_ROOT + "/data/extractable_skills.csv"));
        }
        catch (Exception e) {
            _log.warning("Extractable items data: Can not find '" + Config.DATAPACK_ROOT + "/data/extractable_skills.csv'");
            return;
        }
        int lineCount = 0;
        while (s.hasNextLine()) {
            ++lineCount;
            String line = s.nextLine().trim();
            if (line.startsWith("#") || line.isEmpty()) continue;
            String[] lineSplit = line.split(";");
            boolean ok = true;
            int skillID = 0;
            int skillLvl = 0;
            try {
                skillID = Integer.parseInt(lineSplit[0]);
                skillLvl = Integer.parseInt(lineSplit[1]);
            }
            catch (Exception e) {
                _log.warning("Extractable skills data: Error in line " + lineCount + " -> invalid item id or wrong seperator after skill id!");
                _log.warning("\t\t" + line);
                ok = false;
            }
            L2Skill skill = SkillTable.getInstance().getInfo(skillID, skillLvl);
            if (skill == null) {
                _log.warning("Extractable skills data: Error in line " + lineCount + " -> skill is null!");
                _log.warning("\t\t" + line);
                ok = false;
            }
            if (!ok) continue;
            FastList product_temp = new FastList();
            for (int i = 1; i < lineSplit.length - 1; ++i) {
                ok = true;
                String[] lineSplit2 = lineSplit[i + 1].split(",");
                if (lineSplit2.length < 3) {
                    _log.warning("Extractable skills data: Error in line " + lineCount + " -> wrong seperator!");
                    _log.warning("\t\t" + line);
                    ok = false;
                }
                if (!ok) continue;
                int[] production = null;
                int[] amount = null;
                int chance = 0;
                try {
                    int k = 0;
                    production = new int[lineSplit2.length - 0];
                    amount = new int[lineSplit2.length - 0];
                    for (int j = 0; j < lineSplit2.length - 1; ++j) {
                        production[k] = Integer.parseInt(lineSplit2[j]);
                        amount[k] = Integer.parseInt(lineSplit2[++j]);
                        ++k;
                    }
                    chance = Integer.parseInt(lineSplit2[lineSplit2.length - 1]);
                }
                catch (Exception e) {
                    _log.warning("Extractable skills data: Error in line " + lineCount + " -> incomplete/invalid production data or wrong seperator!");
                    _log.warning("\t\t" + line);
                    ok = false;
                }
                if (!ok) continue;
                L2ExtractableProductItem product = new L2ExtractableProductItem(production, amount, chance);
                product_temp.add((Object)product);
            }
            int fullChances = 0;
            for (L2ExtractableProductItem Pi : product_temp) {
                fullChances += Pi.getChance();
            }
            if (fullChances > 100) {
                _log.warning("Extractable skills data: Error in line " + lineCount + " -> all chances together are more then 100!");
                _log.warning("\t\t" + line);
                continue;
            }
            int hash = SkillTable.getSkillHashCode(skill);
            L2ExtractableSkill product = new L2ExtractableSkill(hash, (FastList<L2ExtractableProductItem>)product_temp);
            this._items.put(hash, (Object)product);
        }
        s.close();
        _log.info("Extractable skills data: Loaded " + this._items.size() + " extractable skills!");
    }

    public L2ExtractableSkill getExtractableItem(L2Skill skill) {
        return (L2ExtractableSkill)this._items.get(SkillTable.getSkillHashCode(skill));
    }

    private static class SingletonHolder {
        protected static final ExtractableSkillsData _instance = new ExtractableSkillsData();

        private SingletonHolder() {
        }
    }
}

