/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.log;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ItemLogFormatter
extends Formatter {
    private static final String CRLF = "\r\n";
    private SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        Object[] params = record.getParameters();
        StringBuilder output = StringUtil.startAppend(30 + record.getMessage().length() + params.length * 50, "[", this.dateFmt.format(new Date(record.getMillis())), "] ", record.getMessage());
        for (Object p : record.getParameters()) {
            if (p == null) continue;
            output.append(", ");
            if (p instanceof L2ItemInstance) {
                L2ItemInstance item = (L2ItemInstance)p;
                StringUtil.append(output, "item ", String.valueOf(item.getObjectId()), ":");
                if (item.getEnchantLevel() > 0) {
                    StringUtil.append(output, "+", String.valueOf(item.getEnchantLevel()), " ");
                }
                StringUtil.append(output, item.getItem().getName(), "(", String.valueOf(item.getCount()), ")");
                continue;
            }
            output.append(p.toString());
        }
        output.append(CRLF);
        return output.toString();
    }
}

