/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.conditions;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.templates.item.L2ArmorType;

public final class ConditionUsingItemType
extends Condition {
    private final int _mask;

    public ConditionUsingItemType(int mask) {
        this._mask = mask;
    }

    @Override
    public boolean testImpl(Env env) {
        if (!(env.player instanceof L2PcInstance)) {
            return false;
        }
        PcInventory inv = ((L2PcInstance)env.player).getInventory();
        if (this._mask == L2ArmorType.LIGHT.mask() || this._mask == L2ArmorType.HEAVY.mask() || this._mask == L2ArmorType.MAGIC.mask()) {
            L2ItemInstance chest = inv.getPaperdollItem(12);
            if (chest == null) {
                return false;
            }
            int chestMask = chest.getItem().getItemMask();
            if ((this._mask & chestMask) == 0) {
                return false;
            }
            int chestBodyPart = chest.getItem().getBodyPart();
            if (chestBodyPart == 32768) {
                return true;
            }
            L2ItemInstance legs = inv.getPaperdollItem(13);
            if (legs == null) {
                return false;
            }
            int legMask = legs.getItem().getItemMask();
            return (this._mask & legMask) != 0;
        }
        return (this._mask & inv.getWearedMask()) != 0;
    }
}

