/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script;

import com.l2jserver.gameserver.script.ScriptDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javolution.util.FastList;

public class ScriptPackage {
    private List<ScriptDocument> _scriptFiles = new FastList();

    public ScriptPackage(ZipFile pack) {
        this.addFiles(pack);
    }

    public List<ScriptDocument> getScriptFiles() {
        return this._scriptFiles;
    }

    private void addFiles(ZipFile pack) {
        String xml = pack.getName().replaceFirst("\\.zip$", ".xml");
        if (new File(xml).exists()) {
            try {
                FileInputStream in = new FileInputStream(xml);
                ScriptDocument newScript = new ScriptDocument(xml, in);
                this._scriptFiles.add(newScript);
                ((InputStream)in).close();
                System.out.println("***" + xml + " \u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f\u3002");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        Enumeration<? extends ZipEntry> e = pack.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".xml")) continue;
            try {
                ScriptDocument newScript = new ScriptDocument(entry.getName(), pack.getInputStream(entry));
                this._scriptFiles.add(newScript);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

